
#include <mingpp.h>

int main()
{
  Ming_init();
  Ming_setScale(1.0);

  SWFMorph *p = new SWFMorph();

  SWFBitmap *b = new SWFBitmap("../common/alphafill.jpg");
  float width = b->getWidth();
  float height = b->getHeight();

  SWFShape *s = p->getShape1();
  SWFFill *f = s->addBitmapFill(b, SWFFILL_TILED_BITMAP);

  f->moveTo(-width/2, -height/4);
  f->scaleTo(1.0, 0.5);
  s->setLeftFill(f);
  s->movePenTo(-width/2, -height/4);
  s->drawLine(width, 0);
  s->drawLine(0, height/2);
  s->drawLine(-width, 0);
  s->drawLine(0, -height/2);

  s = p->getShape2();
  f = s->addBitmapFill(b, SWFFILL_TILED_BITMAP);

  // flash player bug: these two have no effect!
  f->moveTo(-width/4, -height/2);
  f->scaleTo(0.5, 1.0);

  s->setLeftFill(f);
  s->movePenTo(-width/4, -height/2);
  s->drawLine(width/2, 0);
  s->drawLine(0, height);
  s->drawLine(-width/2, 0);
  s->drawLine(0, -height);

  SWFMovie *m = new SWFMovie();
  m->setDimension(width, height);

  SWFDisplayItem *i = m->add(p);
  i->moveTo(width/2, height/2);

  for(int n=0; n<100; n+=3)
  {
    i->setRatio(n/100.0);
    m->nextFrame();
  }

  m->save("test.swf");

  exit(0);
}
