
#include <string.h>

#include "ming.h"

int main()
{
  SWFSprite p;
  SWFMovie m;
  SWFDisplayItem i;
  SWFTextField t;
  SWFShape s;
  SWFButton b;
  SWFFont f;
  
  char *letter, *chars;
  int n;
  char action[64];

  Ming_init();
  Ming_setScale(1.0);

  /* sprite has one letter per frame */
  p = newSWFMovieClip();

  SWFMovieClip_add(p, compileSWFActionCode("stop();"));

  chars = "abcdefghijklmnopqrstuvwxyz1234567890!@#$%^&*()_+-=/[]{}|;:,.<>?`~";

  f = newSWFBrowserFont("_sans");

  letter = strdup("x");
  i = NULL;

  for(n=0; n<strlen(chars); ++n)
  {
    letter[0] = chars[n];

    if(i)
      SWFMovieClip_remove(p, i);

    t = newSWFTextField();
    SWFTextField_setFont(t, f);
    SWFTextField_setHeight(t, 240);
    SWFTextField_setBounds(t, 600, 240);
    SWFTextField_setAlignment(t, SWFTEXTFIELD_ALIGN_CENTER);
    SWFTextField_addString(t, letter);
    i = SWFMovieClip_add(p, t);
    SWFMovieClip_labelFrame(p, letter);
    SWFMovieClip_nextFrame(p);
  }


  /* hit region for button - the entire frame */

  s = newSWFShape();
  SWFShape_setRightFill(s, SWFShape_addSolidFill(s, 0, 0, 0, 0xff));
  SWFShape_drawLine(s, 600, 0);
  SWFShape_drawLine(s, 0, 400);
  SWFShape_drawLine(s, -600, 0);
  SWFShape_drawLine(s, 0, -400);


  /* button checks for pressed key, sends sprite to the right frame */

  b = newSWFButton();
  SWFButton_addShape(b, s, SWFBUTTON_HIT);

  for(n=0; n<strlen(chars); ++n)
  {
    sprintf(action, "setTarget('/char'); gotoFrame('%c');", chars[n]);
    SWFButton_addAction(b, compileSWFActionCode(action), SWFBUTTON_KEYPRESS(chars[n]));
  }

  m = newSWFMovie();
  SWFMovie_setDimension(m, 600,400);

  i = SWFMovie_add(m, p);
  SWFDisplayItem_setName(i, "char");
  SWFDisplayItem_moveTo(i, 0, 80);

  SWFMovie_add(m, b);

  SWFMovie_save(m, "test.swf");

  exit(0);
}
