
from ming import *

Ming_setScale(1.0)

string = "ming!"

f = SWFFont("../common/test.fdb")

m = SWFMovie()
m.setRate(24.0)
m.setDimension(2400, 1600)
m.setBackground(0xff, 0xff, 0xff)

# functions with huge numbers of arbitrary
# arguments are always a good idea!  Really!

def text(r, g, b, a, rot, x, y, scale, string):

  t = SWFText()
  t.setFont(f)
  t.setColor(r, g, b, a)
  t.setHeight(960)
  t.moveTo(-(t.getWidth(string))/2.0, 220)   # f.getAscent()/2)
  t.addString(string)

  i = m.add(t)
  i.x = x
  i.y = y
  i.rot = rot
  i.s = scale
  i.rotateTo(rot)
  i.scale(scale, scale)

  return i


def step(i):

  i.rot = 19*i.rot/20.0
  i.x = (19*i.x + 1200)/20.0
  i.y = (19*i.y + 800)/20.0
  i.s = (19*i.s + 1.0)/20.0

  i.rotateTo(i.rot)
  i.scaleTo(i.s, i.s)
  i.moveTo(i.x, i.y)


# see?  it sure paid off in legibility:

i1 = text(0xff, 0x33, 0x33, 0xff, 900, 1200, 800, 0.03, string)
i2 = text(0x00, 0x33, 0xff, 0x7f, -560, 1200, 800, 0.04, string)
i3 = text(0xff, 0xff, 0xff, 0x9f, 180, 1200, 800, 0.001, string)

for i in range(1, 101):
  step(i1)
  step(i2)
  step(i3)

  m.nextFrame()

m.save("test.swf")
