
require 'ming'

class ITEM
	attr_accessor :i, :x, :y, :rot, :s
end

string = "ming!"

f = SWFFont.new("../common/test.fdb")

m = SWFMovie.new
m.setRate(24.0)
m.setDimension(2400, 1600)
m.setBackground(0xff, 0xff, 0xff)

# functions with huge numbers of arbitrary
# arguments are always a good idea!  Really!

def text(f, m, r, g, b, a, rot, x, y, scale, string)

  t = SWFText.new
  t.setFont(f)
  t.setColor(r, g, b, a)
  t.setHeight(960)
  t.moveTo(-(t.getWidth(string))/2.0, 220)   # f.getAscent()/2)
  t.addString(string)

  i = ITEM.new
  i.i = m.add(t)
  i.x = x
  i.y = y
  i.rot = rot
  i.s = scale
  i.i.rotateTo(rot)
  i.i.scale(scale, scale)

  return i
end

def step(i)

  i.rot = 19*i.rot/20.0
  i.x = (19*i.x + 1200)/20.0
  i.y = (19*i.y + 800)/20.0
  i.s = (19*i.s + 1.0)/20.0

  i.i.rotateTo(i.rot)
  i.i.scaleTo(i.s, i.s)
  i.i.moveTo(i.x, i.y)
end


# see?  it sure paid off in legibility:

i1 = text(f, m, 0xff, 0x33, 0x33, 0xff, 900, 1200, 800, 0.03, string)
i2 = text(f, m, 0x00, 0x33, 0xff, 0x7f, -560, 1200, 800, 0.04, string)
i3 = text(f, m, 0xff, 0xff, 0xff, 0x9f, 180, 1200, 800, 0.001, string)

for i in 1...101
  step(i1)
  step(i2)
  step(i3)

  m.nextFrame()
end

m.save("test.swf")
