
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h> 
#include <sys/types.h>
#include <string.h>
#include "xl_hzinput.h"

FILE *fr, *fw;
int lineno;

void print_error(char *fmt,...)
{
  va_list args;

  va_start(args, fmt);
  vfprintf(stderr, fmt, args);
  va_end(args);
  fprintf(stderr,"\n");
  exit(-1);
}

char *skip_space(char *s)
{
	while ((*s==' ' || *s=='\t') && *s) s++;
	return s;
}

char *to_space(char *s)
{
	while (*s!=' ' && *s!='\t' && *s) s++;
	return s;
}

void del_nl_space(char *s)
{
	char *t;

	int len=strlen(s);
	if (!*s) return;
	t=s+len-1;
	while ( (*t=='\n' || *t==' ' || *t=='\t' )&& s<t) t--;
	*(t+1)=0;
}


void get_line(u_char *tt)
{
	while (!feof(fr)) 
        {
		fgets(tt,128,fr);
		lineno++;
		if (tt[0]=='#') continue;
		else break;
	}
}

void cmd_arg(u_char *s, u_char **cmd, u_char **arg)
{
	char *t;

	s[0]='\0';
	while (!feof(fr) && !(s[0]) || s[0]=='\n')
	{
		get_line(s);
//	if (!*s) { *cmd=*arg=s; return; }
		s=skip_space(s);
	}
	t=to_space(s);
	*cmd=s;
	if (!(*t)) {
		*arg=t;
		return;
	}
	*t=0;
	t++;
	t=skip_space(t);
	del_nl_space(t);
	*arg=t;
}

#define MAXSIZE 65535
 /* maximum char/phrase can be defined */

ITEM ItemTable[MAXSIZE], ItemTmp[MAXSIZE];
ITEM ItemOut[MAXSIZE];
int  PhraseIndex[MAXSIZE];
char PhraseBuffer[250000];  /* max 250K phrase buffer */ 

/* qcmp2 compare two ITEM2 structure, according to its key1/key2/ch */
int qcmp2(const void *c, const void *d)
{
       ITEM *a, *b;
       a=(ITEM*)c;
       b=(ITEM*)d;
	if (a->key > b->key) return 1;
	if (a->key < b->key) return -1;
	if (a->ch > b->ch) return 1;
	if (a->ch < b->ch) return -1;
	return 0;
}



int main(int argc, char **argv)
{
int i,k;
char fname[64], fname_cin[64], fname_tab[64];
char fname_phr[64];
char tt[128];
u_char *cmd, *arg;
u_char lst[12], atfrq;
hz_input_table InpTable;
int TotalKeyNum;
ITEM LastItem;
long index,ItemCount;
u_short CharDef[64];
int phrase_count=0, phrasebuf_pointer=0;

if (argc<=1) 
{
	printf("Enter table file name [.cin] : ");
	scanf("%s", fname);
}
else strcpy(fname,argv[1]);

strcpy(fname_cin,fname);
strcpy(fname_tab,fname);
strcat(fname_cin,".cin");
strcat(fname_tab,".tab");
strcpy(fname_phr,fname_tab);
strcat(fname_phr,".phr");

if ((fr=fopen(fname_cin,"r"))==NULL ) 
	print_error("Cannot open %s \n", fname_cin);

bzero(&InpTable,sizeof(InpTable));
bzero(ItemTable,sizeof(ItemTable));
bzero(ItemOut,sizeof(ItemOut));

printf("Generating binary *.tab file for input method %s...\n",fname_cin);

/****************** Now some basic information ************************/

strcpy(InpTable.magic_number,MAGIC_NUMBER);
cmd_arg(tt, &cmd, &arg);
if (strcmp(cmd,"%ename") || !(*arg) )
	print_error("%d:  %%ename english_name  expected", lineno);
arg[CIN_ENAME_LENGTH-1]=0;
strcpy(InpTable.ename,arg);

cmd_arg(tt, &cmd, &arg);
if (strcmp(cmd,"%prompt") || !(*arg) )
	print_error("%d:  %%prompt prompt_name  expected", lineno);
arg[CIN_CNAME_LENGTH-1]=0;
strcpy(InpTable.cname, arg);

cmd_arg(tt,&cmd, &arg); 
if (strcmp(cmd,"%selkey") || !(*arg) )
	print_error("%d:  %%selkey select_key_list expected", lineno);
strcpy(InpTable.selkey,arg);

cmd_arg(tt,&cmd, &arg);
if (strcmp(cmd,"%last_full") || !(*arg)) 
  InpTable.last_full = 1;
else 
{
        if ( arg[0]=='0' ) InpTable.last_full=0;
        else InpTable.last_full=1;
        cmd_arg(tt, &cmd, &arg);
}

if (strcmp(cmd,"%dupsel") || !(*arg) )
	print_error("%d:  %%dupsel NO of dup sel keys  expected", lineno);
InpTable.MaxDupSel=atoi(arg);

/******************* now the keyname ****************************/

cmd_arg(tt,&cmd, &arg);
if (strcmp(cmd,"%keyname") || strcmp(arg,"begin"))
	print_error("%d:  %%keyname begin   expected", lineno);

TotalKeyNum=0;
while(1) 
{
	cmd_arg(tt,&cmd, &arg);
	if (!strcmp(cmd,"%keyname")) break;
	k = tolower(cmd[0]);  /* k = char */
	if (InpTable.KeyMap[k]) 
            print_error("%d:  key %c is already used",lineno, k);

	InpTable.KeyMap[k] = ++TotalKeyNum;

        if (TotalKeyNum > 63)
            print_error("Error, at most 64 key can be defined!\n");
	InpTable.KeyName[TotalKeyNum] = arg[0];
}

InpTable.KeyMap[32] = 0;  /* SPACE = 32 */
InpTable.KeyName[0] = ' ';
TotalKeyNum++;
InpTable.TotalKey = TotalKeyNum;    /* include space */
printf("TotalKeyNum=%d\n",TotalKeyNum);

/************************ now the character/phrase ***********************/

//cmd_arg(tt,&cmd, &arg);
index=0;
strcpy(lst,"");
while (!feof(fr)) 
{
	int len;
	u_long key;
	int k;
	cmd_arg(tt,&cmd,&arg);
	if (!cmd[0] || !arg[0]) break;
	len = strlen(cmd);
	if (len > InpTable.MaxPress) InpTable.MaxPress=len;
	if (len > 4) print_error("%d:  only <= 4 keys is allowed",lineno);

       if (!strcmp(cmd,lst)) 
       {
               atfrq++;
               if (atfrq >= 256) atfrq=0;
       }
       else
       {
               atfrq=0;
               strcpy(lst,cmd);
       }

	key=0;
	for(i=0;i<len;i++) 
        {
              k = InpTable.KeyMap[cmd[i]];
		key |= k << (26-i*6);
	}
       key |= atfrq;
	memcpy(&ItemTable[index].key,&key,4);

        /* is it a chinese character(GB), or phrase ? */	
       len = strlen(arg);
       if (len==2)
       {
	       memcpy(&ItemTable[index].ch,arg,2);
              ItemTable[index].phindex=0xFFFF;
       }
       else 
       {
	       memcpy(&ItemTable[index].ch,arg,2);
              ItemTable[index].phindex=phrase_count;
		PhraseIndex[phrase_count]=phrasebuf_pointer;
		strcpy(&PhraseBuffer[phrasebuf_pointer],arg);
		phrasebuf_pointer += len;
                phrase_count++;
	}
//	ItemTable[index].occur_seq=index;
	index++;
}
fclose(fr);

if (phrase_count > 0 ) 
{
       int i,t,s;
	PhraseIndex[phrase_count++]=phrasebuf_pointer;
	if ((fw=fopen(fname_phr,"w"))==NULL)
		print_error("Cannot create %s\n", fname_phr);
	printf("Phrase Count = %d ", phrase_count);
	fwrite(&phrase_count,4,1,fw);
	fwrite(PhraseIndex,4,phrase_count,fw);
	fwrite(PhraseBuffer,1,phrasebuf_pointer,fw);
	fclose(fw);
}
InpTable.PhraseNum = phrase_count;
InpTable.TotalChar = index;
qsort(ItemTable,index,sizeof(ITEM),qcmp2);
printf("Total Item = %d\n\n", index);

/******************* generate 64 index number ***********************/

bzero(CharDef,sizeof(CharDef));
for(i=0;i<index;i++) 
{
    int kk=(ItemTable[i].key >> 26) & 0x3f; 
    if (!CharDef[kk]) 
    {
        InpTable.KeyIndex[kk]=(u_short)i;
        CharDef[kk]=1;
    }
}

InpTable.KeyIndex[TotalKeyNum]=index;
for(i=TotalKeyNum-1; i>0; i--)
	if (!CharDef[i]) InpTable.KeyIndex[i] = InpTable.KeyIndex[i+1];

if ((fw=fopen(fname_tab,"w"))==NULL) {
	print_error("Cannot create");
}

fwrite(&InpTable,1,sizeof(InpTable),fw);
fwrite(ItemTable,sizeof(ITEM),index, fw);
fclose(fw);

}
