/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include "all.h"

Boolean file_exist(char *fname)
{
	char name[256];
	if((!strcmp(fname, "gb"))||(strstr(fname,"pyinput"))
			||(!strcmp(fname,"cce"))) return True;		//ZNPY
	sprintf(name, "%s/%s", dict_path, fname);

	if(access(name, F_OK) == 0) return True;
	else return False;
}

void HZnotifyEncoding(Display *dpy, Window win)
{

        Window twin;
        XClientMessageEvent event;

        hz_toolbar_atom = XInternAtom(dpy, HZ_TOOLBAR_ATOM,False);

        twin = XGetSelectionOwner(dpy,hz_toolbar_atom);
        if(twin != None){
		/* notify current encoding and input method */
	        event.type=ClientMessage;
	        event.window=window1;
	        event.message_type=hz_reply_atom;
	        event.format=32;
	        event.data.b[0] = HZCLIENT_QUERY_ENCODING;
	        event.data.b[1] = HZServer.encoding;
	        XSendEvent(dpy, twin, False, 0, (XEvent *)&event);
	}
}

void HZnotifyInputMethod(Display *dpy, Window win)
{

        Window twin;
        XClientMessageEvent event;

        hz_toolbar_atom = XInternAtom(dpy, HZ_TOOLBAR_ATOM,False);

        twin = XGetSelectionOwner(dpy,hz_toolbar_atom);
        if(twin != None){
                /* notify current encoding and input method */
                event.type=ClientMessage;
                event.window=window1;
                event.message_type=hz_reply_atom;
                event.format=32;
                event.data.b[0] = HZCLIENT_QUERY_INPUTMETHOD;
		event.data.b[1] = cur_inputmethod;
                //strcpy(s+1, input_method);
                XSendEvent(dpy, twin, False, 0, (XEvent *)&event);
	}

}

void HZnotifyStatus(Display *dpy, Window win)
{

        Window twin;
        XClientMessageEvent event;
        char *s = event.data.b;

        hz_toolbar_atom = XInternAtom(dpy, HZ_TOOLBAR_ATOM,False);

        twin = XGetSelectionOwner(dpy,hz_toolbar_atom);
        if(twin != None){
		char str[20];

                /* notify current encoding and input method */
                event.type=ClientMessage;
                event.window=window1;
                event.message_type=hz_reply_atom;
                event.format=32;
                event.data.b[0] = HZCLIENT_QUERY_STATUS;
                strcpy(s+1, str);
                XSendEvent(dpy, twin, False, 0, (XEvent *)&event);
        }

}

void HZnotifyToolbar(void)
{
        Window twin;
        XClientMessageEvent event;

        hz_toolbar_atom = XInternAtom(display, HZ_TOOLBAR_ATOM,False);

        twin = XGetSelectionOwner(display,hz_toolbar_atom);
        if(twin != None){

                /* notify current encoding and input method */
                event.type=ClientMessage;
                event.window=window1;
                event.message_type=hz_config_atom;
                event.format=32;
                event.data.l[0] = ZWIN_FLAG_ENC;
		if(flag_encoding == HZSERVER_ENCODING_GB)
                	event.data.l[1] = ENC_GB;
		else
			event.data.l[1] = ENC_BIG5;
                XSendEvent(display, twin, False, 0, (XEvent *)&event);

                event.data.l[0] = ZWIN_FLAG_CORNER;
		if(flag_corner == True)
			event.data.l[1] = CORNER_FULL;
		else
			event.data.l[1] = CORNER_HALF;
                XSendEvent(display, twin, False, 0, (XEvent *)&event);

                event.data.l[0] = ZWIN_FLAG_PUNCT;
		if(flag_punct == True) 
                        event.data.l[1] = PUNCT_CHINESE;
                else
                        event.data.l[1] = PUNCT_WESTERN;
                XSendEvent(display, twin, False, 0, (XEvent *)&event);

                event.data.l[0] = ZWIN_FLAG_INPUT;
                event.data.l[1] = cur_inputmethod;
                XSendEvent(display, twin, False, 0, (XEvent *)&event);

		event.data.l[0] = ZWIN_FLAG_HIDE;
                if(map_mode == 1)
                        event.data.l[1] = BAR_POP;
                else
                        event.data.l[1] = BAR_HIDE;
                XSendEvent(display, twin, False, 0, (XEvent *)&event);
        }

}

void HZrecvQuery(XClientMessageEvent *ev)
{
}

void proc_close(void)
{

	/* need security check */
	/* e.g., if there are some clients registered to the server */
	myExit();
}

//deprecated
void proc_position(int x, int y)
{

}


void proc_qj(int corner)
{
        flag_corner = (corner == 1 ? True : False);

	HZnotifyToolbar();

	if(map_mode == 0) return;

	if(dmode == HZSERVER_DMODE_ROOT) {
		HZrootCornerFlush();
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		HZonspotFlush();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		HZoffspotFlush();
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		HZoverspotFlush();
	}
}


void proc_punct(int punct)
{
        flag_punct = (punct == 1 ? True : False);

	HZnotifyToolbar();

	if(map_mode == 0) return;

	if(dmode == HZSERVER_DMODE_ROOT){
		HZrootPunctFlush();
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		HZonspotFlush();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		HZoffspotFlush();
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		HZoverspotFlush();
	}
}

void proc_popup_window()
{
	map_mode = 1;
    flag_tip = flag_showtips;

	HZprocSetMode(dmode);
	if(dmode == HZSERVER_DMODE_ROOT){
		XMapRaised(display, window1);
		HZrootFlush();
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		XMapRaised(display, window1);
               	HZoverspotFlush ();
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		HZonspotFlush();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		HZoffspotFlush();

//	} else if(dmode == HZSERVER_DMODE_HW){
//		XMapRaised(display, window6);
//		XMapRaised(display, window5);
//		XMapRaised(display, window4);
	}
	if(HZServer.hzVKwin.onflag)
		XMapRaised(display, window3);
}

void proc_hide_window()
{
	map_mode = 0;

	if(dmode == HZSERVER_DMODE_ROOT){
		XUnmapWindow(display, window1);
		XUnmapWindow(display, window2);
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		XUnmapWindow(display, window1);	
		XUnmapWindow(display, window2);
		HZoverspotHideStatusWindow();
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		XUnmapWindow(display, window1);
		XUnmapWindow(display, window2); //if any
		HZonspotClear();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		HZoffspotHideWindows();
//	} else if(dmode == HZSERVER_DMODE_HW){
//		XUnmapWindow(display, window6);
//		XUnmapWindow(display, window5);
//		XUnmapWindow(display, window4);
//		XUnmapWindow(display, window3);
//		XUnmapWindow(display, window2);
//		XUnmapWindow(display, window1);
	}
	if(HZServer.hzVKwin.onflag)
		XUnmapWindow(display, window3);
        IMM_FlushUserPhrase(chinput_imm);
}

void HZprocToggleWindow(void)
{
	if(map_mode == 1) proc_hide_window();
	else proc_popup_window();
	HZnotifyToolbar();
}

//outdated
void proc_lockwindow(unsigned long w)
{
	if(HZServer.lockw != None)
		return;

	HZServer.lockw = (Window)w;
        alloc_color("#ff0000",  "#000000", "#000000");
        XSetForeground(display,HZServer.ledGC,foreground_pixel);
        HZbaDrawWindow();

}

//outdated
void proc_releasewindow(unsigned long w)
{
	if(HZServer.lockw == None ||
	   w != HZServer.lockw)
		return;

        HZServer.lockw = None;
        alloc_color("#00ff00",  "#000000", "#000000");
        XSetForeground(display,HZServer.ledGC,foreground_pixel);
        HZbaDrawWindow();
}

//outdated
void unlock_window(void)
{
	/* server's absolute request */

        HZServer.lockw = None;
        alloc_color("#00ff00",  "#000000", "#000000");
        XSetForeground(display,HZServer.ledGC,foreground_pixel);
        HZbaDrawWindow();
}

//outdated
void lock_focus_window(void)
{

        /* server's absolute request */
        alloc_color("#ff0000",  "#000000", "#000000");
        XSetForeground(display,HZServer.ledGC,foreground_pixel);
        HZServer.hzBwin.flag = True;
        HZbaDrawWindow();

}

//outdated
void proc_plugin(Window win, int xpos, int ypos)
{
	Window r;
        int x, y, w, h, bw, depth;

	if(HZServer.plugin &&
	   parent != win) return;

        parent = win;
        XReparentWindow(display, window1, parent, xpos, ypos);

        /* after reparent window, adjust the parameter,
           so  it look OK when moving window */
        XGetGeometry(display, window1, &r, &x, &y, &w, &h, &bw, &depth);
        HZServer.hzIwin.x = x;
        HZServer.hzIwin.y = y;

	HZServer.plugin = True;
}
//outdated
void proc_freewin(Window win)
{
        Window r;
        int x, y, w, h, bw, depth;
        if(parent != win) return;

        parent = RootWindow(display, screen_num);
        XReparentWindow(display, window1, parent, 0, 0);

        /* after reparent window, adjust the parameter,
           so  it looks OK when moving window */
        XGetGeometry(display, window1, &r, &x, &y, &w, &h, &bw, &depth);
        HZServer.hzIwin.x = x;
        HZServer.hzIwin.y = y;

        HZServer.plugin = False;

	/* set to default color scheme */
	proc_default();

}

void proc_encodingflag(int enc)
{
	//flag_encoding = enc;

	//config control bar
	HZnotifyToolbar();
}

void HZswitchEncoding()
{
	if(HZServer.encoding == HZSERVER_ENCODING_GB){
                HZServer.hzKwin.cur = 0xa1;
                HZServer.hzKwin.first_start = 0xa1;
                HZServer.hzKwin.first_end   = 0xf7;
                HZServer.hzKwin.second_start = 0xa1;
                HZServer.hzKwin.second_end   = 0xfe;
	}else{
                HZServer.hzKwin.cur = 0xa1;
                HZServer.hzKwin.first_start = 0xa1;
                HZServer.hzKwin.first_end   = 0xf9;
                HZServer.hzKwin.second_start = 0x40;
                HZServer.hzKwin.second_end   = 0x7e;
                HZServer.hzKwin.second_start2 = 0xa1;
                HZServer.hzKwin.second_end2   = 0xfe;
        }
}


/* process the request of input method configuration....
   No valid check as to what encoding currently support, so
   it may encounter problem if this encoding scheme has not
   such input method */

void proc_inmethod(int method)
{
	if(method == cur_inputmethod) return;

	//change the encoding for later use
	if(!strcmp(chinputime[method].encoding, "GB"))
		HZServer.encoding = HZSERVER_ENCODING_GB;
	else
		HZServer.encoding = HZSERVER_ENCODING_BIG5;

	HZswitchEncoding();
	HZswitchInputMethodById(method);

	if(map_mode == 0) HZprocToggleWindow();
}

void proc_default(void)
{
	/* set default color */
        alloc_color(HZSERVER_PANEL_COLOR,  "#000000", "#000000");
        XSetForeground(display, HZServer.panelGC,
                foreground_pixel);
        alloc_color(HZSERVER_DIM_COLOR,  "#000000", "#000000");
        XSetForeground(display, HZServer.dimGC,
                foreground_pixel);
        alloc_color(HZSERVER_LIGHT_COLOR,  "#000000", "#000000");
        XSetForeground(display, HZServer.lightGC,
                foreground_pixel);
        alloc_color(HZSERVER_HZ_COLOR,  "#000000", "#000000");
        HZbaDrawPanel();
        HZbaDrawWindow();
        HZkaDrawPanel();
        HZkaDrawWindow();
}

void proc_textcolor(int r, int g, int b)
{
	char name[10];

	sprintf(name, "#%.2x%.2x%.2x", r, g, b);
	alloc_color(name,  "#000000", "#000000");
}

void proc_panelcolor(int r, int g, int b)
{
        char name[10];

        sprintf(name, "#%.2x%.2x%.2x", r, g, b);
        alloc_color(name,  "#000000", "#000000");
        XSetForeground(display, HZServer.panelGC,
                foreground_pixel);

        HZbaDrawPanel();
        HZbaDrawWindow();
        HZkaDrawPanel();
        HZkaDrawWindow();
}

void proc_dimcolor(int r, int g, int b)
{
        char name[10];

        sprintf(name, "#%.2x%.2x%.2x", r, g, b);
        alloc_color(name,  "#000000", "#000000");
        XSetForeground(display, HZServer.dimGC,
                foreground_pixel);
}

void proc_lightcolor(int r, int g, int b)
{
        char name[10];

        sprintf(name, "#%.2x%.2x%.2x", r, g, b);
        alloc_color(name,  "#000000", "#000000");
        XSetForeground(display, HZServer.lightGC,
                foreground_pixel);
}

//switch mode among root mode , caret mode and handwriting mode
//this function does not map the window
void HZprocSwitchMode(void)
{
	if(map_mode == 0) return;
	
	if(dmode == HZSERVER_DMODE_OVERSPOT){
		dmode = HZSERVER_DMODE_ROOT;
		XUnmapWindow(display, window2);
		XResizeWindow(display, window1,
			HZServer.hzIwin.width + HZServer.hzBwin.width,
			HZServer.hzIwin.height + 
			((HZServer.hzKwin.onflag)?HZServer.hzKwin.height : 0));
	} else if(dmode == HZSERVER_DMODE_ROOT){
		dmode = HZSERVER_DMODE_ONSPOT;
		XUnmapWindow(display, window2);
		XUnmapWindow(display, window1);
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		dmode = HZSERVER_DMODE_OFFSPOT;
	//} else if(dmode == HZSERVER_DMODE_OFFSPOT){
//		dmode = HZSERVER_DMODE_HW;
//		XUnmapWindow(display, window1);
//		XUnmapWindow(display, window2);
//		XUnmapWindow(display, window3);
//		XMapRaised(display, window4);
//		XMapRaised(display, window5);
//		XMapRaised(display, window6);
//	} else if(dmode == HZSERVER_DMODE_HW){

	} else if(dmode == HZSERVER_DMODE_OFFSPOT) {
		dmode = HZSERVER_DMODE_OVERSPOT;
		XUnmapWindow(display, window4);
		XUnmapWindow(display, window5);
		XUnmapWindow(display, window6);
		XResizeWindow(display, window1, 
			HZSERVER_INPUT_WIN16_WIDTH,
			HZSERVER_INPUT_WIN16_HEIGHT);
		XMapRaised(display, window1);
	}
}

void HZprocSetMode(int m)
{
	dmode = m;
	if(map_mode == 0) return;

	if(dmode == HZSERVER_DMODE_ROOT){
		//XUnmapWindow(display, window6);
		//XUnmapWindow(display, window5);
		//XUnmapWindow(display, window4);
		XUnmapWindow(display, window3);
		XUnmapWindow(display, window2);
		XResizeWindow(display, window1,
			HZServer.hzIwin.width + HZServer.hzBwin.width,
			HZServer.hzIwin.height + 
			((HZServer.hzKwin.onflag)?HZServer.hzKwin.height : 0));
		XMapRaised(display, window1);
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		//XUnmapWindow(display, window6);
		//XUnmapWindow(display, window5);
		//XUnmapWindow(display, window4);
		XUnmapWindow(display, window3);
		XUnmapWindow(display, window2);
		XUnmapWindow(display, window1);
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		//XUnmapWindow(display, window6);
		//XUnmapWindow(display, window5);
		//XUnmapWindow(display, window4);
		XUnmapWindow(display, window3);
		XUnmapWindow(display, window2);
		XUnmapWindow(display, window1);
		//popup
		HZoffspotMapWindows();
//	} else if(dmode == HZSERVER_DMODE_HW){
//		XUnmapWindow(display, window1);
//		XUnmapWindow(display, window2);
//		XUnmapWindow(display, window3);
//		XMapRaised(display, window4);
//		XMapRaised(display, window5);
//		XMapRaised(display, window6);
	} else if(dmode == HZSERVER_DMODE_OVERSPOT){
		//XUnmapWindow(display, window6);
		//XUnmapWindow(display, window5);
		//XUnmapWindow(display, window4);
		XUnmapWindow(display, window3);
		XResizeWindow(display, window1, 
			HZSERVER_INPUT_WIN16_WIDTH,
			HZSERVER_INPUT_WIN16_HEIGHT);
		XMapRaised(display, window1);
	}
}

void HZrecvConfig(XClientMessageEvent *ev)
{
        switch(ev->data.l[0]){
		case HZCLIENT_CONFIG_DEFAULTCOLOR:
		     proc_default();
		     break;
		case HZCLIENT_CONFIG_DIMCOLOR:
		     proc_dimcolor(ev->data.l[1],ev->data.l[2],ev->data.l[3]);
		     break;
		case HZCLIENT_CONFIG_LIGHTCOLOR:
		     proc_lightcolor(ev->data.l[1],ev->data.l[2],ev->data.l[3]);
		     break;
                case HZCLIENT_CONFIG_PANELCOLOR:
                     proc_panelcolor(ev->data.l[1],ev->data.l[2],ev->data.l[3]);
                     break;
                case HZCLIENT_CONFIG_TEXTCOLOR:
                     proc_textcolor(ev->data.l[1],ev->data.l[2],ev->data.l[3]);
                     break;
                case HZCLIENT_CONFIG_ENCODING:
                     //proc_encoding(ev->data.l[1]);
		     proc_encodingflag(ev->data.l[1]);		
                     break;
                case HZCLIENT_CONFIG_INMETHOD:
                     proc_inmethod(ev->data.l[1]);
                     break;
		case HZCLIENT_CONFIG_LOCKWINDOW:
		     proc_lockwindow(ev->window);
		     break;
		case HZCLIENT_CONFIG_RELEASEWINDOW:
		     proc_releasewindow(ev->window);
		     break;
		case HZCLIENT_CONFIG_PLUGIN:
		     proc_plugin(ev->data.l[1],ev->data.l[2],ev->data.l[3]);
		     break;
		case HZCLIENT_CONFIG_FREEWIN:
		     proc_freewin(ev->window);
		     break;
		case HZCLIENT_CONFIG_HIDE:
		     HZprocToggleWindow();
		     break;
		case HZCLIENT_CONFIG_POSITION:
		     proc_position(ev->data.l[1],ev->data.l[2]);
		     break;
		case HZCLIENT_CONFIG_QJ:
		     proc_qj(ev->data.l[1]);
		     break;
		case HZCLIENT_CONFIG_PUNCT:
		     proc_punct(ev->data.l[1]);
		     break;
		case HZCLIENT_CONFIG_LOCK:
		     proc_lock(ev->data.l[1]);
		     break;
		case HZCLIENT_CONFIG_SWITCH:
		     HZprocSwitchMode();
		     break;
		case HZCLIENT_CONFIG_KEYBOARD:
		     HZprocRightButton();
		     break;
		case HZCLIENT_CONFIG_HANDWRITING:
//		     HZprocHW();
		     break;
		case HZCLIENT_CONFIG_VOICE:
		     HZprocVoice();
		     break;
		case HZCLIENT_CONFIG_CLOSE:
		     proc_close();
		     break;
		default:
		     break;
	}
}

void HZrealProcCommand(KeySym keysym, int state)
{
        //InputModule *inmd=&HZServer.cxtermInput.InputMd;

        switch(keysym){
                case XK_F1:
		case XK_F12:
                        break;

                case XK_F2:
                        break;
                case XK_F3:
                        break;
                case XK_F4:
                        break;
                case XK_F5:
                        break;
                case XK_F6:
                        break;
                case XK_F7:
                        break;
                case XK_F8:
                        break;
                case XK_F9:
                        break;
                case XK_F10:
                        break;
                case XK_F11:
                        break;
        }
}

void HZprocXIMCommand(KeySym keysym, int state)
{
	HZrealProcCommand(keysym, state);
}

void HZprocCommand(XClientMessageEvent *ev)
{
	HZrealProcCommand(ev->data.l[0], ev->data.l[1]);
}

void HZrecvInput(XClientMessageEvent *ev)
{
        if(ev->data.l[0] >= XK_F1 && ev->data.l[0] <= XK_F12)
                HZprocCommand(ev);
        else
                HZprocMessage(ev);
}

int HZgetInputMethod(char *imd)
{
	int i;
	if(HZServer.encoding == HZSERVER_ENCODING_GB){
		for(i=0; i<index_ime; i++){
			if(!strcmp(chinputime[i].name, imd) && 
			   !strcmp(chinputime[i].encoding, "GB")){
				return i;
			}
		}
	} else if(HZServer.encoding == HZSERVER_ENCODING_BIG5){
		for(i=0; i<index_ime; i++){
			if(!strcmp(chinputime[i].name, imd) && 
			   !strcmp(chinputime[i].encoding, "BIG5")){
				return i;
			}
		}
	}
	return 0;
}

void HZloadInputMethod(int id)
{
	char fname[256];
	long mode = IMM_DOUBLE_BYTE_MODE;

	//We allow absolute path for input method
	if(chinputime[id].fname[0] == '/')
		strcpy(fname, chinputime[id].fname);
	else
		sprintf(fname, "%s/%s", dict_path, chinputime[id].fname);
	if(HZServer.encoding == HZSERVER_ENCODING_GB)
       		chinput_imm = IMM_OpenInput (chinput_imserver, 
       			chinputime[id].module, fname, IMM_LC_GB2312);
	else
       		chinput_imm = IMM_OpenInput (chinput_imserver, 
       			chinputime[id].module, fname, IMM_LC_BIG5);

	IMM_SetInputMode(chinput_imm, mode);

       if (dmode == HZSERVER_DMODE_OVERSPOT) 
	IMM_ConfigInputArea(chinput_imm, 200);
       else
	IMM_ConfigInputArea(chinput_imm, width_inputbar);
	HZresizeWindow(width_inputbar);

	if(chinput_imm == NULL){
		printf("Cannot load input method: %s\n", fname);
		exit(1);
	}
		
	HZnotifyToolbar();
}

void HZswitchInputMethodById(int id)
{
	flag_refresh = 1;

	IMM_CloseInput(chinput_imm);
	//IMM_CloseClient(chinput_imserver);
	//LibRelease();

	//LibOpen();
	//chinput_imserver = IMM_OpenClient("127.0.0.1", 9010);

	cur_inputmethod = id;
	if(!strcmp(chinputime[cur_inputmethod].encoding, "GB"))
		HZServer.encoding = HZSERVER_ENCODING_GB;
	else
		HZServer.encoding = HZSERVER_ENCODING_BIG5;
	HZloadInputMethod(cur_inputmethod);

	//clear display
        if(dmode == HZSERVER_DMODE_ROOT){
                HZrootDrawPanel();
		HZrootInputFlush();
		HZrootDrawInputArea("", 0);
		if(HZServer.hzKwin.onflag){
			HZkaDrawPanel();
			HZkaDrawButton();
			HZkaDrawWindow();
		}
        } else if(dmode == HZSERVER_DMODE_OVERSPOT){
/*
                HZoverspotDrawInputPanel();
		HZoverspotInputFlush();
		if(HZServer.encoding == HZSERVER_ENCODING_GB)
			strcpy(tbuf, chinputime[cur_inputmethod].namegb);
		else
			strcpy(tbuf, chinputime[cur_inputmethod].namebig5);
		HZoverspotDrawInputArea(tbuf, strlen(tbuf));
*/
		HZoverspotFlush();
	} else if(dmode == HZSERVER_DMODE_ONSPOT){
		HZonspotFlush();
	} else if(dmode == HZSERVER_DMODE_OFFSPOT){
		HZoffspotFlush();
	}
	HZnotifyToolbar();
}

void HZprocCirculateInputMethod(void)
{
	int id = cur_inputmethod + 1;	//to next id
	if(id == index_ime) id = 0;
	while(chinputime[id].favorite == 0 ||
	      !file_exist(chinputime[id].fname)) {
			id++;
			if(id == index_ime) id = 0;
	}
	HZswitchInputMethodById(id);
}

