/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include "all.h"
#include "config.h"

#ifdef HAVE_LIBIMLIB
#include "icons/chinput.xpm"
#include "icons/123.xpm"
#endif

void HZserverInfo(void)
{
	fprintf(stderr, "\033[34;1m");
	fprintf(stderr, "%s Version %s -- XIM Server\n",PACKAGE_NAME,PACKAGE_VERSION);
	fprintf(stderr, "Distributed under the terms of the GNU General Public License (GPL)\n");
	fprintf(stderr, "\033[0m");
}

void HZinitDisplay(void)
{

        if ( (display=XOpenDisplay(NULL)) == NULL )
        {
		fprintf(stderr, "\033[33;1m");
                fprintf(stderr, "Error: cannot connect to X server \n");
		fprintf(stderr, "\033[0m");
                exit(1);
        }

}

void HZinitServerAtom(void)
{
	Window twin;

        hz_protocol_atom = XInternAtom(display, HZ_PROTOCOL_ATOM, False);
	hz_toolbar_atom  = XInternAtom(display, HZ_TOOLBAR_ATOM,  False);
        hz_input_atom    = XInternAtom(display, HZ_INPUT_ATOM,    False);
        hz_output_atom   = XInternAtom(display, HZ_OUTPUT_ATOM,   False);
        hz_config_atom   = XInternAtom(display, HZ_CONFIG_ATOM,   False);
        hz_reply_atom    = XInternAtom(display, HZ_REPLY_ATOM,    False);
        hz_query_atom    = XInternAtom(display, HZ_QUERY_ATOM,    False);


        if((twin = XGetSelectionOwner(display, hz_protocol_atom)) != None ){
		fprintf(stderr, "\033[33;1m");
                fprintf(stderr, "Chinese Input Server is already activated.\n");
		fprintf(stderr, "\033[0m");
                exit(1);
        }

	/* claim the owner of these selections */
        XSetSelectionOwner(display, hz_protocol_atom, window1, CurrentTime);
        XSetSelectionOwner(display, hz_input_atom,    window1, CurrentTime);
        XSetSelectionOwner(display, hz_output_atom,   window1, CurrentTime);
        XSetSelectionOwner(display, hz_reply_atom,    window1, CurrentTime);
        XSetSelectionOwner(display, hz_query_atom,    window1, CurrentTime);
        XSetSelectionOwner(display, hz_config_atom,   window1, CurrentTime);
}

void HZinitServerFont(void)
{
	char **missing_list;
        int  missing_count;
        char *def_string;
	char fontname[256];

        char **font_struct_list_return ,**font_name_list_return;
        int  j,font_name_list_num;
	int  tmpwidth=0,tmpheight=0;


        load_font(&font_info, font_latin);
	if(strstr(deflocale,"zh_CN")){
		if(strstr(deflocale,"2312") || strstr(deflocale,"EUC")) 
        		load_font(&hzgbfont_info, font_gb);  
		else if(strstr(deflocale,"gbk")||strstr(deflocale,"GBK")) 
        		load_font(&hzgbkfont_info, font_gbk);  
		else if(strstr(deflocale,"18030")) 
        		load_font(&hzgb18030font_info, font_gb18030);  
		else 
			load_font(&hzgbfont_info, font_gb);

		setlocale(LC_ALL, gblocale);
		sprintf(fontname, "%s,%s,%s,%s", font_latin, font_gb, font_gbk, font_gb18030);
        	if((fontset_gb = XCreateFontSet(display, fontname, &missing_list,
                	&missing_count, &def_string)) == NULL) {
                	fprintf(stderr, "Error : XCreateFontSet() !\n");
                	exit(1);
        	}

        	font_name_list_num = XFontsOfFontSet
                	(fontset_gb, &font_struct_list_return,&font_name_list_return);

	}
	if(strstr(deflocale,"zh_TW"))
	{
        	load_font(&hzbig5font_info, font_big5);
		setlocale(LC_ALL, big5locale);
		sprintf(fontname, "%s,%s", font_latin, font_big5);
		if((fontset_big5 = XCreateFontSet(display, fontname, &missing_list,
			&missing_count, &def_string)) == NULL) {
			fprintf(stderr, "Error : XCreateFontSet() !\n");
			exit(1);
		}
        	font_name_list_num = XFontsOfFontSet
                	(fontset_big5, &font_struct_list_return,&font_name_list_return);

	}
       	if(font_name_list_num > 0){
               	printf("Following charsets:\n");
               	for(j=0; j<font_name_list_num; j++){
                       	printf("%d: %s\n",
                               	j, font_name_list_return[j]);
                        tmpwidth=((XFontStruct*)font_struct_list_return[j])->ascent+((XFontStruct*)font_struct_list_return[j])->descent;
                        tmpheight=((XFontStruct*)font_struct_list_return[j])->ascent+((XFontStruct*)font_struct_list_return[j])->descent;
			if (HZServer.f_width < tmpwidth) HZServer.f_width=tmpwidth;
			if (HZServer.f_height <tmpheight) HZServer.f_height=tmpheight;
               	}
       	}

}


void HZinitServerGC(void)
{
        char **missing_list;
        int  missing_count;
        char *def_string;
	char fontname[256];

        char **font_struct_list_return ,**font_name_list_return;
        int  font_name_list_num;
        Status retval;
        int j;

        if(strstr(deflocale,"zh_CN")){
		//create font set
                if(strstr(deflocale,"2312") || strstr(deflocale,"EUC")){
			get_FontGC(window1,  &offspot_gbgc, hzgbfont_info, "#FFFF00");
		}
		else if(strstr(deflocale,"gbk")||strstr(deflocale,"GBK")){
			get_FontGC(window1,  &offspot_gbkgc, hzgbkfont_info, "#FFFF00");
		}
		else if(strstr(deflocale,"18030")){
			get_FontGC(window1,  &offspot_gb18030gc, hzgb18030font_info, "#FFFF00");
		} else {
			get_FontGC(window1,  &offspot_gbgc, hzgbfont_info, "#FFFF00");
		}
        }
        if(strstr(deflocale,"zh_TW")) {
		get_FontGC(window1,  &offspot_big5gc, hzbig5font_info, "#FFFF00");
	}

        get_FontGC(window1,  &HZServer.normalGC, font_info, color_hz);
	get_FontGC(window1,  &offspot_gc, font_info, "#FFFF00");
	get_FontGC(window1,  &offspot_bggc, font_info, "#0000FF");
        get_ColorGC(window1, &HZServer.dimGC, color_dim);
        get_ColorGC(window1, &HZServer.lightGC, color_light);
        get_ColorGC(window1, &HZServer.panelGC, color_panel);
        get_ColorGC(window1, &HZServer.ledGC, color_led);
        get_ColorGC(window1, &HZServer.barGC, color_bar);

        HZServer.display = display;
        HZServer.window1 = window1;
        HZServer.window2 = window2;
	HZServer.window3 = window3;
	HZServer.window4 = window4;
	HZServer.window5 = window5;
	HZServer.window6 = window6;


	HZServer.lockw  = None;
	HZServer.focus  = False;

#ifdef HAVE_LIBXFT
        if (xft_on == 1) {
            xftfont = XftFontOpen(display, screen_num,
                           XFT_FAMILY, XftTypeString, xft_font_family,
                           XFT_ANTIALIAS, XftTypeBool, xft_anti_aliasing,
                           XFT_SIZE, XftTypeInteger, xft_font_size, 0);

            if (!xftfont) {
                perror("XftFontOpen(): Failed"); exit(1);
            }

            retval = XAllocNamedColor(display,DefaultColormap(display,
                               screen_num),
                               "black", &fg, &dummyc);
            if (!retval) {
              perror("XAllocNamedColor(): Failed"); exit(1);}

            color_fg.color.red = dummyc.red;
            color_fg.color.green = dummyc.green;
            color_fg.color.blue = dummyc.blue;
            color_fg.color.alpha = 0x00ff00;
            color_fg.pixel = fg.pixel;

            for(j = 0; j < 10; j++){
                window_xftdraw[j].win = -1;
                window_xftdraw[j].draw = NULL;
            }
        }
#endif
}

void HZinitServerInputArea(int x, int y, int w, int h)
{
	/* hanzi input area size */
        HZServer.hzIwin.rows = HZSERVER_ROWS;
        HZServer.hzIwin.cols = HZSERVER_COLS;
        HZServer.hzIwin.x = x;
        HZServer.hzIwin.y = y;
        HZServer.hzIwin.width = w;
        HZServer.hzIwin.height =h;
}

void HZinitServerButtonArea(int bx, int by, int bw, int bh)
{
	/* button area size, which is on the right of input area */
	HZServer.hzBwin.flag = True;
        HZServer.hzBwin.x = bx;
        HZServer.hzBwin.y = by;
        HZServer.hzBwin.width = bw;
        HZServer.hzBwin.height = bh;
        HZServer.hzBwin.ledx1 = HZServer.hzIwin.width + bw - 25;
        HZServer.hzBwin.ledy1 = 5;
        HZServer.hzBwin.ledx2 = HZServer.hzIwin.width + bw - 5;
        HZServer.hzBwin.ledy2 = 11;
        HZServer.hzBwin.btnx1 = HZServer.hzIwin.width + bw - 23;
        HZServer.hzBwin.btny1 = HZServer.hzIwin.height - 10;
        HZServer.hzBwin.btnx2 = HZServer.hzIwin.width + bw - 7;
        HZServer.hzBwin.btny2 = HZServer.hzIwin.height - 10;
        HZServer.hzBwin.btnx3 = HZServer.hzIwin.width + bw - 15;
        HZServer.hzBwin.btny3 = HZServer.hzIwin.height - 3;

	// two buttons
        HZServer.hzBwin.q_x1 = HZServer.hzBwin.ledx1 - 26;
        HZServer.hzBwin.q_y1 = HZServer.hzBwin.ledy1;
        HZServer.hzBwin.q_x2 = HZServer.hzBwin.q_x1 + 19;
	HZServer.hzBwin.q_y2 = HZServer.hzBwin.q_y1 + 19;

        HZServer.hzBwin.p_x1 = HZServer.hzBwin.q_x1;
        HZServer.hzBwin.p_y1 = HZServer.hzBwin.q_y1 + 22;
        HZServer.hzBwin.p_x2 = HZServer.hzBwin.p_x1 + 19;
        HZServer.hzBwin.p_y2 = HZServer.hzBwin.p_y1 + 19;
        HZServer.hzBwin.offset = 16;
}

void HZinitServerBrowseArea(int kx, int ky, int kw, int kh,
	int offx1, int offy1, int offx2, int offy2)
{
	/* keyboard area... popup when press the lower-right button */
	HZServer.hzKwin.onflag = False;
	HZServer.hzKwin.offx1 = offx1;
        HZServer.hzKwin.offy1 = offy1;
        HZServer.hzKwin.offx2 = offx2;
        HZServer.hzKwin.offy2 = offy2;
        HZServer.hzKwin.x = kx;
        HZServer.hzKwin.y = ky;
        HZServer.hzKwin.width = kw;
        HZServer.hzKwin.height = kh;
	HZServer.hzKwin.rows = 10;
	HZServer.hzKwin.cols = 10;
        HZServer.hzKwin.prevx2 = kw - 50;
        HZServer.hzKwin.prevy2 = HZServer.hzIwin.height + kh - 20;
        HZServer.hzKwin.prevx3 = kw - 40;
        HZServer.hzKwin.prevy3 = HZServer.hzIwin.height + kh - 30;
        HZServer.hzKwin.prevx1 = kw - 40;
        HZServer.hzKwin.prevy1 = HZServer.hzIwin.height + kh - 10;
        HZServer.hzKwin.nextx1 = kw - 10;
        HZServer.hzKwin.nexty1 = HZServer.hzIwin.height + kh - 20;
        HZServer.hzKwin.nextx3 = kw - 20;
        HZServer.hzKwin.nexty3 = HZServer.hzIwin.height + kh - 30;
        HZServer.hzKwin.nextx2 = kw - 20;
        HZServer.hzKwin.nexty2 = HZServer.hzIwin.height + kh - 10;

        switch(HZServer.encoding)
        {
                case HZSERVER_ENCODING_GB:
/*GB2312
		        HZServer.hzKwin.cur = 0xa1;
			HZServer.hzKwin.first_start = 0xa1;
			HZServer.hzKwin.first_end   = 0xf7;
			HZServer.hzKwin.second_start = 0xa1;
			HZServer.hzKwin.second_end   = 0xfe;
*/
//gbk
			HZServer.hzKwin.cur           = 0x81;
			HZServer.hzKwin.first_start   = 0x81;
			HZServer.hzKwin.first_end     = 0xfe;
			HZServer.hzKwin.second_start  = 0x40;
                        HZServer.hzKwin.second_end    = 0x7e;
                        HZServer.hzKwin.second_start2 = 0x80;
                        HZServer.hzKwin.second_end2   = 0xfe;
                	break;

                case HZSERVER_ENCODING_BIG5:

			HZServer.hzKwin.cur = 0xa1;
                        HZServer.hzKwin.first_start   = 0xa1;
                        HZServer.hzKwin.first_end     = 0xf9;
                        HZServer.hzKwin.second_start  = 0x40;
                        HZServer.hzKwin.second_end    = 0x7e;
                        HZServer.hzKwin.second_start2 = 0xa1;
                        HZServer.hzKwin.second_end2   = 0xfe;
                	break;

                default:
                	break;
        }
}

void HZinitControlBar(void)
{
        Window twin;

        hz_toolbar_atom = XInternAtom(display, HZ_TOOLBAR_ATOM,False);

        twin = XGetSelectionOwner(display,hz_toolbar_atom);
        if(twin == None){
		if(access("/usr/bin/zwincontrol", X_OK) == 0)
			system("/usr/bin/zwincontrol &");
	}
}

void HZparseParameters(int argc, char **argv)
{
	int i, ow_encoding = 0;

	if (argc >= 2) {

		for(i=1; i<argc; i++){
			if(!strcmp(argv[i], "-h")) usage();

			if(!strcmp(argv[i], "-gb")){	//force to GB
				ow_encoding = 1;
				strcpy(deflocale, gblocale);
				HZServer.encoding = HZSERVER_ENCODING_GB;
				flag_encoding = HZSERVER_ENCODING_GB;
				cur_inputmethod = HZgetInputMethod(input_method_gb);
			}
			if(!strcmp(argv[i], "-big5")){	//force to Big5
				ow_encoding = 1;
				strcpy(deflocale, big5locale);
				HZServer.encoding = HZSERVER_ENCODING_BIG5;
				flag_encoding = HZSERVER_ENCODING_BIG5;
				cur_inputmethod = HZgetInputMethod(input_method_big5);
			}
			if(!strcmp(argv[i], "-root")){
				dmode = HZSERVER_DMODE_ROOT;
				flag_automode = False;
			}
                	if(!strcmp(argv[i], "-overspot")){
                        	dmode = HZSERVER_DMODE_OVERSPOT;
				flag_automode = False;
			}
			if(!strcmp(argv[i], "-onspot")){
				dmode = HZSERVER_DMODE_ONSPOT;
				flag_automode = False;
			}
			if(!strcmp(argv[i], "-offspot")){
				dmode = HZSERVER_DMODE_OFFSPOT;
				flag_automode = False;
			}

		}/*for*/
	}/*if*/

	if (ow_encoding == 0) {
		if (strstr(deflocale,"zh_CN"))
			strcpy(gblocale, deflocale);
		if (strstr(deflocale,"zh_TW"))
			strcpy(big5locale, deflocale);
	}
}

void HZinitIcons(void)
{
#ifdef  HAVE_LIBIMLIB
	int w,h;
	icon_id = Imlib_init(display);
	//icon chinput
	im_chinput = Imlib_create_image_from_xpm_data(icon_id,icon_chinput);
	w = im_chinput->rgb_width;
	h = im_chinput->rgb_height;
	Imlib_render(icon_id, im_chinput, w, h);
	//icon 123
	im_123 = Imlib_create_image_from_xpm_data(icon_id,icon_123);
	w = im_123->rgb_width;
	h = im_123->rgb_height;
	Imlib_render(icon_id, im_123, w, h);
#endif
}

//default setting of the program
void HZinitResource(void)
{
        /* load definition from header file */
        strcpy(font_latin, 	HZSERVER_FONT);
        strcpy(font_gb, 	HZSERVER_GB_FONT);
        strcpy(font_gb18030, 	HZSERVER_GB18030_FONT);
        strcpy(font_big5, 	HZSERVER_BIG5_FONT);
        strcpy(color_dim, 	HZSERVER_DIM_COLOR);
        strcpy(color_light, 	HZSERVER_LIGHT_COLOR);
        strcpy(color_panel, 	HZSERVER_PANEL_COLOR);
	strcpy(color_hz,	HZSERVER_HZ_COLOR);
	strcpy(color_led,	HZSERVER_LED_COLOR);
	strcpy(color_bar,	HZSERVER_BAR_COLOR);

	//enable two locales at the same time
	strcpy(imlocale, IMLOCALE);

	strcpy(deflocale, getenv("LANG"));

	if(getenv("LANG") && strstr(getenv("LANG"), "zh_TW")){
		//strcpy(deflocale, big5locale);
		//strcpy(imlocale,  "zh_TW");
		flag_encoding = HZSERVER_ENCODING_BIG5;
               	HZServer.encoding = HZSERVER_ENCODING_BIG5;
		//flag_enc = True;	//gb encoding
	} else {
		//strcpy(deflocale, gblocale);
		//strcpy(imlocale,  "zh_CN");
		flag_encoding = HZSERVER_ENCODING_GB;
              	HZServer.encoding = HZSERVER_ENCODING_GB;
		//flag_enc = False;
	}

	flag_corner = False;	//half
	flag_punct = False;	//chinese punctuation
	flag_lock = LOCK_NONE;	//encoding not locked
	flag_ec  = True;	//chinese output
	flag_english = False;	//no english
	flag_single = 0;	//not single choice
	bzero(input_buf, 80);
	map_mode = 0;		//not mapped when started
	index_ime = 0;		//ime list index
	boxdrawn = False;
	dmode = HZSERVER_DMODE_OVERSPOT;
	hmode = HZSERVER_HMODE_NO;
	strcpy(input_method_gb, "ZNPY");
	strcpy(input_method_big5, "PY");
	strcpy(dict_path, IMDIR);
	cur_inputmethod = 0;
	flag_showime = True;
	flag_automode = True;
	flag_client = HZSERVER_AREAMODE_CLIENT;	//client decide the area and position
	width_input_win = HZSERVER_INPUT_WIN16_WIDTH;
	width_inputbar = HZSERVER_COLS;
	flag_up = False;
	flag_down = False;
	prev_dmode = -1;
	hwmode = False;
}	


static int mystrcmp(char *str1, char *str2)
{
	return strncmp(str1, str2, strlen(str2));
}

static char *get_value(char *line)
{
        char *ptr, *ptr2;
        line[strlen(line)-1] = '\0';            //trim line
        ptr = strchr(line, '=') + 1;                //search value
	while(*ptr == ' ' || *ptr == '\t')ptr++;//skip spaces
	ptr2 = ptr;
	while(*ptr2 && *ptr2 != ' ' && *ptr2 != '\t') ptr2++;
	*ptr2 = '\0';
        return ptr;
}

void HZinitDaemon()
{
	pid_t id;

	id = fork();
	if(id == -1) return;		//error in fork
	else if(id > 0) exit(0);	//parent
	else return;			//child
}


//This will overwrite the default value of program
//
void HZloadRCFile(void)
{

	FILE *fp = NULL;
        char line[255];

	// try ~/.chinput first
        if(getenv("HOME")){
		sprintf(line, "%s/.chinput", (char *)getenv("HOME"));
        	fp = fopen(line, "r");
	}

	// system ad file
	if(fp == NULL){
        	if((fp = fopen(RESOURCEFILE, "r")) == NULL){
                	printf("chinput: Chinput.ad not found.\n");
			exit(1);
        	}
	}

	while(fgets(line, 256, fp)){
		if(line[0] == '!') continue;
		if(line[0] == '\n') continue;
		if(!mystrcmp(line, "chinput.gblocale")){
			char *ptr = get_value(line);
			strcpy(gblocale, ptr);
		} else if(!mystrcmp(line, "chinput.big5locale")){
			char *ptr = get_value(line);
			strcpy(big5locale, ptr);
		} else if(!mystrcmp(line, "chinput.dmode")){
			char *ptr = get_value(line);
			if(!strcmp(ptr, "AUTO")){
				flag_automode = True;
				dmode = HZSERVER_DMODE_OVERSPOT;
			} else if(!strcmp(ptr, "ROOT")){
				dmode = HZSERVER_DMODE_ROOT;
				flag_automode = False;
			} else if(!strcmp(ptr, "OVERSPOT") ||
				!strcmp(ptr, "CARET")){
				dmode = HZSERVER_DMODE_OVERSPOT;
				flag_automode = False;
			} else if(!strcmp(ptr, "ONSPOT")){
				dmode = HZSERVER_DMODE_ONSPOT;
				flag_automode = False;
			} else if(!strcmp(ptr, "OFFSPOT")) {
				dmode = HZSERVER_DMODE_OFFSPOT;
				flag_automode = False;
			}
		} else if(!mystrcmp(line, "chinput.hmode")){
			if(!strcmp(get_value(line), "AUTO"))
				hmode = HZSERVER_HMODE_AUTO;
			else
				hmode = HZSERVER_HMODE_NO;
		} else if(!mystrcmp(line, "chinput.cmode")){
			if(!strcmp(get_value(line), "AUTO"))
				cmode = HZSERVER_CMODE_AUTO;
			else
				cmode = HZSERVER_CMODE_NO;
		} else if(!mystrcmp(line, "chinput.areamode")){
			if(!strcmp(get_value(line), "CLIENT"))
				flag_client = HZSERVER_AREAMODE_CLIENT;
			else
				flag_client = HZSERVER_AREAMODE_SERVER;
		} else if(!mystrcmp(line, "chinput.dictionary")){
                	strcpy(dict_path, get_value(line));
		} else if(!mystrcmp(line, "chinput.showime")){
			if(!strcmp(get_value(line), "YES"))
				flag_showime = 1;
			else
				flag_showime = 0;
		} else if(!mystrcmp(line,"chinput.showtips")){
			if(!strcmp(get_value(line), "YES"))
				flag_showtips = 1;
			else
				flag_showtips = 0;
		} else if(!mystrcmp(line, "chinput.font")){
                	strcpy(font_latin, get_value(line));
        	} else if(!mystrcmp(line, "chinput.gbfont")){
                	strcpy(font_gb, get_value(line));
        	} else if(!mystrcmp(line, "chinput.gbkfont")){
                	strcpy(font_gbk, get_value(line));
        	} else if(!mystrcmp(line, "chinput.gb18030font")){
                	strcpy(font_gb18030, get_value(line));
        	} else if(!mystrcmp(line, "chinput.big5font")){
                	strcpy(font_big5, get_value(line));
		} else if(!mystrcmp(line, "chinput.width")){
			width_inputbar = atoi(get_value(line));
        	} else if(!mystrcmp(line, "chinput.dimcolor")){
                	strcpy(color_dim, get_value(line));
        	} else if(!mystrcmp(line, "chinput.lightcolor")){
                	strcpy(color_light, get_value(line));
        	} else if(!mystrcmp(line, "chinput.panelcolor")){
                	strcpy(color_panel, get_value(line));
		} else if(!mystrcmp(line, "chinput.hzcolor")){
                	strcpy(color_hz, get_value(line));
        	} else if(!mystrcmp(line, "chinput.ledcolor")){
                	strcpy(color_led, get_value(line));
        	} else if(!mystrcmp(line, "chinput.barcolor")){
                	strcpy(color_bar, get_value(line));
        	} else if(!mystrcmp(line, "chinput.hwtimeout")){
                	hw_timeout = atoi(get_value(line));
        	} else if(!mystrcmp(line, "chinput.inputmethod.big5")){
                	strcpy(input_method_big5, get_value(line));
		} else if(!mystrcmp(line, "chinput.inputmethod.gb")){
                        strcpy(input_method_gb, get_value(line));
#ifdef HAVE_LIBXFT
		} else if(!mystrcmp(line, "xft.font.family")){
                        strcpy(xft_font_family, get_value(line));
		} else if(!mystrcmp(line, "xft.font.size")){
                        xft_font_size  = atoi(get_value(line));
		} else if(!mystrcmp(line, "xft.anti-aliasing")){
			if(!strcmp(get_value(line), "YES"))
			     xft_anti_aliasing = 1;
			else xft_anti_aliasing = 0;
		} else if(!mystrcmp(line, "xft.on")){
			if(!strcmp(get_value(line), "YES"))
			     xft_on = 1; else xft_on = 0;
#endif
                }
	}

	fclose(fp);
}

//Loading Resource File
//Chinput will search for .chinput at your home directory first,
//if not found, it will load the system file /usr/lib/ZWinPro/Chinput.ad
void HZloadRCIME(void)
{
	FILE *fp;
	char fname[256];
	char line[256];

	sprintf(fname, "%s/.chinput", getenv("HOME"));
	fp = fopen(fname, "r");
	if(!fp){
		fp = fopen(RESOURCEFILE, "r");
		if(!fp) {
			printf("Cannot open resource file Chinput.ad\n");
			exit(1);
		}
	} 
	while(fgets(line, 256, fp)){
		if(line[0] == '[') {    //find an entry
			char *ptr;
			ptr = strchr(line, ']');
			*ptr = '\0';
			strcpy(chinputime[index_ime].name, line+1);
			if(!fgets(line, 256, fp)) return;
			strcpy(chinputime[index_ime].namegb, get_value(line));
			if(!fgets(line, 256, fp)) return;
			strcpy(chinputime[index_ime].namebig5, get_value(line));
			if(!fgets(line, 256, fp)) return;
			strcpy(chinputime[index_ime].encoding,get_value(line));
			if(!fgets(line, 256, fp)) return;
			strcpy(chinputime[index_ime].fname, get_value(line));
			if(!fgets(line, 256, fp)) return;
			strcpy(chinputime[index_ime].module, get_value(line));
			if(!fgets(line, 256, fp)) return;
			if ((!strcmp(get_value(line),"YES")) &&
			   (((!strcmp(chinputime[index_ime].encoding,"GB")) &&
                             (HZServer.encoding == HZSERVER_ENCODING_GB)) ||
			   ((!strcmp(chinputime[index_ime].encoding,"BIG5")) &&
                             (HZServer.encoding == HZSERVER_ENCODING_BIG5))))
				chinputime[index_ime].favorite = 1;
			else
				chinputime[index_ime].favorite = 0;
			//dictinary validate
			index_ime ++;
		}
	}
	fclose(fp);

	if(getenv("LANG") && strstr(getenv("LANG"), "zh_TW"))
		cur_inputmethod = HZgetInputMethod(input_method_big5);
	else
		cur_inputmethod = HZgetInputMethod(input_method_gb);
}

void HZinitWindows(void)
{
	//normal input window
	int winx=0, winy=0, winw=0, winh=0;
	int bwinx=0, bwiny=0, bwinw=0, bwinh=0;
	int kwinx=0, kwiny=0, kwinw=0, kwinh=0;
	int offx1=0, offx2=0, offy1=0, offy2=0;

	//winmode input window
	int win1x, win1y, win1w, win1h;
	int win2x, win2y, win2w, win2h;
	int win3x, win3y, win3w, win3h;
	int win4x, win4y, win4w, win4h;

	winx = HZSERVER_STARTX;
       	winy = HZSERVER_STARTY;
       	winw = HZSERVER_16_WIDTH2;
       	winh = HZSERVER_16_HEIGHT2;
       	bwinx = HZSERVER_16_WIDTH2;
       	bwiny = 0;
       	bwinw = HZSERVER_BWIN16_WIDTH;
       	bwinh = HZSERVER_BWIN16_HEIGHT;
       	kwinx = 0;
       	kwiny = HZSERVER_16_HEIGHT2;
       	kwinw = HZSERVER_16_WIDTH2 + HZSERVER_BWIN16_WIDTH;
       	kwinh = HZSERVER_KWIN16_HEIGHT;
       	offx1 = HZSERVER_KWIN16_XOFFSET1;
       	offy1 = HZSERVER_KWIN16_YOFFSET1;
       	offx2 = HZSERVER_KWIN16_XOFFSET2;
       	offy2 = HZSERVER_KWIN16_YOFFSET2;

	win1x = winx;
	win1y = winy;
	win1w = HZSERVER_INPUT_WIN16_WIDTH;
	win1h = HZSERVER_INPUT_WIN16_HEIGHT;

	win2x = win1x + HZSERVER_WIN16_XOFFSET;
	win2y = win1y;
	win2w = HZSERVER_CHOICE_WIN16_WIDTH;
	win2h = HZSERVER_CHOICE_WIN16_HEIGHT;

	win3x = winx;
	win3y = winy;
	win3w = HZSERVER_VK_WIDTH;
	win3h = HZSERVER_VK_HEIGHT;

	win4x = winx;
	win4y = winy;
	win4w = HZSERVER_HW_WIDTH;
	win4h = HZSERVER_HW_HEIGHT;

	/* create the window  with input area and button area */
	if(dmode == HZSERVER_DMODE_ROOT) {
		window1 = create_win(winx, winy, winw + bwinw, winh);
	} else {
		window1 = create_win(win1x, win1y, win1w, win1h);
	}
	window2 = create_win(win2x, win2y, win2w, win2h);
	window3 = create_win(win3x, win3y, win3w, win3h);
	window4 = create_win(win4x, win4y, win4w, win4h);

	//creating the child windows, and reparent it
	window5 = create_win(0, 0, HZSERVER_HW_CHILD_WIDTH, HZSERVER_HW_CHILD_HEIGHT);
	window6 = create_win(0, 0, HZSERVER_HW_CHILD_WIDTH, HZSERVER_HW_CHILD_HEIGHT);
	XReparentWindow(display, window5, window4, 
		HZSERVER_HW_XOFF, HZSERVER_HW_YOFF);
	XReparentWindow(display, window6, window4, 
		HZSERVER_HW_XOFF*2 + HZSERVER_HW_CHILD_WIDTH, HZSERVER_HW_YOFF);

	HZinitServerInputArea(winx, winy, winw, winh);
	HZinitServerButtonArea(bwinx, bwiny, bwinw, bwinh);
	HZinitServerBrowseArea(kwinx, kwiny, kwinw, kwinh,
		offx1, offy1, offx2, offy2);
	HZinitServerCaretMode(win1x, win1y, win1w, win1h,
		win2x, win2y, win2w, win2h);
	HZinitServerVirtualKeyboard(win3x, win3y, win3w, win3h);
//	HZinitServerHandwritingPad(win4x, win4y, win4w, win4h);
}

void HZinitIME(void)
{
	flag_refresh = 1;		//need not get display/input buffer

	//open ime server
	chinput_imserver = IMM_OpenClient("127.0.0.1", 9010);

	//cur_inputmethod = HZgetInputMethod(input_method);
	HZloadInputMethod(cur_inputmethod);

        HZnotifyToolbar();

	XSetErrorHandler(HZerrorHandler);

	/* detect toolbar */
	HZnotifyEncoding(display, window1);
	HZnotifyInputMethod(display, window1);
	HZnotifyStatus(display, window1);

	//XFlush(display);
	fprintf(stderr, "Chinput ................................................[\033[32;1mOK\033[0m]\n");

}

