#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pinyin.h>
#include "safestring.h"

PinYin pytab[26][MAX_EACH_PY];
char hztab[MAX_PY_NUM][MAX_EACH_HZ]; 


//Convert Phrase_Key to PY_Key
void Key2PYKey(u_char *key, u_short *pykey, u_char len)
{
        int i,j,p;

        for (i=0; i<len; i++) pykey[i] = '\0';

        j=p=0;
        for (i=0; i<len; i++){
                pykey[i] |= (key[j++] << (2 + p)) & 0x3ff;
                pykey[i] |= key[j] >> (6 - p);
                p += 2;
                if ( (p %= 8) == 0 ) j++;
        }

}


int LoadTable(char* pathname)
{
  FILE *stream;
  char str[1024],strpy[15],strhz[1000];
  int i=0, j=0, lastpy=0, curpy;
   
  if ( (stream = fopen( pathname, "r" )) == NULL )
  {
    fprintf(stderr,"%s file not found\n",pathname);
    exit(1);
  }
  while ( !feof( stream ))
  {
    if ( fgets(str,1024,stream) != NULL)
    {
      sscanf(str,"%s %s",strpy,strhz);
      curpy = strpy[0]-'a';
      if (curpy != lastpy) j = 0; 
      strcpy(pytab[curpy][j].py,strpy);
      pytab[curpy][j].key = i+1;
      lastpy = curpy;
      i++,j++;
    }
  }
  fclose(stream);
  
  return 0;
}

int PrintOutPhrase(char *infile,char *pathname)
{
  FILE *out,*in;
  u_short len;
  char str[250];
  u_char key[MAX_KEY_LEN],
           tmppy[10],pinyin[70];
  u_short pykk[12];
  u_short count,keyint,keytmp;
  char tab='\011',*p;
  int i,j,k,size,l,m,fsize;
  u_char freq;
  Phrase *kph;
  SysPhrase *sysph_tmp;
  char *file;

  if ( (out = fopen( pathname, "wb" )) == NULL )
  {
    fprintf(stderr,"%s cant open.\n",pathname);
    exit(1);
  }

  if ( (in = fopen( infile, "rb" )) == NULL )
  {
    fprintf(stderr,"%s cant open.\n",infile);
    exit(1);
  }

  if (fseek(in,-sizeof(int),SEEK_END) == -1 ||
      fread(&fsize,sizeof(int),1,in) != 1 ||
      fsize != ftell(in)-sizeof(int))   // error!!
  {
      fprintf(stderr,"%s is not a valid pinyin phrase file.\n",infile);
      exit(1);
  }

  if ( (file = (char*)malloc(fsize)) == NULL)
  {
       fprintf(stderr,"Not enough memory!\n");
       exit(1);
  }

  fseek(in,0,SEEK_SET);
  fread(file,fsize,1,in);

  p = file;

  kph=((SysPhrase*)p)->phrase;
  for(i = 1; i < MAX_PY_NUM; i++)
  {
     sysph_tmp = (SysPhrase*)p;
     p = (char*)sysph_tmp->phrase;
     for(j = 0; j < sysph_tmp->count; j++)
     {
         kph = (Phrase *)p; 
         len = kph->len;
         pinyin[0] = '\0';  
         Key2PYKey(kph->key,pykk,len);
 	  for(k=0; k<len; k++)
         {
	    keyint = pykk[k];
	    for(l=0; l<26; l++)
	      for(m=0; keytmp=pytab[l][m].key; m++)
	        if (keyint == keytmp)
                {
		   snprintf(tmppy,sizeof(tmppy),"%s ",pytab[l][m].py);
                   break;
                }
	    if (strlen(pinyin) + strlen(tmppy) + 1 < sizeof(pinyin))
		strcat(pinyin,tmppy);
	    else {
		fprintf(stderr, "buffer overrun1\n");
		abort();
	    }
	 }

         for(k = 0; k < kph->count; k++)
         {
	     if (sizeof(str) < (size_t)(2 * len + 1)) {
		 fprintf(stderr, "buffer overrun2\n");
		 abort();
	     } else
		 memcpy(str,kph->key+KEYLEN(len)+(2*len+1)*k,2*len);
             str[2*len] = '\0';
             freq = kph->key[KEYLEN(len)+(2*len+1)*k+2*len];
             fprintf(out,"%s %s %d\n",str,pinyin,freq);
         }
         p += SizeOfPhrase(kph->len,kph->count); 
     }
  } // MAX_PY

  fclose(in);
  fclose(out);
  return 1;
}

int main(int argc,char **argv)
{
  if (argc != 3) 
  {
    fprintf(stderr,"usage: %s <input_name> <output_name>\n",argv[0]);
    return 1;
  }
  LoadTable("./pinyin.map");
  PrintOutPhrase(argv[1],argv[2]);

  return 0;  // no error
}
