/*
 *
 * UNICON - The Console Chinese & I18N
 * Copyright (c) 1999-2002
 *
 * This file is part of UNICON, a console Chinese & I18N
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file COPYING directory of this archive
 * Author: see CREDITS
 */

/* hzinput.h -- definitions used in input methods */

#ifndef HZINPUT_H
#define HZINPUT_H

#define MAX_INPUT_LENGTH        17
#define MAGIC_NUMBER            "WBGBK"
#define CIN_ENAME_LENGTH        24
#define CIN_CNAME_LENGTH        16
#define MAX_PHRASE_LENGTH       20 
#define SELECT_KEY_LENGTH       16 
#define END_KEY_LENGTH          16

typedef struct {
  unsigned long key;        /* sizeof(ITEM=8) */
  unsigned short ch;
  unsigned short phindex;
} ITEM;

typedef struct {
        char magic_number[sizeof(MAGIC_NUMBER)];    /* magic number */
        char ename[CIN_ENAME_LENGTH];               /* ascii name */
        char cname[CIN_CNAME_LENGTH];               /* prompt */
        char selkey[SELECT_KEY_LENGTH];             /* select keys */

        char last_full;         /* last full code need a more SPACE? */
        int TotalKey;           /* number of keys needed */
        int MaxPress;           /* Max len of keystroke */
        int MaxDupSel;          /* how many keys used to select */
        int TotalChar;          /* Defined characters */

        unsigned char KeyMap[128];     /* Map 128 chars to 64(6 bit) key index */
        unsigned char KeyName[64];     /* Map 64 key to 128 chars */
        unsigned short KeyIndex[64];   /* 64 key first index of TotalChar */

        int PhraseNum;          /* Total Phrase Number */
        ITEM *item;             /* item */
        char *Phrasetable;
        int *Phraseindex;

} hz_input_table;

typedef struct __HZ_INPUT_TABLE__
{
   hz_input_table *cur_table;
   int MaxSelectLen;
   int MAX_SEL_LENGTH;
   int HTMode,       // Hint-Mode, Display KEYS for each entry
       LXMode;       // Lian-Xiang-Mode

   char seltab[16][MAX_PHRASE_LENGTH];
   char seltabkey[16][5];

   int CurSelNum;              /* Current Total Selection Number */
   unsigned long InpKey[MAX_INPUT_LENGTH],
                 save_InpKey[MAX_INPUT_LENGTH];
   /* Input key buffer */

   int InputCount, InputMatch; 

   int CharIndex[15];   // starting index of matched char/phrases
   int StartKey, EndKey,
       NextPageIndex,
       CurrentPageIndex,
       MultiPageMode;
   int save_StartKey, save_EndKey,
       save_NextPageIndex,
       save_CurrentPageIndex,
       save_MultiPageMode; 

   int QMode,        // Query-Mode, 'z' support.
       LXon;         // If LX on or off.

   char LXchar[MAX_PHRASE_LENGTH];
   int PassedPage[30]; // should be longer than 178/10, where 178 is the 
   		       // largest amont of phrases with the same HZ header.
   int PageNum; //Index of current page for LXmode
   
   unsigned long val1, key1, Qmask;
} HzInputTable_T;

#endif
