//---------------------------------------------------------------------------
// Copyright (C) 1999 Dallas Semiconductor Corporation, All Rights Reserved.
// 
// Permission is hereby granted, free of charge, to any person obtaining a 
// copy of this software and associated documentation files (the "Software"), 
// to deal in the Software without restriction, including without limitation 
// the rights to use, copy, modify, merge, publish, distribute, sublicense, 
// and/or sell copies of the Software, and to permit persons to whom the 
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES 
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name of Dallas Semiconductor 
// shall not be used except as stated in the Dallas Semiconductor 
// Branding Policy. 
//---------------------------------------------------------------------------
//
//  tstmlane.c - Test application to test the EPROM programming functions.
//
//  Version: 1.03
//
//  History: 1.01 -> 1.02  Changed to generic OpenCOM/CloseCOM for easier 
//                         use with other platforms.  
//           1.02 -> 1.03  Removed caps in #includes for Linux capatibility
//                         Changed to use Aquire/Release 1-Wire Net functions
//

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "mlan.h"

// external MLan functions to test
extern int  MLanTouchByte(int);
extern int  MLanFirst(int,int);
extern int  MLanNext(int,int);
extern void MLanSerialNum(uchar *, int);
extern void MLanFamilySearchSetup(int);
extern void MLanSkipFamily(void);
extern int  MLanAccess(void);
extern int  MLanOverdriveAccess(void);
extern int  MLanVerify(int);
extern int  MLanBlock(int, uchar *, int);
extern int  MLanReadPacketStd(int, int, uchar *);
extern int  MLanWritePacketStd(int, uchar *, int, int, int);   
extern int  MLanSpeed(int);
extern int  MLanLevel(int);
extern int  MLanReadFile(uchar *, uchar *);
extern int  MLanFormatWriteFile(uchar *, int, uchar *);
extern int  MLanProgramPulse(void);
extern int  MLanProgramByte(int, int, int, int, int);
extern int  Aquire1WireNet(char *, char *);
extern void Release1WireNet(char *);

// local funcitons
void PrintSerialNum(void);

//----------------------------------------------------------------------
//  Main Test
//
void main(short argc, char **argv)
{
   int PortNum=1,rslt,i,testcnt=0,length,pg;
   uchar tran_buffer[2000];
   char return_msg[128];
  
   // check for required port name
   if (argc != 2)
   {
      printf("1-Wire Net name required on command line!\n"
             " (example: \"COM1\" (Win32 DS2480),\"/dev/cua0\" "
             "(Linux DS2480),\"1\" (Win32 TMEX)\n");
      exit(1);
   }

   // attempt to aquire the 1-Wire Net
   if (!Aquire1WireNet(argv[1], return_msg))
   {  
      printf("%s",return_msg);
      exit(1);
   }

   // success
   printf("%s",return_msg);

   //----------------------------------------
   // Introduction
   printf("\n/---------------------------------------------\n");
   printf("  The following is a test excersize of the\n"
          "  MicroLAN public domain library Version 1.03.\n\n"
          "  This test was run using a 12 Volt program capable \n"
          "  adapter and 1 DS1985 and 1 DS1982\n\n");

   //----------------------------------------
   // Find the DS1982 on the MicroLAN
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Find the DS1982 on the MicroLAN\n",testcnt++);

   // find the first device 
   rslt = MLanFirst(TRUE, FALSE);
   // print the Serial Number of the device just found
   PrintSerialNum();

   //----------------------------------------
   // Write a packet with MLanWritePacketStd to DS1982 
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Write a packet with MLanWritePacketStd to DS1982\n",testcnt++);
     
   // set the page to write
   pg = 3; 

   for (i = 0; i < 29; i++)
      tran_buffer[i] = (uchar)i;

   printf("Write EPROM page %d: %d\n",pg,MLanWritePacketStd(pg,tran_buffer,29,TRUE,0));

   for (i = 0; i < 29; i++)
      tran_buffer[i] = 0;

   length = MLanReadPacketStd(TRUE,pg,tran_buffer);

   printf("Read page %d: %d\n",pg,length);

   for (i = 0; i < length; i++)
      printf("%02X",tran_buffer[i]);
   printf("\n");

   //----------------------------------------
   // Find the DS1985 on the MicroLAN
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Find the DS1985 on the MicroLAN\n",testcnt++);

   // find the first device 
   rslt = MLanNext(TRUE, FALSE);
   // print the Serial Number of the device just found
   PrintSerialNum();

   //----------------------------------------
   // Write a packet with MLanWritePacketStd to DS1985 
   printf("\n/---------------------------------------------\n");
   printf("TEST%d: Write a packet with MLanWritePacketStd to DS1985\n",testcnt++);
      
   // set the page to write
   pg = 62; 

   for (i = 0; i < 29; i++)
      tran_buffer[i] = (uchar)i;

   printf("Write EPROM page %d: %d\n",pg,MLanWritePacketStd(pg,tran_buffer,29,TRUE,1));

   for (i = 0; i < 29; i++)
      tran_buffer[i] = 0;

   length = MLanReadPacketStd(TRUE,pg,tran_buffer);

   printf("Read page %d: %d\n",pg,length);

   for (i = 0; i < length; i++)
      printf("%02X",tran_buffer[i]);
   printf("\n");

   // release the 1-Wire Net
   Release1WireNet(return_msg);
   printf("%s",return_msg);
   exit(0);
}


//----------------------------------------------------------------------
//  Read and print the Serial Number.
//
void PrintSerialNum(void)
{
   uchar TempSerialNumber[8];
   int i;

   MLanSerialNum(TempSerialNumber,TRUE);
   for (i = 7; i >= 0; i--)
      printf("%02X",TempSerialNumber[i]);
   printf("\n");
}
