#!/usr/bin/python

import sys
import traceback

TS_PACKET_LENGTH = 188
TS_SYNC          = 0x47


id_list = {}

class PES_ID:
    def __init__(self, pesid):
        self.count    = 0
        self.pesid    = pesid
        self.type     = ''

    def __str__(self):
        return 'id=%3s type=%s count=%6s' % (self.pesid, self.type, self.count)

    
class TS_ID:
    def __init__(self, tsid):
        self.tsid     = tsid
        self.count    = 0
        self.pes      = False
        self.unknown  = False
        self.pes_list = {}
        
    def __str__(self):
        ret = 'id=%5s (pes=%s/%s), count=%6s' % (self.tsid, self.pes,
                                                 self.unknown, self.count)
        for p in self.pes_list:
            ret += '\n  %s' % self.pes_list[p]
        if self.pes_list:
            ret += '\n'
        return ret
    
        
def find_start(file):
    offset = file.tell()
    buffer = file.read(TS_PACKET_LENGTH * 2)
    c = 0

    while c + TS_PACKET_LENGTH < len(buffer):
        if ord(buffer[c]) == ord(buffer[c+TS_PACKET_LENGTH]) == TS_SYNC:
            break
        c += 1
    else:
        return -1

    return offset + c


def read_pes(file, tsinfo):
    """
    Parse a PES header.
    http://dvd.sourceforge.net/dvdinfo/pes-hdr.html
    """
    buffer = file.read(3)
    if not buffer[0:3] == '\x00\x00\x01':
        return 3

    buffer += file.read(7)
    seek          = 10
    packet_length = (ord(buffer[4]) << 8) + ord(buffer[5]) + 6
    align         = ord(buffer[6]) & 4
    header_length = ord(buffer[8])

    pesinfo = None

    # PES ID (starting with 001)
    if ord(buffer[3]) & 0xE0 == 0xC0:
        id = ord(buffer[3]) & 0x1F
        if not id in tsinfo.pes_list:
            tsinfo.pes_list[id] = PES_ID(id)

        pesinfo = tsinfo.pes_list[id]
        pesinfo.type   = 'audio'
        pesinfo.count += 1

    elif ord(buffer[3]) & 0xF0 == 0xE0:
        id = ord(buffer[3]) & 0x1F
        if not id in tsinfo.pes_list:
            tsinfo.pes_list[id] = PES_ID(id)

        pesinfo = tsinfo.pes_list[id]
        pesinfo.type   = 'video'
        pesinfo.count += 1

        # new mpeg starting
        file.seek(header_length - 1, 1)
        seek    = seek + 3 + header_length
        buffer  = file.read(4)
        
        if buffer == '\x00\x00\x01\xB3':
            buffer = file.read(4)
            seek   = seek + 4
            # buffer[-1] indicated aspect ratio
            
        elif buffer.startswith('\x00\x00\x01') and ord(buffer[-1]) >= 0xB9:
            print 'vi', ord(buffer[-1])
            pass
#     else:
#         id = ord(buffer[3])
#         print id
#         if id == 0:
#             # PAD
#             print 'pad'
#             file.seek(header_length - 1, 1)
#             seek    = seek + 7 + header_length
#             buffer  = file.read(8)
#             if not ord(buffer[0]):
#                 print ord(buffer[3]), ord(buffer[4])
#                 for i in range(ord(buffer[6]), ord(buffer[7])):
#                     seek   = seek + 4
#                     buffer = file.read(4)
#                     prog   = (ord(buffer[0]) << 8) + ord(buffer[1])
#                     if prog > 0:
#                         print (ord(buffer[2]) << 8) + ord(buffer[3])
#             pass
#         else:
#             print 'pes', id
#         # unknown content
#         pass

    return seek


def read_ts(file):
    seek   = TS_PACKET_LENGTH - 4
    buffer = file.read(4)

    if len(buffer) < 4:
        return False
    
    if ord(buffer[0]) != TS_SYNC:
        raise IOError('TS_SYNC in %s' % (file.tell() - 4))

    if not ord(buffer[1]) & 0x40:
        # no new pes or psi in stream payload starting
        file.seek(seek, 1)
        return True
        
    tsid = ((ord(buffer[1]) & 0x3F) << 8) + ord(buffer[2])
    adapt = (ord(buffer[3]) & 0x30) >> 4

    if not tsid in id_list:
        id_list[tsid] = TS_ID(tsid)

    idinfo = id_list[tsid]
    idinfo.count += 1
    
    if adapt & 0x02:
        seek -= 1
        adapt_length = ord(file.read(1))
        # meta info present, skip it for now
        if adapt_length:
            flags = ord(file.read(1))
            # if flags != 80 and flags != 64 and flags != 17:
            # print flags, file.tell()
            file.seek(adapt_length - 1, 1)
            seek -= adapt_length
    
    if adapt & 0x01:
        is_pes = read_pes(file, idinfo)
        if is_pes > 3:
            idinfo.pes = True
        seek -= is_pes
        pass
    
    elif adapt & 0x01:
        idinfo.unknown = True
        pass

    file.seek(seek, 1)
    return True

    
f = open(sys.argv[1])
start = find_start(f)
if start < 0:
    f.close()
    sys.exit(1)

f.seek(start)
#for i in range(20000):
while 1:
    try:
        if not read_ts(f):
            break
    except IOError, e:
        if not str(e).startswith('TS_SYNC'):
            print e
            break
        print e
        start = find_start(f)
        if start == -1:
            break
        f.seek(start, 1)
    
    except Exception, e:
        traceback.print_exc()
        break
f.close()

for id in id_list:
    print id_list[id]
