dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl acinclude.m4 for inclusion into aclocal.m4 by aclocal
dnl
dnl   Author : Robert Chalmers
dnl Original : September, 13, 1999
dnl  Revised : 
dnl
dnl  Content : Macros developed for use in hierarchical java development environment.


dnl Usage:
dnl RC_OUTPUT_AUTO(pattern-list, [file-list])
dnl Indirect call to AC_OUTPUT to auto-determine output file list.
dnl Use pattern list to find files actually present in distribution. 
dnl Files with a .in extension will be searched for from pattern. 
dnl Any files in filelist will be included as is.
dnl
dnl This is a cheap override function for AC_OUTPUT.  It undefines 
dnl AC_OUTPUT at the end so a separate call can still be made in 
dnl configure.in - need this for automake to work properly.
AC_DEFUN(RC_OUTPUT_AUTO, 
[dnl gather configuration files
for rc_fil in $1; do 
  rc_cfg_files="$rc_cfg_files `cd $srcdir; find . -name ${rc_fil}.in -print | grep -v CVS | sed -e 's%\./%%g; s%\.in%%g'`";
done 
indir([AC_OUTPUT],$rc_cfg_files $2)dnl
dnl now redefine AC_OUTPUT so it can still be called in configure.in 
define([AC_OUTPUT],defn([RC_OUTPUT_REDIRECT]))dnl
])


dnl Usage:
dnl RC_OUTPUT_REDIRECT(file-list, [extra-cmds], [init-cmds])
dnl Dummy call to replace normal AC_OUTPUT.  Used by RC_OUPUT to
dnl redirect normal call in configure.in.
AC_DEFUN(RC_OUTPUT_REDIRECT,
[dnl do nothing at all
])



Usage:
dnl RC_MSG_INIT
dnl Redirect AC_MSG_ERROR to a custom macro that allows for conditional
dnl or down-graded errors.
AC_DEFUN(RC_MSG_INIT,
[dnl copy the original AC_MSG_ERROR and then redirect it
define([RC_MSG_ERROR_REDIRECT],defn([AC_MSG_ERROR]))
define([AC_MSG_ERROR],defn([RC_MSG_ERROR]))
])


dnl Usage:
dnl RC_MSG_ERROR(msg, [err-test])
dnl A redirection mechanism for errors that may not be deemed terminal
dnl in some  configurations, as well as conditionally calling the error.
dnl If err-test is not provided or passes then rc_msg_warn will be used
dnl to determine whether to invoke an error or just a warning.
dnl A mechanism to set a trap for errors is also provided so that
dnl conditional errors can be handled where indirect calls to  
dnl AC_MSG_ERROR occur.
AC_DEFUN(RC_MSG_ERROR,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl first check if we should throw an error at all
{ dnl
ifelse($#,2,[if $2; then ],ifdef([$$rc_msg_trap_test],[if indir([$$rc_msg_trap_test]); then ]))dnl
dnl check if we sould treat the error as a warning
ifdef([$$rc_msg_warn_test],[if indir([$$rc_msg_warn_test]); then AC_MSG_WARN([(error) $1]); else RC_MSG_ERROR_REDIRECT([$1]); fi;],[RC_MSG_ERROR_REDIRECT([$1])])dnl
ifelse($#,2,[ fi;],ifdef([$$rc_msg_trap_test],[ fi; indir([$$rc_msg_trap_set]);]))dnl 
 }
])


dnl Usage:
dnl RC_MSG_ERROR_TRAP([trap-set], [trap-test])
dnl Set a trap test to inhibit the printing of error messages.
dnl If no test is supplied use false (block errors). 
dnl In the body of the error function, use the trap-set
dnl if supplied. 
dnl Existing traps are pushed and restored once this trap
dnl is removed.
AC_DEFUN(RC_MSG_ERROR_TRAP,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl define the test and set for the trap
pushdef([$$rc_msg_trap_set],[$1])dnl
pushdef([$$rc_msg_trap_test],ifelse([$2],,[false],[$2]))dnl
])


dnl Usage:
dnl RC_MSG_ERROR_UNTRAP
dnl Clear the current trap test, restoring any previous trap. 
AC_DEFUN(RC_MSG_ERROR_UNTRAP,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl undefine the test and set for the trap
popdef([$$rc_msg_trap_set])dnl
popdef([$$rc_msg_trap_test])dnl
])


dnl Usage:
dnl RC_MSG_ERROR_TRAP_OFF
dnl Clear the all trap tests. 
AC_DEFUN(RC_MSG_ERROR_TRAP_OFF,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl undefine all tests and sets for the trap
undefine([$$rc_msg_trap_set])dnl
undefine([$$rc_msg_trap_test])dnl
])


dnl Usage:
dnl RC_MSG_WARN_ON([warn-test], [old-test-var])
dnl Set warn test, rc_msg_warn_test  If no test is provided, 
dnl true will be used.
dnl The old test value will be pushed and then assigned to 
dnl old-test-var if passed.
AC_DEFUN(RC_MSG_WARN_ON,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl return old value if requested
ifelse($#,2,[$2="indir([$$rc_msg_warn_test])"])
dnl save reference to test
pushdef([$$rc_msg_warn_test],ifelse([$1],,[true],[$1]))dnl
])

  
dnl Usage:
dnl RC_MSG_WARN_WITH(warn-var, [old-test-var])
dnl Set warn test, rc_msg_warn_test, with a test for non-zero variable.
dnl The old test value will be pushed and then assigned to 
dnl old-test-var if passed.
AC_DEFUN(RC_MSG_WARN_WITH,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl return old value if requested
ifelse($#,2,[$2="indir([$$rc_msg_warn_test])"])
dnl save a test on passed variable
pushdef([$$rc_msg_warn_test],[test -n "[$]$1"])dnl
])


dnl Usage:
dnl RC_MSG_UNWARN
dnl Clear the current warn test, rc_msg_warn_test, restoring the
dnl previous test.
AC_DEFUN(RC_MSG_UNWARN,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl clear reference to current test
popdef([$$rc_msg_warn_test])dnl
])


dnl Usage:
dnl RC_MSG_WARN_OFF
dnl Clear all saved warn tests.
AC_DEFUN(RC_MSG_WARN_OFF,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl clear reference to all tests
undefine([$$rc_msg_warn_test])dnl
])


dnl Usage:
dnl RC_MSG_WARN_ONLY
dnl Add a command-line parameter to enable the configuration to run in
dnl a configuration only mode.
AC_DEFUN(RC_MSG_WARN_ONLY,
[dnl ensure the message redirection has taken place
AC_REQUIRE([RC_MSG_INIT])dnl
dnl check parameter for warninig only and set warning test appropriately
AC_MSG_CHECKING([whether to configure with only warnings])
AC_ARG_ENABLE(warn-only,
  [  --enable-warn-only      configure with normal errors reported as warnings],
  [if test "$enableval" != "no"; then
    rc_warn_only="yes" 
    AC_MSG_RESULT([yes])
    AC_MSG_WARN([You have enabled a warning-only mode configuration.  Most errors will be reported simply as warnings - prefaced with (error), but they do imply that an attempt to compile will probably fail since a normal configuration would have stopped with an error.])
  fi],
  [AC_MSG_RESULT([no])]
  )
RC_MSG_WARN_WITH([rc_warn_only])
])
  


dnl Usage:
dnl RC_PATH_FIX(result-variable, path-value)
dnl Remove a trailing slash from a path.
AC_DEFUN(RC_PATH_FIX,
[dnl remove the trailing slash from the path
$1="`echo "$2" | sed -e 's%\(.*\)/$%\1%'`" 
])


dnl Usage:
dnl RC_PATH_FILE(path-var, file, [value-if-not-found], [paths])
dnl Search for specific files in given path list or $PATH. 
dnl Assign complete path of file found to path-var.
dnl Equivalent to AC_PROG_PATH without the caching.
AC_DEFUN(RC_PATH_FILE,
[dnl change the whitespace character to colon
IFS="${IFS= 	}"; rc_save_ifs="$IFS"; IFS=":"
dnl $rc_dirs forces splitting on constant user-supplied paths.
rc_dirs="ifelse($#,4,[$4],[$PATH])"
rc_path_val=
for rc_dir in $rc_dirs; do 
  if test -n "$rc_dir" && test -r "$rc_dir/$2"; then
    rc_path_val="$rc_dir/$2"
    break
  fi
done
IFS="$rc_save_ifs"
dnl save found path or not-found value
if test -n "$rc_path_val"; then
  $1="$rc_path_val"
else
  $1=$3
fi
])



dnl Usage:
dnl RC_CACHE_VALUE(assign-var, [cache-var])
dnl Check for a cache value and set assign-var if found.
AC_DEFUN(RC_CACHE_VAL,
[dnl check if the cache value is set
rc_cache=
AC_CACHE_VAL(ifelse($#,2,[$2],[rc_cv_val_$1]),[rc_cache="nocache"])
dnl assign value if so
if test "$rc_cache" != "nocache"; then
  $1="[$]ifelse($#,2,[$2],[rc_cv_val_$1])"
fi
])


dnl Usage:
dnl RC_CACHE_SET([assign-var]])
dnl Set a cache variable with cache value using the assignment
dnl variable's name in the cache variable name.
AC_DEFUN(RC_CACHE_SET,
[dnl set the cache variable
rc_cv_val_$1="[$]$1"
])


dnl Usage:
dnl RC_CACHE_CLEAR(assign-var)
dnl Clear a cache variable created from an original
dnl assignment variable in RC_CACHE_VALUE.
AC_DEFUN(RC_CACHE_CLEAR,
[dnl unset the cache variable
unset rc_cv_val_$1
])



dnl Usage:
dnl RC_PROG_JAVA([path-to-check], [action-if-successful], [action-if-unsuccessful])
dnl Locate an appropriate java jdk. Check current path, excluding
dnl common bin directories or explicit path if given and subsequently 
dnl check $JDK_HOME. 
dnl Allow the user to override the path search with an explicit 
dnl $JDK_HOME environment variable.
dnl Exports JAVA_PATH variable with found path or empty. 
AC_DEFUN(RC_PROG_JAVA,
[dnl export JAVA_PATH variable
AC_SUBST(JAVA_PATH)dnl
dnl first check if the user has explicitly requestes use of $JDK_HOME
AC_ARG_ENABLE(jdk-home,
  [  --enable-jdk-home       try JDK location from \$JDK_HOME before searching],
  [if test "$enableval" != "no"; then
    RC_PROG_JAVA_HOME([$2],[$3])
  fi]
  )
if test -z "$JAVA_PATH"; then
  # search for java binary, but exclude normal bin paths since we want to find the jdk
  rc_search_path="`echo ":$PATH" | sed -e 's%:\(/usr\)*\(local/\)*/bin/*%%g; s%^:%%; s%::*%:%g'`"
  AC_PATH_PROG(rc_java_prog,java,,ifelse([$1],,$rc_search_path,$1))

  if test -n "$rc_java_prog"; then
    JAVA_PATH="`echo "$rc_java_prog" | sed -e 's%/bin/java%%'`"
    ifelse([$2],,:,[$2])
  else
    AC_MSG_WARN([Could not find jdk in path. Trying \$JDK_HOME.])
    RC_PROG_JAVA_HOME([$2],[$3])
  fi
fi
])


dnl Usage:
dnl RC_PROG_JAVA_HOME([action-if-successful], [action-if-unsuccessful])
dnl Locate an appropriate java jdk from the $JDK_HOME environment variable.
AC_DEFUN(RC_PROG_JAVA_HOME,
[dnl check if path in $JAVA_HOME leads to a java binary
AC_MSG_CHECKING([for java package])
RC_PATH_FIX([JAVA_PATH],[$JDK_HOME]) 
if test -n "$JAVA_PATH" && test -r "$JAVA_PATH/bin/java"; then
  AC_MSG_RESULT([$JAVA_PATH])
  ifelse([$2],,:,[$2])
else
  AC_MSG_RESULT([none])
  JAVA_PATH=
  ifelse([$3],,:,[$3])
fi
])



dnl Usage:
dnl RC_JAVA_PROP_CHECK(jdk-path, action-if-successful, [action-if-unsuccessful])
dnl Setup a test case for gathering java properties.
AC_DEFUN(RC_JAVA_PROP_CHECK,
[dnl create a java app to get system properties
cat > conftestProps.java << EOF
/* check for properties of jdk */
public class conftestProps {
  public static void main( String[[]] args ) {
    System.out.println( System.getProperty( args[[0]] ));
  }
}
EOF

dnl setup test classpath
rc_java_test_cp="-classpath ."
test -f "$1/lib/classes.zip" && rc_java_test_cp="$rc_java_test_cp:$1/lib/classes.zip"

dnl try to compile test app and run specified actions
if $1/bin/javac $rc_java_test_cp conftestProps.java 2> /dev/null; then
define([rc_java_bin],[$1/bin/java $rc_java_test_cp conftestProps])dnl
  ifelse([$2],,:,[$2])
ifelse($#,3,[else
  $3])
fi
dnl clear bin path and remove test app
undefine([rc_java_bin])dnl
rm -f conftestProps.*
])


dnl Usage:
dnl RC_JAVA_PROP(test-variable, test-prop)
dnl Test for a specific property and set the test variable to the result.
dnl A cache variable will be initialized from the variable name.
dnl This macro should only be used within the action parameters of 
dnl RC_JAVA_PROPS.
AC_DEFUN(RC_JAVA_PROP,
[dnl run properties test assigning the new cached value 
ifdef([rc_java_bin],[
AC_CACHE_CHECK([for $2],rc_cv_java_prop_$1,[rc_cv_java_prop_$1="`rc_java_bin '$2'`"])
$1="$rc_cv_java_prop_$1"])
])


dnl Usage:
dnl RC_JAVA_PROP_CLEAR(variables)
dnl Clear the cache values for the property variables listed.
AC_DEFUN(RC_JAVA_PROP_CLEAR,
[dnl unset the cache value for each variable
for prop in [$1]; do
  unset rc_cv_java_prop_$prop
done
])



dnl Usage:
dnl RC_JAVA_PKG_JINI([action-if-successful], [action-if-unsuccessful])
dnl Allow the user to supply a path to the Jini package.
dnl If nothing is given, try the $JINI_HOME environment variable.
dnl Exports JAVA_JINIPATH variable with found path or empty.
AC_DEFUN(RC_JAVA_PKG_JINI,
[dnl export the jini path variable
AC_SUBST(JAVA_JINIPATH)dnl
dnl check if the user supplied the path else try $JINI_HOME
AC_MSG_CHECKING([for jini package])
AC_ARG_WITH(jini,
  [  --with-jini=DIR         jini resources are in DIR [\$JINI_HOME]],                       
  test "$withval" != "no" && JAVA_JINIPATH="$withval",
  test -n "$JINI_HOME" && JAVA_JINIPATH="$JINI_HOME"
  )
dnl assign the path if its cached
RC_CACHE_VAL([JAVA_JINIPATH],[rc_cv_path_jini])

RC_PATH_FIX([JAVA_JINIPATH],[$JAVA_JINIPATH])
if test -n "$JAVA_JINIPATH" && test -d "$JAVA_JINIPATH/lib"; then
  AC_MSG_RESULT([$JAVA_JINIPATH])
  rc_cv_path_jini="$JAVA_JINIPATH"
  ifelse([$1],,:,[$1])
else
  AC_MSG_RESULT([none])
  JAVA_JINIPATH=
  unset rc_cv_path_jini
  ifelse([$2],,:,[$2])
fi
])


dnl Usage:
dnl RC_JAVA_PKG_CHECK(package, imports, [classpath], [java-path], [action-if-successful], [action-if-unsuccessful])
dnl Create a test java application to ensure that all listed imports can
dnl be found by the java compiler. Imports should be a colon separated list.  
dnl If not the path is not specified javac will be run using the 
dnl $JAVA_PATH variable if available else with no absolute path.
AC_DEFUN(RC_JAVA_PKG_CHECK,
[dnl create the test java file with each of the imported classes/pkgs  
AC_MSG_CHECKING([for $1 compliance])
changequote(, )dnl
rc_pkg_imports="`echo ":$2" | sed -e 's%::*%:%g; s%:$%%; s%:\([^:]*\)%import \1; %g'`"
changequote([, ])dnl

cat > conftestPkg.java << EOF
/* check for pkg imports */
$rc_pkg_imports
public class conftestPkg {
}
EOF

ifelse([$4],,
[if test -n "$JAVA_PATH"; then
  rc_java_javac="$JAVA_PATH/bin/javac"
else
  rc_java_javac="javac"
fi],[rc_java_javac="[$4]/bin/javac"])
if $rc_java_javac ifelse([$3],,,[-classpath $3 ])[]conftestPkg.java 2> /dev/null; then
  AC_MSG_RESULT([yes])
  rm -f conftestPkg.*
  ifelse([$5],,:,[$5])
else
  AC_MSG_RESULT([no]) 
  rm -f conftestPkg.*
  ifelse([$6],,:,[$6])  
fi
])


dnl Usage:
dnl RC_JAVA_PKG_FIND(files, classpath-var, extpath-var, [search-paths], [ext-paths])
dnl Search for specific files in java's extended path as well as any specific paths.
dnl Add files found in the extended path to extpath-var.
dnl If file not found in extension search in specified paths and add to classpath-var
dnl if found.
AC_DEFUN(RC_JAVA_PKG_FIND,
[dnl try to each file in paths provided 
for fil in $1; do
  rc_java_file=
  dnl check in ext dirs first since java checks there first
  ifelse($#,5,
[  RC_PATH_FILE([rc_java_file],[$fil],,[$5])
  test -n "$rc_java_file" && $3="[$]$3:$rc_java_file"
])dnl
  ifelse([$4],,,
[  if test -z "$rc_java_file"; then
    RC_PATH_FILE([rc_java_file],[$fil],,[$4])
    test -n "$rc_java_file" && $2="[$]$2:$rc_java_file"
  fi
])dnl
done
])


dnl Usage:
dnl RC_JAVA_PKG_FILE(pkg-var, pkg-file, [opt-path])
dnl Take a possible path to a jar file and split it into a path
dnl and file name to be searched for with RC_JAVA_PKG_FIND.
dnl If the path consists only of a directory use pkg-file
dnl as the file name. If no directory is given, optionally 
dnl assign the opt-path as a possible search path.
dnl Variable (pkg-var)_jar and (pkg_var)_dir are assigned
dnl the resulting file name and directory.
AC_DEFUN(RC_JAVA_PKG_FILE,
[dnl check whether the path contains a file name
case "[$]$1" in
*.jar)
  changequote(, )dnl
  $1_dir="`echo "[$]$1" | sed -e 's%\(.*\)/\([^/]*\.jar\)$%\1%; s%.*\.jar$%%'`"
  $1_jar="`echo "[$]$1" | sed -e 's%\(.*\)/\([^/]*\.jar\)$%\2%'`"
  changequote([, ])dnl
;;
*)
  $1_dir="[$]$1"
  $1_jar="$2"
;;
esac  
dnl could try the extended path if given
ifelse($#,3,[test -z "[$]$1_dir" && $1_dir="$3"
])dnl
RC_PATH_FIX($1_dir,[$]$1_dir)
])



dnl Usage:
dnl RC_SECTION_ROOT([root-var], [build-var])
dnl Set the root for further section checks to the value
dnl of root variable.  If root variable is not passed or
dnl empty, use the current $srcdir path and set the
dnl root variable.
dnl Set the build directory, assign to build-var if passed. 
dnl Exports SECTION_ROOT, SECTION_BUILD and SECTION_LIST variables.
AC_DEFUN(RC_SECTION_ROOT,
[dnl export variables
AC_SUBST(SECTION_ROOT)dnl
AC_SUBST(SECTION_BUILD)dnl
AC_SUBST(SECTION_LIST)dnl
dnl set the top of the project
AC_MSG_CHECKING([for top of project])
SECTION_ROOT="ifelse([$1],,[`cd $srcdir && pwd`],[$][{$1:-`cd $srcdir && pwd`}])"
ifelse([$1],,,[$1="$SECTION_ROOT"])
AC_MSG_RESULT([$SECTION_ROOT])
dnl set the top of build
AC_MSG_CHECKING([for top of build])
SECTION_BUILD="ifelse([$2],,[`pwd`],[$][{$2:-`pwd`}])"
ifelse([$2],,,[$2="$SECTION_BUILD"])
AC_MSG_RESULT([$SECTION_BUILD])
])


dnl Usage:
dnl RC_SECTION_CHECK(section-var, section-subdir, section-name, [section-top], [action-if-found], [action-if-not-found])
dnl Check is a section is present in the current cofiguration.
dnl If found the path will be assigned to the section varaible and
dnl the subdir to SECTION_LIST.
dnl A separate build variable, (section-var)_BUILD will be defined
dnl as the section-subdir from the SECTION_BUILD base.
dnl This macro uses SECTION_ROOT to determine the root of the
dnl current configuration.  An alternate top can be passed in as
dnl section-top, but the extra build variable will be not be created
dnl and the found section will not be added to SECTION_LIST.
AC_DEFUN(RC_SECTION_CHECK,
[dnl ensure RC_SECTION_ROOT has been called to set SECTION_ROOT variable
AC_REQUIRE([RC_SECTION_ROOT])dnl
AC_MSG_CHECKING([for project $3])
dnl allow user to supply alternate base directory
rc_section_top="ifelse([$4],,[$SECTION_ROOT],[$4])"
# check for the section directory
if test -d "$rc_section_top/$2"; then
  $1="$rc_section_top/$2"
  AC_MSG_RESULT([$]$1)
dnl if using standard section top, add to section list and export build variable
  ifelse([$4],,[SECTION_LIST="$SECTION_LIST $2"
  $1_BUILD="$SECTION_BUILD/$2"])
  ifelse([$5],,:,[$5]) 
else
  AC_MSG_RESULT([no])
  ifelse([$6],,:,[$6])
fi
])



dnl Usage:
dnl RC_MODULE_SUCCESSFUL([module-var],[result])
dnl Output a positive result.
dnl Set the variable to "yes" as a by-product.
AC_DEFUN(RC_MODULE_SUCCESSFUL,
[dnl output a positive result and set the variable
AC_MSG_RESULT(ifelse($#,2,[$2],[yes]))
ifelse([$1],,,[$1="yes"
])dnl
])


dnl Usage:
dnl RC_MODULE_UNSUCCESSFUL(module-var, msg, [result])
dnl Create a conditional error call based on whether the
dnl module variable is "yes", meaning that it is to be
dnl included.  If so then output a negative result and error.
dnl Set the variable to "no" as a by-product.
AC_DEFUN(RC_MODULE_UNSUCCESSFUL,
[dnl make a conditional error call and reset the value
AC_MSG_RESULT(ifelse($#,3,[$3],[no]))
RC_MSG_ERROR([$2],[test "[$]$1" = "yes"])
$1="no"
])


dnl Usage:
dnl RC_MODULE_ERROR(module-var, msg)
dnl Create a conditional error call based on whether the
dnl module variable is "yes", meaning that it is to be
dnl included.
dnl Set the variable to "no" as a by-product.
AC_DEFUN(RC_MODULE_ERROR,
[dnl make a conditional error call and reset the value
RC_MSG_ERROR([$2],[test "[$]$1" = "yes"])
$1="no"
])


dnl Usage:
dnl RC_MODULE_TRAP(module-var)
dnl Add a hook into the error mechanism to report that an
dnl error condition occurred indirectly through another macro.
AC_DEFUN(RC_MODULE_TRAP,
[dnl create a trap condition and action
RC_MSG_ERROR_TRAP([$1="no"],[test "[$]$1" = "yes"])
])


dnl Supply an alternate name for untrapping errors.
define([RC_MODULE_UNTRAP],defn([RC_MSG_ERROR_UNTRAP]))
# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

