/* 
   Code generation debug program.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "inc/mob.h"
#include "inc/genCode.h"


#define MIN_SETS 100


inline long long rdtsc(void) {
  
  unsigned int tmp[2];
  
  __asm__ ("rdtsc"
	   : "=a" (tmp[1]), "=d" (tmp[0])
	   : "c" (0x10) );
  
  return ( ((long long)tmp[0] << 32 | tmp[1]) );
}



/*
  Main function for debugging code generation.
  
  argc - number of command-line parameters
  argv - command-line parameters
  return - 0 on success, non-zero otherwise
*/
int main( int argc, char *argv[] ) {

  unsigned int size, stride;
  char *code;
#if 1
#undef REP_BLOCK
#endif
#ifdef REP_BLOCK
  unsigned int sets = MIN_SETS;
#else
  unsigned int s, sets = MIN_SETS;
  void *ret = &&retaddr;
#endif
  double ops, time3;
  long long time1, time2;
  
  /* check command line arguments */
  if( argc < 2 ) {
    printf( "usage: dbgCode <size> <stride>\n" );
    return( -2 );
  }
  /* get size and stride from command line */
  size = atoi( argv[1] );
  stride = atoi( argv[2] );

  /* generate enough space for code */
  code = (char *)malloc( (size * 2) * sizeof(char) );
  if( ! code ) {
    printf( "error: couldn't allocate enough space.\n" );
    return( -1 );
  }  
  /* print code block sizes */
  printf( "Block Sizes: jmp=%d nop=%d ret=%d\n", jmpBlockSize(), nopBlockSize(), retBlockSize() );   

  /* generate code and execute */
  generateCode( code, size, stride );

   
      time1 = rdtsc();
 
 run:
#ifdef REP_BLOCK
  REP_BLOCK( code, stride, sets );
#else
  RUN_BLOCK( code, stride, ret );

  printf( "Didn't work... :-(\n" );
  return( 1 );
#endif

  goto retaddr;
  goto run;
  
 retaddr:      
  time2 = rdtsc();
  time3 = (((double)(time2-time1))*2.0);
  ops = (stride) ? (size / stride) : (size / nopBlockSize());
  printf( "%d %.4f\n", stride, time3 / (ops * sets) );
  
  printf( "It works.. :-)\n" ); 
  return( 0 );
}
