#ifndef __CFGPARSER_H__
#define __CFGPARSER_H__

/* Object that has information about the zone being parsed */
struct parseZone{
  /* Adds a symbol and pair(optional) values into the zone object */
  int (* addPair)(void * obj, char * symbol,char * value);
  /* Function to called when the parsing zone is finished to write the object 
   into the global system structures if valid */
  int (* flushObject)(void * obj);
  /* prints the object to the fp stream */
  void (* printObject)( FILE * fp, void * obj);
  /* Zone object pointer */
  void * object; 
};

/* This function will be called every time a new parse zone is found in the
   config file. It will allocate a new zone struct, calling the "create"
   function of the specific zone, and filling the data field with the value
   that the this (create) function returns */
void openZone( struct parseZone * pZone, char * zoneName );

/* Function called when a parse zone is finished. It will call the flush object 
   function.
   If parse zone not initialized, it does nothing and returns success.
   The object is not freed, it's up to the "flushObject" function to do
   it if needed (i.e: in case object is duplicated ) 
   Returns 0 on success or <> otherwise */
int closeZone( struct parseZone * zoneObj );

/* Function that given a file handle, it will parse it and create
   the specified zone objects, fill them with as much information as provided
   and place them in the global system structure.
   If more than one object of the same type and level (say two data L1 caches)
   are defined in the file, the last one will override the previous ones */

int parseConfig( FILE * cFile );

/* It will get the config file name from the system, will parse the
   configuration, create the defined objects and put them in the global
   system structures */
void loadConfig(void);

/* It saves the actual configuration of the system structures to 
   the specified output file (or stdout if none) */
void saveConfig();
#endif /*__CFGPARSER_H__*/
