/* 
   Command line processing structures and function prototypes.
*/


#ifndef __CMDLINE_H__
#define __CMDLINE_H__


#define DEF_CONFIG     "mob.conf"  /* default configuration file name */
#define DEF_TRIALS     3           /* default number of trials per test */
#define DEF_RUNTIME    1000000     /* default number of microseconds to run test for (1 sec.) */
#define ARG_SEPARATOR  ","         /* separator between variable length arguments */

/* command line structure initializer */
#define INIT_CMDLINE { NULL, NULL, NULL, DEF_TRIALS, DEF_RUNTIME, VERB_NORMAL, 0 }



/* parameters parsed from the command line */
struct cmdLine {
  char *program;             /* name of running program */
  char *config;              /* name of input configuration file */
  char *output;              /* name of file to output new configuration - defaults to config */
  unsigned int trials;       /* number of trials to perform each test */
  unsigned long runTime;     /* number of microseconds to run tests */
  unsigned int verbosity;    /* level of verbosity */
  unsigned int interactive;  /* whether to run interactively */
};



/* function prototypes */

/*
  Parse all command line arguments.

  argc - number of arguments
  argv - list of argument strings
 */
void parseCmdLine( int argc, char *argv[] );

/*
  Print the usage syntax with an optional error message.

  msg - informational message to print in addition to basic usage syntax
  ecode - exit code to return
*/
void printUsage( char *msg, int ecode );


#endif


