/*
  Architectute dependent code block definitions for alpha family.
*/


#ifndef __MACHDEP_H__
#define __MACHDEP_H__

#define MACH_ALPHA


/* architecture specific code blocks */

/* 
   Instructions to start executing generated code on "code", 
   jumping "jump" bytes and returning to "ret".  Each of the 
   parameters should be a value on the stack.  The next address
   is stored in R1, the amount to jump is stored in R1, and the
   return address is stored in R3.
*/
#define RUN_BLOCK( code, jump, ret ) __asm__ __volatile__( "ldq $1,%0 \n\t ldl $2,%1 \n\t ldq $3,%2 \n\t jmp ($1) " :/*NO OUT*/: "m"(code),"m"(jump),"m"(ret) : "$1","$2","$3" );

/*
  Instructions to jump within the code block to the next jump 
  instruction or the return block.  The jump size is added to 
  the currrent address in R1.  Any delay slots must be filled
  in this block since the compiler will not see it.
*/
#define JMP_BLOCK startjmp: __asm( "addq $1,$2,$1 \n\t jmp ($1)" );\
                  endjmp:

/*
  Instruction used as filler.
*/
#define NOP_BLOCK  startnop: __asm( "nop" );\
                   endnop:

/*
  Instruction used to return back to the calling code.
  The return address is excepted in R3.  Any delay slots 
  must be filled in this block since the compiler will not 
  see it.
*/
#define RET_BLOCK startret: __asm( "jmp ($3)" );\
                  endret:


#endif
