/*
  Architectute dependent code block definitions for mips family.
*/


#ifndef __MACHDEP_H__
#define __MACHDEP_H__

#define MACH_MIPS


/* architecture specific code blocks */

/* 
   Instructions to start executing generated code on "code", 
   jumping "jump" bytes and returning to "ret".  Each of the 
   parameters should be a value on the stack.  The next address
   is stored in R0, the amount to jump is stored in R1, and the
   return address is stored in R3.
*/
#define RUN_BLOCK( code, jump, ret ) __asm__ __volatile__( "ld %0,%%o0 \n\t ld %1,%%o1 \n\t ld %2,%%o2 \n\t jmp %%o0 \n\t nop" :/*NO OUT*/: "m"(code),"m"(jump),"m"(ret) : "%o0","%o1","%o2" );

/*
  Instructions to jump within the code block to the next jump 
  instruction or the return block.  The jump size is added to 
  the currrent address in R0.  Any delay slots must be filled
  in this block since the compiler will not see it.
*/
#define JMP_BLOCK startjmp: __asm( "add %o0,%o1,%o0 \n\t jmp %o0" );\
                  endjmp:

/*
  Instruction used as filler.
*/
#define NOP_BLOCK  startnop: __asm( "nop" );\
                   endnop:

/*
  Instruction used to return back to the calling code.
  The return address is excepted in R3.  Any delay slots 
  must be filled in this block since the compiler will not 
  see it.
*/
#define RET_BLOCK startret: __asm( "jmp %o2 \n\t nop" );\
                  endret:


#endif
