/**
 * Main project header.
 *
 **/

#ifndef __MOB_H__
#define __MOB_H__

/* common system includes */
#include "benchmark.h"
#include "cmdLine.h"
#include "zone.h"


/* constant defined for a million */
#define MILL 1000000L


/* maximum number of items in system structure */
#define MAX_SYSTEM_CACHES  8
#define MAX_SYSTEM_TLBS    MAX_SYSTEM_CACHES

/* macros used for minimum and maximum values when both
   are simply values or simple calculations since operands 
   may be resolved twice */
#define minVal(x,y) (((x) < (y)) ? (x) : (y))
#define maxVal(x,y) (((x) > (y)) ? (x) : (y))


/* type of cache */
typedef enum type { TYPE_NONE, TYPE_DATA, TYPE_INST, TYPE_SHARED } type_t;
/* replacement policies */
typedef enum replacement { REPL_NONE, REPL_RAND, REPL_LRU } replacement_t;
/* write policies */
typedef enum writeMode { WR_NONE, WR_BACK_ALLOC, WR_BACK_NOALLOC, WR_THROUGH_ALLOC, WR_THROUGH_NOALLOC } writeMode_t;
/* error codes */
typedef enum mobErr { EinvalMask, EinvalReps, EnoMem, EinvalParams, EinvalConfig,Ezone,EsaveConfig } mobErr_t;
/* verbosity levels (incremental) */
typedef enum verbLevel { VERB_QUIET,   /* Nothing is printed */
			 VERB_PLOT,    /* Only plotting information is printed */
			 VERB_NORMAL,  /* Progess indication */
			 VERB_WARN,    /* Config and runtime warnings */
			 VERB_INSPECT, /* Intermediate test values */
			 VERB_DEBUG,   /* Low level test value inspection */ 
			 VERB_ALL      /* Print everything */
                         } verbLevel_t;


/* structure representing a single cache (instruction or data) */
struct cache {
  type_t type; /* type of cache, instruction, data or shared */
  unsigned int level; /* Cache level */
  unsigned int size; /* Total cache size (bytes)*/
  unsigned int lineSize;  /* Cache line size (bytes) */
  unsigned int associativity; /* Cache associativity (1=direct mapped) */
  replacement_t replacement; /* Replacement type (if associative >1 ) */
  writeMode_t writeMode; /* Cache write mode */
  double latency; /* Cache latency from CPU (ns) */
  struct vZoneOps zOps; /* Zone object operations */
};


/* structure representing a single tlb (instruction or data) */
struct tlb {
  type_t type;  /* type of TLB, instruction, data or shared */
  unsigned int pageSize; /* Page size */
  unsigned int numEntries; /* Number of entries in TLB */
  unsigned int associativity; /* TLB associativity (1=direct mapped) */
  double latency; /* TLB latency from CPU (ns) */
  struct vZoneOps zOps; /* Zone object operations */
};


/* structure representing system memory */
struct memory {
  unsigned long size; /* Total memory size (bytes)*/
  double latency; /* Memory latency from CPU (ns) */
  struct vZoneOps zOps; /* Zone object operations */
};


/* global system structure */
struct globalSystem { 
  struct cmdLine args; /* parsed command line arguments */
  struct benchmark benchmarks[MAX_BENCHMARKS]; /* individual benchamrk information */
  struct memory mem; /* memory information */
  struct cache *dataCaches[MAX_SYSTEM_CACHES]; /* data cache information */
  struct cache *instCaches[MAX_SYSTEM_CACHES]; /* instruction cache information */
  unsigned int numDataCaches; /* number of data caches found */
  unsigned int numInstCaches; /* number of instruction caches found */
  struct tlb *dataTLB; /* data TLB information */
  struct tlb *instTLB; /* instruction TLB information */
  char *array;            /* data area for running benchmarks */
  unsigned int arraySize; /* size of allocated array */
};


#endif
