/*
  Common utility routines.
*/


#ifndef __ROUTINES_H__
#define __ROUTINES_H__


/* bit-mask to size macro */
#define M_SIZE( m ) (m + 1)

/* bit-mask definitions */
#define NUM_MASKS 18
#define M_32M   0x1ffffff
#define M_16M   0xffffff
#define M_8M    0x7fffff
#define M_4M    0x3fffff
#define M_2M    0x1fffff
#define M_1M    0xfffff
#define M_512K  0x7ffff
#define M_256K  0x3ffff
#define M_128K  0x1ffff
#define M_64K   0xffff
#define M_32K   0x7fff
#define M_16K   0x3fff
#define M_8K    0x1fff
#define M_4K    0xfff
#define M_2K    0x7ff
#define M_1K    0x3ff
#define M_512   0x1ff
#define M_256   0xff


/* constants */
#define LOOK_AHEAD 3



/* function prototypes */

int arrayAllocate( unsigned int size );
int arrayPrepare( unsigned int size );


int show( verbLevel_t level, char * fmt, ... );
void handleError( char *where, int errno );

double min( double a, double b );
double max( double a, double b );
double getMin( double *data , unsigned int points );

double getMax( double *data, unsigned int points );
double getMean( double *data , unsigned int points );
double getStdDev( double *data , unsigned int points );
double *getReverse( double *data, unsigned int points );
double getRise( double *data, unsigned int points );
double *getSmooth( double * data, unsigned int points, double alpha );
int getPopular( unsigned int *votes, unsigned int points );

unsigned long getMaxCache( void );

char *trim( char * string );

unsigned int *detectTransitions( double *data, double *control, unsigned int points );
int getMaxTransition( double *data, double *control, unsigned int points );
int getFirstTransition( double *data, double *control, unsigned int points );
unsigned int *detectPlateau( double *data, unsigned int points );
unsigned int *detectPlateau2( double *data, unsigned int points );

unsigned long getMask( char *mask );
unsigned long getMaskSize( char *mask );

#endif
