#ifndef __ZONE_H__
#define __ZONE_H__

/* Maximum of different types of object zones in the system */
#define MAX_ZONE_OBJS  10


#define MAX_LINE_LEN  250 
#define MAX_SYMBOL_LEN  30
#define MAX_VALUE_LEN   MAX_SYMBOL_LEN

/* Operations that every zone object type has to provide */
struct vZoneOps{
  char * name;  /* Zone Object name */
  /* Clears and deallocates the system objects of this zone type */
  void (* clearObjects)(void);
  void *(* createObject)(void); /* creates an dataObject zone specific */
  /* Adds the zone specific pair to the zone data object */
  int (* addPair)( void * obj, char * symbol,char * value );
  /* Checks and stores a completed zone object */
  int (* flushObject)( void * obj);
  /* Prints the object to the specified file pointer stream */
  void (* printObject)( FILE * fp, void * obj);
};

/* The list of registered zones of the system */
#define CACHEOPS {"cache",\
                   cache_clearObjects,\
		   cache_createObject,\
		   cache_addPair,\
		   cache_flushObject,\
		   cache_printObject}

#define TLBOPS {"tlb",\
                 tlb_clearObjects,\
	         tlb_createObject,\
		 tlb_addPair,\
		 tlb_flushObject,\
		 tlb_printObject}

/* It returns the zone operations from a zone name.
   Returns NULL if the zone is not defined in the global list */
struct vZoneOps * getZoneOps( char * zoneName );

/* Zone specific functions */
void   cache_clearObjects();
void * cache_createObject(void);
int    cache_addPair( void * obj, char * symbol,char * value );
int    cache_flushObject( void * obj);
void   cache_printObject( FILE * fp, void * obj);

void   tlb_clearObjects();
void * tlb_createObject(void);
int    tlb_addPair( void * obj, char * symbol,char * value );
int    tlb_flushObject( void * obj);
void   tlb_printObject( FILE * fp, void * obj);

#endif /*__ZONE_H__*/
