/**
 * Main function and control loop.
 **/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "inc/mob.h"
#include "inc/cfgParser.h"
#include "inc/routines.h"

/* global system information structure */
struct globalSystem sys = { INIT_CMDLINE, INIT_BENCHMARKS };



/* 
   Main program function
   
   argc - number of command line arguments
   argv - array of argument strings
*/
int main( int argc, char *argv[] ) {

  unsigned int m;

  /* parse the command line parameters */
  parseCmdLine( argc, argv );


  /* parse the configuration file if available */
  loadConfig();

  /* check config data to determine state of benchmarks */
  validateBenchmarks();
  /* set runtime dependencies to fill necessary portions of data */
  runDependencies();  
  /* finalize selection of benchmarks by checking whether anything
     is marked for run, if not mark everything not already valid */
  finalizeBenchmarks();

  /* allocate a large chunk of memory for tests
     FIXME: the size should be based on which benchmarks are going to be run */
  if( arrayAllocate( 0 ) )
    handleError( "creating test array", EnoMem ); 
  
  /* Build a title for the data plot output */
  {
    char buffer[250];
    gethostname(buffer,250);
    show( VERB_PLOT,"# TITLE \"Test performed on %s (trials:%d runTime:%d)\"\n",buffer,sys.args.trials,sys.args.runTime);
  }
  /* run each benchmark indicated */
  for( m = 0; m < MAX_BENCHMARKS; m++ ) {
    if( sys.benchmarks[m].state == STATE_RUN ){
      show(VERB_NORMAL,"Performing benchmark: %s \n",sys.benchmarks[m].name);
      /* perform benchmark, check for error */
      sys.benchmarks[m].perform();
      sys.benchmarks[m].state = STATE_DONE ;
    }
  }

  /* free array memory */
  free( sys.array );
  
  /* save the configuration */
  saveConfig();

  return( 0 );
}



/*
  Determine whether each cache in the hierarchy is physically or virtually indexed.

  return - 0 if successful, non-zero if failed
*/
int cacheIndex( void ) { return( 0 ); }

/*
  Determine whether the current data is valid for a given benchmark.
  If it is valid then another run is unecessary unless explicitly requested.

  return - 1 if valid, 0 otherwise
*/
int cacheIndexValid( void ) { return( 0 ); }
