      double precision function caldis(crot,fdist,cdist,tol)
      implicit double precision (a-h,o-z)
      parameter (bignum=1.0d12)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)

      common /gamori/imap(numat1),cstand(3,numat1),istand(numat1),
     &               msucc
      dimension crot(3,numat1),fdist(numat1),cdist(numat1)

c dist = the shortest distance found between a particular atom of crot
c        whilst screening it against all of the atoms of cstand
c dis  = the total sum over all atoms of dist(iatom)

      caldis = 0.0d0
      do k=1,iatoms
         dist = bignum
         imap(k) = 0
         do l=1,iatoms
            if((ianz(k).eq.istand(l)).and.
     &      ((fdist(k)-cdist(l))**2.lt.tol)) then
                distt = 0.0d0
                do j=1,3
                   distt = distt + 
     &             (crot(j,k)-cstand(j,l))**2
                end do
                if (distt.lt.dist) then
                   dist = distt
                   imap(k) = l
                endif
            endif
         end do
         caldis = caldis + dsqrt(dist)
      end do
      caldis = dsqrt(caldis)

      return
      end
