      subroutine geomop(formax,forrms,dismax,disrms,epoints,isav)
      implicit double precision (a-h,o-z)
      logical getmop, domopf
      common /rdwr/   iun1,iun2,iun3,iun4,iun5
      common /geocnv/ fmaxt,frmst,dmaxt,drmst,fgmin,fgmax,dgmin,dgmax,
     &                enmax,enmin,ngeoms,nepnts,igcvav,ifmxav,ifrmav,
     &                idmxav,idrmav,ieav,ifrav,mxpnt
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      dimension formax(*),forrms(*),dismax(*),disrms(*),epoints(*)
      dimension isav(*)

      rewind iun2

      igcvav = 1
      ifmxav = 0
      ifrmav = 0
      idmxav = 0
      idrmav = 0
      ieav = 1
      nepnts = 0
      ngeoms = 0
      dmaxt = 0.0d0
      fmaxt = 0.0d0
      drmst = 0.0d0
      frmst = 0.0d0
      enmax = -1000000.0d0
      enmin = 1000000.0d0
      do i=1,mxpnt
         epoints(i) = 0.0d0
      end do
      ihasep = 0

      domopf = .true.
      do while (getmop(coo,ianz,iatoms,heat,.false.,domopf))
         domopf = .false.
         if (ngeoms.eq.mxpnt) then
             call inferr('exceeded MAXPNT !',1)
             goto 100
         endif
         ngeoms = ngeoms + 1
         isav(ngeoms) = 1
         if (heat.ne.0.0d0) then
            ihasep = 1
            epoints(ngeoms) = heat
            if (heat.gt.enmax) enmax = heat
            if (heat.lt.enmin) enmin = heat
         endif
      end do

100   continue
      nepnts =  ngeoms
      if (ihasep.eq.0) then
         igcvav = 0
         ieav = 0
      endif

      return
      end

      subroutine geoxyz(ihasg,iff,
     &                  formax,forrms,dismax,disrms,epoints,isav)
      implicit double precision (a-h,o-z)
      logical getxyz,getzm,gettnk,goon,getmol
      common /rdwr/   iun1,iun2,iun3,iun4,iun5
      common /geocnv/ fmaxt,frmst,dmaxt,drmst,fgmin,fgmax,dgmin,dgmax,
     &                enmax,enmin,ngeoms,nepnts,igcvav,ifmxav,ifrmav,
     &                idmxav,idrmav,ieav,ifrav,mxpnt
      integer xmol
      logical favail,oxyz,stpdb,doconv,dozme,gusirc
      common /getpnt/ irtype,ipdbon,ipdbgro,xmol,favail,oxyz,stpdb,
     &                doconv,dozme,gusirc
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      character*137 line
      dimension formax(*),forrms(*),dismax(*),disrms(*),epoints(*)
      dimension isav(*)

      ngeoms = 0
      if (ihasg.gt.0) then
         call rewmf
         call srchmf(line,'[GEOMETRIES]',istat)
      else
         rewind iun2
         igcvav = 1
         ifmxav = 0
         ifrmav = 0
         idmxav = 0
         idrmav = 0
         ieav = 1
         nepnts = 0
         dmaxt = 0.0d0
         fmaxt = 0.0d0
         drmst = 0.0d0
         frmst = 0.0d0
         enmax = -1000000.0d0
         enmin = 1000000.0d0
         ihasep = 0
         do i=1,mxpnt
            epoints(i) = 0.0d0
         end do
      endif

      do while (.true.)

         iheat = 0
         if (ihasg.le.1) then
             if (xmol.eq.2.or.xmol.eq.3) then
                goon = gettnk(.false.,ipdbon,iff)
             elseif (xmol.eq.4) then
                goon = getmol(.false.)
             else
                goon = getxyz(heat,.false.)
                iheat = 1
             endif
         else
             goon = getzm(coo,ianz,iatoms,.false.,.false.)
         endif
         if (.not.goon) goto 100

         if (ngeoms.eq.mxpnt) then
             call inferr('exceeded MAXPNT !',1)
             goto 100
         endif
         ngeoms = ngeoms + 1
         if (ihasg.eq.0) then
            isav(ngeoms) = 1
            if (iheat.eq.1) then
               ihasep = 1
               epoints(ngeoms) = heat
               if (heat.gt.enmax) enmax = heat
               if (heat.lt.enmin) enmin = heat
            endif
         endif
      end do

100   continue
      nepnts =  ngeoms
      if (enmax.eq.enmin) enmax = enmin + 0.00001d0
      if (ihasg.eq.0) then
         if (ihasep.eq.0) then
            igcvav = 0
            ieav = 0
         endif
      endif

      return
      end
