      subroutine eem(iop)
c
c     program for the calculation of eem parameters
c     patrick bultinck, jrf, 2001
c
c     J. Phys. Chem. A (2002)
c
      implicit double precision(a-h,o-z)
      parameter (mxeat=300)
      parameter (numat1=50000)
      dimension var(mxeat,2)

      call valdis(var,numat,iop,istat)
      if (istat.eq.0) call eemcalc(var,numat)

      return
c
      end
c
      subroutine valdis(var,numat,iop,istat)
c
      implicit double precision(a-h,o-z)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxeat=300)
      parameter (maxtyp=19)
      parameter (mxtyp4=4*maxtyp)
      parameter (mxel=100)
      integer numat, ipt(mxel)
      double precision param(maxtyp,3,2),var(mxeat,2)
      double precision pparam(maxtyp,3,2)
c
      common /eempar/param,pparam,ipt
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      character*2 elemnt
      common /elem/elemnt(mxel)
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      logical ofive

c      data attyp/'H  ','HE ','LI ','BE ','B  ','C  ','N  ',
c     &'O  ','F  ',
c     &'NE ','NA ','K  ','AL ','SI ','P  ','S  ','CL ',
c     &'AR ','BR',
c     &'H2 ','HE2','LI2','BE2','B2 ','C2 ','N2 '
c     &,'O2 ','F2 ','NE2',
c     &'NA2','K2 ','AL2','SI2','P2 ','S2 ','CL2',
c     &'AR2','BR2',
c     &'H3 ','HE3','LI3','BE3','B3 ','C3 ','N3 ','O3 ','F3 ',
c     &'NE3','NA3','K3 ','AL3','SI3','P3 ','S3 ','CL3','AR3','BR3'/

      data ((param(i,1,k),k=1,2),i=1,maxtyp) /
     & -0.00298,0.89729,0.54541,0.00000,0.93882,0.00000,
     &  0.00000,0.10570,0.00000,0.61634,0.35970,0.33639,
     &  0.53938,0.37574,1.04219,0.72138,1.44195,1.57956,
     &  0.28351,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000/
      data (((param(i,j,k),k=1,2),j=2,3),i=1,maxtyp) /
     &  mxtyp4*0.0/
      data ((pparam(i,1,k),k=1,2),i=1,maxtyp) /
     &  0.20606,0.65971,0.00000,0.00000,0.00000,0.75331,
     &  0.00000,0.00000,0.00000,0.00000,0.36237,0.32966,
     &  0.49279,0.34519,0.73013,0.54428,0.72052,0.72664,
     &  0.78058,0.75467,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000/
c
      data ((pparam(i,2,k),k=1,2),i=1,maxtyp) /
     &  0.04890,0.65686,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.33266,0.37041,
     &  0.56978,0.43659,0.50999,0.35632,0.00000,0.00000,
     &  0.78058,0.75467,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000/
c
      data ((pparam(i,3,k),k=1,2),i=1,maxtyp) /
     &  0.04890,0.65686,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.33266,0.37041,
     &  0.56978,0.43659,0.50999,0.35632,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000,0.00000,0.00000,0.00000,0.00000,
     &  0.00000,0.00000/

      data ipt /1,2,
     1        3,4,5,6,7,8,9,10,
     2        11,0,13,14,15,16,17,18,
     3        12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,
     4        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     5        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     3        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     4        0,0,0,0,0/

      istat = 0
c
      do i=1,iatoms
          do j=1,2
             ipatm = ipt(ianz(i))
             if (ipatm.eq.0) then
                call inferr(
     &           'no parameters for element '//elemnt(ianz(i)),0)
                ihasq = 0
                istat = 1
                return
             endif
             if (iop.eq.1) then
c NPA
                var(i,j) = param(ipatm,1,j)
             else
c Mull
                var(i,j) = pparam(ipatm,1,j)
             endif
          end do
      end do
      numat = iatoms
c
      return
      end
c
      subroutine eemcalc(var,numat)
c
      implicit double precision(a-h,o-z)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxeat=300)
      integer numat
      double precision var(mxeat,2)
      double precision x(mxeat+1,mxeat+1),y(mxeat+1)
      double precision work(mxeat+1,mxeat+1)
      integer ipvt(mxeat+1),info
      dimension det(2)
      logical ofive
c
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
c

      do i=1,(numat-1)
         x(i,i)       = 2*var(i,2)
         x(i,numat+1) = -1
         x(numat+1,i) = 1

         do j=i+1,numat
            x(i,j) = (coo(1,i)-coo(1,j))**2
            x(i,j) = x(i,j)+(coo(2,i)-coo(2,j))**2
            x(i,j) = x(i,j)+(coo(3,i)-coo(3,j))**2
            x(i,j) = sqrt(x(i,j))
            x(i,j) = 1/x(i,j)
            x(j,i) = x(i,j)
         end do

      end do
      x(numat,numat)     = 2*var(numat,2)
      x(numat,numat+1)   = -1
      x(numat+1,numat)   = 1
      x(numat+1,numat+1) = 0
c
      y(numat+1)       = 0
c
      do i=1,numat
         y(i) = -var(i,1)
      end do

      call dgefa(x,mxeat+1,numat+1,ipvt,info)
      call dgedi(x,mxeat+1,(numat+1),ipvt,det,work,01)

c
      call mtmul(x,y,qat,numat)
      do i=1,(numat+1)
          write (*,'(f10.5)') qat(i)
      end do
      ihasq = 1

      return
      end
c
      subroutine mtmul(a,y,b,numat)
c
      parameter (mxeat=300)
c
      integer i,j,numat
      double precision a(mxeat+1,mxeat+1),y(mxeat+1),b(mxeat+1)
c
      do i=1,numat+1

         b(i) = 0.0

         do j=1,numat+1
            b(i) = b(i) + a(i,j)*y(j)
         end do

      end do
c
      return
      end
c
      subroutine dgedi(a,lda,n,ipvt,det,work,job)
      implicit double precision(a-h,o-z)
      dimension a(lda,*),det(2),work(*),ipvt(*)
c
c     dgedi computes the determinant and inverse of a matrix
c     using the factors computed by dgeco or dgefa.
c
c     on entry
c
c        a       double precision(lda, n)
c                the output from dgeco or dgefa.
c
c        lda     integer
c                the leading dimension of the array  a .
c
c        n       integer
c                the order of the matrix  a .
c
c        ipvt    integer(n)
c                the pivot vector from dgeco or dgefa.
c
c        work    double precision(n)
c                work vector.  contents destroyed.
c
c        job     integer
c                = 11   both determinant and inverse.
c                = 01   inverse only.
c                = 10   determinant only.
c
c     on return
c
c        a       inverse of original matrix if requested.
c                otherwise unchanged.
c
c        det     double precision(2)
c                determinant of original matrix if requested.
c                otherwise not referenced.
c                determinant = det(1) * 10.0**det(2)
c                with  1.0 .le. abs(det(1)) .lt. 10.0
c                or  det(1) .eq. 0.0 .
c
c     error condition
c
c        a division by zero will occur if the input factor contains
c        a zero on the diagonal and the inverse is requested.
c        it will not occur if the subroutines are called correctly
c        and if dgeco has set rcond .gt. 0.0 or dgefa has set
c        info .eq. 0 .
c
c     linpack. this version dated 08/14/78 .
c     cleve moler, university of new mexico, argonne national lab.
c
c     subroutines and functions
c
c     blas daxpy,dscal,dswap
c     fortran abs,mod
c
c     compute determinant
c
      if (job/10 .eq. 0) go to 70
         det(1) = 1.0d+00
         det(2) = 0.0d+00
         ten = 10.0d+00
         do 50 i = 1, n
            if (ipvt(i) .ne. i) det(1) = -det(1)
            det(1) = a(i,i)*det(1)
c        ...exit
            if (det(1) .eq. 0.0d+00) go to 60
   10       if (abs(det(1)) .ge. 1.0d+00) go to 20
               det(1) = ten*det(1)
               det(2) = det(2) - 1.0d+00
            go to 10
   20       continue
   30       if (abs(det(1)) .lt. ten) go to 40
               det(1) = det(1)/ten
               det(2) = det(2) + 1.0d+00
            go to 30
   40       continue
   50    continue
   60    continue
   70 continue
c
c     compute inverse(u)
c
      if (mod(job,10) .eq. 0) return
         do k = 1, n
            a(k,k) = 1.0d+00/a(k,k)
            t = -a(k,k)
            call dscal(k-1,t,a(1,k),1)
            kp1 = k + 1
            if (n .lt. kp1) go to 90
            do j = kp1, n
               t = a(k,j)
               a(k,j) = 0.0d+00
               call daxpy(k,t,a(1,k),1,a(1,j),1)
            end do
   90       continue
         end do
c
c        form inverse(u)*inverse(l)
c
         nm1 = n - 1
         if (nm1 .lt. 1) return
         do kb = 1, nm1
            k = n - kb
            kp1 = k + 1
            do i = kp1, n
               work(i) = a(i,k)
               a(i,k) = 0.0d+00
            end do
            do j = kp1, n
               t = work(j)
               call daxpy(n,t,a(1,j),1,a(1,k),1)
            end do
            l = ipvt(k)
            if (l .ne. k) call dswap(n,a(1,k),1,a(1,l),1)
         end do

      return
      end

      subroutine dgefa(a,lda,n,ipvt,info)
      implicit double precision(a-h,o-z)
      dimension a(lda,*),ipvt(*)
c
c     dgefa factors a double precision matrix by gaussian elimination.
c
c     dgefa is usually called by dgeco, but it can be called
c     directly with a saving in time if  rcond  is not needed.
c     (time for dgeco) = (1 + 9/n)*(time for dgefa) .
c
c     on entry
c
c        a       double precision(lda, n)
c                the matrix to be factored.
c
c        lda     integer
c                the leading dimension of the array  a .
c
c        n       integer
c                the order of the matrix  a .
c
c     on return
c
c        a       an upper triangular matrix and the multipliers
c                which were used to obtain it.
c                the factorization can be written  a = l*u  where
c                l  is a product of permutation and unit lower
c                triangular matrices and  u  is upper triangular.
c
c        ipvt    integer(n)
c                an integer vector of pivot indices.
c
c        info    integer
c                = 0  normal value.
c                = k  if  u(k,k) .eq. 0.0 .  this is not an error
c                     condition for this subroutine, but it does
c                     indicate that dgesl or dgedi will divide by zero
c                     if called.  use  rcond  in dgeco for a reliable
c                     indication of singularity.
c
c     linpack. this version dated 08/14/78 .
c     cleve moler, university of new mexico, argonne national lab.
c
c     subroutines and functions
c
c     blas daxpy,dscal,idamax
c
c     gaussian elimination with partial pivoting
c
      info = 0
      nm1 = n - 1
      if (nm1 .lt. 1) go to 70
      do 60 k = 1, nm1
         kp1 = k + 1
c
c        find l = pivot index
c
         l = idamax(n-k+1,a(k,k),1) + k - 1
         ipvt(k) = l
c
c        zero pivot implies this column already triangularized
c
         if (a(l,k) .eq. 0.0d+00) go to 40
c
c           interchange if necessary
c
            if (l .eq. k) go to 10
               t = a(l,k)
               a(l,k) = a(k,k)
               a(k,k) = t
   10       continue
c
c           compute multipliers
c
            t = -1.0d+00/a(k,k)
            call dscal(n-k,t,a(k+1,k),1)
c
c           row elimination with column indexing
c
            do 30 j = kp1, n
               t = a(l,j)
               if (l .eq. k) go to 20
                  a(l,j) = a(k,j)
                  a(k,j) = t
   20          continue
               call daxpy(n-k,t,a(k+1,k),1,a(k+1,j),1)
   30       continue
         go to 50
   40    continue
            info = k
   50    continue
   60 continue
   70 continue
      ipvt(n) = n
      if (a(n,n) .eq. 0.0d+00) info = n
      return
      end

c 10 nov 94 - mws - dnrm2: remove ftncheck warnings
c 11 jun 94 - mws - include a copy of dgemv (level two routine)
c 11 aug 87 - mws - sanitize floating point constants in dnrm2
c 26 mar 87 - mws - use generic sign in drotg
c 28 nov 86 - ste - supply all level one blas
c  7 jul 86 - jab - sanitize floating point constants
c
c basic linear algebra subprograms (blas) from linpack  (level 1)
c
c   this module should be compiled only if specially coded
c   versions of these routines are not available on the target machine
c
      double precision function dasum(n,dx,incx)
c
c     takes the sum of the absolute values.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dtemp
      integer i,incx,m,mp1,n,nincx
c
      dasum = 0.0d+00
      dtemp = 0.0d+00
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      nincx = n*incx
      do 10 i = 1,nincx,incx
        dtemp = dtemp + abs(dx(i))
   10 continue
      dasum = dtemp
      return
c
c        code for increment equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,6)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dtemp + abs(dx(i))
   30 continue
      if( n .lt. 6 ) go to 60
   40 mp1 = m + 1
      do 50 i = mp1,n,6
        dtemp = dtemp + abs(dx(i)) + abs(dx(i + 1)) + abs(dx(i + 2))
     *  + abs(dx(i + 3)) + abs(dx(i + 4)) + abs(dx(i + 5))
   50 continue
   60 dasum = dtemp
      return
      end

      subroutine daxpy(n,da,dx,incx,dy,incy)
      implicit double precision(a-h,o-z)
      dimension dx(1),dy(1)
c
c     constant times a vector plus a vector.
c           dy(i) = dy(i) + da * dx(i)
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      if(n.le.0)return
      if (da .eq. 0.0d+00) return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dy(iy) = dy(iy) + da*dx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dy(i) = dy(i) + da*dx(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        dy(i) = dy(i) + da*dx(i)
        dy(i + 1) = dy(i + 1) + da*dx(i + 1)
        dy(i + 2) = dy(i + 2) + da*dx(i + 2)
        dy(i + 3) = dy(i + 3) + da*dx(i + 3)
   50 continue
      return
      end

      subroutine dcopy(n,dx,incx,dy,incy)
      implicit double precision(a-h,o-z)
      dimension dx(*),dy(*)
c
c     copies a vector.
c           dy(i) <== dx(i)
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dy(iy) = dx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,7)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dy(i) = dx(i)
   30 continue
      if( n .lt. 7 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,7
        dy(i) = dx(i)
        dy(i + 1) = dx(i + 1)
        dy(i + 2) = dx(i + 2)
        dy(i + 3) = dx(i + 3)
        dy(i + 4) = dx(i + 4)
        dy(i + 5) = dx(i + 5)
        dy(i + 6) = dx(i + 6)
   50 continue
      return
      end

      double precision function ddot(n,dx,incx,dy,incy)
      implicit double precision(a-h,o-z)
      dimension dx(1),dy(1)
c
c     forms the dot product of two vectors.
c           dot = dx(i) * dy(i)
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      ddot = 0.0d+00
      dtemp = 0.0d+00
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = dtemp + dx(ix)*dy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      ddot = dtemp
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,5)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dtemp + dx(i)*dy(i)
   30 continue
      if( n .lt. 5 ) go to 60
   40 mp1 = m + 1
      do 50 i = mp1,n,5
        dtemp = dtemp + dx(i)*dy(i) + dx(i + 1)*dy(i + 1) +
     *   dx(i + 2)*dy(i + 2) + dx(i + 3)*dy(i + 3) + dx(i + 4)*dy(i + 4)
   50 continue
   60 ddot = dtemp
      return
      end

      double precision function dnrm2 ( n, dx, incx)
      integer          next
      double precision   dx(1), cutlo, cuthi, hitest, sum, xmax,zero,one
      data   zero, one /0.0d+00, 1.0d+00/
c
c     euclidean norm of the n-vector stored in dx() with storage
c     increment incx .
c     if    n .le. 0 return with result = 0.
c     if n .ge. 1 then incx must be .ge. 1
c
c           c.l.lawson, 1978 jan 08
c
c     four phase method     using two built-in constants that are
c     hopefully applicable to all machines.
c         cutlo = maximum of  sqrt(u/eps)  over all known machines.
c         cuthi = minimum of  sqrt(v)      over all known machines.
c     where
c         eps = smallest no. such that eps + 1. .gt. 1.
c         u   = smallest positive no.   (underflow limit)
c         v   = largest  no.            (overflow  limit)
c
c     brief outline of algorithm..
c
c     phase 1    scans zero components.
c     move to phase 2 when a component is nonzero and .le. cutlo
c     move to phase 3 when a component is .gt. cutlo
c     move to phase 4 when a component is .ge. cuthi/m
c     where m = n for x() real and m = 2*n for complex.
c
c     values for cutlo and cuthi..
c     from the environmental parameters listed in the imsl converter
c     document the limiting values are as follows..
c     cutlo, s.p.   u/eps = 2**(-102) for  honeywell.  close seconds are
c                   univac and dec at 2**(-103)
c                   thus cutlo = 2**(-51) = 4.44089e-16
c     cuthi, s.p.   v = 2**127 for univac, honeywell, and dec.
c                   thus cuthi = 2**(63.5) = 1.30438e19
c     cutlo, d.p.   u/eps = 2**(-67) for honeywell and dec.
c                   thus cutlo = 2**(-33.5) = 8.23181d-11
c     cuthi, d.p.   same as s.p.  cuthi = 1.30438d+19
c     data cutlo, cuthi / 8.232d-11,  1.304d+19 /
c     data cutlo, cuthi / 4.441e-16,  1.304e19 /
      data cutlo, cuthi / 8.232d-11,  1.304d+19 /
c
      j=0
      if(n .gt. 0) go to 10
         dnrm2  = zero
         go to 300
c
   10 assign 30 to next
      sum = zero
      nn = n * incx
c                                                 begin main loop
      i = 1
   20    go to next,(30, 50, 70, 110)
   30 if( abs(dx(i)) .gt. cutlo) go to 85
      assign 50 to next
      xmax = zero
c
c                        phase 1.  sum is zero
c
   50 if( dx(i) .eq. zero) go to 200
      if( abs(dx(i)) .gt. cutlo) go to 85
c
c                                prepare for phase 2.
      assign 70 to next
      go to 105
c
c                                prepare for phase 4.
c
  100 i = j
      assign 110 to next
      sum = (sum / dx(i)) / dx(i)
  105 xmax = abs(dx(i))
      go to 115
c
c                   phase 2.  sum is small.
c                             scale to avoid destructive underflow.
c
   70 if( abs(dx(i)) .gt. cutlo ) go to 75
c
c                     common code for phases 2 and 4.
c                     in phase 4 sum is large.  scale to avoid overflow.
c
  110 if( abs(dx(i)) .le. xmax ) go to 115
         sum = one + sum * (xmax / dx(i))**2
         xmax = abs(dx(i))
         go to 200
c
  115 sum = sum + (dx(i)/xmax)**2
      go to 200
c
c
c                  prepare for phase 3.
c
   75 sum = (sum * xmax) * xmax
c
c
c     for real or d.p. set hitest = cuthi/n
c     for complex      set hitest = cuthi/(2*n)
c
   85 hitest = cuthi/n
c
c                   phase 3.  sum is mid-range.  no scaling.
c
      do 95 j =i,nn,incx
      if(abs(dx(j)) .ge. hitest) go to 100
   95    sum = sum + dx(j)**2
      dnrm2 = sqrt( sum )
      go to 300
c
  200 continue
      i = i + incx
      if ( i .le. nn ) go to 20
c
c              end of main loop.
c
c              compute square root and adjust for scaling.
c
      dnrm2 = xmax * sqrt(sum)
  300 continue
      return
      end

      subroutine drot(n,dx,incx,dy,incy,c,s)
      implicit double precision(a-h,o-z)
      dimension dx(1),dy(1)
c
c     applies a plane rotation.
c           dx(i) =  c*dx(i) + s*dy(i)
c           dy(i) = -s*dx(i) + c*dy(i)
c     jack dongarra, linpack, 3/11/78.
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c       code for unequal increments or equal increments not equal
c         to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = c*dx(ix) + s*dy(iy)
        dy(iy) = c*dy(iy) - s*dx(ix)
        dx(ix) = dtemp
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c       code for both increments equal to 1
c
   20 do 30 i = 1,n
        dtemp = c*dx(i) + s*dy(i)
        dy(i) = c*dy(i) - s*dx(i)
        dx(i) = dtemp
   30 continue
      return
      end

      subroutine drotg(da,db,c,s)
c
c     construct givens plane rotation.
c     jack dongarra, linpack, 3/11/78.
c
      double precision da,db,c,s,roe,scale,r,z
      double precision zero, one
c
      parameter (zero=0.0d+00, one=1.0d+00)
c
c-----------------------------------------------------------------------
c
c
      roe = db
      if( abs(da) .gt. abs(db) ) roe = da
      scale = abs(da) + abs(db)
      if( scale .ne. zero ) go to 10
         c = one
         s = zero
         r = zero
         go to 20
c
   10 r = scale*sqrt((da/scale)**2 + (db/scale)**2)
      r = sign(one,roe)*r
      c = da/r
      s = db/r
   20 z = one
      if( abs(da) .gt. abs(db) ) z = s
      if( abs(db) .ge. abs(da) .and. c .ne. zero ) z = one/c
      da = r
      db = z
      return
      end

      subroutine dscal(n,da,dx,incx)
      implicit double precision(a-h,o-z)
      dimension dx(1)
c
c     scales a vector by a constant.
c           dx(i) = da * dx(i)
c     uses unrolled loops for increment equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      nincx = n*incx
      do 10 i = 1,nincx,incx
        dx(i) = da*dx(i)
   10 continue
      return
c
c        code for increment equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,5)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dx(i) = da*dx(i)
   30 continue
      if( n .lt. 5 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,5
        dx(i) = da*dx(i)
        dx(i + 1) = da*dx(i + 1)
        dx(i + 2) = da*dx(i + 2)
        dx(i + 3) = da*dx(i + 3)
        dx(i + 4) = da*dx(i + 4)
   50 continue
      return
      end

      subroutine dswap(n,dx,incx,dy,incy)
      implicit double precision(a-h,o-z)
      dimension dx(1),dy(1)
c
c     interchanges two vectors.
c           dx(i) <==> dy(i)
c     uses unrolled loops for increments equal one.
c     jack dongarra, linpack, 3/11/78.
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c       code for unequal increments or equal increments not equal
c         to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = dx(ix)
        dx(ix) = dy(iy)
        dy(iy) = dtemp
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c       code for both increments equal to 1
c
c
c       clean-up loop
c
   20 m = mod(n,3)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dx(i)
        dx(i) = dy(i)
        dy(i) = dtemp
   30 continue
      if( n .lt. 3 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,3
        dtemp = dx(i)
        dx(i) = dy(i)
        dy(i) = dtemp
        dtemp = dx(i + 1)
        dx(i + 1) = dy(i + 1)
        dy(i + 1) = dtemp
        dtemp = dx(i + 2)
        dx(i + 2) = dy(i + 2)
        dy(i + 2) = dtemp
   50 continue
      return
      end
      integer function idamax(n,dx,incx)
      implicit double precision(a-h,o-z)
      dimension dx(1)
c
c     finds the index of element having max. absolute value.
c     jack dongarra, linpack, 3/11/78.
c
      idamax = 0
      if( n .lt. 1 ) return
      idamax = 1
      if(n.eq.1)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      ix = 1
      rmax = abs(dx(1))
      ix = ix + incx
      do 10 i = 2,n
         if(abs(dx(ix)).le.rmax) go to 5
         idamax = i
         rmax = abs(dx(ix))
    5    ix = ix + incx
   10 continue
      return
c
c        code for increment equal to 1
c
   20 rmax = abs(dx(1))
      do 30 i = 2,n
         if(abs(dx(i)).le.rmax) go to 30
         idamax = i
         rmax = abs(dx(i))
   30 continue
      return
      end

      subroutine dgemv(forma,m,n,alpha,a,lda,x,incx,beta,y,incy)
      implicit double precision(a-h,o-z)
      character*1 forma
      dimension a(lda,*),x(*),y(*)
      parameter (zero=0.0d+00, one=1.0d+00)
c
c        clone of -dgemv- written by mike schmidt
c
      locy = 1
      if(forma.eq.'t') go to 200
c
c                  y = alpha * a * x + beta * y
c
      if(alpha.eq.one  .and.  beta.eq.zero) then
         do 110 i=1,m
            y(locy) =       ddot(n,a(i,1),lda,x,incx)
            locy = locy+incy
  110    continue
      else
         do 120 i=1,m
            y(locy) = alpha*ddot(n,a(i,1),lda,x,incx) + beta*y(locy)
            locy = locy+incy
  120    continue
      end if
      return
c
c                  y = alpha * a-transpose * x + beta * y
c
  200 continue
      if(alpha.eq.one  .and.  beta.eq.zero) then
         do 210 i=1,n
            y(locy) =       ddot(m,a(1,i),1,x,incx)
            locy = locy+incy
  210    continue
      else
         do 220 i=1,n
            y(locy) = alpha*ddot(m,a(1,i),1,x,incx) + beta*y(locy)
            locy = locy+incy
  220    continue
      end if
      return
      end
c
      subroutine filnam(filn,nnn)
      character name*70,filn*(*)
c
      i1 = 0
      do 1 i = 1,nnn
      if (filn(i:i).eq.' ')  goto 1
      i1 = i1 + 1
      name(i1:i1) = filn(i:i)
 1    continue
      do 2 i = 1,nnn
 2    filn(i:i) = ' '
      do 3 i = 1,i1
 3    filn(i:i) = name(i:i)
c
      return
      end

      subroutine distchk
c
c
      implicit double precision(a-h,o-z)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)

      tol = 0.1d0
      do i=1,iatoms
         do j=i+1,iatoms
             dd = 0.0d0
             do k=1,3
                d1 = coo(k,i) - coo(k,j)
                d2 = d1*d1
                dd = dd + d2
             end do 
             if (dd.lt.tol) print*,'close ',i,' ',j
         end do
      end do

      return
      end

      subroutine sigini
      implicit double precision(a-h,o-z)
      parameter (mxsigm=15)
      parameter (mxmol2=41)
      common /sigma/ siga(mxsigm),sigb(mxsigm),sigc(mxsigm),
     &               sigd(mxsigm),impmol2(mxmol2)
c      data sigs  /"H ","C3","C2","C1","N3","N2","N1","O3","O2","F ",
c     &       "Cl","Br","I ","S3","DU"/     
      data siga /7.17,7.98,8.79,10.39,11.54,12.87,15.68,14.18,
     &       17.07,14.66, 11.00, 10.08,9.90,10.14,0.0/
      data sigb /6.24,9.18,9.32,9.45,10.82,11.15,11.70,12.92,
     &           13.79,13.85,9.69,8.47,7.96,9.13,0.0/
      data sigc /-0.56,1.88,1.51,0.73,1.36,0.85,-0.27,1.39,
     &           0.47,2.31,1.35,1.16,0.96,1.38,0.0/
      data impmol2 /15,15,15,15,2,3,4,3,3,5,6,7,6,6,6,5,
     &           8,9,9,8,8,14,14,14,14,0,1,1,1,10,11,12,13,
     &           15,15,15,15,15,15,15,15/

c sybyl atom types to gasteiger types
c1 any
c2 hal
c3 het
c4 hev
c5 C.3     2
c6 C.2     3
c7 C.1     4
c8 C.ar    3
c9 C.cat   ?
c10 N.3    5
c11 N.2    6
c12 N.1    7
c13 N.ar   6
c14 N.am   6
c15 N.pl3  6
c16 N.4    5
c17 O.3    8
c18 O.2    9
c19 O.co2  9
c20 O.spc  8
c21 O.t3p  8
c22 S.3    14
c23 S.2
c24 S.O
c25 S.O2
c26 P.3
c27 H      1
c28 H.spc  1
c29 H.t3p  1
c30 F      10
c31 Cl     11
c32 Br     12
c33 I      13
c34 Si
c35 Lp
c36 Du
c37 Na
c38 K
c39 Ca
c40 Li
c41 Al

c unknown is DU 15

      do i=1,mxsigm
         sigd(i) = siga(i) + sigb(i) + sigc(i)
      end do
      sigd(15) = 1.0d0

      return
      end
                              
      subroutine calgas
      implicit double precision(a-h,o-z)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxsigm=15)
      parameter (mxmol2=41)
      common /sigma/ siga(mxsigm),sigb(mxsigm),sigc(mxsigm),
     &               sigd(mxsigm),impmol2(mxmol2)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      integer*2 ityp,ipdbt
      common /types/ iff,ityp(numat1),ipdbt(numat1)
      dimension zz(numat1)

      call sigini
  
      ihasq = 0
      iff = 5
      call dotyp(0)
  
      do i=1,iatoms
         l = impmol2(ityp(i))
         zz(i) = siga(l)
         qat(i) = 0.0d0
         ia = ianz(i)
         if (ia.eq.6) then
           if (ityp(i).eq.9) qat(i) = 1.0d0
         elseif (ia.eq.7) then
           ibnd = 0
           do j=1,iconn(1,i)
              if (iconn(1+j,i).gt.0) ibnd = ibnd + 1
           end do
           if (ibnd.eq.4) qat(i) = 1.0d0
c           if (N3+) qat(i) = 1.0d0
         elseif (ia.eq.8) then
c carboxyl
           if (ityp(i).eq.19) qat(i) = -0.5d0
         endif
      end do

      fac = 1.0d0
      icnt = 0

      do while (.true.)

          fac = fac*0.5d0
          sd1 = 0.0d0
          do i=1,iatoms
             l = impmol2(ityp(i))
             if (sigd(l).ne.1.0d0) then
                qt = qat(i)
                do j=1,iconn(1,i)
                   if (iconn(1+j,i).gt.0) then
                      jj = iabs(iconn(1+j,i))
                      ll = impmol2(ityp(jj))
                      if (sigd(ll).ne.1.0d0) then
                         sd2 = sigd(ll)
                         if (zz(jj).gt.zz(i)) sd2 = sigd(l)
                         if (ianz(i).eq.1.or.ianz(jj).eq.1) 
     &                        sd2 = 20.02d0
                         qat(i) = qat(i) + (zz(jj) - zz(i))*fac/sd2
                      endif
                   endif
                end do
                qt = dabs(qat(i) - qt)
                if (qt.gt.sd1) sd1 = qt
             endif
          end do

          if (sd1.ge.1.0d-3) then
             do i=1,iatoms
                l = impmol2(ityp(i))
                zz(i) = siga(l) + sigb(l)*qat(i) + sigc(l)*qat(i)*qat(i)
             end do
          endif 

          icnt = icnt + 1

          if (.not.(sd1.gt.1.0d-3.and.icnt.le.5)) goto 100
      end do

100   continue
      ihasq = 1
      return
      end
