      subroutine wrmsf(iun,icel)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxel=100)
      parameter (numatm=2000)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxsg=238)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      integer*2 ityp,ipdbt
      common /types/ iff,ityp(numat1),ipdbt(numat1)
      common /cell/ nat,norg,icent,inorm,ico(3,8),icn(4,8),icol(32),ncon
      common /celpar/xa,ya,yb,za,zb,zc,a,b,c,alpha,beta,gamma,nspg,kz
      character*7 spnam
      common /spgrnm/ spnam(mxsg)
      common /hring/ lring(numat1)
      character*2 elemnt
      common /elem/elemnt(mxel)
      character*200 header
      character*100 fname
      character*80 col
      character*10 version
      character*6 mklab
      integer*2 nbc(numat1),ibc(numat1,mxcon),ictyp
      integer*2 i2dum,ibc2,iorder(numat1*mxcon)
      real rdum
      logical dochg,ochg
      dimension ibc2(2,numat1*mxcon),rr(3,3)

      istat = 1
      toang = 0.52917706d0
      torad = datan(1.0d0) / 45.0d0
      dochg = .false.

      fname = 'kull'
      natoms = iatoms

      if (icel.eq.1) then

         dochg = ochg(idum)
         natoms = nat
         nstor = numat1-natoms
         do i=1,natoms
            do j=1,3
               coo(j,i) = coo(j,nstor+i)
            end do
            ianz(i) = ianz(nstor+i)
            do j=1,iconn(1,nstor+i)+1
               iconn(j,i) = iconn(j,nstor+i)
            end do
            iatclr(i) = iatclr(nstor+i)
         end do

      else
         if (ihasq.eq.1) dochg = .true.
      endif

      do i=1,natoms
         lring(i) = 0
         iaton(i) = 2
      end do

      ns = 1
      nr = 1
      version = 'QUANTAR3.3'
      header = 'Molden generated MSF'
      write(iun) ns,nr,natoms,version,header
      col = 'END'
      write(iun) col

c
c write segment information
c
      i2dum = 1
      write(iun) 'NEWS'
      write(iun) i2dum
      write(iun) i2dum

c
c write residue information
c
      i2dum = 1
      write(iun) 'RES1  '
      write(iun) 'RES1'
      write(iun) i2dum
      i2dum = natoms
      write(iun) i2dum
      i2dum = 1
      write(iun) i2dum

      rdum = 0.0e0
      write(iun) rdum
      write(iun) rdum
      write(iun) rdum
      rdum = 10.0e0
      write(iun) rdum
c
c write atom info
c
      if (icel.eq.1) then

         call setrr(alpha,beta,gamma,a,b,c,rr)

         do j=1,3
            write(iun) (real(trc(coo(1,i),rr,j)),i=1,natoms)
         end do
      else
         do j=1,3
            write(iun) (real(coo(j,i)*toang),i=1,natoms)
         end do
      endif
 
      write(iun) (mklab(ianz(i),i),i=1,natoms)

      i2dum = 1
      write(iun) (i2dum,i=1,natoms)

      if (iff.eq.6) then
         write(iun) (ityp(i),i=1,natoms)
      else
         write(iun) (ictyp(i,ianz(i),dochg),i=1,natoms)
      endif

      write(iun) (real(qat(i)),i=1,natoms)

c
c write the extra data
c

      rdum = 0.0e0
      write(iun) 'BVALUE    ','REAL',natoms,fname
      write(iun) (rdum,i=1,natoms)

      write(iun) 'CONNECT   ','BOND',natoms,fname

      do i=1,natoms
         nbc(i) = 0
         do j=1,iconn(1,i)
            if (iconn(1+j,i).gt.0) then
               nbc(i) = nbc(i) + 1
               ibc(i,nbc(i)) = iconn(1+j,i)
            endif
         end do
      end do
      write(iun) (nbc(i),(ibc(i,j),j=1,nbc(i)),i=1,natoms)

      nbnds = 0
      do i=1,natoms
         do j=1,iconn(1,i)
            jj = iconn(1+j,i)
            if (jj.gt.0) then
               if (jj.gt.i) then
                  nbnds = nbnds + 1
                  iorder(nbnds) = ibtyp(i,jj,dochg,.true.)
                  if (iorder(nbnds).eq.4) iorder(nbnds) = 7
                  ibc2(1,nbnds) = i
                  ibc2(2,nbnds) = jj
               endif
            endif
         end do
      end do

      write(iun) 'ORDER     ','BOND',nbnds,fname
      write(iun) (iorder(i),(ibc2(j,i),j=1,2),i=1,nbnds)

      if (icel.eq.1) then
          write(iun) spnam(nspg),'   ','SYMM',2,fname
          write(col,'(a5,6(f9.3),i2,i6,3x,a7)') 'CELL ',a,b,c,
     &        alpha/torad,beta/torad,gamma/torad,1,nspg,spnam(nspg)
          write(iun) col
          col = 'END'
          write(iun) col
          call fdat(1,0,0,.false.,0,0)
      endif

      do i=1,natoms
         iaton(i) = 1
      end do

      return
      end

      integer*2 function ictyp(iat,ian,dochg)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxt=14)
      parameter (mxmsf=235)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      character*4 atype
      common /atypes/ ihbt(mxt),atype(mxt)
      common /msft/ ltyp(mxmsf)
      logical dochg
      dimension icnn(mxcon)

      ibnds = 0
      io = 0
      in = 0
      ic = 0
      do i=1,iconn(1,iat)
         if (iconn(i+1,iat).gt.0) then
            ibnds = ibnds + 1
            icnn(ibnds) = iconn(i+1,iat)
            ia = ianz(icnn(ibnds))
            if (ia.eq.6) ic = ic + 1
            if (ia.eq.7) in = in + 1
            if (ia.eq.8) io = io + 1
         endif
      end do
      if (ibnds.gt.0) ian1 = ianz(icnn(1))
      if (ibnds.gt.1) ian2 = ianz(icnn(2))
      if (ibnds.gt.2) ian3 = ianz(icnn(3))

      ihb = ihbt(ispn(iat,irng,dochg,.true.))
      
      ictyp = 1
      if (ian.eq.1) then
         ictyp = 1
         if (ibnds.eq.1) then
            if (ian1.eq.6.or.ian1.eq.14) ictyp = 3
            if (ian1.eq.7) then
               ib = icred(icnn(1),idum1,idum2)
               if (ib.eq.4) ictyp = 2
            endif
            if (ian1.eq.8.or.ian1.eq.14) then
               if (ian1.eq.14) ictyp = 8
               if (ian1.eq.8) then
                  ib = 0
                  ic = 0
                  kat = icnn(1)
                  do j=1,iconn(1,kat)
                     jat = iconn(j+1,kat)
                     if (jat.gt.0) then
                        ib = ib + 1
                        if (ianz(jat).eq.6) ic = jat
                     endif
                  end do
                  if (ib.eq.2.and.ic.ne.0) then
                     ictyp = 8
                     ib = 0
                     io = 0
                     do j=1,iconn(1,ic)
                        jat = iconn(j+1,ic)
                        if (jat.gt.0.and.jat.ne.icnn(1)) then
                           ib = ib + 1
                           if (ianz(jat).eq.8) io = jat
                        endif
                     end do
                     if (ib.eq.2.and.io.ne.0) ictyp = 1
                  endif
               endif
            endif
         endif
      elseif (ian.eq.6) then
         if (ihb.eq.1) then
            ictyp = 18
         elseif (ihb.eq.2) then
            ictyp = 14
            if (ibnds.eq.3) then
               do i=1,3
                  if (ianz(icnn(i)).eq.6.and.
     &                ihbt(ispn(icnn(i),jrng,dochg,.true.)).eq.2)
     &                ictyp = 16
               end do
               if (io.gt.0) ictyp = 14
            endif
         elseif (ihb.eq.3) then
            ictyp = 10
         elseif (ihb.eq.4) then
            if (irng.eq.1) then
               ictyp = 22
            elseif (irng.eq.2) then
               ictyp = 21
            elseif (irng.eq.3) then
               ictyp = 27
            elseif (irng.eq.4) then
               ictyp = 25
            elseif (irng.eq.5) then
               ictyp = 26
            endif
         endif
      elseif (ian.eq.7) then
         if (ihb.eq.1) then
            ictyp = 31
         elseif (ihb.eq.2) then
            ictyp = 32
         elseif (ihb.eq.3) then
            ictyp = 36
            do i=1,ibnds
               iht = ihbt(ispn(icnn(i),jrng,dochg,.true.))
               if (ianz(icnn(i)).eq.6.and.
     &             (iht.eq.2.or.iht.eq.4))
     &             ictyp = 32
            end do
            if (ibnds.eq.3.and.io.eq.2) ictyp = 38
         elseif (ihb.eq.4) then
            ictyp = 35
            if (irng.eq.2) ictyp = 34
         endif
      elseif (ian.eq.8) then
         if (ihb.eq.1) then
            ictyp = 48
         elseif (ihb.eq.2) then
            ictyp = 40
            if (ibnds.eq.1.and.ian1.ne.1) then
               jat = icnn(1)
               if (iconn(1,jat).eq.3.or.
     &           (ian1.eq.15.and.iconn(1,jat).eq.4)) then
                  ih = 0
                  ic = 0
                  ipo = 0
                  do i=1,iconn(1,jat)
                     kat = iconn(1+i,jat)
                     if (kat.gt.0.and.kat.ne.iat) then
                        if (ianz(kat).eq.8) then
                           if (ian1.eq.15) ipo = ipo + 1
                           ib = icred(kat,idum1,idum2)
                           if (ib.eq.2.and.ian1.eq.6) ictyp = 51
                           if (ib.eq.1) ictyp = 43
                        elseif (ianz(kat).eq.1) then
                           ih = ih + 1
                        elseif (ianz(kat).eq.6) then
                           ic = ic + 1
                        endif
                        if (ib.eq.0) then
                           if (ic.eq.2.and.ian1.eq.6) ictyp = 42
                           if (ic.eq.1.and.ih.eq.1.and.ian1.eq.6) 
     &                        ictyp = 41
                        endif
                     endif
                  end do
                  if (ipo.eq.4) ictyp = 43
               endif
            endif
         elseif (ihb.eq.3) then
            ictyp = 45
            if (ibnds.eq.2) then
               if (ian1.ne.1.and.ian2.ne.1) then
                  ictyp = 50
                  do i=1,2
                     jat = icnn(i)
                     if ((ianz(jat).ne.1.and.iconn(1,jat).eq.3).or.
     &               (ianz(jat).eq.15.and.iconn(1,jat).eq.4)) then
                        do j=1,iconn(1,jat)
                           kat = iconn(1+j,jat)
                           if (kat.gt.0.and.kat.ne.iat) then
                              if (ianz(kat).eq.8) then
                                 ib = icred(kat,idum1,idum2)
                                 if (ib.eq.1) ictyp = 49
                              endif
                           endif
                        end do
                     endif
                  end do
                  if (ian1.eq.14.and.ian1.eq.14) ictyp = 55
                  if (ian1.eq.13.and.ian1.eq.14) ictyp = 56
                  if (ian1.eq.14.and.ian1.eq.13) ictyp = 56
                  if (ian1.eq.13.and.ian1.eq.13) ictyp = 56
               endif
            endif
         elseif (ihb.eq.4) then
            ictyp = 53
            if (irng.eq.2) ictyp = 52
         endif
      elseif (ian.eq.15) then
         if (ihb.eq.1) then
            ictyp = 233
         elseif (ihb.eq.2) then
            ictyp = 62
         elseif (ihb.eq.3) then
            ictyp = 60
            if (ibnds.eq.4.or.ibnds.eq.3) then
               if (io.eq.3) ictyp = 61
               if (io.eq.4) ictyp = 62
            endif
         elseif (ihb.eq.4) then
            ictyp = 64
         endif
      elseif (ian.eq.16) then
         if (ihb.eq.1) then
            ictyp = 70
         elseif (ihb.eq.2) then
            ictyp = 75
         elseif (ihb.eq.3) then
            ictyp = 70
            if (ibnds.eq.2) then
               if (ian1.ne.1.and.ian2.ne.1.and.
     &             ian1.ne.16.and.ian2.ne.16) ictyp = 74
            endif
         elseif (ihb.eq.4) then
            ictyp = 73
            if (irng.eq.2) ictyp = 72
         endif
         if (io.eq.4) then
            ictyp = 79
         elseif (io.eq.3) then
            ictyp = 78
         elseif (io.eq.2) then
            ictyp = 77
         elseif (io.eq.1) then
            ictyp = 76
         endif
      elseif (ian.eq.99) then
         ictyp = 489
      else
         do i=1,mxmsf
            if (ltyp(i).eq.ian) ictyp = i
         end do
      endif
      
      return
      end

      integer function icred(iat,inoh,ih)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)

      icred = 0
      inoh = 0
      ih = 0
      do j=1,iconn(1,iat)
         jat = iconn(j+1,iat)
         if (jat.gt.0) then
            icred = icred + 1
            if (ianz(jat).eq.1) then
               ih = ih + 1
            else
               inoh = inoh + 1
            endif
         endif
      end do

      return
      end

      character*6 function mklab(ian,lab)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxel=100)
      character*2 elemnt,ggstr
      common /elem/elemnt(mxel)

      mklab = '      '
      mklab(1:2) = elemnt(ian)
      if (lab.gt.99) return
      if (mklab(2:2).eq.' ') then
          mklab(2:3) = ggstr(lab)
      else
          mklab(3:4) = ggstr(lab)
      endif

      return
      end

      subroutine wrtnk(iun)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxsym=103)
      parameter (mxhsym=64)
      parameter (mxchtp=136)
      parameter (mxamb=648)
      parameter (mxamo=201)
      parameter (mxel=100)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      common /hring/ lring(numat1)
      character*2 elemnt
      common /elem/elemnt(mxel)
      common /cllab/ iclon,iclpnt(4)
      integer*2 ityp,ipdbt
      common /types/ iff,ityp(numat1),ipdbt(numat1)
      character*3 pdbsym,hsym,chtnk,chtmp,ambtnk
      character*2 amotnk
      common /symbol/ pdbsym(mxsym),hsym(mxhsym),chtnk(mxchtp),
     &                ambtnk(mxamb),amotnk(mxamo)
      logical isqmmm
      integer*2 itypi,it10000
      dimension icnn(mxcon),t(3)
      it10000=10000

      if (iun.gt.100) then
         isqmmm = .true.
         iun = iun - 100
      else
         isqmmm = .false.
      endif

c write tinker .xyz file, charmm atom types are written

      toang = 0.52917706d0

      natoms = 0
      ioffmx = numat1
      ioffmn = 0
      do i=1,iatoms
         if (ianz(i).lt.100.and.ianz(i).gt.0) natoms = natoms + 1
         if (ianz(i).eq.100) then
             ioffmx = i
             if (ioffmn.eq.0) ioffmn = i
         endif
      end do
      ioffmn = ioffmx - ioffmn + 1

      do i=1,iatoms
         lring(i) = 0
         iaton(i) = 2
      end do


c tinker

      if (iff.eq.2) then
         write(iun,*) natoms,
     &   ' molden generated tinker .xyz (charmm param.)'
      elseif (iff.eq.3) then
         write(iun,*) natoms,
     &   ' molden generated tinker .xyz (amber param.)'
      elseif (iff.eq.4) then
         write(iun,*) natoms,
     &   ' molden generated tinker .xyz (amoeba param.)'
      else
         write(iun,*) natoms,
     &   ' molden generated tinker .xyz (mm3 param.)'
      endif

      do i=1,iatoms

         if (ianz(i).ne.100) then
            ibnds = 0
            do j=1,iconn(1,i)
               if (iconn(j+1,i).gt.0) then
                  ibnds = ibnds + 1
                  if (iconn(j+1,i).gt.ioffmx) then
                     icnn(ibnds) = iconn(j+1,i) - ioffmn
                  else
                     icnn(ibnds) = iconn(j+1,i)
                  endif
               endif
            end do

CNF 	QM atoms are at the H level, while MM atoms are at M and L levels               
            if (isqmmm. and. ityp(i).lt.10000) then
                itypi = ityp(i) + 20000
            else if(isqmmm) then
                itypi = ityp(i) - (ityp(i)/10000)*10000
            else
                itypi = mod(ityp(i),it10000)
            endif

            if (iff.ge.2.and.iff.le.4) then

               chtmp = elemnt(ianz(i))//' '
               if (iff.eq.2) then
                  if (ityp(i).gt.0.and.(mod(itypi,it10000)).le.mxchtp)
     &               chtmp = chtnk(mod(itypi,it10000))
               endif
               if (iff.eq.3) then
                  if (ityp(i).gt.0.and.(mod(itypi,it10000)).le.mxamb)
     &               chtmp = ambtnk(mod(itypi,it10000))
               endif
               if (iff.eq.4) then
                  if (ityp(i).gt.0.and.(mod(itypi,it10000)).le.mxamo)
     &               chtmp = amotnk(mod(itypi,it10000))
               endif
               write(iun,'(i6,2x,a3,1x,3(f12.6),1x,i6,1x,8i5)')
     &            i,chtmp,(coo(j,i)*toang,j=1,3),
     &            itypi,(icnn(j),j=1,ibnds)

            elseif (iff.eq.1) then

               write(iun,'(i5,1x,a2,1x,3(f12.6),1x,i6,1x,8i5)')
     &            i,elemnt(ianz(i)),(coo(j,i)*toang,j=1,3),
     &            itypi,(icnn(j),j=1,ibnds)
            else

               itypi = mmtyp(i,ianz(i),.false.)
               if (isqmmm. and. ityp(i).lt.10000) then
                  itypi = itypi + 20000
               elseif(isqmmm) then
                  itypi = itypi - (itypi/10000)*10000
               else
                  itypi = mod(itypi,it10000)
               endif
               write(iun,'(i5,1x,a2,1x,3(f12.6),1x,i6,1x,8i5)')
     &            i,elemnt(ianz(i)),(coo(j,i)*toang,j=1,3),
     &            itypi,(icnn(j),j=1,ibnds)

            endif


         endif

      end do

      do i=1,iatoms
         iaton(i) = 1
      end do

      return
      end

      subroutine wrogl(iun)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxel=100)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (ncmx=32)
      common /thephi/theta1,phi1,rroot,rincr,vdwr(mxel),vrad(mxel),
     &               scal,fscal,scali,smag,ipoints,ipnt,icol(mxel)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      common /hring/ lring(numat1)
      common /surf/ natorg,noscnd,isurf(numat1)
      character*2 elemnt
      common /elem/elemnt(mxel)
      integer xmol
      logical favail,oxyz,stpdb,doconv,dozme,gusirc
      common /getpnt/ irtype,ipdbon,ipdbgro,xmol,favail,oxyz,stpdb,
     &                doconv,dozme,gusirc
      logical fyesno,backb
      integer dolabs,fancy,shade,atcol,persp
      common /displ/ fancy,shade,atcol,dolabs,persp,irtcel,
     &               ifd,fyesno,backb,logo
      common /vropt/ ivtwo,ihand,ivadd
      parameter (numcal=2200)
      parameter (mxchai=50)
      parameter (mxheta=50)
      parameter (mxres=42)
      integer reson
      common /calf/ icalf(6,numcal),ncalf,ianf(mxchai),islu(mxchai),
     &              nchain,iamino(numcal),iamicl(mxres),ihet(mxheta),
     &              reson(numcal),issdon
      common /cllab/ iclon,iclpnt(4)
      logical doit,dsurf
      common /gracom/ uscl,colscd,colscpd,ivdwpl
      common /strips/ qnormo(3),crpnto(3,ncmx),crnrmo(3,ncmx),
     &                numcir,nquad
      common /vrcol/ jcol(3,16)
      common /rotmat/rx(3),ry(3),rz(3),tori(3), td(3)
      dimension icnn(mxcon),t(3),tmp1(3),tmp2(3),tmp3(3),tlpos(3)
      dimension rxyzt(3,3)

      ihand = 0

c write moldenogl .ogl file or ribbon povray file

      toang = 0.52917706d0

      do i=1,iatoms
         lring(i) = 0
      end do

      natoms = 0
      do i=1,iatoms

         doit = .false.
         if (ipdbon.eq.1) then
             if (iresid(i).gt.0) then
                if (reson(iresid(i)).eq.1) 
     &            doit = .true. 
             elseif (iresid(i).lt.-3) then
                  doit = .true. 
             endif
         else
             doit = .true. 
         endif

         if (ianz(i).lt.100.and.ianz(i).gt.0.and.iaton(i).gt.0
     &       .and.doit) then
             natoms = natoms + 1
             lring(i) = natoms
         endif

      end do


      if (ivtwo.eq.3) then

c ogl file

        if (atcol.eq.1) then
         if (ivdwpl.eq.1.and.fancy.eq.1) then
            if (numcir.gt.8) then
               write(iun,'(a)') 
     &           '[MOLECULE] UNSCALED SPACEFILL CONN HIGH'
            else
               write(iun,'(a)') '[MOLECULE] UNSCALED SPACEFILL CONN'
            endif
         else
            if (numcir.gt.8) then
               write(iun,'(a)') '[MOLECULE] UNSCALED CONN HIGH'
            else
               write(iun,'(a)') '[MOLECULE] UNSCALED CONN'
            endif
         endif
        else
         if (ivdwpl.eq.1.and.fancy.eq.1) then
            if (numcir.gt.8) then
               write(iun,'(a)') 
     &          '[MOLECULE] UNSCALED GRPCOL SPACEFILL CONN HIGH'
            else
               write(iun,'(a)') 
     &          '[MOLECULE] UNSCALED GRPCOL SPACEFILL CONN'
            endif
         else
            if (numcir.gt.8) then
               write(iun,'(a)') 
     &          '[MOLECULE] UNSCALED GRPCOL CONN HIGH'
            else
               write(iun,'(a)') '[MOLECULE] UNSCALED GRPCOL CONN'
            endif
         endif
        endif
        write(iun,*) natoms

      elseif (ivtwo.eq.2) then

        call cntvec(t,coo,ianz,iatoms)

c        sc1 = vlen(t)*1.4d0

        rzpmax = -10000.d0
        do i=1,iatoms
           if (rzp(i).gt.rzpmax) rzpmax = rzp(i)
        end do

        sc1 = rzpmax*1.8d0

c transpose rotation matrix

        do i=1,3
           rxyzt(1,i) = rx(i)
           rxyzt(2,i) = ry(i)
           rxyzt(3,i) = rz(i)
        end do

        g = rxyzt(1,2) 
        rxyzt(1,2) = rxyzt(2,1)
        rxyzt(2,1) = g

        g = rxyzt(1,3) 
        rxyzt(1,3) = rxyzt(3,1)
        rxyzt(3,1) = g

        g = rxyzt(2,3) 
        rxyzt(2,3) = rxyzt(3,2)
        rxyzt(3,2) = g


c position of the eye in tmp1

        tmp2(1) = 0.0d0
        tmp2(2) = 0.0d0
        tmp2(3) = sc1

        tmp1(1) = 
     &    tmp2(1)*rxyzt(1,1)+tmp2(2)*rxyzt(1,2)+tmp2(3)*rxyzt(1,3)
        tmp1(2) = 
     &    tmp2(1)*rxyzt(2,1)+tmp2(2)*rxyzt(2,2)+tmp2(3)*rxyzt(2,3)
        tmp1(3) = 
     &    tmp2(1)*rxyzt(3,1)+tmp2(2)*rxyzt(3,2)+tmp2(3)*rxyzt(3,3)


c eye looks at center tmp2

        tmp2(1) = 0.0d0
        tmp2(2) = 0.0d0
        tmp2(3) = 0.0d0
        
c position of the light in tlpos

        tmp3(1) = dsqrt(3.0d0)/3.0d0*sc1
        tmp3(2) = dsqrt(3.0d0)/3.0d0*sc1
        tmp3(3) = dsqrt(3.0d0)/3.0d0*sc1

        tlpos(1) = 
     &    tmp3(1)*rxyzt(1,1)+tmp3(2)*rxyzt(1,2)+tmp3(3)*rxyzt(1,3)
        tlpos(2) = 
     &    tmp3(1)*rxyzt(2,1)+tmp3(2)*rxyzt(2,2)+tmp3(3)*rxyzt(2,3)
        tlpos(3) = 
     &    tmp3(1)*rxyzt(3,1)+tmp3(2)*rxyzt(3,2)+tmp3(3)*rxyzt(3,3)


        call plcini
        call plphd(iun,ihand,tmp1,tmp2,tlpos)

      endif
      call cntvec(t,coo,ianz,iatoms)

c  the molecule

      ilin = 0
      do i=1,iatoms

         if (i.gt.natorg.and.natorg.ne.0) ilin = 1

         if (ianz(i).lt.100) then

           ibnds = 0
           do j=1,iconn(1,i)
              if (iconn(j+1,i).gt.0) then
                 if (iaton(iconn(j+1,i)).gt.0) then
                    if (lring(iconn(j+1,i)).gt.0) then
                       ibnds = ibnds + 1
                       icnn(ibnds) = lring(iconn(j+1,i))
                    endif
                 endif
              endif
           end do

           doit = .false.
           if (ipdbon.eq.1) then
               if (iresid(i).gt.0) then
                  if (reson(iresid(i)).eq.1) 
     &              doit = .true. 
               elseif (iresid(i).lt.-3) then
                    doit = .true. 
               endif
           else
               doit = .true. 
           endif

           if (iaton(i).gt.0.and.doit) then

             do j=1,3
                 tmp1(j) = (coo(j,i)-t(j))*toang
             end do

             ia = ianz(i)
             if (atcol.eq.1) then

              if (ivtwo.eq.3) then

               write(iun,'(i3,1x,3(f12.6),1x,i2,1x,8i5)')
     &         ianz(i),(tmp1(j),j=1,3),ibnds,
     &         (icnn(k),k=1,ibnds)

              elseif (ivtwo.eq.2) then

               ic = icol(ia)
               call plvsph(iun,jcol,ic,tmp1,vdwr(ia)/toang)

              endif

             else

              if (ivtwo.eq.3) then

               write(iun,'(i3,1x,i2,1x,3(f12.6),1x,i2,1x,8i5)')
     &         ianz(i),iatclr(i),(tmp1(j),j=1,3),
     &         ibnds,(icnn(k),k=1,ibnds)

              elseif (ivtwo.eq.2) then

               ic = iatclr(i)
               call plvsph(iun,jcol,ic,tmp1,vdwr(ia)/toang)

              endif
             endif

           endif


         endif

      end do

      if (ivtwo.eq.2) then
         write(iun,*) '}'
         write(iun,*) 'molecule'
      endif

c lines

      if (ilin.eq.1.and.ivtwo.eq.3) then
         write(iun,'(a)') '[LINES]'
         do i=1,iatoms
            if (i.gt.natorg.and.natorg.ne.0) then
               do j=1,iconn(1,i)
                  jj = abs(iconn(j+1,i))
                  if (jj.lt.i) then
                    write(iun,'(i2,1x,3(f12.6),1x,3(f12.6))')
     &              iatclr(i),((coo(k,i)-t(k))*toang,k=1,3),
     &              ((coo(k,jj)-t(k))*toang,k=1,3)
                  endif
               end do
            endif
         end do
      endif

c ribbons

100   if (ipdbon.eq.1) then

         if (ivtwo.eq.3) then

          write(iun,'(a)') '[COL STRANDTOP] 1.0 0.0 1.0'
          write(iun,'(a)') '[COL STRANDBOTTOM] 1.0 0.0 1.0'
          write(iun,'(a)') '[COL HELIXOUT] 0.0 1.0 0.0'
          write(iun,'(a)') '[COL HELIXIN] 0.6 0.6 0.6'
          write(iun,'(a)') '[COL RNA] 0.5 1.0 0.5'
          write(iun,'(a)') '[COL COIL] 1.0 1.0 1.0'

          call ribbon(0,1,1,iun,t)
          call ribbon(0,1,2,iun,t)
          call ribbon(0,1,3,iun,t)
          call ribbon(0,1,4,iun,t)
          call ribbon(1,1,1,iun,t)
          call ribbon(1,1,2,iun,t)
          call ribbon(1,1,3,iun,t)
          call ribbon(1,1,4,iun,t)
          call ribbon(3,1,1,iun,t)
          call ribbon(2,1,1,iun,t)

         elseif (ivtwo.eq.2) then

          write(iun,*) '#declare STRANDTOP = texture {'
          write(iun,*) 'pigment { color rgb<0.0, 0.0, 1.0> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          write(iun,*) '#declare STRANDBOTTOM = texture {'
          write(iun,*) 'pigment { color rgb<1.0, 0.0, 1.0> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          write(iun,*) '#declare HELIXOUT = texture {'
          write(iun,*) 'pigment { color rgb<0.0, 1.0, 0.0> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          write(iun,*) '#declare HELIXIN = texture {'
          write(iun,*) 'pigment { color rgb<0.6, 0.6, 0.6> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          write(iun,*) '#declare RNA = texture {'
          write(iun,*) 'pigment { color rgb<0.5, 1.0, 0.5> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          write(iun,*) '#declare COIL = texture {'
          write(iun,*) 'pigment { color rgb<1.0, 1.0, 1.0> }'
          write(iun,*)
     &       'finish { ambient 0.4 diffuse 0.4 specular 0.9}'
          write(iun,*) '}'

          call ribbon(0,2,1,iun,t)
          call ribbon(0,2,2,iun,t)
          call ribbon(0,2,3,iun,t)
          call ribbon(0,2,4,iun,t)
          call ribbon(1,2,1,iun,t)
          call ribbon(1,2,2,iun,t)
          call ribbon(1,2,3,iun,t)
          call ribbon(1,2,4,iun,t)
          call ribbon(3,2,1,iun,t)
          call ribbon(2,2,1,iun,t)

         endif

      endif

      ihand = 1

      do i=1,iatoms
         lring(i) = 0
      end do

      return
      end

      integer function mmtyp(iat,ian,dochg)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxt=14)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      character*4 atype
      common /atypes/ ihbt(mxt),atype(mxt)
      logical dochg,smrng
      integer*2 ictyp
      dimension icnn(mxcon),iring(4)

      isp = ispn(iat,irng,dochg,.false.)
      ihb = ihbt(isp)
      ict = ictyp(iat,ian,dochg)

      ibnds = 0
      ih0 = 0
      ic0 = 0
      in0 = 0
      io0 = 0
      ip0 = 0
      is0 = 0
      ili = 0
      do i=1,iconn(1,iat)
         if (iconn(i+1,iat).gt.0) then
            ibnds = ibnds + 1
            icnn(ibnds) = iconn(i+1,iat)
            ian0 = ianz(iconn(i+1,iat))
            if (ian0.eq.1) then
               ih0 = ih0 + 1
            elseif (ian0.eq.3) then
               ili = ili + 1
            elseif (ian0.eq.6) then
               ic0 = ic0 + 1
            elseif (ian0.eq.7) then
               in0 = in0 + 1
            elseif (ian0.eq.8) then
               io0 = io0 + 1
            elseif (ian0.eq.15) then
               ip0 = ip0 + 1
            elseif (ian0.eq.16) then
               is0 = is0 + 1
            endif
         endif
      end do

      mmtyp = 0

      if (ian.eq.1) then
         mmtyp = 5
         if (ibnds.eq.1) then
            ian1 = ianz(icnn(1))
            if (ian1.eq.6) then
               mmtyp = 5
CNF Add the case of acetylene -> mmtyp = 124
               if (icred(icnn(1),idum1,idum2).eq.2) mmtyp = 124
            elseif (ian1.eq.7) then
               mmtyp = 23
               if (icred(icnn(1),idum1,idum2).eq.4) mmtyp = 48
               if (ispn(icnn(1),irng,dochg,.false.).eq.8) mmtyp = 28
            elseif (ian1.eq.8) then
CNF Add the case of phenol/enol -> mmtyp = 73
               mmtyp = 21
               if (icred(icnn(1),idum1,idum2).eq.2) then
                  do i=1,iconn(1,icnn(1))
                     l = abs(iconn(i+1,icnn(1)))
                     if (ianz(l).eq.6) then
                        if (icred(l,idum1,idum2).eq.3) then
                           io = 0
                           ic = 0
                           do j=1,iconn(1,l)
                              k = abs(iconn(j+1,l))
                              if (ianz(k).eq.8) io = io + 1
                              if (ianz(k).eq.6) ic = ic + 1
                           end do
                           if (io.eq.2) mmtyp = 24
                           if (ictyp(l,ianz(l),dochg).eq.16) mmtyp = 24
                           if (ic.ge.1) mmtyp = 73
                        endif
                     endif
                  end do
               endif
            elseif (ian1.eq.16) then
               mmtyp = 44
            endif
         endif
      elseif (ian.eq.6) then
         mmtyp = 1
         if (ihb.eq.1) then
            mmtyp = 4
         elseif(ihb.eq.2.or.ihb.eq.4) then
            mmtyp = 2
            do i=1,ibnds
               if (ianz(icnn(i)).eq.8) then
                  if (icred(icnn(i),idum1,idum2).eq.1) mmtyp = 3
               endif
            end do
            if (smrng(iat,iring,nring)) then
               if (nring.eq.3) mmtyp = 38
               if (nring.eq.4) mmtyp = 57
            endif
         elseif(ihb.eq.3) then
            mmtyp = 1
            if (smrng(iat,iring,nring)) then
               if (nring.eq.3) mmtyp = 22
               if (nring.eq.4) mmtyp = 56
            endif
         endif
      elseif (ian.eq.7) then
         mmtyp = 8
         if (ihb.eq.1) then
            mmtyp = 10
         elseif(ihb.eq.2.or.ihb.eq.4) then
            mmtyp = 37
            if (isp.eq.8) mmtyp = 9
         elseif(ihb.eq.3) then
            mmtyp = 8
            if (isp.eq.5) mmtyp = 39
            if (isp.eq.8) mmtyp = 9
            if (ict.eq.34) mmtyp = 40
            if (ict.eq.38) mmtyp = 46
            if (ili.gt.0) mmtyp = 164
         endif
      elseif (ian.eq.8) then
         mmtyp = 6
         if (ihb.eq.2) then
            mmtyp = 7
            if (ibnds.eq.1.and.ic0.eq.1) then
               do i=1,iconn(1,icnn(1))
                  iat2 = iconn(i+1,icnn(1))
                  if (ianz(iat2).eq.8.and.iat2.ne.iat) then
                     icc = 0
                     do j=1,iconn(1,iat2)
                       iat3 = iconn(j+1,iat2)
                       if (iat3.gt.0) then
                          if (ianz(iat3).eq.6) icc = icc + 1
                       endif
                     end do
                     if (icc.eq.1) mmtyp = 77
                     if (icc.eq.2) mmtyp = 78
                  endif
               end do
            endif
            if (ict.eq.52) mmtyp = 41
            if (isp.eq.10.and.ianz(icnn(1)).eq.6) mmtyp = 47
         elseif(ihb.eq.3) then
            mmtyp = 6
            if (ic0.ge.1) then
               do i=1,ibnds
                  if (ianz(icnn(i)).eq.6.and.icnn(i).ne.iat) then
                     do j=1,iconn(1,icnn(i))
                        jj = iconn(1+j,icnn(i))
                        if (ianz(iabs(jj)).eq.8.and.iabs(jj).ne.iat)
     &                  then
                          if (icred(icnn(i),idum1,idum2).eq.3) 
     &                       mmtyp = 75 
                        endif
                     end do
                  endif
               end do
            endif
            if (ict.eq.52) mmtyp = 41
            if (smrng(iat,iring,nring)) then
               if (nring.eq.3) mmtyp = 49
            endif
         endif
      elseif (ian.eq.15) then
         mmtyp = 60
         if (ibnds.eq.3) mmtyp = 25
      elseif (ian.eq.16) then
         mmtyp = 15
         if (isp.eq.13) mmtyp = 17
         if (isp.eq.14) mmtyp = 18
         if (ict.eq.72.or.ibnds.eq.1) mmtyp = 42
         if (ibnds.eq.2.and.is0.eq.1) mmtyp = 104
      else
         if (ian.eq.2) mmtyp = 51
         if (ian.eq.3) mmtyp = 163
         if (ian.eq.5) then
            mmtyp = 27
            if (ibnds.eq.3) mmtyp = 26
         endif
         if (ian.eq.9)  mmtyp = 11
         if (ian.eq.10) mmtyp = 52
         if (ian.eq.12) mmtyp = 59
         if (ian.eq.14) mmtyp = 19
         if (ian.eq.17) mmtyp = 12
         if (ian.eq.18) mmtyp = 53
         if (ian.eq.20) mmtyp = 125
         if (ian.eq.26) mmtyp = 61
         if (ian.eq.27) mmtyp = 65
         if (ian.eq.28) mmtyp = 63
         if (ian.eq.32) mmtyp = 31
         if (ian.eq.34) mmtyp = 34
         if (ian.eq.35) mmtyp = 13
         if (ian.eq.36) mmtyp = 54
         if (ian.eq.38) mmtyp = 126
         if (ian.eq.50) mmtyp = 32
         if (ian.eq.52) mmtyp = 35
         if (ian.eq.53) mmtyp = 14
         if (ian.eq.54) mmtyp = 55
         if (ian.ge.56.and.ian.le.71) mmtyp = ian + 71
         if (ian.eq.82) mmtyp = 33
      endif

      if (mmtyp.eq.0) print*,'no mm3 type for this atom'

      return
      end

      logical function smrng(i,iring,nring)
      implicit double precision (a-h,o-z)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)

      dimension iring(4)
      logical ocnos

c finds 3,4 membered rings

      smrng = .false.

      if (ocnos(i)) then
         do j=1,iconn(1,i)
            jj = abs(iconn(j+1,i))
            if (ocnos(jj)) then
               do k=1,iconn(1,jj)
                  kk = abs(iconn(k+1,jj))
                  if (ocnos(kk).and.kk.ne.i) then
                     do l=1,iconn(1,kk)
                        ll = abs(iconn(l+1,kk))
                        if (ocnos(ll).and.ll.ne.jj) then
                           if (ll.eq.i) then
                              nring = 3
                              iring(1) = i
                              iring(2) = jj
                              iring(3) = kk
                              smrng = .true.
                              return
                           else
                              do m=1,iconn(1,ll)
                                 mm = abs(iconn(m+1,ll))
                                 if (ocnos(mm).and.mm.ne.kk) then
                                    if (mm.eq.i) then
                                       nring = 4
                                       iring(1) = i
                                       iring(2) = jj
                                       iring(3) = kk
                                       iring(4) = ll
                                       smrng = .true.
                                       return
                                    endif
                                 endif
                              end do
                           endif
                        endif
                     end do
                  endif
               end do
            endif
         end do
      endif

      return
      end

      logical function gettnk(debug,ipdbon,iffset)
      implicit double precision (a-h,o-z), integer ( i-n)
      integer getlin
      character*137 str
      character*2 catom, catomt, tolowf,iel
      parameter (numatm=2000)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (maxsym=108)
      parameter (numcal=2200)
      parameter (mxchai=50)
      parameter (mxheta=50)
      parameter (mxres=42)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      integer*2 ityp,ipdbt
      common /types/ iff,ityp(numat1),ipdbt(numat1)
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      common /zmfrst/ ihaszm, nz, mxzat
      integer reson
      common /calf/ icalf(6,numcal),ncalf,ianf(mxchai),islu(mxchai),
     &              nchain,iamino(numcal),iamicl(mxres),ihet(mxheta),
     &              reson(numcal),issdon
      common /rdwr/  iun1,iun2,iun3,iun4,iun5
      character*137 line
      common /curlin/ line
      logical debug,first
      dimension iel(maxsym)
      data iel/'bq',
     &         'h ', 'he',
     &         'li', 'be', 'b ', 'c ', 'n ', 'o ', 'f ', 'ne',
     &         'na', 'mg', 'al', 'si', 'p ', 's ', 'cl', 'ar',
     &         'k ', 'ca',
     &                     'sc', 'ti', 'v ', 'cr', 'mn',
     &                     'fe', 'co', 'ni', 'cu', 'zn',
     &                     'ga', 'ge', 'as', 'se', 'br', 'kr',
     & 'rb','sr','y ','zr','nb','mo','tc','ru','rh','pd','ag','cd',
     & 'in','sn','sb','te','i ','xe','cs','ba','la','ce','pr','nd',
     & 'pm','sm','eu','gd','tb','dy','ho','er','tm','yb','lu','hf',
     & 'ta','w ','re','os','ir','pt','au','hg','tl','pb','bi','po',
     & 'at','rn','fr','ra','ac','th','pa','u ','np','pu','am','cm',
     & 'bk','cf','x ','oo','oa','ob','oc','ab','bc','ac','zz'/

      gettnk = .true.
      first = .true.
      ifndhn = 0

      if (debug) print*,'subroutine gettnk'

c get number of atoms

10    continue

      if (getlin(0).eq.1) then
         ktype = nxtwrd(str,nstr,itype,rtype)
         if (ktype.eq.2) then
            iatoms = itype
         else
            goto 100
         endif
      else
         goto 100
      endif

110   continue

      do iat=1,iatoms
         if (getlin(0).eq.1) then
           ktype = nxtwrd(str,nstr,itype,rtype)
           if (ktype.ne.2) goto 100
           ktype = nxtwrd(str,nstr,itype,rtype)
           if (ktype.eq.1) then
                 if (nstr.eq.1) then
                    catomt(1:1) = str(1:1)
                    catomt(2:2) = ' '
                 else
                    catomt = str(1:2)
                    if (catomt(2:2).eq.'+'.or.catomt(2:2).eq.'-'
     &                 .or.catomt(2:2).eq.'*') catomt(2:2) = ' '
                 endif
                 catom = tolowf(catomt)
                 iatmp = 0
                 if (first.and.iffset.le.1) then
                    do j=1,maxsym
                       if (catom .eq. iel(j)) iatmp = j - 1
                    end do
                    if (catom.eq.'xx') iatmp = 99
                    if (catom.eq.'lp') iatmp = 99
                 else
                    if (nstr.eq.3) then
                        if (str(1:3).eq.'SOD') iatmp = 11
                        if (str(1:3).eq.'CAL') iatmp = 20
                    elseif (nstr.eq.2) then
                        if (str(1:2).eq.'MG') iatmp = 12
                        if (str(1:2).eq.'FE') iatmp = 26
                        if (str(1:2).eq.'ZN') iatmp = 30
                        if (str(1:2).eq.'H1'.or.str(1:2).eq.'h1') 
     &                     ifndhn = 1
                        if (str(1:2).eq.'HN'.or.str(1:2).eq.'hn')
     &                     ifndhn = 2
                    endif
                    if (iatmp.eq.0) then
                        if (catom(1:1).eq.'h') iatmp = 1
                        if (catom(1:1).eq.'c') iatmp = 6
                        if (catom(1:1).eq.'n') iatmp = 7
                        if (catom(1:1).eq.'o') iatmp = 8
                        if (catom(1:1).eq.'f') iatmp = 9
                        if (catom(1:1).eq.'p') iatmp = 15
                        if (catom(1:1).eq.'s') iatmp = 16
                        if (catom(1:2).eq.'cl') iatmp = 17
                        if (catom(1:2).eq.'br') iatmp = 35
                        if (catom(1:1).eq.'i') iatmp = 53
                    endif
                 endif
                 if (iatmp.le.0.or.iatmp.gt.maxsym-1) goto 100
                 ianz(iat) = iatmp
           else
              goto 100
           endif
           do i=1,3
              ktype = nxtwrd(str,nstr,itype,rtype)
              if (ktype.eq.3) then
                 coo(i,iat) = rtype
              else
                 goto 100
              endif
           end do
           ktype = nxtwrd(str,nstr,itype,rtype)
           if (ktype.eq.2) then
              ityp(iat) = itype
           else
              goto 100
           endif
           nc = 0
           do i=1,mxcon
              ktype = nxtwrd(str,nstr,itype,rtype)
              if (ktype.eq.2) then
                 iconn(i+1,iat) = itype
                 nc = nc + 1
              endif
           end do
           iconn(1,iat) = nc
        else
          goto 100
        endif
      end do

      call xyzcoo(.false.,.true.,.false.)
      call cooxyz(ianz,iatoms)

      ihaszm = 0
      issdon = 0

      if (iffset.eq.0) then
         if (first) then
            iff = 1
         else
            ipdbon = 1
            if (ifndhn.eq.1) then
               iff = 3
            elseif (ifndhn.eq.2) then
               iff = 4
            else
               iff = 2
            endif
         endif
      endif

      return

100   if (first.and.iffset.eq.0) then
         rewind iun2
         first = .false.
         ifndhn = 0
         goto 10
      else
         if (debug) print*,'ERROR:',line
      endif
      gettnk = .false.
      return
      end

      subroutine dotyp(icel)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)

      parameter (mxel=100)
      parameter (numatm=2000)
      parameter (numat1=50000)
      parameter (mxcon=8)
      parameter (mxt=14)
      parameter (mxppmf=16)
      parameter (mxlpmf=26)
      parameter (mxmol2=41)
      parameter (mxmm3=164)
      parameter (mxchtp=136)
      parameter (mxmsf=235)
      parameter (mxamb=648)
      parameter (mxamo=201)
      parameter (numcal=2200)
      parameter (mxchai=50)
      parameter (mxheta=50)
      parameter (mxres=42)
      parameter (mxsym=103)
      parameter (mxhsym=64)

      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      integer reson
      common /calf/ icalf(6,numcal),ncalf,ianf(mxchai),islu(mxchai),
     &              nchain,iamino(numcal),iamicl(mxres),ihet(mxheta),
     &              reson(numcal),issdon
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon
      integer*2 ityp,ipdbt
      common /types/ iff,ityp(numat1),ipdbt(numat1)
      character*2 ppmf, lpmf
      character*5 mol2
      character*19 mm3
      character*20 chmtnk
      character*20 ambstr
      character*20 amostr
      character*4 chmsf
      common /ftypes/ihasl(11),mol2(mxmol2),mm3(mxmm3),chmtnk(mxchtp),
     &               chmsf(mxmsf),ambstr(mxamb),amostr(mxamo),
     &               ppmf(mxppmf),lpmf(mxlpmf)
      character*6 atmp
      character*4 atype
      common /atypes/ ihbt(mxt),atype(mxt)
      common /hring/ lring(numat1)
      character*2 elemnt,atom
      common /elem/elemnt(mxel)
      common /cell/ nat,norg,icent,inorm,ico(3,8),icn(4,8),icol(32),ncon
      common /celpar/xa,ya,yb,za,zb,zc,a,b,c,alpha,beta,gamma,nspg,kz
      integer dolabs,fancy,persp,shade,atcol
      logical fyesno,backb
      common /displ/ fancy,shade,atcol,dolabs,persp,irtcel,
     &               ifd,fyesno,backb,logo
      common /zmatst/lwrit(numat1),nwrit,nvar,isimpl
      common /typoni/ ioniad
      integer*2 ictyp
      logical dochg,ochg
      dimension rr(3,3),tr1(3)
      dimension ipdb(mxsym),ihpdb(mxhsym*3)

      natoms = iatoms

      if (icel.eq.1) then

         dochg = ochg(idum)
         natoms = nat
         nstor = numat1-natoms
         do i=1,natoms
            do j=1,3
               coo(j,i) = coo(j,nstor+i)
            end do
            ianz(i) = ianz(nstor+i)
            do j=1,iconn(1,nstor+i)+1
               iconn(j,i) = iconn(j,nstor+i)
            end do
            iatclr(i) = iatclr(nstor+i)
         end do

      else
         if (ihasq.eq.1) dochg = .true.
      endif

      do i=1,natoms
         lwrit(i) = 0
         lring(i) = 0
         iaton(i) = 2
         if (ioniad.eq.0) ityp(i) = 0
      end do

      if (icel.eq.1) then

         call setrr(alpha,beta,gamma,a,b,c,rr)
  
         do i=1,nat
            do k=1,3
               tr1(k) = trc(coo(1,i),rr,k)
            end do
            do k=1,3
               coo(k,i) = tr1(k)
            end do
         end do

      endif

      if (iff.eq.2) then
c Tinker Charmm
         do i=1,ncalf
             call getpdb(i,ipdb,ihpdb)
             call typeit(ipdb,iamino(i),ihpdb,.true.)
         end do
      elseif (iff.eq.3) then
c Tinker Amber
         do i=1,ncalf
             call getpdb(i,ipdb,ihpdb)
             call typamb(ipdb,iamino(i),ihpdb,.true.)
         end do
      elseif (iff.eq.4) then
c Tinker Amoeba
         do i=1,ncalf
             call getpdb(i,ipdb,ihpdb)
             call typamo(ipdb,iamino(i),ihpdb,.true.)
         end do
      else
         do i=1,natoms
            ityp(i) = 0
            if (iff.eq.1) then
c Tinker MM3
                ityp(i) = mmtyp(i,ianz(i),.false.)
            elseif (iff.eq.5) then
c Sybyl Mol2
                ityp(i) = 1
                atom = elemnt(ianz(i))
                atmp = atom//atype(ispn(i,irng,dochg,.false.))
                if (atmp(1:1).eq.' ') atmp(1:5) = atmp(2:6)
                do j=1,mxmol2
                   if (atmp(1:5).eq.mol2(j)) ityp(i) = j
                end do
            elseif (iff.eq.6) then
c Quanta Charmm
                ityp(i) = ictyp(i,ianz(i),dochg)
            elseif (iff.eq.7) then
c PMF scoring
c                ityp(i) = ipmtyp(i,ianz(i),dochg)
            endif
         end do

      endif

      if (icel.eq.1) call fdat(ifd,0,0,.false.,0,0)

      do i=1,iatoms
         iaton(i) = 1
      end do

      return
      end

      subroutine fixchg(ich)
      implicit double precision (a-h,p-z),integer (i-n),logical (o)
      parameter (mxel=100)
      parameter (numat1=50000)
      parameter (mxcon=8)
      common /atcom/ coo(3,numat1),rzp(numat1),iatoms,ianz(numat1),
     &               iaton(numat1),iatclr(numat1),iresid(numat1),
     &               ixp(numat1),iyp(numat1),iconn(mxcon+1,numat1)
      common /charge/qat(numat1),dipo(3),ihasq,ihsdp,iqon

      addup = dble(ich)

      totch = 0.0d0
      do i=1,iatoms
          totch = totch + qat(i)
      end do 

      totch = totch - addup
      if (dabs(totch).gt.1.0d-7) then
           totch = totch/dble(iatoms)
           do i=1,iatoms
               qat(i) = qat(i) - totch
           end do
      endif

      return
      end
