
/* Copyright (c) 1995, 1997, 1999, 2000, 2001 by Arkkra Enterprises */
/* All rights reserved */

/* various functions for printing error messages and exiting when
 * things go wrong */

#include "globals.h"
#include "rational.h"

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef Mac_BBEdit
#include <BBEdit_Streams.h>
#endif

extern void exit P((int status));

	int debug_on P((int level));

#ifdef __STDC__
	extern void abort P((void));
#else
	extern int abort();
#endif


/* print a message for a user error and exit with the value of Errorcount,
 * or of 254 if > 254 */

/*VARARGS1*/
#ifdef __STDC__

void
ufatal(char *format, ...)

#else

void
ufatal(format, va_alist)

char *format;	/* printf style format */
va_dcl

#endif

{
	va_list args;

	/* we now have one more error */
	Errorcount++;

	/* print the specified message with a newline */
#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

#ifndef UNIX_LIKE_FILES
	mac_cleanup();
#endif

	(void) vfprintf(stderr, format, args);
	va_end(args);
	(void) fprintf(stderr, "\n");

	exit(Errorcount > 254 ? 254 : Errorcount);
}

/* print a message with filename and linenumber for a user error,
 *  and exit with the value of Errorcount, or of 254 if > 254 */

/*VARARGS3*/
#ifdef __STDC__

void
l_ufatal(char *filename, int lineno, char *format, ...)

#else

void
l_ufatal(filename, lineno, format, va_alist)

char *filename;
int lineno;
char *format;	/* printf style format */
va_dcl

#endif

{
	va_list args;

	/* we now have one more error */
	Errorcount++;

	/* print the specified message with a newline */
#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

#ifndef UNIX_LIKE_FILES
	mac_cleanup();
#endif

	if (filename != (char *) 0 && lineno > 0) {
		(void) fprintf(stderr, "%s: line %d: ", filename, lineno);
	}

	(void) vfprintf(stderr, format, args);
	va_end(args);
	(void) fprintf(stderr, "\n");

#ifdef Mac_BBEdit
	AppendError(filename, lineno);
#endif

	exit(Errorcount > 254 ? 254 : Errorcount);
}


/* print a message for a program internal error and exit with 255 */


/*VARARGS1*/

#ifdef __STDC__

void
pfatal(char *format, ...)

#else

void
pfatal(format, va_alist)

char *format;
va_dcl

#endif

{
	va_list args;

#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

#ifndef UNIX_LIKE_FILES
	mac_cleanup();
#endif

	/* print specified message with newline */
	(void) fprintf(stderr, "internal error: ");
	(void) vfprintf(stderr, format, args);
	va_end(args);
	(void) fprintf(stderr, "\n");

#ifdef CORE_MESSAGE
	(void) fprintf(stderr, "creating a core dump\n");
#endif
	abort();

	exit(255);
}


/* fatal error with line number and file name. Note that this should be the
 * line number and file in the program, not the input file, ie, __LINE__
 * and __FILE__. */

/*VARARGS3*/

#ifdef __STDC__

void
l_pfatal(char *filename, int lineno, char *format, ...)

#else

void
l_pfatal(filename, lineno, format, va_alist)

char *filename;		/* name of program file */
int lineno;		/* pgm line where error was discovered */
char *format;		/* printf format */
va_dcl

#endif

{
	va_list args;

#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

	(void) fprintf(stderr,"%s: line %d: ", filename, lineno);
	pfatal(format, args);
	va_end(args);
}


/* error exit for the common problem of malloc failures */

void
l_no_mem(filename, lineno)

char *filename;
int lineno;

{
	l_pfatal(filename, lineno, "memory allocation failed");
}


/* error exit for common error of not being able to open a specified file */

void
cant_open(filename)

char *filename;

{
	ufatal("can't open '%s'", filename);
}


/* print a warning message */

/*VARARGS1*/

#ifdef __STDC__

void
warning(char *format, ...)

#else

void
warning(format, va_alist)

char *format;
va_dcl

#endif

{
	va_list args;

	if (Score.warn == NO) {
		return;
	}
#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

	(void) fprintf(stderr, "warning: ");
	(void) vfprintf(stderr, format, args);
	(void) fprintf(stderr, "\n");
	va_end(args);

#ifdef Mac_BBEdit
	AppendWarning((char *) 0, -1);
#endif
}


/* warning message with file name and line number */

/*VARARGS3*/

#ifdef __STDC__

void
l_warning(char * filename, int lineno, char *format, ...)

#else

void
l_warning(filename, lineno, format, va_alist)

char *filename;	/* name of program file */
int lineno;		/* pgm line where error was discovered */
char *format;		/* printf format */
va_dcl

#endif

{
	va_list args;

	if (Score.warn == NO) {
		return;
	}
#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

	(void) fprintf(stderr, "warning: ");
	if (filename != (char *) 0 && lineno > 0) {
		(void) fprintf(stderr,"%s: line %d: ", filename, lineno);
	}
	(void) vfprintf(stderr, format, args);
	(void) fprintf(stderr, "\n");
	va_end(args);

#ifdef Mac_BBEdit
	AppendWarning(filename, lineno);
#endif
}


/* varargs version of yyerror, passing a file and linenumber (or -1 for the
 * lineno if you don't want a filename and linenumber printed) */

/*VARARGS3*/

#ifdef __STDC__

void
l_yyerror(char *fname, int lineno, char *format, ...)

#else

void
l_yyerror(fname, lineno, format, va_alist)

char *fname;
int lineno;
char *format;
va_dcl

#endif

{
	va_list args;


	/* if linenumber is zero or negative, assume this is special case of
	 * not being associated with a specific line, so don't print
	 * a line number */
	if (lineno > 0) {
		/* There are cases where the parser has already looked ahead
		 * to find the newline in order to fully match a grammar
		 * rule. When that happens, the line number will already have
		 * been incremented and our message would be off by one.
 		 * So catch that case and compensate. */
		if ( (lineno == yylineno) && (fname == Curr_filename) &&
							(*yytext == '\n') ) {
			lineno--;
		}
		(void) fprintf(stderr, "%s: ", fname);
		(void) fprintf(stderr, "line %d: ", lineno);
	}

#ifdef __STDC__
	va_start(args, format);
#else
	va_start(args);
#endif

	(void) vfprintf(stderr, format, args);
	va_end(args);
	(void) fprintf(stderr, "\n");

	/* if doing macro expansion, also tell where macro was defined */
	mac_error();

#ifdef Mac_BBEdit
	AppendError(fname, lineno);
#endif

	Errorcount++;
}




/* print a debugging message if corresponding debugging bit is on */

/*VARARGS2*/

#ifdef __STDC__

void
debug(int level, char *format, ...)

#else

void
debug(level, format, va_alist)

int level;		/* debugging flag bitmap */
char *format;		/* printf style format */
va_dcl

#endif

{
	va_list args;

	if (debug_on(level)) {
#ifdef __STDC__
		va_start(args, format);
#else
		va_start(args);
#endif
		(void) vfprintf(stderr, format, args);
		va_end(args);
		(void) fprintf(stderr, "\n");
	}
}


/* return AND of Debuglevel and argument. Useful for other debug functions
 * that want to see if a given debug level is currently turned on */

int
debug_on(level)

int level;

{
	return(Debuglevel & level);
}

/* if we get an error while doing rational arithmetic, we are in deep
 * trouble, so print message and get out. */

void
doraterr(code)

int code;

{
	switch (code) {

	case RATOVER:
		pfatal("rational overflow");
		/*NOTREACHED*/
		break;

	case RATDIV0:
		pfatal("rational division by zero");
		/*NOTREACHED*/
		break;

	case RATPARM:
		pfatal("invalid rational number parameter");
		/*NOTREACHED*/
		break;

	default:
		pfatal("error in rational arithmetic routines");
		/*NOTREACHED*/
		break;
	}
}
