/* Copyright (c) 2001, 2003, 2004 by Arkkra Enterprises */
/* All rights reserved */

#ifndef _SSVUSED_H
#define _SSVUSED_H

/*
 * This file contains the array subscript definitions for the used[] array
 * of an SSV struct. An SSV contains parameters associated with a
 * Score, Staff, or Voice.  The used[] array is a set of flags which say
 * whether a given parameter is actually populated in the SSV instance.
 * In the "score" SSV, all used flags are always set true.  In SSVs for
 * a staff or voice, a "used" flag is only set to true if the user
 * specified a value for the parameter in that staff or voice context.
 *
 * The actual values are machine-generated so they get automatically
 * renumbered if parameters are added or deleted or rearranged.
 *
 * We try to put things that are logically similar close together in
 * this list, but they could be in any order, other than that NUMFLDS
 * _must_ be last.
 */

#define	SCALE_FACTOR		(0)
#define	UNITS			(1)
#define	PAGEHEIGHT		(2)
#define	PAGEWIDTH		(3)
#define	PANELSPERPAGE		(4)
#define	TOPMARGIN		(5)
#define	BOTMARGIN		(6)
#define	LEFTMARGIN		(7)
#define	RIGHTMARGIN		(8)
#define	RESTCOMBINE		(9)
#define	FIRSTPAGE		(10)
#define	NUMSTAFF		(11)
#define	MINSCSEP		(12)
#define	MAXSCSEP		(13)
#define	SCOREPAD		(14)
#define	BRACELIST		(15)
#define	BRACKLIST		(16)
#define	BARSTLIST		(17)
#define	TIME			(18)
#define	DIVISION		(19)
#define	ENDINGSTYLE		(20)
#define	GRIDSATEND		(21)
#define	MEASNUM			(22)
#define	MEASNUMFAMILY		(23)
#define	MEASNUMFONT		(24)
#define	MEASNUMSIZE		(25)
#define	PACKFACT		(26)
#define	PACKEXP			(27)
#define	WARN			(28)
#define	STAFFSCALE		(29)
#define	VISIBLE			(30)
#define	STAFFLINES		(31)
#define	GRIDSWHEREUSED		(32)
#define	GRIDSCALE		(33)
#define	GRIDFRET		(34)
#define	NUMBERMRPT		(35)
#define	PRINTMULTNUM		(36)
#define	RESTSYMMULT		(37)
#define	VSCHEME			(38)
#define	SHARPS			(39)
#define	CANCELKEY		(40)
#define	TRANSPOSITION		(41)
#define	ADDTRANSPOSITION	(42)
#define	CLEF			(43)
#define	REHSTYLE		(44)
#define	FONTFAMILY		(45)
#define	FONT			(46)
#define	SIZE			(47)
#define	LYRICSFAMILY		(48)
#define	LYRICSFONT		(49)
#define	LYRICSSIZE		(50)
#define	LYRICSALIGN		(51)
#define	SYLPOSITION		(52)
#define	MINSTSEP		(53)
#define	STAFFPAD		(54)
#define	ABOVEORDER		(55)
#define	BELOWORDER		(56)
#define	BETWEENORDER		(57)
#define	PEDSTYLE		(58)
#define	CHORDDIST		(59)
#define	DIST			(60)
#define	DYNDIST			(61)
#define	LABEL			(62)
#define	LABEL2			(63)
#define	BEAMSTLIST		(64)
#define	BEAMSLOPE		(65)
#define	PAD			(66)
#define	STEMLEN			(67)
#define	STEMSHORTEN		(68)
#define	DEFOCT			(69)
#define	TIMEUNIT		(70)
#define	SWINGUNIT		(71)
#define	RELEASE			(72)
#define	ONTHELINE		(73)
#define	TABWHITEBOX		(74)
#define	NOTEHEADS		(75)
#define	NUMFLDS			(76)

#endif
