/* Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004 by Arkkra Enterprises */
/* All rights reserved */
/*
 *	defines.h
 *
 *	This file defines the constants needed for the music publication
 *	program.
 */

#include <math.h>
#ifndef _DEFINES
#define _DEFINES
#include "muschar.h"

/*
 * Define the environment =============================================
 */

/* for all forms of DOS we've tried, make sure __DOS__ is defined */
#if defined(__TURBOC__) || defined(__WATCOMC__) || defined(__MINGW32__)
#ifndef __DOS__
#define __DOS__
#endif
#endif

/* if you are short on memory or know you'll never use the extended character
 * set (with accented characters, etc) you can undefine EXTCHAR
 */
#ifndef __TURBOC__
#define EXTCHAR
#endif
#include "extchar.h"

/* the following is needed for the DOS port of the GNU C compiler */
#ifdef __DJGPP__
#define __DOS__
#undef unix
#endif

/*
 * Based on system type, #define or don't #define various symbols, as follows:
 *
 * UNIX_LIKE_FILES	If defined, files can be simultaneously read from and
 *			written to and invisibly unlinked.
 * UNIX_LIKE_PATH_RULES	If defined, use these rules for MUPPATH.
 * DOS_LIKE_PATH_RULES	If defined, use these rules for MUPPATH.
 * CORE_MESSAGE		If defined, then a creating core error message will be
 *			printed in debug mode.
 * NEED_GETOPT		If defined, the getopt suite is not available,
 *			therefore use the limited one in main.c.
 * MAGIC_FILE_HOME	If defined, check for magic file in $HOME.
 * MAGIC_FILE_NAME	Name of magic file.
 * OPTION_MARKER	The char which preceeds command line options.
 */
#ifdef unix
#define UNIX_LIKE_FILES
#define	UNIX_LIKE_PATH_RULES
#define CORE_MESSAGE
#define MAGIC_FILE_HOME
#define MAGIC_FILE_NAME	".mup"
#define OPTION_MARKER	'-'
#endif

#ifdef VMS
#define MAGIC_FILE_HOME
#define MAGIC_FILE_NAME	".mup"
#define OPTION_MARKER	'-'
#endif

#ifdef AMIGA
#undef	UNIX_LIKE_FILES
#define NEED_GETOPT
#define MAGIC_FILE_HOME
#define MAGIC_FILE_NAME	".mup"
#define OPTION_MARKER	'-'
#endif

#ifdef __DOS__
#define	DOS_LIKE_PATH_RULES
#define NEED_GETOPT
#define MAGIC_FILE_NAME	"mup.ok"
#define OPTION_MARKER	'/'
#endif

#ifdef Mac_BBEdit
#undef  UNIX_LIKE_FILES
#define NEED_GETOPT
/* skip length byte of Pascal string literal */
#define MAGIC_FILE_NAME	(char *)(MupRegFileName + 1);
#define OPTION_MARKER	'-'
#endif

#ifdef __EMX__
#undef	UNIX_LIKE_FILES
#define	DOS_LIKE_PATH_RULES
#define MAGIC_FILE_HOME
#define MAGIC_FILE_NAME	".mup"
#define OPTION_MARKER	'-'
#endif

/*
 * Define ranges for variables =============================================
 */

/* text point sizes */
#define MINSIZE	(1)
#define MAXSIZE	(100)

/* octave */
#define MINOCTAVE	(0)
#define MAXOCTAVE	(9)

/* staves */
#define MINSTAFFS	(1)
#define MAXSTAFFS	(40)

/* voices */
#define MINVOICES	(1)
#define NORMVOICES	(2)
#define MAXVOICES	(3)

/* number of lines in a tablature staff */
#define	MINTABLINES	(1)
#define	DEFTABLINES	(6)	/* see Guitar[] in globals.c */
#define	MAXTABLINES	(9)

/* number of ticks on a string designation for tablature */
#define	MINTICKS	(0)
#define	MAXTICKS	(MAXTABLINES - 1)

#define TABDEFOCT	(4)

/* tablature fret numbers, including pseudo fret numbers */
#define MINFRET		(0)
#define MAXFRET		(99)
#define DEFFRET		(0)
#define NOFRET		(MAXFRET + 1)
#define IN_UPWARD	(MAXFRET + 2)	/* slur from nowhere, going up */
#define IN_DOWNWARD	(MAXFRET + 3)	/* slur from nowhere, going down */
#define OUT_UPWARD	(MAXFRET + 4)	/* slur to nowhere, going up */
#define OUT_DOWNWARD	(MAXFRET + 5)	/* slur to nowhere, going down */
#define IS_NOWHERE(fret) ((fret) >= IN_UPWARD && (fret) <= OUT_DOWNWARD)

/* range of frets that can be printed by a chord grid */
#define	MINGRIDFRET	(2)
#define	MAXGRIDFRET	(MAXFRET)
#define	DEFGRIDFRET	(4)
#define	NOGRIDFRET	(-1)	/* must be negative so user can't enter it */

/* USE_DFLT_OCTAVE has to be number that is not a valid octave, nor a */
/* valid fret number.  But it has to be positive and small enough to be */
/* able to add MAX_OCTAVE to it */
#define USE_DFLT_OCTAVE	(MAXFRET + 6)

/* min and max numbers for bend integers, numerators, and denominators */
#define BENDINTBITS	(4)
#define MINBENDINT	(0)
#define MAXBENDINT	((1 << BENDINTBITS) - 1)
#define BENDNUMBITS	(6)
#define MINBENDNUM	(0)
#define MAXBENDNUM	((1 << BENDNUMBITS) - 1)
#define BENDDENBITS	(6)
#define MINBENDDEN	(1)
#define MAXBENDDEN	((1 << BENDDENBITS) - 1)

/* time unit */
/* -1 means quadruple whole and 0 means double whole.  Actually, less than -1 */
/* is allowed, and it's minus the number of measures in a multirest */
#define MINBASICTIME	(-1)
#define MAXBASICTIME	(256)

/* the biggest number that is allowed on a multirest */
#define MAXMULTINUM	(1000)

/* limits for scaling the output */
#define MINSCALE	(0.1)
#define MAXSCALE	(10.0)

/* limits for scaling a staff relative to the output as a whole */
#define MINSTFSCALE	(0.1)
#define MAXSTFSCALE	(10.0)

#define MINGRIDSCALE	(0.1)
#define MAXGRIDSCALE	(10.0)
#define DEFGRIDSCALE	(1.0)

/* limits on min distance required between a chord and its staff (stepsizes) */
#define	MINCHORDDIST	(0)
#define	MAXCHORDDIST	(50)
#define	DEFCHORDDIST	(3)

/* limits on min dist required between other stuff and its staff (stepsizes) */
#define	MINDIST		(0)
#define	MAXDIST		(50)
#define	DEFDIST		(2)

/* limits on min distance required between a cresc and its staff (stepsizes) */
#define	MINDYNDIST	(0)
#define	MAXDYNDIST	(50)
#define	DEFDYNDIST	(0)

/* vertical space between staffs and scores, in units of stepsize */
#define	MINMINSTSEP	(6)	/* min user-specified min between staffs */
#define	DEFMINSTSEP	(10)	/* default min between staffs */
#define	MINMINSCSEP	(6)	/* min user-specified min between scores */
#define	DEFMINSCSEP	(12)	/* default min between scores */
#define	MINMAXSCSEP	MINMINSCSEP /* min user-specified max between scores */
#define	DEFMAXSCSEP	(20)	/* default max between scores */
#define MAXSEPVAL	((int)(PGHEIGHT / STEPSIZE)) /* max for either one */
#define	MINSTPAD	(-MAXSEPVAL) /* min user-spec. white between staffs */
#define	MAXSTPAD	(MAXSEPVAL) /* max user white between staffs */
#define	DEFSTPAD	(0)	/* default white between staffs */
#define	MINSCPAD	(-MAXSEPVAL) /* min user-spec. white between scores */
#define	MAXSCPAD	(MAXSEPVAL) /* max user white between scores */
#define	DEFSCPAD	(2)	/* default white between scores */

/* distance from center line a rest should be forced to be */
#define MINRESTDIST	(-50)
#define MAXRESTDIST	(50)
#define	NORESTDIST	(11111)	/* this means it is not set */

/* number of mr needed to combine into a multirest (like -c option) */
#define	MINRESTCOMBINE	(2)
#define	MAXRESTCOMBINE	(1000)
#define	NORESTCOMBINE	(-1)	/* must be negative so user can't enter it */

/* page number to be put on the first page (like -p option) */
#define MINFIRSTPAGE	(1)
#define MAXFIRSTPAGE	(5000)
#define NOFIRSTPAGE	(0)	/* this means it is not set */

/* number to multiply linear regression slope by to get beam's slope */
#define MINBEAMFACT	(0.0)
#define MAXBEAMFACT	(1.0)
#define DEFBEAMFACT	(1.0)

/* maximum beam angle allowed, in degrees */
#define MINBEAMMAX	(0.0)
#define MAXBEAMMAX	(45.0)
#define DEFBEAMMAX	(20.0)

/* angle of beam specified by the "slope" interchord attribute */
#define	MINBEAMANGLE	(-MAXBEAMMAX)
#define	MAXBEAMANGLE	(MAXBEAMMAX)
#define	NOBEAMANGLE	(2 * MAXBEAMANGLE)	/* something out of range */

/* padding to be applied on the left of every group (and the right of the */
/* last group in the measure), in stepsizes */
#define MINPAD		(-5.0)
#define MAXPAD		(50.0)
#define DEFPAD		(0.0)

/* for setting and testing unknown stem length */
#define	STEMLEN_UNKNOWN		(-1.0)
#define	IS_STEMLEN_KNOWN(x)	((x) >= 0.0)	/* avoid using "==" on floats */
#define	IS_STEMLEN_UNKNOWN(x)	((x) < 0.0)	/* avoid using "==" on floats */

/* other stem length definitions */
#define	MINSTEMLEN	(0.0)
#define	DEFSTEMLEN	(7.0)
#define	MAXSTEMLEN	(100.0)
#define	SM_STEMFACTOR	(5.0 / 7.0)	/* grace/cue factor */

/* number of stepsizes by which a beamed stem can be shortened */
#define	MINSTEMSHORTEN	(0.0)
#define	MAXSTEMSHORTEN	(2.0)
#define	DEFSTEMSHORTEN	(1.0)

/* what fraction of each lyrics syllable goes left of the center of chord */
#define MINLYRICSALIGN	(0.0)
#define MAXLYRICSALIGN	(1.0)

/* size of the paper */
#define MINPAGEHEIGHT	(2.0)
#define MAXPAGEHEIGHT	(24.0)
#define MINPAGEWIDTH	(2.0)
#define MAXPAGEWIDTH	(24.0)

/* top and bottom margins */
#define MINVMARGIN	(0.0)
#define MAXVMARGIN	(3.0)

/* left and right margins */
#define MINHMARGIN	(0.0)
#define MAXHMARGIN	(3.0)

/* how tightly to pack the stuff horizontally (default value) */
#define MINPACKFACT	(0.0)
#define DFLTPACKFACT	(1.0)
#define MAXPACKFACT	(10.0)

/* how much to expand long notes relative to short ones */
#define MINPACKEXP	(0.0)
#define DFLTPACKEXP	(0.8)
#define MAXPACKEXP	(1.0)

/* time signature */
#define MINNUMERATOR	(1)
#define MAXNUMERATOR	(99)

#define MINDENOMINATOR	(1)
#define MAXDENOMINATOR	(64)

#define MINDIVISION	(1)
#define DEFDIVISION	(192)
#define MAXDIVISION	(3 * 512)

/* define values for the "release" parameter, in milliseconds */
#define MINRELEASE	(0)
#define DEFRELEASE	(20)
#define MAXRELEASE	(500)

/* define values for the "sylposition" parameter, in points */
#define	MINSYLPOSITION	(-100)
#define	MAXSYLPOSITION	(100)
#define	DEFSYLPOSITION	(-5)
#define	NOSYLPOSITION	(11111)	/* this means it is not set */


/*
 * Define sets of symbols which probably should have been done as enums,
 * but in ANSI C enums aren't much good anyhow.  =============================
 * Also define some macros for testing these enums.
 */

/*
 * To limit the number of terminal symbols so that yacc won't blow up,
 * several tokens map to the same terminal symbol, and we set a variable
 * (yylval) to say which particular one was actually seen.
 */
#define F_STAFFS	(1)
#define F_OCTAVE	(2)
#define F_LYRSIZE	(3)
#define F_VERTSPACE	(4)
#define F_SIZE		(5)

#define F_TOPMARGIN	(6)
#define F_BOTMARGIN	(7)
#define F_LEFTMARGIN	(8)
#define F_RIGHTMARGIN	(9)

#define F_TIMEUNIT	(10)
#define F_VSCHEME	(11)

#define F_BRACKET	(12)
#define F_BRACE		(13)
#define F_BARSTYLE	(14)

#define F_LABEL		(15)
#define F_LABEL2	(16)

#define F_FONT		(17)
#define F_LYRFONT	(18)

#define F_VISIBLE	(19)
#define F_VERSES	(20)

/*
 * Define all the types of context in the input.  Make each one a bit, so that
 * we can also define a couple groupings of them.
 */
#define	C_HEADER	(0x1)	/* first page header */
#define	C_FOOTER	(0x2)	/* first page footer */
#define	C_HEAD2		(0x4)	/* later page header */
#define	C_FOOT2		(0x8)	/* later page footer */
#define	C_TOP		(0x10)	/* initial block at top */
#define	C_BOT		(0x20)	/* initial block at bottom */
#define	C_TOP2		(0x40)	/* later block at top */
#define	C_BOT2		(0x80)	/* later block at bottom */
#define	C_BLOCK		(0x100)	/* other block */
#define	C_SCORE		(0x200)	/* the whole score */
#define	C_STAFF		(0x400)	/* a staff */
#define	C_VOICE		(0x800)	/* a voice */
#define	C_MUSIC		(0x1000) /* notes, etc. */
#define	C_GRIDS		(0x2000) /* chord grids */
#define	C_HEADSHAPES	(0x4000) /* head shapes for notehead characters */

/* context classes--combining things that mostly have the same rules */
#define	C_BLOCKHEAD	(C_HEADER | C_FOOTER | C_HEAD2 | C_FOOT2 | \
			C_TOP | C_BOT | C_TOP2 | C_BOT2 | C_BLOCK)
#define	C_SSV		(C_SCORE | C_STAFF | C_VOICE)

/* define whether things are measured in inches or centimeters */
#define INCHES		(0)
#define CM		(1)

/*
 * Define the voice schemes.  V_1 means just one voice is on the staff;
 * the program will decide the stem direction of each group.  V_2OPSTEM
 * means there are two voices with opposing stems:  the first voice always
 * points up, and the second one always points down.  V_2FREESTEM means there
 * are two voices.  If, at any time, one has a space, the other one's stems
 * can point either way (as with one voice).  Otherwise, the first voice
 * points up and the second one down.
 * V_3OPSTEM and V_3FREESTEM are just like the "2" ones, except that a third
 * voice is allowed to exist.  Its stem direction is determined elsewhere.
 */
#define	V_1		(0)
#define	V_2OPSTEM	(1)
#define	V_2FREESTEM	(2)
#define	V_3OPSTEM	(3)
#define	V_3FREESTEM	(4)

/*
 * Define the staff style vis-a-vis printing of clefs, accidentals (in key
 * signatures and otherwise), and tranposing.  WARNING:  SS_NOTHING must be
 * defined to be 0 so that calloc inits the field to this.
 */
#define	SS_NOTHING	(0)	/* no transpose; print no clef, no accidentals*/
#define	SS_NORMAL	(1)	/* normal printing */
#define	SS_DRUM		(2)	/* like SS_NOTHING, but print a "drum clef" */

/*
 * Define the time signature types.  NUMERIC is the usual two-number
 * signature.  INVISNUM is the same, except that it will not be printed.
 * Common and cut time are noted here separately.  But for all other
 * purposes they are treated as 4/4 and 2/2 respectively.
 */
#define	TS_NUMERIC	(0)
#define	TS_INVISNUM	(1)
#define	TS_COMMON	(2)
#define	TS_CUT		(3)

/*
 * Special bytes used inside time signature representation.
 * These values need to be outside the range of time signature numerators
 * and denominators, but small enough to fit in a byte.
 * Probably safer to keep them under 128 as well, to avoid any possible
 * issues with negative chars.
 *
 * Here's how the encoding works:
 * cut and common get stored as TSR_CUT and TSR_COMMON respectively.
 * If a + is used between a denominator of one fraction
 * and numerator of another, it is encoded as TSR_ADD.
 * When a + is used inside a numerator, nothing is stored at all,
 * since it is clear all numbers up to the slash
 * must be components of the numerator.
 * White space rather than + after a denominator
 * means alternating time signatures, marked internally by TSR_ALTERNATING.
 * Numbers are stored as their binary values.
 * A TSR_END is placed at the end of everything to mark the end.
 * A null is used for that, so one could use things like strlen or strcpy
 * on a representation.
 */
#define TSR_CUT		(MAXNUMERATOR + 1)
#define TSR_COMMON	(MAXNUMERATOR + 2)
#define TSR_SLASH	(MAXNUMERATOR + 3)
#define TSR_ADD		(MAXNUMERATOR + 4)
#define TSR_ALTERNATING	(MAXNUMERATOR + 5)
#define TSR_END		(0)

/*
 * This is the maximum length of an internal time signature representation.
 * Note that the internal form is more compact than the input form,
 * so even something so ridiculously complicated that it's doubtful any
 * human could keep it straight, like
 *   3+1+4/16 + cut + 7+11+41/2  9+2/64 + 5+7+31+29/1 + com
 * would only take 28 bytes, so 40 should be plenty!
 * The maximum number of numerator components 40 bytes could accomodate
 * would be 37, so maximum theoretical effective time signature
 * would be thirty-seven 99's or 3663 counts.
 */
#define MAXTSLEN	40

/*
 * Define when time signatures should be printed.  "Once" means when it
 * changes.  "Always" makes sense only when there is an alternating time sig,
 * and it means print it at each measure.
 */
#define PTS_NEVER	(0)	/* user input "n" */
#define PTS_ONCE	(1)	/* user input nothing */
#define PTS_ALWAYS	(2)	/* user input "y" */

/*
 * Define the clefs that are allowed.  The values are important, so that
 * the program can conveniently figure note positions without having a
 * separate case for each value.
 */
#define	TREBLE_8A	(-7)
#define	FRENCHVIOLIN	(-2)
#define	TREBLE		(0)
#define	SOPRANO		(2)
#define	MEZZOSOPRANO	(4)
#define	ALTO		(6)
#define	TREBLE_8	(7)
#define	TENOR		(8)
#define	BARITONE	(10)
#define	BASS		(12)
#define	TABCLEF		(-1)	/* tablature "clef" */
#define NOCLEF		(-99)	/* no clef is present */

/*
 * Define what a GRPSYL structure can represent.
 */
#define	GS_GROUP	(0)
#define	GS_SYLLABLE	(1)

/*
 * Define the different contents a group can have.
 */
#define	GC_NOTES	(0)
#define	GC_REST		(1)
#define	GC_SPACE	(2)

/*
 * Define the time values a group can have.  Only note groups can be other than
 * normal (grace notes).  There are no grace rests or spaces.
 */
#define	GV_NORMAL	(0)
#define	GV_ZERO		(1)

/*
 * Define the unknown value for headshapes.  The other values aren't defined
 * here because they are established as headshapes are loaded at run time.
 * There is a built-in set of these that are loaded, and then the user can use
 * the "headshapes" context to load more.  Each headshape number corresponds to
 * a headshape name, such as "norm", "xnote", "rect", etc., and stands for the
 * set of music characters used to print note heads of the various basictimes.
 */
#define	HS_UNKNOWN	(0)

/*
 * Define the size of a group.  Spaces are always normal, but notes and rests
 * can have different sizes.  For note groups, this can vary on a per-note
 * basis.
 */
#define	GS_NORMAL	(0)
#define	GS_SMALL	(1)

/*
 * Define position that you can be in relative to a list of objects.
 */
#define	NOITEM		(0)	/* not within a list */
#define	STARTITEM	(1)	/* first item in a list */
#define	INITEM		(2)	/* interior item in a list */
#define	ENDITEM		(3)	/* last item in a list */
#define	LONEITEM	(4)	/* only item in a list */


/*
 * Define the directions for various items.
 */
#define UNKNOWN	(0)
#define	UP	(1)
#define	DOWN	(2)


/*
 * Define values for controlling printing of tuplet numbers and brackets.
 * For PT_DEFAULT, the bracket will be printed unless all the notes of the
 * tuplet (and no other notes) form a beamed set.
 */
#define	PT_NEITHER	(0)	/* never print number or bracket */
#define	PT_DEFAULT	(1)	/* always print number; maybe print bracket */
#define	PT_BOTH		(2)	/* always print number and bracket */
#define	PT_NUMBER	(3)	/* always print just the number */


/*
 * Coordinate types that can have location variables associated with them.
 */
#define CT_BUILTIN	(1)
#define CT_GRPSYL	(2)
#define CT_BAR		(4)
#define CT_NOTE		(8)
#define CT_INVISIBLE	(128)


/*
 * Define the types of STUFF structure.  "Stuff" is things that are to be
 * printed other than the actual music and lyrics.
 */
#define	ST_ROM		(0)
#define	ST_BOLD		(1)
#define	ST_ITAL		(2)
#define	ST_BOLDITAL	(3)
#define	ST_CRESC	(4)
#define	ST_DECRESC	(5)
#define	ST_MUSSYM	(6)
#define	ST_PEDAL	(7)
#define	ST_TIESLUR	(8)
#define	ST_TABSLUR	(9)
#define	ST_BEND		(10)
#define	ST_PHRASE	(11)
#define	ST_OCTAVE	(12)
#define	ST_MIDI		(13)

#define IS_TEXT(stype)	((stype) == ST_ROM || (stype) == ST_ITAL ||	\
			(stype) == ST_BOLD || (stype) == ST_BOLDITAL)

/*
 * Define the places where the stuff can be printed, relative to staff(s).
 */
#define	PL_ABOVE	(0)
#define	PL_BELOW	(1)
#define	PL_BETWEEN	(2)
#define	PL_UNKNOWN	(3)
#define	NUM_PLACE	(3)	/* number of "good" places (exclude unknown) */

/*
 * Define the ways a user can specify the horizonal offset of a group from the
 * chord's X coordinate.
 */
#define	HO_NONE		(0)	/* not specified */
#define	HO_LEFT		(1)	/* "-" (next to other group(s), on the left) */
#define	HO_RIGHT	(2)	/* "+" (next to other group(s), on the right) */
#define	HO_VALUE	(3)	/* "+/-N" (offset given by GRPSYL.ho_value) */

/*
 * Define text modifiers:  different flavors of rom, bold, ital, and
 * boldital.  TM_DYN also applies automatically to the hairpin stuffs, < and >.
 */
#define	TM_NONE		(0)
#define	TM_CHORD	(1)
#define	TM_ANALYSIS	(2)
#define	TM_FIGBASS	(3)
#define	TM_DYN		(4)

#define IS_CHORDLIKE(x)	((x) == TM_CHORD || (x) == TM_ANALYSIS ||	\
			(x) == TM_FIGBASS)

/*
 * Define values for dist_usage in STUFF.
 */
#define	SD_NONE		(0)	/* user did not specify */
#define	SD_MIN		(1)	/* user specified minimum distance */
#define	SD_FORCE	(2)	/* user is forcing this distance */

/*
 * Define all the types of marks that the user can request to be stacked in
 * different orders.  This list is in increasing order of the default priority
 * of stacking, except that by default MK_DYN, MK_OTHERTEXT, and MK_CHORD are
 * of equal priority.  If this list changes, make sure that Defmarkorder[]
 * is updated too.  For each place (above, below, between), the user can
 * specify a different ordering of priority to be used.  There is a restriction
 * that the last ones (MK_LYRICS, MK_ENDING, MK_REHEARSAL, MK_PEDAL) must
 * have a different priority from each other and any of the other ones.  Also,
 * MK_PEDAL is allowed only below; MK_ENDING and MK_REHEARSAL are allowed only
 * above; and those three and MK_OCTAVE are not allowed between.
 */
#define	MK_MUSSYM	(0)	/* ST_MUSSYM */
#define	MK_OCTAVE	(1)	/* ST_OCTAVE */
#define	MK_DYN		(2)	/* ST_CRESC or ST_DECRESC; or ST_ROM, */
				/* ST_ITAL, ST_BOLD, ST_BOLDITAL with "dyn" */
				/* (TM_DYN is set for these and only these) */
#define	MK_OTHERTEXT	(3)	/* ST_ROM, ST_ITAL, ST_BOLD, ST_BOLDITAL */
				/* without chord/analysis/figbass or dyn */
#define	MK_CHORD	(4)	/* ST_ROM, ST_ITAL, ST_BOLD, ST_BOLDITAL */
				/* with chord, analysis, or figbass */
				/* (TM_CHORD is set for these and only these) */
#define	MK_LYRICS	(5)	/* lyrics */
#define	MK_ENDING	(6)	/* ending mark */
#define	MK_REHEARSAL	(7)	/* rehearsal mark */
#define	MK_PEDAL	(8)	/* ST_PEDAL */
#define NUM_MARK	(9)	/* this must follow the last MK */

/*
 * While parsing, we need to temporarily store some things as pseudo-pitches.
 * When the user does not specify any pitch for the first group of a measure,
 * we temporarily use PP_NO_PITCH, since not specifying a pitch is legal iff it
 * is for one or more 1-line staffs, but it's not easy to check on that until
 * later.  We also need to save rest, space, and rpt as pseudo notes until we
 * later map them to groups.
 */
#define PP_NO_PITCH	'h'
#define PP_REST		'r'
#define PP_SPACE	's'
#define PP_RPT		'p'

/*
 * Define the other staff that a given staff's groups are beamed or stemmed to.
 */
#define CS_SAME		(0)
#define CS_ABOVE	(1)
#define CS_BELOW	(2)

/*
 * Define symbols for indexing coordinate arrays.  The first 12 are X, Y,
 * north, south, east, and west, both relative and absolute.  Not all things
 * that have coordinates bother to set all 12 of these.  There should be
 * comments in structs.h saying which things get set for what.
 *
 * In GRPSYL, during the time that positions of phrase marks are being
 * figured out, AN and AS are used in a strange way.  But later, they get
 * set to their intended values.
 *
 * The 13th is a special number used by nongrace notes and GRPSYLs, and BARs
 * only.  For notes and GRPSYLs, it has the following meaning.  It indicates
 * how many inches of horizontal space would be allocated to this object
 * if it were a whole note instead of whatever it actually is, but were
 * allocated space proportionally.  That is, fulltime times this number
 * is the amount of space between the X coordinates of this GRPSYL and
 * the next one in the measure (or the bar line if this is the last GRPSYL
 * in the measure).  Notice that even for notes, it's the X coordinate of
 * the note's GRPSYL that count, even if the note head is on the "wrong"
 * side of the stem.  For BARs, this 13th number has a similiar use.  If
 * you pretend that a bar line is count 0 of the following measure, and
 * the first GRPSYL of the measure is at count 1 (whichever type of note
 * constitutes a "count"), this number is how many inches would be allocated
 * to a whole note instead of the one count of space that is there.
 */
#define	RX	(0)
#define	RY	(1)
#define	RN	(2)
#define	RS	(3)
#define	RE	(4)
#define	RW	(5)
#define	AX	(6)
#define	AY	(7)
#define	AN	(8)
#define	AS	(9)
#define	AE	(10)
#define	AW	(11)
#define	INCHPERWHOLE	(12)
#define NUMCTYPE	(13)


/*
 * AN and AS of group coordinates are used temporarily to store the distance
 * from the group to any phrase marks, to be used to make sure nesting phrases
 * don't impinge on that space. But if a group has a phrase ending on it and
 * another beginning on it, those won't collide.  So use bitmap to keep track
 * of whether the AN and AS values apply to east side, west side, or both.
 * (phraseside in GRPSYL is a bit map.)
 */
#define EAST_SIDE	(1 << 0)
#define WEST_SIDE	(1 << 1)


/*
 * Define the types of bar line.
 */
#define	INVISBAR	(0)
#define	SINGLEBAR	(1)
#define	DOUBLEBAR	(2)
#define	REPEATSTART	(3)
#define	REPEATEND	(4)
#define	REPEATBOTH	(5)
#define	ENDBAR		(6)
#define	RESTART		(7)

/*
 * Define the types of font, leaving 0 unused to avoid ending up having
 * null characters appear in strings where this number is stored,
 * and to have something convenient to use to flag an unknown font.
 * WARNING:  the getfontinfo.c program depends on all the font names
 * beginning with "FONT_", and on MAXFONTS being at the end of the list.
 */
#define FONT_UNKNOWN	(0)
#define FAMILY_DFLT	(-1)

#define BASE_TIMES	(0)
#define	FONT_TR		(1)
#define	FONT_TI		(2)
#define	FONT_TB		(3)
#define	FONT_TX		(4)

#define BASE_AVANTGARDE	(FONT_TX)
#define FONT_AR		(BASE_AVANTGARDE + FONT_TR)
#define FONT_AI		(BASE_AVANTGARDE + FONT_TI)
#define FONT_AB		(BASE_AVANTGARDE + FONT_TB)
#define FONT_AX		(BASE_AVANTGARDE + FONT_TX)

#define BASE_COURIER	(FONT_AX)
#define FONT_CR		(BASE_COURIER + FONT_TR)
#define FONT_CI		(BASE_COURIER + FONT_TI)
#define FONT_CB		(BASE_COURIER + FONT_TB)
#define FONT_CX		(BASE_COURIER + FONT_TX)

#define BASE_HELVETICA	(FONT_CX)
#define FONT_HR		(BASE_HELVETICA + FONT_TR)
#define FONT_HI		(BASE_HELVETICA + FONT_TI)
#define FONT_HB		(BASE_HELVETICA + FONT_TB)
#define FONT_HX		(BASE_HELVETICA + FONT_TX)

#define BASE_BOOKMAN	(FONT_HX)
#define FONT_BR		(BASE_BOOKMAN + FONT_TR)
#define FONT_BI		(BASE_BOOKMAN + FONT_TI)
#define FONT_BB		(BASE_BOOKMAN + FONT_TB)
#define FONT_BX		(BASE_BOOKMAN + FONT_TX)

#define BASE_NEWCENTURY	(FONT_BX)
#define FONT_NR		(BASE_NEWCENTURY + FONT_TR)
#define FONT_NI		(BASE_NEWCENTURY + FONT_TI)
#define FONT_NB		(BASE_NEWCENTURY + FONT_TB)
#define FONT_NX		(BASE_NEWCENTURY + FONT_TX)

#define BASE_PALATINO	(FONT_NX)
#define FONT_PR		(BASE_PALATINO + FONT_TR)
#define FONT_PI		(BASE_PALATINO + FONT_TI)
#define FONT_PB		(BASE_PALATINO + FONT_TB)
#define FONT_PX		(BASE_PALATINO + FONT_TX)

#ifdef EXTCHAR
/* extra fonts that contain the extended character set start here.
 * They go in the same order as their corresponding standard ASCII fonts */
#define EXT_FONT_OFFSET	(FONT_PX - BASE_TIMES)

#define FONT_XTR	(FONT_TR + EXT_FONT_OFFSET)
#define	FONT_XTI	(FONT_TI + EXT_FONT_OFFSET)
#define	FONT_XTB	(FONT_TB + EXT_FONT_OFFSET)
#define	FONT_XTX	(FONT_TX + EXT_FONT_OFFSET)

#define FONT_XAR	(FONT_AR + EXT_FONT_OFFSET)
#define FONT_XAI	(FONT_AI + EXT_FONT_OFFSET)
#define FONT_XAB	(FONT_AB + EXT_FONT_OFFSET)
#define FONT_XAX	(FONT_AX + EXT_FONT_OFFSET)

#define FONT_XCR	(FONT_CR + EXT_FONT_OFFSET)
#define FONT_XCI	(FONT_CI + EXT_FONT_OFFSET)
#define FONT_XCB	(FONT_CB + EXT_FONT_OFFSET)
#define FONT_XCX	(FONT_CX + EXT_FONT_OFFSET)

#define FONT_XHR	(FONT_HR + EXT_FONT_OFFSET)
#define FONT_XHI	(FONT_HI + EXT_FONT_OFFSET)
#define FONT_XHB	(FONT_HB + EXT_FONT_OFFSET)
#define FONT_XHX	(FONT_HX + EXT_FONT_OFFSET)

#define FONT_XBR	(FONT_BR + EXT_FONT_OFFSET)
#define FONT_XBI	(FONT_BI + EXT_FONT_OFFSET)
#define FONT_XBB	(FONT_BB + EXT_FONT_OFFSET)
#define FONT_XBX	(FONT_BX + EXT_FONT_OFFSET)

#define FONT_XNR	(FONT_NR + EXT_FONT_OFFSET)
#define FONT_XNI	(FONT_NI + EXT_FONT_OFFSET)
#define FONT_XNB	(FONT_NB + EXT_FONT_OFFSET)
#define FONT_XNX	(FONT_NX + EXT_FONT_OFFSET)

#define FONT_XPR	(FONT_PR + EXT_FONT_OFFSET)
#define FONT_XPI	(FONT_PI + EXT_FONT_OFFSET)
#define FONT_XPB	(FONT_PB + EXT_FONT_OFFSET)
#define FONT_XPX	(FONT_PX + EXT_FONT_OFFSET)

#define BASE_MISC	(FONT_XPX)
#else
#define BASE_MISC	(FONT_PX)
#endif
#define FONT_ZD		(BASE_MISC + 1)
#define FONT_ZI		(BASE_MISC + 2)
#define	FONT_MUSIC	(BASE_MISC + 3)
#define	FONT_MUSIC2	(BASE_MISC + 4)
#define MAXFONTS	(BASE_MISC + 5)

/* number of music fonts */
#define NUM_MFONTS	(2)

/* first printable character in a font */
#define	FIRST_CHAR	(32)

/*
 * The following value plus FIRST_CHAR needs to be at least as large as
 * one more than the largest value in either muschar.h or extchar.h
 */
#define CHARS_IN_FONT	(96)

/*
 * Find array offset into height, width, and ascent tables.  This is character
 * code -FIRST_CHAR, to skip ASCII control characters.
 */
#define CHAR_INDEX(c)	((c) - FIRST_CHAR)

/*
 * Test if a font is a "music" font.
 */
#define IS_MUSIC_FONT(f)	((f) == FONT_MUSIC || (f) == FONT_MUSIC2)

/*
 * Special commands to use inside internal format of strings.
 * All use high-bit==1 to indicate a command.
 * Note that the low order bits of STR_MUS_CHAR* specify which music font it is.
 */
#define STR_MUS_CHAR		0x80	/* followed by 1-byte size and 1-byte \
					 * music character code */
#define STR_MUS_CHAR2		0x81	/* same rules as above */
#define STR_FONT		0xe0	/* followed by 1-byte font number */
#define STR_SIZE		0xe1	/* followed by 1-byte size */
#define STR_PAGENUM		0xe2	/* followed by '%' */
#define STR_NUMPAGES		0xe3	/* followed by '#' */
#define STR_PRE			0xe4	/* pre-syl <--->, ignored in spacing */
#define STR_U_PRE		0xe5	/* pre-syl <...>, used in spacing */
#define STR_PRE_END		0xe6	/* end of pre-syllable <...> */
#define STR_PST			0xe7	/* post-syl <...>, ignored in spacing */
#define STR_U_PST		0xe8	/* post-syl <...>, used in spacing */
#define STR_PST_END		0xe9	/* end of post-syllable <...> */
/*
 * Backspace is a bit strange.  The amount to back up varies because of
 * proportionally spaced fonts.  So we save the distance in terms of the width
 * in 250ths of an inch in the default size.  The actual distance to back up is
 * then that number times the ratio of the current actual size to the default
 * size divided by 250.  250 was chosen because that means a range of 1-127
 * (to make sure it is non-zero and with high-bit of zero)
 * will give a range of .004 to 0.508 inches, which should cover all
 * characters we have today (the widest of which is currently just over 1/4").
 * This is done in floating point, so no reason to use a power of 2 like 256.
 */
#define STR_BACKSPACE		0xea	/* followed by how much to back up */

#define BACKSP_FACTOR		(250.0)

/* string commands for boxed text */
#define STR_BOX			0xeb
#define STR_BOX_END		0xec
#define IS_BOXED(string)   (((string[2] & 0xff) == (STR_BOX & 0xff)) ? YES : NO)

#define	STR_VERTICAL		0xed	/* vert move followed by 1-byte dist */
#define	STR_L_ALIGN		0xee	/* align at left edge of next char */
#define	STR_C_ALIGN		0xef	/* align at center of next char */
#define STR_PILE		0xf0	/* toggle for piling, \: */
#define STR_SLASH		0xf1	/* slash used by figbass, \/ */

/* string commands for circled text */
#define STR_CIR			0xf2
#define STR_CIR_END		0xf3
#define IS_CIRCLED(string) (((string[2] & 0xff) == (STR_CIR & 0xff)) ? YES : NO)

/*
 * Define macros relating to vertical movement within a string.  It is stored
 * in points, offset by a bias so that the number will always be positive when
 * stored in the byte after the STR_VERTICAL in a string.
 */
#define	MINVERTICAL	(-50)
#define	MAXVERTICAL	(50)
#define	VERT_BIAS	(1 - MINVERTICAL)
#define	ENCODE_VERT(x)	(x + VERT_BIAS)
#define	DECODE_VERT(x)	(x - VERT_BIAS)

/*
 * Macro to determine if a character in an internal-format string is a
 * command character.
 */
#define IS_STR_COMMAND(c)	((c) & 0x80)


#define DFLT_SIZE	(12)
#define SMALLSIZE	((int)(DFLT_SIZE * SM_FACTOR))

/*
 * Define the default font size of a measure number.
 */
#define MNUM_SIZE	(11)

/*
 * Define types of lines and curves.
 */
#define	L_NORMAL	(0)
#define	L_MEDIUM	(1)
#define	L_WIDE 		(2)
#define	L_WAVY		(3)
#define	L_DOTTED	(4)
#define	L_DASHED	(5)

/*
 * Define the kinds of justification.
 */
#define	J_LEFT		(1)
#define	J_RIGHT		(2)
#define	J_CENTER	(3)
#define	J_NONE		(4)
#define	J_RAGPARA	(5)	/* ragged-right paragraph */
#define	J_JUSTPARA	(6)	/* justified paragraph */

/*
 * Define the ending styles (which staffs 1st, 2nd, etc. endings are to
 * be drawn on).
 */
#define ENDING_TOP	(0)	/* only above top visible staff */
#define ENDING_BARRED	(1)	/* above each group of staffs barred together*/
#define ENDING_GROUPED	(2)	/* above each group of staffs grouped */
				/*  together by braces or brackets */

/*
 * Define types of rehearsal letters/numbers.
 */
#define REH_NONE	(0)	/* none at all */
#define REH_STRING	(1)	/* user-supplied string */
#define REH_NUM		(2)	/* consecutive numbers 1, 2, 3, . . . */
#define REH_LET		(3)	/* consecutive letters A, B, C, . . . */
#define REH_MNUM	(4)	/* use current measure number */

/*
 * Define the style of (ways of drawing) rehearsal letters/numbers.
 */
#define	RS_PLAIN	(0)	/* just the letter/number */
#define	RS_BOXED	(1)	/* enclosed in a box */
#define	RS_CIRCLED	(2)	/* enclosed in a circle */

/*
 * Define the ways to print pedal markings.
 */
#define P_LINE		(0)	/* draw a line under where the pedal is down */
#define P_PEDSTAR	(1)	/* print "Ped." and the start and "*" at end */
#define P_ALTPEDSTAR	(2)	/* like P_PEDSTAR but only "Ped." when bounce*/

/*
 * Define the side of a stem that a partial beam can be on.  There is code in
 * prntdata.c that depends on these values, -1 and 1.
 */
#define PB_LEFT		(-1)
#define PB_RIGHT	(1)

/*
 * Define types of intervals.  There is code that depends on these being in
 * this order, starting from 0, counting up (like in trnspose.c).
 */
#define	DIMINISHED	(0)
#define	MINOR		(1)
#define	PERFECT		(2)
#define	MAJOR		(3)
#define	AUGMENTED	(4)

/*
 * Define the input style.
 */
#define IS_VOICE_INPUT  (0)     /* voice-at-a-time (must be zero) */
#define IS_CHORD_INPUT  (1)	/* chord-at-a-time */

/*
 * Define various constants =============================================
 */

/* the number of PostScript points in one inch */
#define PPI		(72.0)

/* the size of a point in inches */
#define POINT		(1.0 / PPI)

/* the distance between a note and the next higher note */
#define STEPSIZE	(3.0 * POINT)

/* size of white space for surrounding things that should be padded thus */
#define	STDPAD		(STEPSIZE / 3.0)

/* (distance between tab staff lines) / (distance between normal staff lines)*/
#define TABRATIO	(1.735)

/* scaling factor giving size of "sm" (small) music chars relative to normal */
#define SM_FACTOR	(0.65)

/* scaling factor giving size of a grace fret number relative to normal */
#define SMFRETSIZE	((int)(0.80 * DFLT_SIZE))

/* font character size information is stored in FONTFACTORs of an inch */
#define FONTFACTOR	(1000.0)

/* widths of various types of lines, in points */
#define	W_NORMAL	(0.7)
#define	W_MEDIUM	(1.5)
#define	W_WIDE 		(3.0)

/* vertical distance between two flags or two beams */
#define	FLAGSEP		(1.6 * STEPSIZE)	/* for normal notes */
#define	SMFLAGSEP	(FLAGSEP * SM_FACTOR)	/* for cue or grace notes */

/* minimum width to be given to a multirest */
#define MINMULTIWIDTH	(0.7)

/* temporary width for a measure rest, serves as a marker */
#define	TEMPMRPTWIDTH	(0.02)

/* half the width of a restart bar */
#define HALF_RESTART_WIDTH	(12 * POINT)

/* padding provided to force more room between groups for various reasons */
#define	TIESLURPAD	(0.12)	/* ties and slurs */
#define	SLASHPAD	(0.06)	/* slashes through stems */
#define	ALTPAD		(0.12)	/* alternation beams between groups */
#define ROLLPADDING	(12 * STDPAD)	/* a roll to the left of a group */

/* padding to be put after a clef */
#define CLEFPAD		(2.0 * STDPAD)

/* how high certain things are */
#define TUPHEIGHT	(10.0/3.0 * STEPSIZE)	/* tuplet bracket */
#define OCTHEIGHT	(10.0/3.0 * STEPSIZE)	/* octave bracket */
#define ENDINGHEIGHT	(13.0/3.0 * STEPSIZE)	/* ending bracket */
#define MULTIHEIGHT	(12.0/3.0 * STEPSIZE)	/* multirest number */
#define MINWITHHEIGHT	(2.2 * STEPSIZE)	/* minimum "with" list item */

/* horizontal extent of a slash, in stepsizes */
#define SLASHHORZ	(5.0 / 3.0)

/*
 * The maximum number of notes there could ever be in a "hand" (the notes of a
 * chord that occur on a given staff) is the number of unique notes that can
 * exist, C0 through B9.
 */
#define MAXHAND		((MAXOCTAVE - MINOCTAVE + 1) * 7)

/* the length in the X direction of a tabslur to or from nowhere */
#define	SLIDEXLEN	(3.0 * STEPSIZE)

/* define the default distance, in stepsizes, between the lines of a grid */
#define	WHEREUSED_GS	(1.6)	/* when printed by the music */
#define	ATEND_GS	(2.0)	/* when printed at the end of the song */

#define	NO		(0)
#define	YES		(1)

/* the "used" field in input SSVs uses the following in addition to YES/NO */
#define	UNSET		(2)

#ifndef PI
#define PI	(3.141592653589793)
#endif

#define	CMPERINCH	(2.54)		/* centimeters per inch */

/*
 * Define miscellaneous macros =============================================
 */

/* number of elements in an array */
#define NUMELEM(a)	(sizeof(a) / sizeof((a)[0]))

/*
 * Define macros for allocating structures.
 */
#define	MALLOC(structtype, new_p, numelem) {				\
	if ((new_p = (struct structtype *)malloc((unsigned)		\
			(((numelem) == 0 ? 1 : (numelem)) *		\
			sizeof(struct structtype)))) == 0)		\
		l_no_mem(__FILE__, __LINE__);				\
}
#define	CALLOC(structtype, new_p, numelem) {				\
	if ((new_p = (struct structtype *)calloc(			\
			(numelem) == 0 ? 1 : (numelem),			\
			(unsigned)sizeof(struct structtype)))  == 0)	\
		l_no_mem(__FILE__, __LINE__);				\
}
#ifndef __STDC__
#define	REALLOC(structtype, new_p, numelem) {				\
	if ((new_p = (struct structtype *)realloc((char *)(new_p),	\
			(unsigned)(((numelem) == 0 ? 1 : (numelem)) *	\
			sizeof(struct structtype)))) == 0) 		\
		l_no_mem(__FILE__, __LINE__);				\
}
#else
#define	REALLOC(structtype, new_p, numelem) {				\
	if ((new_p = (struct structtype *)realloc((void *)(new_p),	\
			(unsigned)(((numelem) == 0 ? 1 : (numelem)) *	\
			sizeof(struct structtype)))) == 0) 		\
		l_no_mem(__FILE__, __LINE__);				\
}
#endif

/*
 * Define macros for allocating other arrays.
 */
#define	MALLOCA(type, new_p, numelem) {					\
	if ((new_p = (type *)malloc((unsigned)				\
			(((numelem) == 0 ? 1 : (numelem)) *		\
			sizeof(type)))) == 0)				\
		l_no_mem(__FILE__, __LINE__);				\
}
#define	CALLOCA(type, new_p, numelem) {					\
	if ((new_p = (type *)calloc((numelem) == 0 ? 1 : (numelem),	\
			(unsigned)sizeof(type)))  == 0)			\
		l_no_mem(__FILE__, __LINE__);				\
}
#ifndef __STDC__
#define	REALLOCA(type, new_p, numelem) {				\
	if ((new_p = (type *)realloc((char *)(new_p),			\
			(unsigned)(((numelem) == 0 ? 1 : (numelem)) *	\
			sizeof(type)))) == 0)				\
		l_no_mem(__FILE__, __LINE__);				\
}
#else
#define	REALLOCA(type, new_p, numelem) {				\
	if ((new_p = (type *)realloc((void *)(new_p),			\
			(unsigned)(((numelem) == 0 ? 1 : (numelem)) *	\
			sizeof(type)))) == 0)				\
		l_no_mem(__FILE__, __LINE__);				\
}
#endif

/* define macro for freeing memory */
#ifdef __STDC__
#define	FREE(mem_p)	free((void *)mem_p)
#else
#define	FREE(mem_p)	free((char *)mem_p)
#endif

/* convert a RATIONAL to a float */
#define RAT2FLOAT(rat)	( (float)(rat).n / (float)(rat).d )

/* the usual minimum and maximum macros */
#define MAX(a, b)	( (a) > (b) ? (a) : (b) )
#define MIN(a, b)	( (a) < (b) ? (a) : (b) )

/* absolute value of the difference of a and b */
#define ABSDIFF(a, b)	( (a) > (b) ? (a) - (b) : (b) - (a) )

/* even and odd numbers (positive, zero, or negative; works on any compiler) */
#define	EVEN(a)		(abs(a) % 2 == 0)
#define	ODD(a)		(abs(a) % 2 == 1)

#define SQUARED(x)	((x) * (x))
#define NEARESTQUARTER(x) ( (int)((x) * 4.0 + 0.5) / 4.0 )

/* half the height of a staff in stepsizes; use 1 for 1-line staffs */
#define HALFSTAFF(s)	((svpath(s, STAFFLINES)->stafflines == 5) ? 4 : 1)

/* given ptr to a group, return the NOTE struct for note nearest to the beam */
#define BNOTE(gs_p)	\
	(gs_p)->notelist[ (gs_p)->stemdir == UP ? 0 : (gs_p)->nnotes - 1 ]

/*
 * Define indices into GRPSYL.notelist for the first (FNNI) and last (LNNI)
 * non-cross-staff-stemmed notes.  Also define indices for the first (FCNI)
 * and last (LCNI) cross-staff-stemmed notes.
 *
 * For FNNI and LNNI to work, there must be non-CSS notes, although even if
 * not, it's still okay to have loops like 
 *	for (n = FNNI(gs_p); n <= LNNI(gs_p); n++)
 * and the NNN macro, which uses them, always works.
 *
 * LCNI and FCNI only work if there are CSS notes.
 */
#define	FNNI(gs_p)	((gs_p)->stemto == CS_ABOVE ?	\
			(gs_p)->stemto_idx + 1 : 0)
#define	LNNI(gs_p)	((gs_p)->stemto == CS_BELOW ?	\
			(gs_p)->stemto_idx - 1 : (gs_p)->nnotes - 1)
#define	FCNI(gs_p)	((gs_p)->stemto == CS_ABOVE ?	\
			0 : (gs_p)->stemto_idx)
#define	LCNI(gs_p)	((gs_p)->stemto == CS_BELOW ?	\
			(gs_p)->nnotes - 1 : (gs_p)->stemto_idx)

/* define the Number of Normal Notes (non-CSS notes) in a group */
#define NNN(gs_p)	(LNNI(gs_p) - FNNI(gs_p) + 1)

/* test whether the note given via the index is CSS */
#define IS_CSS_NOTE(gs_p, idx)	(					\
	(((gs_p)->stemto == CS_ABOVE && idx <= (gs_p)->stemto_idx) ||	\
	 ((gs_p)->stemto == CS_BELOW && idx >= (gs_p)->stemto_idx))	\
)

/* test whether any CSS notes that exist would be on stem side of the group */
#define STEMSIDE_CSS(gs_p)					\
	((gs_p)->stemto == CS_ABOVE && (gs_p)->stemdir == UP ||	\
	 (gs_p)->stemto == CS_BELOW && (gs_p)->stemdir == DOWN)

/*
 * Define CSS_STEPS to be an offset to be applied to "stepsup" when the note is
 * on the other staff.  It needs to be at least as big as the number of possible
 * notes (so that stepsup will become a value that it could never be for a
 * normal note), and it has to be an even number, because, for example, that
 * matters for vertical dot placement.
 */
#define CSS_STEPS	(((MAXHAND + 1) / 2) * 2)

/* is this FEED followed by a CLEFSIG (music), not a block? */
#define IS_CLEFSIG_FEED(mll_p) ((mll_p)->str == S_FEED && \
		(mll_p)->next != 0 && (mll_p)->next->str == S_CLEFSIG)

/*
 * This macro is to be used as in this example:
 *	extern int func P((int parm1, float parm2));
 * The ANSI version will result in a function prototype.  The other version
 * will result in a function declaration (no parameters).
 */
#ifdef __STDC__
#define	P(parms)	parms
#else
#define	P(parms)	()
#endif

#endif
