/**
 * Mupen64 - gcop1_d.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"

void genadd_d()
{
   gencallinterp((unsigned long)ADD_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fadd_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);*/
}

void gendiv_d()
{
   gencallinterp((unsigned long)DIV_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fdiv_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);*/
}

void gensub_d()
{
   gencallinterp((unsigned long)SUB_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fsub_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);*/
}

void genmul_d()
{
   gencallinterp((unsigned long)MUL_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fmul_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);*/
}

void genmov_d()
{
   gencallinterp((unsigned long)MOV_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   mov_reg32_preg32(EBX, EAX);
   add_reg32_imm8(EAX, 4);
   mov_reg32_preg32(ECX, EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   mov_preg32_reg32(EAX, EBX);
   add_reg32_imm8(EAX, 4);
   mov_preg32_reg32(EAX, ECX);
   genupdate_system(0);*/
}

void genneg_d()
{
   gencallinterp((unsigned long)NEG_D, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   fchs();
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);*/
}

void gencvt_s_d()
{
   gencallinterp((unsigned long)CVT_S_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_S_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gencvt_w_d()
{
   gencallinterp((unsigned long)CVT_W_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_W_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gentrunc_w_d()
{
   gencallinterp((unsigned long)TRUNC_W_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genc_le_d()
{
   gencallinterp((unsigned long)C_LE_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LE_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genc_lt_d()
{
   gencallinterp((unsigned long)C_LT_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LT_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genc_eq_d()
{
   gencallinterp((unsigned long)C_EQ_D, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_EQ_D));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gensqrt_d()
{
   gencallinterp((unsigned long)SQRT_D, 0);
}

void genabs_d()
{
   gencallinterp((unsigned long)ABS_D, 0);
}

void genround_l_d()
{
   gencallinterp((unsigned long)ROUND_L_D, 0);
}

void gentrunc_l_d()
{
   gencallinterp((unsigned long)TRUNC_L_D, 0);
}

void genceil_l_d()
{
   gencallinterp((unsigned long)CEIL_L_D, 0);
}

void genfloor_l_d()
{
   gencallinterp((unsigned long)FLOOR_L_D, 0);
}

void genround_w_d()
{
   gencallinterp((unsigned long)ROUND_W_D, 0);
}

void genceil_w_d()
{
   gencallinterp((unsigned long)CEIL_W_D, 0);
}

void genfloor_w_d()
{
   gencallinterp((unsigned long)FLOOR_W_D, 0);
}

void gencvt_l_d()
{
   gencallinterp((unsigned long)CVT_L_D, 0);
}

void genc_f_d()
{
   gencallinterp((unsigned long)C_F_D, 0);
}

void genc_un_d()
{
   gencallinterp((unsigned long)C_UN_D, 0);
}

void genc_ueq_d()
{
   gencallinterp((unsigned long)C_UEQ_D, 0);
}

void genc_olt_d()
{
   gencallinterp((unsigned long)C_OLT_D, 0);
}

void genc_ult_d()
{
   gencallinterp((unsigned long)C_ULT_D, 0);
}

void genc_ole_d()
{
   gencallinterp((unsigned long)C_OLE_D, 0);
}

void genc_ule_d()
{
   gencallinterp((unsigned long)C_ULE_D, 0);
}

void genc_sf_d()
{
   gencallinterp((unsigned long)C_SF_D, 0);
}

void genc_ngle_d()
{
   gencallinterp((unsigned long)C_NGLE_D, 0);
}

void genc_seq_d()
{
   gencallinterp((unsigned long)C_SEQ_D, 0);
}

void genc_ngl_d()
{
   gencallinterp((unsigned long)C_NGL_D, 0);
}

void genc_nge_d()
{
   gencallinterp((unsigned long)C_NGE_D, 0);
}

void genc_ngt_d()
{
   gencallinterp((unsigned long)C_NGT_D, 0);
}
