/**
 * Mupen64 - gcop1_s.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"
#include "../macros.h"


void gendiv_s()
{
   gencallinterp((unsigned long)DIV_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fdiv_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);*/
}

void genmov_s()
{
   gencallinterp((unsigned long)MOV_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   mov_reg32_preg32(EBX, EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   mov_preg32_reg32(EAX, EBX);
   genupdate_system(0);*/
}

void genneg_s()
{
   gencallinterp((unsigned long)NEG_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   fchs();
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);*/
}

void genabs_s()
{
   gencallinterp((unsigned long)ABS_S, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(ABS_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gencvt_d_s()
{
   gencallinterp((unsigned long)CVT_D_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_double) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_D_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genadd_s()
{
   gencallinterp((unsigned long)ADD_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fadd_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);*/
}

void gensub_s()
{
   gencallinterp((unsigned long)SUB_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fsub_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);*/
}

void gensqrt_s()
{
   gencallinterp((unsigned long)SQRT_S, 0);
   /*dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(SQRT_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genmul_s()
{
   gencallinterp((unsigned long)MUL_S, 0);
   /*dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fmul_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);*/
}

void genc_le_s()
{
   gencallinterp((unsigned long)C_LE_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(5);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LE_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genc_lt_s()
{
   gencallinterp((unsigned long)C_LT_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(69);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LT_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genc_eq_s()
{
   gencallinterp((unsigned long)C_EQ_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(68);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_EQ_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gentrunc_w_s()
{
   gencallinterp((unsigned long)TRUNC_W_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(&Status));
   and_eax_imm32(0x04000000);
   cmp_reg32_imm8(EAX, 0);
   je_rj(8);
   fistp_m64((unsigned long long int*)(&reg_cop1_fgr_64[dst->f.cf.fd]));
   jmp_imm_short(6);
   fistp_m32((unsigned long*)(&reg_cop1_fgr_32[dst->f.cf.fd]));*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void gencvt_w_s()
{
   gencallinterp((unsigned long)CVT_W_S, 0);
//   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(&Status));
   and_eax_imm32(0x04000000);
   cmp_reg32_imm8(EAX, 0);
   je_rj(8);
   fistp_m64((unsigned long long int*)(&reg_cop1_fgr_64[dst->f.cf.fd]));
   jmp_imm_short(6);
   fistp_m32((unsigned long*)(&reg_cop1_fgr_32[dst->f.cf.fd]));*/
/*   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_S));
   call_reg32(EAX);
   genupdate_system(0);*/
}

void genround_l_s()
{
   gencallinterp((unsigned long)ROUND_L_S, 0);
}

void gentrunc_l_s()
{
   gencallinterp((unsigned long)TRUNC_L_S, 0);
}

void genceil_l_s()
{
   gencallinterp((unsigned long)CEIL_L_S, 0);
}

void genfloor_l_s()
{
   gencallinterp((unsigned long)FLOOR_L_S, 0);
}

void genround_w_s()
{
   gencallinterp((unsigned long)ROUND_W_S, 0);
}

void genceil_w_s()
{
   gencallinterp((unsigned long)CEIL_W_S, 0);
}

void genfloor_w_s()
{
   gencallinterp((unsigned long)FLOOR_W_S, 0);
}

void gencvt_l_s()
{
   gencallinterp((unsigned long)CVT_L_S, 0);
}

void genc_f_s()
{
   gencallinterp((unsigned long)C_F_S, 0);
}

void genc_un_s()
{
   gencallinterp((unsigned long)C_UN_S, 0);
}

void genc_ueq_s()
{
   gencallinterp((unsigned long)C_UEQ_S, 0);
}

void genc_olt_s()
{
   gencallinterp((unsigned long)C_OLT_S, 0);
}

void genc_ult_s()
{
   gencallinterp((unsigned long)C_ULT_S, 0);
}

void genc_ole_s()
{
   gencallinterp((unsigned long)C_OLE_S, 0);
}

void genc_ule_s()
{
   gencallinterp((unsigned long)C_ULE_S, 0);
}

void genc_sf_s()
{
   gencallinterp((unsigned long)C_SF_S, 0);
}

void genc_ngle_s()
{
   gencallinterp((unsigned long)C_NGLE_S, 0);
}

void genc_seq_s()
{
   gencallinterp((unsigned long)C_SEQ_S, 0);
}

void genc_ngl_s()
{
   gencallinterp((unsigned long)C_NGL_S, 0);
}

void genc_nge_s()
{
   gencallinterp((unsigned long)C_NGE_S, 0);
}

void genc_ngt_s()
{
   gencallinterp((unsigned long)C_NGT_S, 0);
}
