/**
 * Mupen64 - gregimm.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "../recomp.h"
#include "../r4300.h"
#include "assemble.h"
#include "../ops.h"
#include "../../memory/memory.h"
#include "../macros.h"

void genbltz_test()
{
   int rs_64bit = is64((unsigned long *)dst->f.i.rs);
   
   if (!rs_64bit)
     {
	int rs = allocate_register((unsigned long *)dst->f.i.rs);
	
	cmp_reg32_imm32(rs, 0);
	jge_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
   else if (rs_64bit == -1)
     {
	cmp_m32_imm32(((unsigned long *)dst->f.i.rs)+1, 0);
	jge_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
   else
     {
	int rs2 = allocate_64_register2((unsigned long *)dst->f.i.rs);
	
	cmp_reg32_imm32(rs2, 0);
	jge_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
}

void genbltz()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZ, 1);
	return;
     }
   
   genbltz_test();
   gendelayslot();
   gentest();
}

void genbltz_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZ_OUT, 1);
	return;
     }
   
   genbltz_test();
   gendelayslot();
   gentest_out();
}

void genbltz_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZ_IDLE, 1);
	return;
     }
   
   genbltz_test();
   gentest_idle();
   genbltz();
}

void genbgez_test()
{
   int rs_64bit = is64((unsigned long *)dst->f.i.rs);
   
   if (!rs_64bit)
     {
	int rs = allocate_register((unsigned long *)dst->f.i.rs);
	
	cmp_reg32_imm32(rs, 0);
	jl_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
   else if (rs_64bit == -1)
     {
	cmp_m32_imm32(((unsigned long *)dst->f.i.rs)+1, 0);
	jl_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
   else
     {
	int rs2 = allocate_64_register2((unsigned long *)dst->f.i.rs);
	
	cmp_reg32_imm32(rs2, 0);
	jl_rj(12);
	mov_m32_imm32((unsigned long *)(&branch_taken), 1); // 10
	jmp_imm_short(10); // 2
	mov_m32_imm32((unsigned long *)(&branch_taken), 0); // 10
     }
}

void genbgez()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZ, 1);
	return;
     }
   
   genbgez_test();
   gendelayslot();
   gentest();
}

void genbgez_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZ_OUT, 1);
	return;
     }
   
   genbgez_test();
   gendelayslot();
   gentest_out();
}

void genbgez_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZ_IDLE, 1);
	return;
     }
   
   genbgez_test();
   gentest_idle();
   genbgez();
}

void genbltzl()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZL, 1);
	return;
     }
   
   genbltz_test();
   free_all_registers();
   gentestl();
}

void genbltzl_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZL_OUT, 1);
	return;
     }
   
   genbltz_test();
   free_all_registers();
   gentestl_out();
}

void genbltzl_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZL_IDLE, 1);
	return;
     }
   
   genbltz_test();
   gentest_idle();
   genbltzl();
}

void genbgezl()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZL, 1);
	return;
     }
   
   genbgez_test();
   free_all_registers();
   gentestl();
}

void genbgezl_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZL_OUT, 1);
	return;
     }
   
   genbgez_test();
   free_all_registers();
   gentestl_out();
}

void genbgezl_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZL_IDLE, 1);
	return;
     }
   
   genbgez_test();
   gentest_idle();
   genbgezl();
}

void genbranchlink()
{
   int r31_64bit = is64((unsigned long*)&reg[31]);
   
   if (!r31_64bit)
     {
	int r31 = allocate_register_w((unsigned long *)&reg[31]);
	
	mov_reg32_imm32(r31, dst->addr+8);
     }
   else if (r31_64bit == -1)
     {
	mov_m32_imm32((unsigned long *)&reg[31], dst->addr + 8);
	if (dst->addr & 0x80000000)
	  mov_m32_imm32(((unsigned long *)&reg[31])+1, 0xFFFFFFFF);
	else
	  mov_m32_imm32(((unsigned long *)&reg[31])+1, 0);
     }
   else
     {
	int r311 = allocate_64_register1_w((unsigned long *)&reg[31]);
	int r312 = allocate_64_register2_w((unsigned long *)&reg[31]);
	
	mov_reg32_imm32(r311, dst->addr+8);
	if (dst->addr & 0x80000000)
	  mov_reg32_imm32(r312, 0xFFFFFFFF);
	else
	  mov_reg32_imm32(r312, 0);
     }
}

void genbltzal()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZAL, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   gendelayslot();
   gentest();
}

void genbltzal_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZAL_OUT, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   gendelayslot();
   gentest_out();
}

void genbltzal_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZAL_IDLE, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   gentest_idle();
   genbltzal();
}

void genbgezal()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZAL, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   gendelayslot();
   gentest();
}

void genbgezal_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZAL_OUT, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   gendelayslot();
   gentest_out();
}

void genbgezal_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZAL_IDLE, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   gentest_idle();
   genbgezal();
}

void genbltzall()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZALL, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   free_all_registers();
   gentestl();
}

void genbltzall_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZALL_OUT, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   free_all_registers();
   gentestl_out();
}

void genbltzall_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BLTZALL_IDLE, 1);
	return;
     }
   
   genbltz_test();
   genbranchlink();
   gentest_idle();
   genbltzall();
}

void genbgezall()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZALL, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   free_all_registers();
   gentestl();
}

void genbgezall_out()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZALL_OUT, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   free_all_registers();
   gentestl_out();
}

void genbgezall_idle()
{
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)BGEZALL_IDLE, 1);
	return;
     }
   
   genbgez_test();
   genbranchlink();
   gentest_idle();
   genbgezall();
}
