/**
 * Mupen64 - gspecial.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "../recomp.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"
#include "../macros.h"
#include "../exception.h"

void gensll()
{
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd, rt);
   shl_reg32_imm8(rd, dst->f.r.sa);
}

void gensrl()
{
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd, rt);
   shr_reg32_imm8(rd, dst->f.r.sa);
}

void gensra()
{
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd, rt);
   sar_reg32_imm8(rd, dst->f.r.sa);
}

void gensllv()
{
   int rt, rd;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt = allocate_register((unsigned long *)dst->f.r.rt);
   rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rd != ECX)
     {
	mov_reg32_reg32(rd, rt);
	shl_reg32_cl(rd);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rt);
	shl_reg32_cl(temp);
	mov_reg32_reg32(rd, temp);
     }
}

void gensrlv()
{
   int rt, rd;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt = allocate_register((unsigned long *)dst->f.r.rt);
   rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rd != ECX)
     {
	mov_reg32_reg32(rd, rt);
	shr_reg32_cl(rd);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rt);
	shr_reg32_cl(temp);
	mov_reg32_reg32(rd, temp);
     }
}

void gensrav()
{
   int rt, rd;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt = allocate_register((unsigned long *)dst->f.r.rt);
   rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rd != ECX)
     {
	mov_reg32_reg32(rd, rt);
	sar_reg32_cl(rd);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rt);
	sar_reg32_cl(temp);
	mov_reg32_reg32(rd, temp);
     }
}

void genjr()
{
   static unsigned long precomp_instr_size = sizeof(precomp_instr);
   unsigned long diff = 
     (unsigned long)(&dst->local_addr) - (unsigned long)(dst);
   unsigned long diff_need = 
     (unsigned long)(&dst->reg_cache_infos.need_map) - (unsigned long)(dst);
   unsigned long diff_wrap = 
     (unsigned long)(&dst->reg_cache_infos.jump_wrapper) - (unsigned long)(dst);
   unsigned long temp, temp2;
   
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)JR, 1);
	return;
     }
   
   free_all_registers();
   mov_eax_memoffs32((unsigned long *)dst->f.i.rs);
   mov_memoffs32_eax((unsigned long *)&local_rs);
   
   gendelayslot();
   
   mov_eax_memoffs32((unsigned long *)&local_rs);
   mov_memoffs32_eax((unsigned long *)&last_addr);
   
   gencheck_interupt_reg();
   
   mov_eax_memoffs32((unsigned long *)&local_rs);
   mov_reg32_reg32(EBX, EAX);
   and_eax_imm32(0xFFFFF000);
   cmp_eax_imm32(dst_block->start & 0xFFFFF000);
   je_near_rj(0);
   temp = code_length;
   
   mov_m32_reg32(&jump_to_address, EBX);
   mov_m32_imm32((unsigned long*)(&PC), (unsigned long)(dst+1));
   mov_reg32_imm32(EAX, (unsigned long)jump_to_func);
   call_reg32(EAX);
   
   temp2 = code_length;
   code_length = temp-4;
   put32(temp2 - temp);
   code_length = temp2;
   
   mov_reg32_reg32(EAX, EBX);
   sub_eax_imm32(dst_block->start);
   shr_reg32_imm8(EAX, 2);
   mul_m32((unsigned long *)(&precomp_instr_size));
   
   mov_reg32_preg32pimm32(EBX, EAX, (unsigned long)(dst_block->block)+diff_need);
   cmp_reg32_imm32(EBX, 1);
   jne_rj(7);
   
   add_eax_imm32((unsigned long)(dst_block->block)+diff_wrap); // 5
   jmp_reg32(EAX); // 2
   
   mov_reg32_preg32pimm32(EAX, EAX, (unsigned long)(dst_block->block)+diff);
   add_reg32_m32(EAX, (unsigned long *)(&dst_block->code));
   
   jmp_reg32(EAX);
}

void genjalr()
{
   static unsigned long precomp_instr_size = sizeof(precomp_instr);
   unsigned long diff = 
     (unsigned long)(&dst->local_addr) - (unsigned long)(dst);
   unsigned long diff_need = 
     (unsigned long)(&dst->reg_cache_infos.need_map) - (unsigned long)(dst);
   unsigned long diff_wrap = 
     (unsigned long)(&dst->reg_cache_infos.jump_wrapper) - (unsigned long)(dst);
   unsigned long temp, temp2;
   
   if (((dst->addr & 0xFFF) == 0xFFC && 
       (dst->addr < 0x80000000 || dst->addr >= 0xC0000000))||no_compiled_jump)
     {
	gencallinterp((unsigned long)JALR, 1);
	return;
     }
   
   free_all_registers();
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_memoffs32_eax((unsigned long *)&local_rs);
   
   gendelayslot();
   
   mov_m32_imm32((unsigned long *)(dst-1)->f.r.rd, dst->addr+4);
   if ((dst->addr+4) & 0x80000000)
     mov_m32_imm32(((unsigned long *)(dst-1)->f.r.rd)+1, 0xFFFFFFFF);
   else
     mov_m32_imm32(((unsigned long *)(dst-1)->f.r.rd)+1, 0);
   
   mov_eax_memoffs32((unsigned long *)&local_rs);
   mov_memoffs32_eax((unsigned long *)&last_addr);
   
   gencheck_interupt_reg();
   
   mov_eax_memoffs32((unsigned long *)&local_rs);
   mov_reg32_reg32(EBX, EAX);
   and_eax_imm32(0xFFFFF000);
   cmp_eax_imm32(dst_block->start & 0xFFFFF000);
   je_near_rj(0);
   temp = code_length;
   
   mov_m32_reg32(&jump_to_address, EBX);
   mov_m32_imm32((unsigned long*)(&PC), (unsigned long)(dst+1));
   mov_reg32_imm32(EAX, (unsigned long)jump_to_func);
   call_reg32(EAX);
   
   temp2 = code_length;
   code_length = temp-4;
   put32(temp2 - temp);
   code_length = temp2;
   
   mov_reg32_reg32(EAX, EBX);
   sub_eax_imm32(dst_block->start);
   shr_reg32_imm8(EAX, 2);
   mul_m32((unsigned long *)(&precomp_instr_size));
   
   mov_reg32_preg32pimm32(EBX, EAX, (unsigned long)(dst_block->block)+diff_need);
   cmp_reg32_imm32(EBX, 1);
   jne_rj(7);
   
   add_eax_imm32((unsigned long)(dst_block->block)+diff_wrap); // 5
   jmp_reg32(EAX); // 2
   
   mov_reg32_preg32pimm32(EAX, EAX, (unsigned long)(dst_block->block)+diff);
   add_reg32_m32(EAX, (unsigned long *)(&dst_block->code));
   
   jmp_reg32(EAX);
}

void gensyscall()
{
   free_all_registers();
   mov_m32_imm32(&Cause, 8 << 2);
   gencallinterp((unsigned long)exception_general, 0);
}

void gensync()
{
}

void genmfhi()
{
   int rd1 = allocate_64_register1_w((unsigned long*)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long*)dst->f.r.rd);
   int hi1 = allocate_64_register1((unsigned long*)&hi);
   int hi2 = allocate_64_register2((unsigned long*)&hi);
   
   mov_reg32_reg32(rd1, hi1);
   mov_reg32_reg32(rd2, hi2);
}

void genmthi()
{
   int hi1 = allocate_64_register1_w((unsigned long*)&hi);
   int hi2 = allocate_64_register2_w((unsigned long*)&hi);
   int rs1 = allocate_64_register1((unsigned long*)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long*)dst->f.r.rs);
   
   mov_reg32_reg32(hi1, rs1);
   mov_reg32_reg32(hi2, rs2);
}

void genmflo()
{
   int rd1 = allocate_64_register1_w((unsigned long*)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long*)dst->f.r.rd);
   int lo1 = allocate_64_register1((unsigned long*)&lo);
   int lo2 = allocate_64_register2((unsigned long*)&lo);
   
   mov_reg32_reg32(rd1, lo1);
   mov_reg32_reg32(rd2, lo2);
}

void genmtlo()
{
   int lo1 = allocate_64_register1_w((unsigned long*)&lo);
   int lo2 = allocate_64_register2_w((unsigned long*)&lo);
   int rs1 = allocate_64_register1((unsigned long*)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long*)dst->f.r.rs);
   
   mov_reg32_reg32(lo1, rs1);
   mov_reg32_reg32(lo2, rs2);
}

void gendsllv()
{
   int rt1, rt2, rd1, rd2;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rd1 != ECX && rd2 != ECX)
     {
	mov_reg32_reg32(rd1, rt1);
	mov_reg32_reg32(rd2, rt2);
	shld_reg32_reg32_cl(rd2,rd1);
	shl_reg32_cl(rd1);
	test_reg32_imm32(ECX, 0x20);
	je_rj(4);
	mov_reg32_reg32(rd2, rd1); // 2
	xor_reg32_reg32(rd1, rd1); // 2
     }
   else
     {
	int temp1, temp2;
	force_32(ECX);
	temp1 = lru_register();
	temp2 = lru_register_exc1(temp1);
	free_register(temp1);
	free_register(temp2);
	
	mov_reg32_reg32(temp1, rt1);
	mov_reg32_reg32(temp2, rt2);
	shld_reg32_reg32_cl(temp2, temp1);
	shl_reg32_cl(temp1);
	test_reg32_imm32(ECX, 0x20);
	je_rj(4);
	mov_reg32_reg32(temp2, temp1); // 2
	xor_reg32_reg32(temp1, temp1); // 2
	
	mov_reg32_reg32(rd1, temp1);
	mov_reg32_reg32(rd2, temp2);
     }
}

void gendsrlv()
{
   int rt1, rt2, rd1, rd2;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rd1 != ECX && rd2 != ECX)
     {
	mov_reg32_reg32(rd1, rt1);
	mov_reg32_reg32(rd2, rt2);
	shrd_reg32_reg32_cl(rd1,rd2);
	shr_reg32_cl(rd2);
	test_reg32_imm32(ECX, 0x20);
	je_rj(4);
	mov_reg32_reg32(rd1, rd2); // 2
	xor_reg32_reg32(rd2, rd2); // 2
     }
   else
     {
	int temp1, temp2;
	force_32(ECX);
	temp1 = lru_register();
	temp2 = lru_register_exc1(temp1);
	free_register(temp1);
	free_register(temp2);
	
	mov_reg32_reg32(temp1, rt1);
	mov_reg32_reg32(temp2, rt2);
	shrd_reg32_reg32_cl(temp1, temp2);
	shr_reg32_cl(temp2);
	test_reg32_imm32(ECX, 0x20);
	je_rj(4);
	mov_reg32_reg32(temp1, temp2); // 2
	xor_reg32_reg32(temp2, temp2); // 2
	
	mov_reg32_reg32(rd1, temp1);
	mov_reg32_reg32(rd2, temp2);
     }
}

void gendsrav()
{
   int rt1, rt2, rd1, rd2;
   allocate_register_manually(ECX, (unsigned long *)dst->f.r.rs);
   
   rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rd1 != ECX && rd2 != ECX)
     {
	mov_reg32_reg32(rd1, rt1);
	mov_reg32_reg32(rd2, rt2);
	shrd_reg32_reg32_cl(rd1,rd2);
	sar_reg32_cl(rd2);
	test_reg32_imm32(ECX, 0x20);
	je_rj(5);
	mov_reg32_reg32(rd1, rd2); // 2
	sar_reg32_imm8(rd2, 31); // 3
     }
   else
     {
	int temp1, temp2;
	force_32(ECX);
	temp1 = lru_register();
	temp2 = lru_register_exc1(temp1);
	free_register(temp1);
	free_register(temp2);
	
	mov_reg32_reg32(temp1, rt1);
	mov_reg32_reg32(temp2, rt2);
	shrd_reg32_reg32_cl(temp1, temp2);
	sar_reg32_cl(temp2);
	test_reg32_imm32(ECX, 0x20);
	je_rj(5);
	mov_reg32_reg32(temp1, temp2); // 2
	sar_reg32_imm8(temp2, 31); // 3
	
	mov_reg32_reg32(rd1, temp1);
	mov_reg32_reg32(rd2, temp2);
     }
}

void genmult()
{
   int rs, rt;
   allocate_register_manually_w(EAX, (unsigned long *)&lo, 0);
   allocate_register_manually_w(EDX, (unsigned long *)&hi, 0);
   rs = allocate_register((unsigned long*)dst->f.r.rs);
   rt = allocate_register((unsigned long*)dst->f.r.rt);
   mov_reg32_reg32(EAX, rs);
   imul_reg32(rt);
}

void genmultu()
{
   int rs, rt;
   allocate_register_manually_w(EAX, (unsigned long *)&lo, 0);
   allocate_register_manually_w(EDX, (unsigned long *)&hi, 0);
   rs = allocate_register((unsigned long*)dst->f.r.rs);
   rt = allocate_register((unsigned long*)dst->f.r.rt);
   mov_reg32_reg32(EAX, rs);
   mul_reg32(rt);
}

void gendiv()
{
   int rs, rt;
   allocate_register_manually_w(EAX, (unsigned long *)&lo, 0);
   allocate_register_manually_w(EDX, (unsigned long *)&hi, 0);
   rs = allocate_register((unsigned long*)dst->f.r.rs);
   rt = allocate_register((unsigned long*)dst->f.r.rt);
   mov_reg32_reg32(EAX, rs);
   cdq();
   idiv_reg32(rt);
}

void gendivu()
{
   int rs, rt;
   allocate_register_manually_w(EAX, (unsigned long *)&lo, 0);
   allocate_register_manually_w(EDX, (unsigned long *)&hi, 0);
   rs = allocate_register((unsigned long*)dst->f.r.rs);
   rt = allocate_register((unsigned long*)dst->f.r.rt);
   mov_reg32_reg32(EAX, rs);
   xor_reg32_reg32(EDX, EDX);
   div_reg32(rt);
}

void gendmult()
{
   gencallinterp((unsigned long)DMULT, 0);
}

void gendmultu()
{
   free_all_registers();
   
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mul_m32((unsigned long *)dst->f.r.rt); // EDX:EAX = temp1
   mov_memoffs32_eax((unsigned long *)(&lo));
   
   mov_reg32_reg32(EBX, EDX); // EBX = temp1>>32
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EBX, EAX);
   adc_reg32_imm32(EDX, 0);
   mov_reg32_reg32(ECX, EDX); // ECX:EBX = temp2
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)dst->f.r.rt); // EDX:EAX = temp3
   
   add_reg32_reg32(EBX, EAX);
   adc_reg32_imm32(ECX, 0); // ECX:EBX = result2
   mov_m32_reg32((unsigned long*)(&lo)+1, EBX);
   
   mov_reg32_reg32(ESI, EDX); // ESI = temp3>>32
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EAX, ESI);
   adc_reg32_imm32(EDX, 0); // EDX:EAX = temp4
   
   add_reg32_reg32(EAX, ECX);
   adc_reg32_imm32(EDX, 0); // EDX:EAX = result3
   mov_memoffs32_eax((unsigned long *)(&hi));
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
}

void genddiv()
{
   gencallinterp((unsigned long)DDIV, 0);
}

void genddivu()
{
   gencallinterp((unsigned long)DDIVU, 0);
}

void genadd()
{
   int rs = allocate_register((unsigned long *)dst->f.r.rs);
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rt != rd && rs != rd)
     {
	mov_reg32_reg32(rd, rs);
	add_reg32_reg32(rd, rt);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs);
	add_reg32_reg32(temp, rt);
	mov_reg32_reg32(rd, temp);
     }
}

void genaddu()
{
   int rs = allocate_register((unsigned long *)dst->f.r.rs);
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rt != rd && rs != rd)
     {
	mov_reg32_reg32(rd, rs);
	add_reg32_reg32(rd, rt);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs);
	add_reg32_reg32(temp, rt);
	mov_reg32_reg32(rd, temp);
     }
}

void gensub()
{
   int rs = allocate_register((unsigned long *)dst->f.r.rs);
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rt != rd && rs != rd)
     {
	mov_reg32_reg32(rd, rs);
	sub_reg32_reg32(rd, rt);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs);
	sub_reg32_reg32(temp, rt);
	mov_reg32_reg32(rd, temp);
     }
}

void gensubu()
{
   int rs = allocate_register((unsigned long *)dst->f.r.rs);
   int rt = allocate_register((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   if (rt != rd && rs != rd)
     {
	mov_reg32_reg32(rd, rs);
	sub_reg32_reg32(rd, rt);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs);
	sub_reg32_reg32(temp, rt);
	mov_reg32_reg32(rd, temp);
     }
}

void genand()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	and_reg32_reg32(rd1, rt1);
	and_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	and_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	and_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void genor()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	or_reg32_reg32(rd1, rt1);
	or_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	or_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	or_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void genxor()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	xor_reg32_reg32(rd1, rt1);
	xor_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	xor_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	xor_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void gennor()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	or_reg32_reg32(rd1, rt1);
	or_reg32_reg32(rd2, rt2);
	not_reg32(rd1);
	not_reg32(rd2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	or_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	or_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
	not_reg32(rd1);
	not_reg32(rd2);
     }
}

void genslt()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   cmp_reg32_reg32(rs2, rt2);
   jl_rj(13);
   jne_rj(4); // 2
   cmp_reg32_reg32(rs1, rt1); // 2
   jl_rj(7); // 2
   mov_reg32_imm32(rd, 0); // 5
   jmp_imm_short(5); // 2
   mov_reg32_imm32(rd, 1); // 5
}

void gensltu()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   cmp_reg32_reg32(rs2, rt2);
   jb_rj(13);
   jne_rj(4); // 2
   cmp_reg32_reg32(rs1, rt1); // 2
   jb_rj(7); // 2
   mov_reg32_imm32(rd, 0); // 5
   jmp_imm_short(5); // 2
   mov_reg32_imm32(rd, 1); // 5
}

void gendadd()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	add_reg32_reg32(rd1, rt1);
	adc_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	add_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	adc_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void gendaddu()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	add_reg32_reg32(rd1, rt1);
	adc_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	add_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	adc_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void gendsub()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	sub_reg32_reg32(rd1, rt1);
	sbb_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	sub_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	sbb_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void gendsubu()
{
   int rs1 = allocate_64_register1((unsigned long *)dst->f.r.rs);
   int rs2 = allocate_64_register2((unsigned long *)dst->f.r.rs);
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   if (rt1 != rd1 && rs1 != rd1)
     {
	mov_reg32_reg32(rd1, rs1);
	mov_reg32_reg32(rd2, rs2);
	sub_reg32_reg32(rd1, rt1);
	sbb_reg32_reg32(rd2, rt2);
     }
   else
     {
	int temp = lru_register();
	free_register(temp);
	mov_reg32_reg32(temp, rs1);
	sub_reg32_reg32(temp, rt1);
	mov_reg32_reg32(rd1, temp);
	mov_reg32_reg32(temp, rs2);
	sbb_reg32_reg32(temp, rt2);
	mov_reg32_reg32(rd2, temp);
     }
}

void genteq()
{
   gencallinterp((unsigned long)TEQ, 0);
}

void gendsll()
{
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd1, rt1);
   mov_reg32_reg32(rd2, rt2);
   shld_reg32_reg32_imm8(rd2, rd1, dst->f.r.sa);
   shl_reg32_imm8(rd1, dst->f.r.sa);
   if (dst->f.r.sa & 0x20)
     {
	mov_reg32_reg32(rd2, rd1);
	xor_reg32_reg32(rd1, rd1);
     }
}

void gendsrl()
{
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd1, rt1);
   mov_reg32_reg32(rd2, rt2);
   shrd_reg32_reg32_imm8(rd1, rd2, dst->f.r.sa);
   shr_reg32_imm8(rd2, dst->f.r.sa);
   if (dst->f.r.sa & 0x20)
     {
	mov_reg32_reg32(rd1, rd2);
	xor_reg32_reg32(rd2, rd2);
     }
}

void gendsra()
{
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd1, rt1);
   mov_reg32_reg32(rd2, rt2);
   shrd_reg32_reg32_imm8(rd1, rd2, dst->f.r.sa);
   sar_reg32_imm8(rd2, dst->f.r.sa);
   if (dst->f.r.sa & 0x20)
     {
	mov_reg32_reg32(rd1, rd2);
	sar_reg32_imm8(rd2, 31);
     }
}

void gendsll32()
{
   int rt1 = allocate_64_register1((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd2, rt1);
   shl_reg32_imm8(rd2, dst->f.r.sa);
   xor_reg32_reg32(rd1, rd1);
}

void gendsrl32()
{
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd1 = allocate_64_register1_w((unsigned long *)dst->f.r.rd);
   int rd2 = allocate_64_register2_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd1, rt2);
   shr_reg32_imm8(rd1, dst->f.r.sa);
   xor_reg32_reg32(rd2, rd2);
}

void gendsra32()
{
   int rt2 = allocate_64_register2((unsigned long *)dst->f.r.rt);
   int rd = allocate_register_w((unsigned long *)dst->f.r.rd);
   
   mov_reg32_reg32(rd, rt2);
   sar_reg32_imm8(rd, dst->f.r.sa);
}
