/*
* all or most callbacks live here
*
* $Id: callbacks.c,v 1.5 2000/03/07 05:50:18 kline Exp kline $
*/
#include "globals.h"
#include "muuz.h"
#include "muuztypes.h"
#include "muuzerror.h"
#include "xbm.h"
#include "xfonts.h"
#include <sys/types.h>
#include <signal.h>

#include "errMessage.h"
#include "cancelconfirm.h"
#include "do_colors.h"
#include "callbacks.h"
#include "structs.h"
#include "creativity.h"
#include "relaxation.h"
#include "meditation.h"
#include "learning.h"
#include "fun.h"
#include "energize.h"
#include "sleep.h"
#include "flashForm.h"
#include "muuzaudio.h"
#include "mixerControls.h"
#include "setAudioValues.h"
#include "flashes.h"
#include "misc.h"
#include "main.h"
#include "prepcallbacks.h"
#include "copyright.h"

extern errMessage program;  // for emsg()
int skipTimeOut = 0;

boolean settingPrepVolume = off;
boolean settingPrepAudioOnly = off;
boolean settingPrepVideoOnly = off;



#ifdef UNDERDEVEL
class dLabel
{
  private:
  public:
    void displayLabel(int &mode, const int n, Widget &dw, char s[], int d);
};


int n= 0;
Arg wargs[10];
 
if (muuzmode++ >= 2) muuzmode = 0; 
XtSetArg(wargs[n], XtNlabel, avDisplayLabels[muuzmode] ); n++;
XtSetValues(displayAv, wargs, n);
 
void
displayLabel(int &mode, const int n, Widget &dw, char s[], int direction)
{
  int nargs = 0;
  Arg wargs[n];
if (direction == UP)
if (mode++ >= n) mode = 0;
else
if (mode-- <= 0) mode = n;
XtSetArg(wargs[nargs], XtNlabel, s[mode]); nargs++;
 
program.emsg(nprint,
  "DEBUG: in = (%d), wargs[nargs] = (0%o), nargs = (%d), dw = (0%o)\n",
n, wargs[nargs], nargs, dw);
 
XtSetValues(dw, wargs, nargs);
}
#endif //UNDERDEVEL

void
pmuuz()
{
  switch (muuzmode)
  {
  case AUDIO:
    program.emsg(nprint, "muuzmode == AUDIO");
    break;
  case VIDEO:
    program.emsg(nprint, "muuzmode == VIDEO");
    break;
  case AUDIOVIDEO:
    program.emsg(nprint, "muuzmode == AUDIOVIDEO");
    break;
  }
}

/*  DEBUG for callback.c */
static short int inPrepSection = 0;

static int saveRightChannel = 10, saveLeftChannel = 10;


/* are all modes and all select flags set or zero? */

int allmodes, allflags;

category_t programCategory;  /* categories of program; fewer than 20 */
XtIntervalId pausetimeout;
toggle controlpanelstate = off;
char    *avDisplayLabels[] = {"  Audio  ", "  Video  ", "   A+V   "};

char    *colorsDisplayLabels[] = {"  White  ", " Yellow ", " Orange ",
                                  " Pink  ", " Skyblue "};

char *hertzDisplayLabels[] =
  {
    "1 Delta   ", "2 Delta", "3 Delta", "4 Theta", "5 Theta", "6 Theta",
    "7 Theta", "8 Altheta","9 Alpha","10 Alpha", "11 Alpha","12 Alpha",
    "13 Alpha", "14 Beta", "15 Beta", "16 Beta", "17 Beta", "18 Beta",
    "19 Beta", "20 Beta", "21 Beta", "22 Beta", "23 Beta", "24 Beta",
    "25 Beta", "26 Beta", "27 Beta", "28 Beta", "29 Beta", "30 Beta"
  };


/*
* Blank Programs window with space '\040' each new Selection 
*  this initialized the window length (width) to accomodate
*  the many selection-name-strings (like "New Mindset", 
*  "zazen", "Before Study", &c.
*/
char *blankProgWin="                  ";

char *pitchDisplayLabels[] = {"      Lowest       ", "Medium Low","Medium High",
                              "Highest"};
char *prepTopicsButtonLabel[] =
  {
    "                  ",   /* blank the 0th entry */
    "    Creativity    ",
    "    Learning      ",
    "    Relaxation    ",
    "    Meditation    ",
    "      Sleep       ",
    "     Energize     ",
    "       Fun        ",
    (char *) 0
  };

char    *sspDisplayLabels[] = {"    Stop   ", "  Play   ", "  Pause  "};

char  *volumeDisplayLabels[] = {" OFF ", " 10 10 ", " 20 20 ", " 30 30 ", " 40 40 ", " 50 50 ", " 60 60 ", " 70 70 ", " 80 80 ", " 90 90 ", "100 100"};


action_t sspmode;
audiovideo_t muuzmode;
colors_t colorsmode;
volume_t  volume;


Widget selectionup_button, selectiondown_button, progup_button,
progdown_button;

Widget  form, menuform, formbox0, formbox1, formbox2, formbox3, /*FORMS*/
formtopic, formprogram;


Widget displayColors, displayHertz, displayPitch, displayPrep,
displayAv, displayProg, displaymode, displayAction, displayVolume;

Widget labelDesc, labelProgram, labelProgdescription, labelSelection;

XFontStruct     *selectionFont, *programFont;
XFontStruct     *init_font(Display *, const char *);


/*
* controlWidget Fonts here for global declaration.
*/
XFontStruct  *avDisplayFont, *colorsDisplayFont, *hertzDisplayFont,
*pitchDisplayFont, *sspDisplayFont, *volumeDisplayFont;


Widget  DownArrow, UpArrow;


/*
* begin av up/down button CB functions
*/
void
avdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  void test(int &mode, const int n, Arg &wargs, Widget w, char s[], int);
  mixerControls saudio;
  audioValues setAudio;
  int n = 0;
  Arg wargs[10];
  flashForm forFlash;
  void XMuuzMessagePopupHandler(char *);


  if ( prepstate == on && adjustflag == off)
  {
    XMuuzMessagePopupHandler(M_ADJUST);
    return;
  }

  if (muuzmode-- <= 0) muuzmode = 2;
  XtSetArg(wargs[n], XtNlabel, avDisplayLabels[muuzmode] );
  n++;
  XtSetValues(displayAv, wargs, n);


  switch (muuzmode)
  {
  case AUDIO:
    program.emsg(nprint, "\t\t\tAt AudioDown: sspmode = (%d)\n", sspmode);
    saudio.ZXMuuzGetChannel();
    do_once = 0;
    if (sspmode == PLAY)
    {
      skipTimeOut = 0;
      //audio = 1, video = 0, audiovideo = 0;
      forFlash.setFormSlategrey();
    }
    setAudio.displayCurrentVolume();
    if (settingPrepVideoOnly==on)
    {
      settingPrepVideoOnly = off;
    }
    if (prepstate == on && adjustflag == on)
    {
      settingPrepAudioOnly = on;  // A_O
    }
    program.emsg(nprint, "debDOWN: prepAudio = %s\nprepVideo = %s\n",
      settingPrepAudioOnly==on?"on":"off", settingPrepVideoOnly==on?"on":"off");

    break;
  case VIDEO:
    program.emsg(nprint, "At Video: sspmode = (%d)", sspmode);
    saudio.ZXMuuzGetChannel();
    do_once = 0;
    if (sspmode == PLAY)
    {
      if (beatsPid)
      {
	puts("coming from audio: beats:: Killing #100");
	kill(beatsPid, SIGINT);
      }
      skipTimeOut = 0;
    }

    //audio = 0, video = 1, audiovideo = 0;
    if (settingPrepAudioOnly==on)
    {
      settingPrepAudioOnly = off;
    }

    if (prepstate == on && adjustflag == on)
    {
      settingPrepVideoOnly = on;  // A_O
    }
    program.emsg(nprint, "debDOWN: prepAudio = %s\nprepVideo = %s\n",
      settingPrepAudioOnly==on?"on":"off",settingPrepVideoOnly==on?"on":"off");
    break;
  case AUDIOVIDEO:
    do_once = 0;
    saudio.ZXMuuzGetChannel();  // debug to stdout
    program.emsg(nprint, "A+V: sspmode = (%d)\n", sspmode);
    if (sspmode == PLAY)
    {
      program.emsg(nprint, "HITTING: saveright = ((%d)), saveleft = ((%d))\n",
                   saveRightChannel, saveLeftChannel);
    }
    if (flashing == 0)
    {
      {
        program.emsg(nprint,"A+V-down: PLAY & No FLASH, hits timeout",_fl_);
        skipTimeOut=0;
        program.emsg(nprint, "\n\n\tA+V_DOWN and 0L\n\n", _fl_ );
        timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
      }
    }
    //audio = 0, video = 0, audiovideo = 1;
    if (settingPrepAudioOnly==on)
    {
      settingPrepAudioOnly = off;
    }
    if (settingPrepVideoOnly==on)
    {
      settingPrepVideoOnly = off;
    }
    setAudio.displayCurrentVolume();
    break;
  }
}

#ifdef W_DEVEL
void test (int &mode, const int n, Arg &wargs, Widget w, char s[], int direction)
{
  Arg Wargs[1];
  int nargs =0; 
 
  program.emsg(nprint,"mode= (%d), n =(%d), wargs = (0%o), w = 0%o, s = [%s]\n",
    mode, n, wargs, w, s);
  program.emsg(nprint, "Wargs = (0%o), *Wargs = (0%o)\n", Wargs, *Wargs);
if (direction == UP)
{
puts("In UP");
if (mode++ >= n) mode = 0;
XtSetArg(Wargs[nargs], XtNlabel, s ); nargs++;
XtSetValues(w, Wargs, nargs);
 
}
else
{
if (muuzmode-- <= 0) muuzmode = 2;
XtSetArg(Wargs[nargs], XtNlabel, s ); nargs++;
XtSetValues(w, Wargs, nargs);
}
 
}
#endif // W_DEVEL



void
avup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  mixerControls saudio;
  audioValues setAudio;
  flashForm forFlash;
  int n= 0;
  Arg wargs[1];
  void XMuuzMessagePopupHandler(char *);


  if ( prepstate == on && adjustflag == off)
  {
    XMuuzMessagePopupHandler(M_ADJUST);
    return;
  }

  program.emsg(nprint, "debUP: prepAudio = %d\nprepVideo = %d\n",
    settingPrepAudioOnly, settingPrepVideoOnly);


  if (muuzmode++ >= 2) muuzmode = 0;
  XtSetArg(wargs[n], XtNlabel, avDisplayLabels[muuzmode] );
  n++;
  XtSetValues(displayAv, wargs, n);

  switch (muuzmode)
  {
  case AUDIO:
    program.emsg(nprint, "\t\t\tAt AudioUP: sspmode = (%d)\n", sspmode );
    saudio.ZXMuuzGetChannel();
    do_once = 0;
    if (sspmode == PLAY)
    {
      skipTimeOut=0;
      //audio = 1, video = 0, audiovideo = 0;
      forFlash.setFormSlategrey();
    }
    setAudio.displayCurrentVolume();
    if (settingPrepVideoOnly==on)
    {
      settingPrepVideoOnly = off;
    }
    if (prepstate == on && adjustflag == on)
    {
      settingPrepAudioOnly = on;  // A_O
    }
  program.emsg(nprint, "DebUP: prepAudio = %s\nprepVideo = %s\n",
    settingPrepAudioOnly==on?"on":"off", settingPrepVideoOnly==on?"on":"off");
    break;
  case VIDEO:
    program.emsg(nprint, "At Video sspmode = (%d)\n", sspmode );
    saudio.ZXMuuzGetChannel();
    do_once = 0;
    if (sspmode == PLAY)
    {
      skipTimeOut = 0;
      if (beatsPid)
      {
	puts("coming from audio: beats:: Killing #101");
	kill(beatsPid, SIGINT);
      }
      if (!flashing)
      {
        program.emsg(nprint,"\t\tVIDEO: !flashing: CALLING timeout_proc()",_fl_);
        timeout = XtAppAddTimeOut(app, (1/interval)*1000,timeout_proc, NULL);
      }
    }

    if (settingPrepAudioOnly==on)
    {
      settingPrepAudioOnly = off;
    }
    //audio = 0, video = 1, audiovideo = 0;
    if (prepstate == on && adjustflag == on)
    {
      settingPrepVideoOnly = on;  // A_O
    }
    break;
  case AUDIOVIDEO:
    program.emsg(nprint, "A+V: killing");
    do_once = 0;
    saudio.ZXMuuzGetChannel();  // debug to stdout
    if (sspmode == PLAY)
    {
      program.emsg(nprint, "HITTING: saveright = ((%d)), saveleft = ((%d))\n",
                   saveRightChannel, saveLeftChannel);

    }
    if (flashing == 0)
    {
      {
        program.emsg(nprint,"\t\t A+V_UP: No FLASH, hitting timeout",_fl_);
        skipTimeOut=0;
        timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
      }
    }
    //audio = 0, video = 0, audiovideo = 1;
    if (settingPrepAudioOnly==on)
    {
      settingPrepAudioOnly = off;
    }
    if (settingPrepVideoOnly==on)
    {
      settingPrepVideoOnly = off;
    }
    setAudio.displayCurrentVolume();
    break;
  }
}

/*
* end av up/down button CB functions
*/


/*
* begin ssp up/down button CB functions
*/
void
sspdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  audioValues setAudio;
  mixerControls saudio;
  /* mode is the number of pushes mod the number of possible modes */
  int n = 0;
  Arg wargs[10];
  char chooseProgram[] = NP_ERR;
  flashForm forFlash;


  allflagsState();
  allmodesState();
  sspmode--;  /* move down */

  if (prepstate == on)
  {
    if (sspmode < STOP)
      if (allflags == 0 && allmodes == 0)
      {
        char progsetErrstring[] = NSP_ERR;
        XMuuzErrHandler( progsetErrstring );
        sspmode++;
        return;
      }
  }
  program.emsg(nprint, "sspdown_button: sspmode = (%d), playing = (%d)\n", sspmode,playing,_fl_);

  if (sspmode < 0) sspmode = 2;
  XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
  n++;
  XtSetValues(displayAction, wargs, n);
  switch (sspmode)
  {
  case STOP:
    if (beatsPid)
    {
      puts("calling kill #10:: STOP");
      kill(beatsPid, SIGINT);
    }
    if (pausecount != 0 || Pause == 1)
    {
      XtRemoveTimeOut (pausetimeout);
      pausecount = 0;
    }
    forFlash.setFormColor(SLATEGREY);
    stop = 1, Pause = 0, play = 0;
    break;
  case PLAY:
    skipTimeOut=0;
    if (pausecount != 0)
    {
      XtRemoveTimeOut (pausetimeout);
    }
    play = 1, stop = 0, Pause = 0;
    //program.emsg(nprint, "PLAYDEB: case PLAY:  muuzmode = (%d)\n", muuzmode,_fl_);
    do_once = 0;
    timeout = XtAppAddTimeOut(app, (1/interval)*1000,timeout_proc, NULL);
    if (ccr_flag == 1)
    {
      if (ccr < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_creative(ccr);
    }
    if (crx_flag == 1)
    {
      if (crx < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_relaxation(crx);
    }
    else if (clr_flag == 1)
    {
      if (clr < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_learning(clr);
    }
    else if (cen_flag == 1)
    {
      if (cen < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_energize(cen);
    }
    else if (cmd_flag == 1)
    {
      if (cmd < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_meditation(cmd);
    }
    else if (csl_flag == 1)
    {
      if (csl < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_sleep(csl);
    }
    else if (cfu_flag == 1)
    {
      if (cfu < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_fun(cfu);
    }
    break;
  case PAUSE:
    Pause = 1, play = 0, stop = 0, pausecount = 0;
    pauseinterval = PAUSEINTERVAL;
    if (beatsPid)
    {
      puts("calling kill #11: PAUSE");
      kill(beatsPid, SIGINT);
    }
    pausetimeout = XtAppAddTimeOut(app, (1/pauseinterval)*1000,
                                   pausetimeout_proc,NULL);

    program.emsg(nprint, "Returned to sspdown_buttonCB()\n");
    break;
  }
}

void
sspup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  audioValues setAudio;
  mixerControls saudio;
  flashForm forFlash;
  int n= 0;
  Arg wargs[10];
  /***void XtRemoveTimeOut(XtIntervalId timer);*/
  char chooseProgram[] = NP_ERR;

  allflagsState();
  allmodesState();
  sspmode++;  /* move ssp up */


  //program.emsg(nprint, "DEBug: sspup_buttonCB(): prepstate = (%s)\n", prepstate==on?"on":"off",_fl_);

  if (prepstate == on)  /** are we looking for a program **/
  {
    if (sspmode == PLAY)
      if (allflags == 0 && allmodes == 0)
      {

        char progsetErrstring[] = NSP_ERR;
        XMuuzErrHandler( progsetErrstring );
        sspmode--;
        return;
      }
  }


  /*program.emsg(nprint, "sspup_button: sspmode = (%d), playing = (%d)\n", sspmode, playing,_fl_);
  */

  if (sspmode > 2) sspmode = 0; /* UP */
  XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
  n++;
  XtSetValues(displayAction, wargs, n);
  switch (sspmode)
  {
  case STOP:
    if (beatsPid)
    {
      puts("calling kill #12:: STOP");
      kill(beatsPid, SIGINT);
    }
    if (pausecount != 0 || Pause == 1)
    {
      XtRemoveTimeOut (pausetimeout);
      pausecount = 0;
    }
    forFlash.setFormColor(SLATEGREY);
    stop = 1, Pause = 0, play = 0;
    break;
  case PLAY:
    skipTimeOut=0;
    if (pausecount != 0)
    {
      XtRemoveTimeOut (pausetimeout);
    }
    play = 1, stop = 0, Pause = 0;

    //program.emsg(nprint, "PLAYDEB: case PLAY:  muuzmode = (%d)\n", muuzmode);
    // ONE
    do_once = 0;
    timeout = XtAppAddTimeOut(app, (1/interval)*1000,timeout_proc, NULL);
    /*
    * PLAY logic belongs here in STOP:/PLAY:/PAUSE callback function 
    *  deduced 29sep98::  red-letter day, muuz-wise.
    */
    if (ccr_flag == 1)
    {
      if (ccr < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_creative(ccr);
    }
    else if (crx_flag == 1)
    {
      if (crx < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_relaxation(crx);
    }
    else if (clr_flag == 1)
    {
      if (clr < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_learning(clr);
    }
    else if (cen_flag == 1)
    {
      if (cen < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_energize(cen);
    }
    else if (cmd_flag == 1)
    {
      if (cmd < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_meditation(cmd);
    }
    else if (csl_flag == 1)
    {
      if (csl < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_sleep(csl);
    }
    else if (cfu_flag == 1)
    {
      if (cfu < 0)
      {
        XMuuzErrHandler(chooseProgram);
        n = 0, sspmode = STOP;
        XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] );
        n++;
        XtSetValues(displayAction, wargs, n);
      }
      do_fun(cfu);
    }
    break;
  case PAUSE:
    Pause = 1, play = 0, stop = 0, pausecount = 0;
    pauseinterval = PAUSEINTERVAL;
    if (beatsPid)
    {
      puts("calling kill #13: PAUSE");
      kill(beatsPid, SIGINT);
    }
    pausetimeout = XtAppAddTimeOut(app, (1/pauseinterval)*1000,
                                   pausetimeout_proc,NULL);

    program.emsg(nprint, "Returned to sspdown_buttonCB()\n");
    break;
  }
}

/*
* end ssp up/down button CB functions and required kill() signal calls.
*/




/*
* the callback routine - this is called when the button we create in main()
* is pushed;  The arguments are the widget itself (allowing the same
* callback to be registered on multiple widgets if desired), a client data
* structure that carrys any user data specified when the callback is
* registered, and a call data structure that is filled in by Xt and which
* can be used to get more information about the callback, if needed
*/

void
hertzdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n = 0;
  Arg wargs[10];
  audioValues setAudio;

  do_once = 0;
  interval--;
  if (interval < 1) interval = 30;

  if (frequency-- <= 0) frequency = 29; /* was 29, 14feb99 */
  hertz = HzArray[frequency];           /* get correct hertz for state */
  //program.emsg(nprint, "DEB: hertzdown: hertz = (%ld), frequency = (%d)\n",
  //hertz,frequency,_fl_);
  //program.emsg(nprint, "DEB: hertzdown: LABEL = [[ %s ]]\n",
  //hertzDisplayLabels[frequency],_fl_);
  //program.emsg(nprint, "DEB: hertzdown: interval = (%d), hertz = (%ld), frequency = (%d)\n",
  //interval, hertz, frequency,_fl_);

  /*
  *  if audio, kill; and if PLAY, restart at another hertz
  */

  // HERE
  if (sspmode == PLAY && (muuzmode == AUDIO || muuzmode == AUDIOVIDEO) )
  {
    //	  puts("calling kill #15");
    skipTimeOut=1;
    timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
  }
  XtSetArg(wargs[n], XtNlabel, hertzDisplayLabels[frequency] );
  n++;
  XtSetValues(displayHertz, wargs, n);
}

void
hertzup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0;
  Arg wargs[10];
  audioValues setAudio;

  do_once = 0;
  interval++;
  if (interval > 30) interval = 1;

  if (frequency++ >= 29) frequency = 0; /* was 29:: 14feb99 */
  hertz = HzArray[frequency];           /* get correct hertz for state */

  program.emsg(nprint, "DEB: hertzup: hertz = (%ld), frequency = (%d)\n",
    hertz, frequency,_fl_);
  program.emsg(nprint, "DEB: hertzup: LABEL = [[ %s ]]\n",
    hertzDisplayLabels[frequency],_fl_);
  program.emsg(nprint, "DEB: hertzup: interval = (%d), hertz = (%ld), frequency = (%d)\n",
    interval, hertz, frequency,_fl_);

  /*
   *  if audio, kill; and if PLAY, restart at another hertz
   */
  if (sspmode == PLAY && (muuzmode == AUDIO || muuzmode == AUDIOVIDEO) )
  {
    skipTimeOut=1;
    timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
  }
  XtSetArg(wargs[n], XtNlabel, hertzDisplayLabels[frequency] );
  n++;
  XtSetValues(displayHertz, wargs, n);
}

void
pitchup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n = 0;
  Arg wargs[10];

  audioValues setAudio;


  do_once = 0;
  if (octave++ >= 3) octave = 0;
  XtSetArg(wargs[n], XtNlabel, pitchDisplayLabels[octave] );
  n++;
  XtSetValues(displayPitch, wargs, n);

  if (sspmode == PLAY)
  {
    program.emsg(nprint,"\n\t\thittong timeout_proc() from pitchup()", _fl_ );
    skipTimeOut=1;
    timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
  }
}


void
pitchdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0;
  Arg wargs[10];

  audioValues setAudio;


  do_once = 0;
  if (octave-- <= 0) octave = 3;
  XtSetArg(wargs[n], XtNlabel, pitchDisplayLabels[octave] );
  n++;
  XtSetValues(displayPitch, wargs, n);

  if (sspmode == PLAY)
  {
    //program.emsg(nprint,"\n\t\thitting timeout_proc() from pitchdown()",_fl_);
    skipTimeOut=1;
    timeout = XtAppAddTimeOut(app, 0L, timeout_proc, NULL);
  }
}
void
progdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  Arg largs[10], wargs[10];
  /*
  * pre-programmed display title strings[]
  */

  int ln = 0, n= 0;

  if (playing)
  {
    char prepErrplaying[] = NAP_ERR;

    XMuuzErrHandler(prepErrplaying);
    return;
  }
  if (programCategory == 0)
  {
    char prepErrstring[] = NS_ERR;

    XMuuzErrHandler(prepErrstring);
    return;
  }
  if (ccr_flag == 1)
  {
    if (ccr-- <= 0) ccr = NUM_CR;
    {
      XtSetArg(wargs[n], XtNlabel, c_cr[ccr] );
      n++;
      XtSetValues(displayProg, wargs, n);

      XtSetArg(largs[ln], XtNlabel, label_cr[ccr] );
      ln++;
      XtSetValues( labelDesc, largs, ln);
    }
  }
  else if (clr_flag)
  {
    if (clr-- <= 0) clr = NUM_LR;
    XtSetArg(wargs[n], XtNlabel, c_lr[clr] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (crx_flag)
  {
    if (crx-- <= 0) crx = NUM_RX;
    {
      XtSetArg(wargs[n], XtNlabel, c_rx[crx] );
      n++;
      XtSetValues(displayProg, wargs, n);

      XtSetArg(largs[ln], XtNlabel, label_rx[crx] );
      ln++;
      XtSetValues( labelDesc, largs, ln);
    }
    /***** TRY *****/
    /*   This turned the display label red when pressed; we need to
    *   decide if this is worthwhile... it may help;... or not..
    */

    if (sspmode != PLAY)
    {
      if(depth>8)
        XtVaSetValues(displayAction, XtNbackground, red_color.pixel,
                      XtNforeground,  yellow_color.pixel, NULL);
      else
        XtVaSetValues(displayAction, XtNbackground, red,
                      XtNforeground,  yellow, NULL);
    }
    /***else
  {
    if(depth>8)
    XtVaSetValues(displayAction, XtNbackground,  blue_color.pixel,
    XtNforeground,  yellow_color.pixel, NULL);
    else
    XtVaSetValues(displayAction, XtNbackground,  blue,
    XtNforeground,  yellow, NULL);
  }***/
    if (sspmode == PLAY)
    {}







  }
  else if (cmd_flag)
  {
    if (cmd-- <= 0) cmd = NUM_MD;
    XtSetArg(wargs[n], XtNlabel, c_md[cmd] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (cen_flag)
  {
    if (cen-- <= 0) cen = NUM_EN;
    XtSetArg(wargs[n], XtNlabel, c_en[cen] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (csl_flag)
  {
    if (csl-- <= 0) csl = NUM_SL;
    XtSetArg(wargs[n], XtNlabel, c_sl[csl] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (cfu_flag)
  {
    if (cfu-- <= 0) cfu = NUM_FU;
    XtSetArg(wargs[n], XtNlabel, c_fu[cfu] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }


}


void
progup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  Arg largs[10], wargs[10];
  int ln = 0, n= 0;

  if (playing)
  {
    char prepErrplaying[] = NAP_ERR;

    XMuuzErrHandler(prepErrplaying);
    return;
  }
  if (programCategory == 0)
  {
    char prepErrstring[] = NS_ERR;

    XMuuzErrHandler(prepErrstring);
    return;
  }
  if (ccr_flag)
  {
    if (ccr++ >= NUM_CR) ccr = 0;
    {
      XtSetArg(wargs[n], XtNlabel, c_cr[ccr] );
      n++;
      XtSetValues(displayProg, wargs, n);

      XtSetArg(largs[ln], XtNlabel, label_cr[ccr] );
      ln++;
      XtSetValues( labelDesc, largs, ln);
    }
  }
  else if (clr_flag)
  {
    if (clr++ >= NUM_LR) clr = 0;
    XtSetArg(wargs[n], XtNlabel, c_lr[clr] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (crx_flag)
  {

    if (crx++ >= NUM_RX) crx = 0;
    {
      XtSetArg(wargs[n], XtNlabel, c_rx[crx] );
      n++;
      XtSetValues(displayProg, wargs, n);

      XtSetArg(largs[ln], XtNlabel, label_rx[crx] );
      ln++;
      XtSetValues( labelDesc, largs, ln);

    }
    /**** TRY ****/
    if (sspmode != PLAY)
    {
      if(depth>8)
        XtVaSetValues(displayAction, XtNbackground,  red_color.pixel,
                      XtNforeground,  yellow_color.pixel, NULL);
      else
        XtVaSetValues(displayAction, XtNbackground,  red,
                      XtNforeground,  yellow, NULL);
    }
  }
  else if (cmd_flag)
  {
    if (cmd++ >= NUM_MD) cmd = 0;
    XtSetArg(wargs[n], XtNlabel, c_md[cmd] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (cen_flag)
  {
    if (cen++ >= NUM_EN) cen = 0;
    XtSetArg(wargs[n], XtNlabel, c_en[cen] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (csl_flag)
  {
    if (csl++ >= NUM_SL) csl = 0;
    XtSetArg(wargs[n], XtNlabel, c_sl[csl] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
  else if (cfu_flag)
  {
    if (cfu++ >= NUM_FU) cfu = 0;
    XtSetArg(wargs[n], XtNlabel, c_fu[cfu] );
    n++;
    XtSetValues(displayProg, wargs, n);
  }
}


void
prepdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0, N = 0, ln = 0;
  Arg  largs[10], wargs[10], Wargs[10];

  if (playing)
  {
    char prepErrplaying[] = NAP_ERR;

    XMuuzErrHandler(prepErrplaying);
    return;
  }
  if (programCategory-- <= 0) programCategory = 7;
  XtSetArg(wargs[n], XtNlabel, prepTopicsButtonLabel[programCategory] );
  n++;
  XtSetValues(displayPrep, wargs, n);

  /*
  * CLEAR Programs window AND label Desc window with **each** Selection change 
  */
  XtSetArg(Wargs[N], XtNlabel, blankProgWin );
  N++;
  XtSetValues(displayProg, Wargs, N);

  XtSetArg(largs[ln], XtNlabel, blankDescLabel );
  ln++;
  XtSetValues( labelDesc, largs, ln);

  /*
  * reset the counters with each new Selection 
  */
  ccr = clr = crx = cmd = csl = cen = cfu  = -1; /* TEST 22oct98 */


  switch(programCategory)
  {
  case 0:
    break;
  case CCR:
    on_ccrflag();
    break;
  case CLR:
    on_clrflag();
    break;
  case CRX:
    on_crxflag();
    break;
  case CMD:
    on_cmdflag();
    break;
  case CSL:
    on_cslflag();
    break;
  case CEN:
    on_cenflag();
    break;
  case CFU:
    on_cfuflag();
    break;
  }
  /**  disallow logic-error:: this disallows PLAY if programCategory is OFF **/
  if (programCategory == 0)
  {
    offAllPrepFlags();
  }
}


void
prepup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0, N = 0, ln = 0;
  Arg largs[10], wargs[10], Wargs[10];

  if (playing)
  {
    char prepErrplaying[] = NAP_ERR;

    XMuuzErrHandler(prepErrplaying);
    return;
  }

  if (programCategory++ >= 7) programCategory = 0;
  XtSetArg(wargs[n], XtNlabel, prepTopicsButtonLabel[programCategory] );
  n++;
  XtSetValues(displayPrep, wargs, n);
  /*
  *  CLEAR Programs window AND label Desc window **each** Selection change
  */
  XtSetArg(Wargs[N], XtNlabel, blankProgWin );
  N++;
  XtSetValues(displayProg, Wargs, N);

  XtSetArg(largs[ln], XtNlabel, blankDescLabel );
  ln++;
  XtSetValues( labelDesc, largs, ln);

  /*
  * reset the counters with each new Selection 
  */
  ccr = clr = crx = cmd = csl = cen = cfu  = -1;

  switch(programCategory)
  {
  case 0:
    break;
  case CCR:
    on_ccrflag();
    break;
  case CLR:
    on_clrflag();
    break;
  case CRX:
    on_crxflag();
    break;
  case CMD:
    on_cmdflag();
    break;
  case CSL:
    on_cslflag();
    break;
  case CEN:
    on_cenflag();
    break;
  case CFU:
    on_cfuflag();
    break;
  }
  /**  disallow logic-error:: this disallows PLAY if programCategory is OFF **/
  if (programCategory == 0)
  {
    offAllPrepFlags();
  }
}


void
selectpanel_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  Arg wargs[10];
  Widget avdown_button, avup_button;
  Widget formAv, formColors, formHertz, formPitch, formAction, formVolume;
  Widget  colorsup_button, colorsdown_button,
  sspdown_button, sspup_button;
  Widget hertzup_button, hertzdown_button;
  Widget labelAction, labelAv, labelColors, labelHertz, labelPitch, labelVolume;
  Widget pitchup_button, pitchdown_button;
  Widget volumeup_button, volumedown_button;
  XFontStruct *avFont, *colorsFont, *hertzFont, *pitchFont,
  *actionFont, *volumeFont;

  Widget formboxCB;//, formAv; fixing var names (05oct99)

  if (controlpanelstate == off)
  {
    int n = 0;
    void do_click();
    void initState();
    audioValues setAudio;

    controlpanelstate = on, prepstate = userstate = off;
    volume = VOFF;     /* turn off if it was on */
    XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[volume] );
    n++;
    XtSetValues(displayVolume, wargs, n);
    initState();                          /* reset program environment */
    do_click();
    setAudio.OffVolume();
  }
  else if (controlpanelstate == on)
  {
    return;
  }


  /*
  * The following 6 control assemblies come _after_ the user has gone to
  * the prep form and returrned to this ``Control Panel''; effectively,
  * this is a re-painting of forms and function.
  *  Just refigured the dimensions of the forms and repossitioned 3 of them
  * to the rightward edge of this form.
  *
  *     This HxW sizes covers the prev display(s); it must be large enough.
  *       this allows the blue bg with black_color font label to be
  *       expressed.  Following (label) code.
  */

  if (depth>8)
  {
    formboxCB = XtVaCreateManagedWidget("formboxCB", formWidgetClass, form,
    /* formboxCB matches the previous Control Panel form */
    XtNheight, Do.resizeH(125),  // was 117 and too short ::133 too L
    /* ``653''just fills the formbox BLUE */
    XtNwidth, Do.resizeW(700),
    XtNbackground, blue_color.pixel,
    XtNborderWidth, 0,
    XtNfromVert, menuform,
    XtNfromHoriz, formbox0,
    XtNtop, XawChainTop,
    XtNbottom, XawChainBottom,  // BLUEFORM TEST,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft, NULL);
  }
  else
  {

    formboxCB = XtVaCreateManagedWidget("formboxCB", formWidgetClass, form,
	/* formboxCB matches the previous Control Panel form */
	XtNheight, Do.resizeH(125),  // was 117 and too short ::133 too L
	/* ``653''just fills the formbox BLUE */
	XtNwidth, Do.resizeW(700),   // was  680 and covered <--->
	XtNbackground, blue,
	XtNborderWidth, 0,
	XtNfromVert, menuform,
	XtNfromHoriz, formbox0,
	XtNtop, XawChainTop,
	XtNbottom, XawChainBottom,  // BLUEFORM TEST,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft,
                                        NULL);

  }


  labelFont = init_font(display, NCS18);
  //
  //  This code controls the "Control Panel" 25x625 label on the
  //  second- and final-appearing L_CONTROLPANEL label
  //
  if (depth>8)
  {

    labelForm = XtVaCreateManagedWidget("labelForm", labelWidgetClass, formboxCB,
	XtNfont, labelFont,
	XtNlabel, L_CONTROLPANEL,
	XtNheight, Do.resizeH(25),
	XtNwidth,  Do.resizeW(625),          // should this be 725 or 625?
	XtNbackground, blue_color.pixel,
	XtNforeground, black_color,
	XtNfromVert, NULL,
	XtNfromHoriz, NULL,
	XtNhorizDistance, 0,  // no resize for width
	XtNborderWidth, 0,    // no resize for height
	XtNtop, XawChainTop,
	XtNbottom, XawChainTop,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft,
	NULL);
  }
  else
  {
    labelForm = XtVaCreateManagedWidget("labelForm", labelWidgetClass, 
      formboxCB,
	XtNfont, labelFont,
	XtNlabel, L_CONTROLPANEL,
	XtNheight, Do.resizeH(25),
	XtNwidth,  Do.resizeW(625),
	XtNbackground, blue,
	XtNforeground, black_color,
	XtNfromVert, NULL,
	XtNfromHoriz, NULL,
	XtNhorizDistance, 0,  /* flush */
	XtNborderWidth, 0,    // no resize
	XtNtop, XawChainTop,
	XtNbottom, XawChainTop,
	XtNleft, XawChainLeft,
	XtNright, XawChainLeft,
	NULL);

  }

  /*
  * This is where the six 2nd-level `CONTROL_PANEL' assemblies are built
  */

  /* BEGIN formAv:: action forms code */
  if(depth>8)
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formboxCB,
     XtNheight, Do.resizeH(25),
     XtNwidth, Do.resizeW(213), /* was 180 with TBOLD12 */
     // ASSEMBLY BACKGROUND COLOR AND SHADOW
     XtNbackground, whitesmoke_color.pixel,
     XtNshadowWidth,  2,
     XtNfromVert, NULL,
     XtNfromHoriz, NULL,
     // ADJUSTIN Assembly from top of label  ( was 32)
     XtNvertDistance, Do.resizeH(32),  //TEST /* keep formboxCB correctly sized */
     XtNtop, XawChainTop,
     XtNbottom, XawChainBottom,   // was XawChainTop..... 
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft,
     NULL);
  else
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formboxCB,
     XtNheight, Do.resizeH(25),
     XtNwidth, Do.resizeW(213),  /* was 180 with TBOLD12 */
     // ASSEMBLY BACKGROUND COLOR AND SHADOW
     XtNbackground, whitesmoke,
     XtNshadowWidth,  2,
     XtNfromVert, NULL,
     XtNfromHoriz, NULL,
     XtNvertDistance, Do.resizeH(32), //TEST  /* keep formboxCB correctly sized */
     XtNtop, XawChainTop,
     XtNbottom, XawChainBottom,
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft,
     NULL);


  avFont = init_font(display, NCS12);
  labelAv =
    XtVaCreateManagedWidget("labelAv", labelWidgetClass, formAv,
      XtNfont, avFont,
      XtNlabel, L_MODE,
      //  LABEL_COLORS
      XtNbackground, white_color,
      XtNforeground, black_color,
      XtNshadowWidth,  2,
      XtNfromVert, NULL,
      XtNfromHoriz, NULL,
      XtNborderWidth, 0,      /* standalone    */
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);

  if(depth>8)
    avup_button =
      XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAv,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    avup_button =
      XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAv,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(avup_button, XtNcallback, avup_buttonCB, NULL);


  avDisplayFont = init_font(display, NCS12);
  displayAv =
    XtVaCreateManagedWidget("displayAv", labelWidgetClass, formAv,
    XtNfont, avDisplayFont,
    XtNlabel,  avDisplayLabels[muuzmode],
    XtNfromVert, NULL,
    XtNfromHoriz, avup_button,
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  if(depth>8)
    avdown_button =
      XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAv,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    avdown_button =
      XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAv,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(avdown_button, XtNcallback, avdown_buttonCB, NULL);
  /* END   AV trio     */


  // This is the topform holding the ACTION button-widgets.
  // start formAction:: action forms code (2nd-appearing CONTROLPANEL)
  //
  if(depth>8)
    formAction = XtVaCreateManagedWidget("formAction", formWidgetClass,
                                         formboxCB,
                                         XtNheight, Do.resizeH(25),
                                         XtNwidth, Do.resizeW(213),
                                         XtNfromVert, formAv,
                                         XtNfromHoriz, NULL,
                                         XtNbackground,
                                         // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                         whitesmoke_color.pixel,
                                         XtNshadowWidth,  2,
                                         XtNtop, XawChainTop,
                                         XtNbottom, XawChainTop,
                                         XtNleft, XawChainLeft,
                                         XtNright, XawChainLeft,
                                         NULL);
  else
    formAction = XtVaCreateManagedWidget("formAction", formWidgetClass,
                                         formboxCB,
                                         XtNheight, Do.resizeH(25),
                                         XtNwidth, Do.resizeW(213),
                                         XtNfromVert, formAv,
                                         XtNfromHoriz, NULL,
                                         // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                         XtNbackground,
                                         whitesmoke,
                                         XtNshadowWidth,  2,
                                         XtNtop, XawChainTop,
                                         XtNbottom, XawChainTop,
                                         XtNleft, XawChainLeft,
                                         XtNright, XawChainLeft,
                                         NULL);


  actionFont = init_font(display, NCS12);
  labelAction =
    XtVaCreateManagedWidget("labelAction", labelWidgetClass, formAction,
                            XtNfont, actionFont,
                            XtNlabel, L_ACTION,
                            //  LABEL_COLORS
                            XtNbackground, white_color,
                            XtNforeground, black_color,
                            XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,      /* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  /* begin SSP trio */
  if(depth>8)
    sspup_button =
      XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelAction,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    sspup_button =
      XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelAction,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(sspup_button, XtNcallback, sspup_buttonCB, NULL);

  /*sspDisplayFont = init_font(display, TBOLD12);*/
  sspDisplayFont = init_font(display, NCS12);
  displayAction =
    XtVaCreateManagedWidget("displayAction", labelWidgetClass, formAction,
                            XtNfont, sspDisplayFont,
                            XtNlabel, sspDisplayLabels[sspmode],
                            XtNfromVert, NULL,
                            XtNfromHoriz, sspup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  if(depth>8)
    sspdown_button =
      XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayAction,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    sspdown_button =
      XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayAction,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(sspdown_button, XtNcallback, sspdown_buttonCB, NULL);
  /* END   SSP trio     */



  /* H7 */

  /*
  *  Start of Hz//Freq Assembly.  (2nd-Nth popup)
  *
  * Here begins the Frequency assembly.
  * This need to be shifted N pixels rightward.
  *
  *    Note that this is the Control_Panel beneath the 1st-appearing one.
  *         This is the SECOND- and LAST-appearing Control Panel. (08mar99)
  */
  if(depth>8)
    formHertz = XtVaCreateManagedWidget("formHertz",formWidgetClass,formboxCB,
                                        XtNfromVert, NULL,
                                        XtNvertDistance,Do.resizeH(32),             /* Down from Control Panel label  */
                                        XtNhorizDistance, Do.resizeW(191),          /* right-shift to even appearance */
                                        XtNfromHoriz, formAv,
                                        // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                        XtNbackground, whitesmoke_color.pixel,
                                        XtNshadowWidth,  2,
                                        XtNheight, Do.resizeH(25),
                                        XtNwidth, Do.resizeW(237),
                                        XtNtop, XawChainTop,
                                        XtNbottom, XawChainTop,
                                        XtNleft, XawChainLeft,
                                        XtNright, XawChainLeft,
                                        NULL);
  else
    formHertz = XtVaCreateManagedWidget("formHertz",formWidgetClass,formboxCB,
                                        XtNfromVert, NULL,
                                        XtNvertDistance,Do.resizeH(32),             /* Down from Control Panel label  */
                                        XtNhorizDistance, Do.resizeW(191),          /* right-shift to even appearance */
                                        XtNfromHoriz, formAv,
                                        // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                        XtNbackground, whitesmoke,
                                        XtNshadowWidth,  2,
                                        XtNheight, Do.resizeH(25),
                                        XtNwidth, Do.resizeW(237),
                                        XtNtop, XawChainTop,
                                        XtNbottom, XawChainTop,
                                        XtNleft, XawChainLeft,
                                        XtNright, XawChainLeft,
                                        NULL);


  hertzFont = init_font(display, NCS12);
  labelHertz =
    XtVaCreateManagedWidget("labelHertz", labelWidgetClass, formHertz,
                            XtNfont, hertzFont,
                            XtNlabel, L_HERTZ,
                            //  LABEL_COLORS
                            XtNbackground, white_color,
                            XtNforeground, black_color,
                            XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,	/* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  /* begin Hz trio */
  if(depth>8)
    hertzup_button =
      XtVaCreateManagedWidget("hertzup_button", commandWidgetClass, formHertz,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelHertz,
                              XtNhorizDistance, Do.resizeW(15),
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    hertzup_button =
      XtVaCreateManagedWidget("hertzup_button", commandWidgetClass, formHertz,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelHertz,
                              XtNhorizDistance, Do.resizeW(15),
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(hertzup_button, XtNcallback, hertzup_buttonCB, NULL);

  /**hertzDisplayFont = init_font(display, TBOLD12);*/

  hertzDisplayFont = init_font(display, NCS12);
  displayHertz =
    XtVaCreateManagedWidget("displayHertz", labelWidgetClass, formHertz,
                            XtNfont, hertzDisplayFont,
                            XtNlabel, hertzDisplayLabels[frequency],
                            XtNfromVert, NULL,

                            XtNfromHoriz, hertzup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,

                            NULL);


  if(depth>8)
    hertzdown_button =
      XtVaCreateManagedWidget("hertzdown_button", commandWidgetClass,
                              formHertz,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayHertz,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    hertzdown_button =
      XtVaCreateManagedWidget("hertzdown_button", commandWidgetClass,
                              formHertz,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayHertz,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(hertzdown_button, XtNcallback, hertzdown_buttonCB,
                NULL);
  /* end   Hz trio     */




  //
  // Start of Pitch Assembly  (2nd-backup to Nth PopUp)
  //
  if(depth>8)
    formPitch =
      XtVaCreateManagedWidget("formPitch", formWidgetClass, formboxCB,
                              XtNfromVert, formHertz,
                              XtNheight, Do.resizeH(25),
                              /* Pitch longest */  /* was 180; larger for TBOLD12 */
                              XtNwidth, Do.resizeW(248),
                              XtNfromHoriz, formAction,
                              // ASSEMBLY BACKGROUND COLOR AND SHADOW
                              XtNbackground, whitesmoke_color.pixel,
                              XtNshadowWidth,  2,
                              XtNhorizDistance, Do.resizeW(181),          /* right-shift to even appearance */
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    formPitch =
      XtVaCreateManagedWidget("formPitch", formWidgetClass, formboxCB,
                              XtNfromVert, formHertz,
                              XtNheight, Do.resizeH(25),
                              /* Pitch longest */  /* was 180; larger for TBOLD12 */
                              XtNwidth, Do.resizeW(248),
                              XtNfromHoriz, formAction,
                              // ASSEMBLY BACKGROUND COLOR AND SHADOW
                              XtNbackground, whitesmoke,
                              XtNshadowWidth,  2,
                              XtNhorizDistance, Do.resizeW(181),          /* right-shift to even appearance */
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);


  /*pitchFont = init_font(display, TBOLD12);**/

  pitchFont = init_font(display, NCS12);
  labelPitch =
    XtVaCreateManagedWidget("labelHertz", labelWidgetClass, formPitch,
                            XtNfont, pitchFont,
                            XtNlabel, L_PITCH,
                            //  LABEL_COLORS
                            XtNbackground, white_color,
                            XtNforeground, black_color,
                            XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,	/* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  /* begin pitch trio */
  if(depth>8)
    pitchup_button =
      XtVaCreateManagedWidget("pitchup_button", commandWidgetClass,
                              formPitch,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelPitch,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    pitchup_button =
      XtVaCreateManagedWidget("pitchup_button", commandWidgetClass,
                              formPitch,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelPitch,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(pitchup_button, XtNcallback, pitchup_buttonCB, NULL);


  pitchDisplayFont = init_font(display, NCS12);
  displayPitch =
    XtVaCreateManagedWidget("displayPitch", labelWidgetClass, formPitch,
                            XtNfont,  pitchDisplayFont,
                            XtNlabel, pitchDisplayLabels[octave],
                            XtNfromVert, NULL,
                            XtNfromHoriz, pitchup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  if(depth>8)
    pitchdown_button =
      XtVaCreateManagedWidget("pitchdown_button", commandWidgetClass,
                              formPitch,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayPitch,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    pitchdown_button =
      XtVaCreateManagedWidget("pitchdown_button", commandWidgetClass,
                              formPitch,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayPitch,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(pitchdown_button, XtNcallback, pitchdown_buttonCB, NULL);


  // Start of Colors Assembly ::  2nd-Nth appearing screen

  if(depth>8)
    formColors = XtVaCreateManagedWidget("formColors", formWidgetClass,
                                         formboxCB,
                                         XtNfromVert, formAction,
                                         XtNfromHoriz, NULL,
                                         // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                         XtNbackground, whitesmoke_color.pixel,
                                         XtNshadowWidth,  2,
                                         XtNheight, Do.resizeH(25),
                                         XtNwidth, Do.resizeW(213),          /* was 190 */
                                         XtNtop, XawChainTop,
                                         XtNbottom, XawChainTop,
                                         XtNleft, XawChainLeft,
                                         XtNright, XawChainLeft,
                                         NULL);
  else
    formColors = XtVaCreateManagedWidget("formColors", formWidgetClass,
                                         formboxCB,
                                         XtNfromVert, formAction,
                                         XtNfromHoriz, NULL,
                                         // ASSEMBLY BACKGROUND COLOR AND SHADOW
                                         XtNbackground, whitesmoke,
                                         XtNshadowWidth,  2,
                                         XtNheight, Do.resizeH(25),
                                         XtNwidth, Do.resizeW(213),          /* was 190 */
                                         XtNtop, XawChainTop,
                                         XtNbottom, XawChainTop,
                                         XtNleft, XawChainLeft,
                                         XtNright, XawChainLeft,
                                         NULL);

  /*colorsFont = init_font(display, TBOLD12);*/

  colorsFont = init_font(display, NCS12);
  labelColors =
    XtVaCreateManagedWidget("labelColors", labelWidgetClass, formColors,
                            XtNfont, colorsFont,
                            XtNlabel, L_COLORS,
                            //  LABEL_COLORS
                            XtNbackground, white_color,
                            XtNforeground, black_color,
                            XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,  /* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  /* begin colors trio */
  if(depth>8)
    colorsup_button =
      XtVaCreateManagedWidget("colorsup_button", commandWidgetClass,
                              formColors,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelColors,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    colorsup_button =
      XtVaCreateManagedWidget("colorsup_button", commandWidgetClass,
                              formColors,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelColors,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(colorsup_button, XtNcallback, colorsup_buttonCB, NULL);


  colorsDisplayFont = init_font(display, NCS12);
  displayColors =
    XtVaCreateManagedWidget("displayColors", labelWidgetClass, formColors,
                            XtNfont, colorsDisplayFont,
                            XtNlabel, colorsDisplayLabels[colorsmode],
                            XtNfromVert, NULL,
                            XtNfromHoriz, colorsup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  if(depth>8)
    colorsdown_button =
      XtVaCreateManagedWidget("colorsdown_button",commandWidgetClass,formColors,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayColors,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    colorsdown_button =
      XtVaCreateManagedWidget("colorsdown_button",commandWidgetClass,formColors,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayColors,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(colorsdown_button, XtNcallback, colorsdown_buttonCB, NULL);


  /* end of moved color stuff */


  //
  // Start of Volume Assembly  (2nd-Nth popup)
  //
  if(depth>8)
    formVolume =
      XtVaCreateManagedWidget("formVolume", formWidgetClass, formboxCB,
                              XtNfromVert, formPitch,
                              XtNfromHoriz, formColors,
                              XtNhorizDistance, Do.resizeW(191),          /* right-shift to even appearance */
                              // ASSEMBLY BACKGROUND COLOR AND SHADOW
                              XtNbackground, whitesmoke_color.pixel,
                              XtNshadowWidth,  2,
                              XtNheight, Do.resizeH(25),
                              XtNwidth, Do.resizeW(201),           /* was 180 */
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    formVolume =
      XtVaCreateManagedWidget("formVolume", formWidgetClass, formboxCB,
                              XtNfromVert, formPitch,
                              XtNfromHoriz, formColors,
                              XtNhorizDistance, Do.resizeW(191),          /* right-shift to even appearance */
                              // ASSEMBLY BACKGROUND COLOR AND SHADOW
                              XtNbackground, whitesmoke,
                              XtNshadowWidth,  2,
                              XtNheight, Do.resizeH(25),
                              XtNwidth, Do.resizeW(201),            /* was 180 */
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);


  /*volumeFont = init_font(display, TBOLD12);*/

  volumeFont = init_font(display, NCS12);
  labelVolume =
    XtVaCreateManagedWidget("labelVolume", labelWidgetClass, formVolume,
                            XtNfont, volumeFont,
                            XtNlabel, L_VOLUME,
                            //  LABEL_COLORS
                            XtNbackground, white_color,
                            XtNforeground, black_color,
                            XtNshadowWidth,  2,
                            XtNfromVert, NULL,
                            XtNfromHoriz, NULL,
                            XtNborderWidth, 0,	/* standalone    */
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  /* begin volume trio */
  if(depth>8)
    volumeup_button =
      XtVaCreateManagedWidget("volumeup_button", commandWidgetClass,
                              formVolume,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelVolume,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    volumeup_button =
      XtVaCreateManagedWidget("volumeup_button", commandWidgetClass,
                              formVolume,
                              XtNbitmap, UpArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, labelVolume,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(volumeup_button, XtNcallback, volumeup_buttonCB, NULL);

  /*volumeDisplayFont = init_font(display, TBOLD12);*/

  volumeDisplayFont = init_font(display, NCS12);
  displayVolume =
    XtVaCreateManagedWidget("displayVolume", labelWidgetClass, formVolume,
                            XtNfont,  volumeDisplayFont,
                            XtNlabel,  volumeDisplayLabels[volume],
                            XtNfromVert, NULL,
                            XtNfromHoriz, volumeup_button,
                            XtNtop, XawChainTop,
                            XtNbottom, XawChainTop,
                            XtNleft, XawChainLeft,
                            XtNright, XawChainLeft,
                            NULL);

  if(depth>8)
    volumedown_button =
      XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
                              formVolume,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayVolume,
                              // ARROW_COLORS
                              XtNbackground,grey_color.pixel,
                              XtNforeground,darkblue_color.pixel,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);
  else
    volumedown_button =
      XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
                              formVolume,
                              XtNbitmap, DownArrow,
                              XtNfromVert, NULL,
                              XtNfromHoriz, displayVolume,
                              XtNbackground,grey,
                              XtNforeground,darkblue,
                              XtNshadowWidth,  3,
                              XtNtop, XawChainTop,
                              XtNbottom, XawChainTop,
                              XtNleft, XawChainLeft,
                              XtNright, XawChainLeft,
                              NULL);

  XtAddCallback(volumedown_button, XtNcallback, volumedown_buttonCB,
                NULL);

  /* end volume trio */

}

/* HEZZ */



void
volumedown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  /* mode is the number of pushes mod the number of possible modes */
  int n = 0;
  Arg wargs[10];
  audioValues setAudio;
  void XMuuzMessagePopupHandler(char *);

  if ( prepstate == on && adjustflag == off)
  {
    XMuuzMessagePopupHandler(M_ADJUST);
    return;
  }

  if (volume-- <= 0) volume = 10;
  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[volume] );
  n++;
  XtSetValues(displayVolume, wargs, n);

  setAudio.Volume();
}

void
volumeup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0;
  Arg wargs[10];
  audioValues setAudio;
  void XMuuzMessagePopupHandler(char *);

  if ( prepstate == on && adjustflag == off)
  {
    XMuuzMessagePopupHandler(M_ADJUST);
    return;
  }

  if (volume++ >= 10) volume = 0;
  XtSetArg(wargs[n], XtNlabel, volumeDisplayLabels[volume] );
  n++;
  XtSetValues(displayVolume, wargs, n);

  //program.emsg(nprint, "DEBUG: volumeup():: volume = (%d)\n", volume,_fl_);
  setAudio.Volume();
}

/* color arrows CB functions */

void
colorsdown_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n = 0;
  Arg wargs[10];


  if (colorsmode-- <= 0) colorsmode = 4;
  XtSetArg(wargs[n], XtNlabel, colorsDisplayLabels[colorsmode] );
  n++;
  XtSetValues(displayColors, wargs, n);
  switch(colorsmode)
  {
  case 0:
    global_flash_color = white_color; /* spl case */
    break;
  case 1:
    if(depth>8)
      global_flash_color = yellow_color.pixel;
    else
      global_flash_color = yellow;
    break;
  case 2:
    if(depth>8)
      global_flash_color = orange_color.pixel;
    else
      global_flash_color = orange;
    break;
  case 3:
    if(depth>8)
      global_flash_color = pink_color.pixel;
    else
      global_flash_color = lightpink;
    break;
  case 4:
    if(depth>8)
      global_flash_color = skyblue_color.pixel;
    else
      global_flash_color = lightskyblue;
    break;
  }
}

void
colorsup_buttonCB(Widget _w, XtPointer _client_data, XtPointer _call_data)
{
  int n= 0;
  Arg wargs[10];

  if (colorsmode++ >= 4) colorsmode = 0;
  XtSetArg(wargs[n], XtNlabel, colorsDisplayLabels[colorsmode] );
  n++;
  XtSetValues(displayColors, wargs, n);
  switch(colorsmode)
  {
  case 0:
    global_flash_color = white_color; /* spl case */
    break;
  case 1:
    if(depth>8)
      global_flash_color = yellow_color.pixel;
    else
      global_flash_color = yellow;
    break;
  case 2:
    if(depth>8)
      global_flash_color = orange_color.pixel;
    else
      global_flash_color = orange;
    break;
  case 3:
    if(depth>8)
      global_flash_color = pink_color.pixel;
    else
      global_flash_color = lightpink;
    break;
  case 4:
    if(depth>8)
      global_flash_color = skyblue_color.pixel;
    else
      global_flash_color = lightskyblue;
    break;
  }


}
