/*
 * The timeout for pause is here and so is the confirm/cancel widgets to Quit.
 *
 * $Id: cancelconfirm.c,v 1.4 2000/04/11 01:17:05 kline Exp kline $
 */
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#include "globals.h"
#include "muuz.h"
#include "muuztypes.h"
#include "xbm.h"
#include "xfonts.h"
#include "do_colors.h"

#include "errMessage.h"
#include "flashForm.h"
#include "muuzaudio.h"
#include "flashes.h"
#include "misc.h"
#include "main.h"
#include "copyright.h"


extern errMessage program;  // for emsg()

void ConfirmDestroy(Widget, XtPointer, XtPointer);
void CancelDestroy(Widget, XtPointer, XtPointer);

static boolean pausedone = false;
int pausecount = 0, pauseinterval;

/* Timeout routine */
void
pausetimeout_proc(XtPointer _client_data, XtIntervalId *_id)
{
  flashForm forFlash;
  extern action_t sspmode;
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow;

  extern int pausecount;
  extern XtIntervalId pausetimeout;
  extern boolean pausedone;
  void pausetimeout_proc(XtPointer _client_data, XtIntervalId *_id);



  pausecount++;
  if (pausecount == 1)
  {
    if (beatsPid)
    {
      program.emsg(trace, "KILLING audio in Pause()");
      kill (beatsPid, SIGINT);
    }
    forFlash.setFormColor(GREY);
  }

  if (pausecount == PAUSETIMECOUNT) 
  {
    pausedone = true;
  }

  /*
   * this code is hit during auto-return, when the user let's the program
   * __PAUSE__ until the time-out limit is hit.  The timeout is removed,  
   * the action assembly is returned to " Stop ", and the original slategrey
   * color is restored to the main flashform.
   */
  if (pausedone)
  {
    pausedone = false;
    XtRemoveTimeOut (pausetimeout);
    if (sspmode == PAUSE) 
    {
      forFlash.setFormColor(SLATEGREY);
    }
    return;
  }

  /* restablish timeout - remember interval is in milliseconds */
  pausetimeout = XtAppAddTimeOut(app, (1/pauseinterval)*1000,
        pausetimeout_proc,NULL);
  program.emsg(nprint, "leaving pausetimeout_proc()");
}



/*
 * Useful macros.
 */
#define SetArg(which, val)      XtSetArg(args[nargs], (which),\
                                         (XtArgVal) (val)); nargs++
#define SetCallback(which, val) callbacks[0].callback = (which); \
                                callbacks[0].closure = (XtPointer) (val)



static Widget   confirmwidget;


/*
 * ConfirmIt - put up a window asking for confirmation.
 */
void
ConfirmIt(XtCallbackRec *confirm_callbacks, XtCallbackRec *cancel_callbacks)
{
  Arg             args[4];
  Window          root, child;
  unsigned int    buttons;
  register int    nargs, nwidgets;
  static Boolean  initialized = False;
  static Widget   cform, widgets[2];
  int             root_x, root_y, child_x, child_y;

  /*
   * Find out where the mouse is, so we can put the confirmation box right
   * there.
   */
  XQueryPointer(display, XtWindow(top), &root, &child,
		&root_x, &root_y, &child_x, &child_y, &buttons);

  /*
   * If we need to construct the confirmation box do that, otherwise just
   * reset the position and callbacks and put it up again.
   */
  if (initialized == False)
  {
    nargs = 0;
    SetArg(XtNx, root_x);
    SetArg(XtNy, root_y);


    /*
     * The confirmation box will be a pop-up widget.
     *
     *   Here making it bigger than need-be.
     */
    confirmwidget = XtVaCreatePopupShell("confirmwidget",
	       transientShellWidgetClass, top, 
	       XtNx, root_x, XtNy, root_y,
	       XtNheight, Do.resizeH(100), XtNwidth,  Do.resizeW(200),
	        NULL);

    /*
     * Make a form to put the buttons in.
     */
    if (depth > 8)
    {
      cform = XtVaCreateWidget("Buttons", formWidgetClass, 
        confirmwidget,  XtNbackground, whitesmoke_color.pixel, NULL);
    }
    else
    {
      cform = XtVaCreateWidget("Buttons", formWidgetClass, 
        confirmwidget, XtNbackground, whitesmoke, NULL);
    }

    nwidgets = -1;

    /*
     * Confirmation button.
     */
    nargs = 0;
    SetArg(XtNcallback, confirm_callbacks);
    widgets[++nwidgets] = XtCreateWidget("Confirm", commandWidgetClass,
					 cform, args, nargs);

    /*
     * Set up labels within cform with set bg/fg colors
     */
    nargs= 0; SetArg(XtNlabel, L_CONFIRM);           
    SetArg(XtNbackground, white_color);
    SetArg(XtNforeground, black_color);
    XtSetValues(widgets[0], args, nargs);
    /*
     * Cancellation button.
     */
    nargs = 0;
    SetArg(XtNcallback, cancel_callbacks);
    SetArg(XtNfromHoriz, widgets[nwidgets]);
    widgets[++nwidgets] = XtCreateWidget("Cancel", commandWidgetClass,
					 cform, args, nargs);

    /*
     * Set up labels within cform with set bg/fg colors
     */
    nargs= 0; SetArg(XtNlabel, L_CANCEL);            
    SetArg(XtNbackground, white_color);
    SetArg(XtNforeground, black_color);
    XtSetValues(widgets[1], args, nargs);


    /*
     * Let the shell widget know we're here.
     */
    /*XtManageChildren(widgets, XtNumber(widgets)); */
    XtManageChildren(widgets, nwidgets+1 );
    XtManageChild(cform);

    XtRealizeWidget(confirmwidget);
    initialized = True;
  } 
  else
  {
    /*
     * Reset the confirmation box position.
     */
    nargs = 0;
    SetArg(XtNx, root_x);
    SetArg(XtNy, root_y);
    XtSetValues(confirmwidget, args, nargs);
    /*
     * Reset the callbacks.
     */
    nargs = 0;
    SetArg(XtNcallback, confirm_callbacks);
    SetArg(XtNlabel, L_CONFIRM);            
    SetArg(XtNbackground, white_color);
    SetArg(XtNforeground, black_color);
    XtSetValues(widgets[0], args, nargs);

    nargs = 0;
    SetArg(XtNcallback, cancel_callbacks);
    SetArg(XtNlabel, L_CANCEL);            
    SetArg(XtNbackground, white_color);
    SetArg(XtNforeground, black_color);
    XtSetValues(widgets[1], args, nargs);
  }

  /*
   * Pop up the confirmation box.
   */
  XtPopup(confirmwidget, XtGrabExclusive);
}

/*
 * AskConfirmCB - destroy a note.
 */
void
AskConfirmCB(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtCallbackRec   cancel[2], confirm[2];

  bzero(confirm, sizeof(confirm));
  bzero(cancel, sizeof(cancel));
  confirm[0].callback = ConfirmDestroy;
  cancel[0].callback = CancelDestroy;

  /*
   * Get confirmation of what they want to do.
   */
  ConfirmIt(confirm, cancel);
}

/*
 * CancelDestroy - callback for title cancel.
 */
void
CancelDestroy(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown(confirmwidget);
  return;
}

/*
 * ConfirmDestroy - callback for destroy confirmation.
 */
void
ConfirmDestroy(Widget w, XtPointer client_data, XtPointer call_data)
{
  /* Get rid of the confirmation box and popdown the confirmation widget.  */
  XtPopdown(confirmwidget);
  XtDestroyWidget(confirmwidget);
  XtDestroyWidget(top);

  /* signal catcher should reset beatsPid to zero, so if beatsPid not
     zero, then it means we still have to shut down audio.
  */
  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
    //pause();   /* wait until SIGCHLD comes in. */
  }

#ifdef NEWBEATSAUDIO
  flush_samples();  // scotch any miscellaneous sounds.
  if (devfd)
    close(devfd);     // close the audio dev
#endif


  exit(0);  /*** exit from muuz here ***/
}

