/*
 * $Id: controlpanel.c,v 1.1 2000/01/29 20:44:47 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include "copyright.h"


/*
 *  The control assemblies here (buttons, labels, arrow-wwidgets) seem to
 *  be totally isolated from the rest of muuz.  (28feb98)  (??)
 */

void
controlPanel()
{
  void  hertzup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  hertzdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void avup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void avdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  sspup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  sspdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  colorsdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  colorsup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  progup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  progdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  volumeup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  volumedown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  pitchup_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  void  pitchdown_buttonCB(Widget _w, XtPointer, XtPointer _call_data);
  XFontStruct *init_font(Display *display, const char *fontName);
  extern xcolor_t blue, brown1, whitesmoke, grey90;
  extern XColor blue_color, brown1_color, whitesmoke_color, grey90_color;
  extern volume_t volume;
  extern action_t sspmode;
  extern audiovideo_t muuzmode;
  extern colors_t colorsmode;
  extern frequency_t frequency;
  extern octave_t octave;
  extern char *avDisplayLabels[];
  extern char *colorsDisplayLabels[];
  extern char *hertzDisplayLabels[];
  extern char  *sspDisplayLabels[];
  extern char *volumeDisplayLabels[];
  extern Widget  displayColors, displayAction;
  extern Widget form, formbox1;
  unsigned long colorname();
  Widget formAv, formColors, formFrequency, formPitch, formAction, formVolume;
  Widget avdown_button, avup_button, colorsup_button, colorsdown_button,
  sspdown_button, sspup_button;
  Widget hertzup_button, hertzdown_button;
  Widget labelAv, labelColors, labelHertz, labelPitch, labelAction, labelVolume;
  Widget pitchup_button, pitchdown_button;
  Widget volumeup_button, volumedown_button;
  Widget dummyav;   // required with Xaw[3d] to fill out the bg from <--->
  XFontStruct *avFont, *colorsFont,*hertzFont,*pitchFont,*actionFont, *volumeFont;

  extern XFontStruct *avDisplayFont, *colorsDisplayFont, *hertzDisplayFont,
    *pitchDisplayFont, *sspDisplayFont, *volumeDisplayFont;

  /* start formAv:: action forms code */
  if(depth>8)
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formbox1,
     XtNfromVert, NULL,
     // TESTING assembly distance from top of form (was 32)
     XtNvertDistance, Do.resizeH(32), //TEST  /* keep formbox1 correctly sized */
     // ASSEMBLY BACKGROUND COLOR AND SHADOW
     XtNbackground, whitesmoke_color.pixel,
     XtNshadowWidth,  1,
     XtNfromHoriz, NULL,
     XtNtop, XawChainTop,
     XtNbottom, XawChainBottom,
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft,
     NULL);
  else
    formAv = XtVaCreateManagedWidget("formAv", formWidgetClass, formbox1,
     XtNfromVert, NULL,
     XtNvertDistance, Do.resizeH(32), //TEST  /* keep formbox1 correctly sized */
     XtNbackground, whitesmoke,
     XtNshadowWidth,  1,
     XtNfromHoriz, NULL,
     XtNtop, XawChainTop,
     XtNbottom, XawChainBottom,  // was XawChainTop.... 
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft,
     NULL);

  /*
   * the ASSEMBLIES created in this file are the first presented to the
   * user.  This ``Control Panel'', if covered by switching to another 
   * panel, is never displayed again.
   * 
   * There are 6 assemblies immediately below: Mode (A/V/AV), Colors,
   * Frequency, Pitch, Action (Start/Pause/Stop), and Volume
   */


  avFont = init_font(display, NCS12);
  labelAv =
    XtVaCreateManagedWidget("labelAv", labelWidgetClass, formAv,
    XtNfont, avFont,
    XtNlabel, L_MODE,
    //  LABEL_COLORS
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNfromVert, NULL,
    XtNfromHoriz, NULL,
    XtNborderWidth, 0,      /* standalone    */
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  /*
   *  Xaw at least needs this dummy label to fill out the blue bg
   *  from left - right  <---> boarder
   */
  dummyav =
    XtVaCreateManagedWidget("dummyav", labelWidgetClass, formbox1,
      XtNlabel, L_DUMMY,
      //XtNshadowWidth,  2,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAv,
      XtNhorizDistance,  Do.resizeH(575), //With no NshadowWidth this is fine
      XtNborderWidth, 0,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  if(depth>8)
    XtVaSetValues(dummyav, XtNbackground, blue_color.pixel, NULL);
  else
    XtVaSetValues(dummyav, XtNbackground, blue, NULL);
  // this old kludge may no longer be necessary

  if(depth>8)
    avup_button =
      XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
        XtNbitmap, UpArrow,
        XtNfromVert, NULL,
        XtNfromHoriz, labelAv,
        // ARROW_COLORS
        XtNbackground,grey_color.pixel,
        XtNforeground,darkblue_color.pixel,
        XtNshadowWidth,  3,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  else
    avup_button =
      XtVaCreateManagedWidget("avup_button", commandWidgetClass, formAv,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAv,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(avup_button, XtNcallback, avup_buttonCB, NULL);

  /*avDisplayFont = init_font(display, TBOLD12);*/

  avDisplayFont = init_font(display, NCS12);
  if(depth>8)
    displayAv =
      XtVaCreateManagedWidget("displayAv", labelWidgetClass, formAv,
      XtNfont,   avDisplayFont,
      XtNlabel,  avDisplayLabels[muuzmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90_color.pixel,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, avup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    displayAv =
      XtVaCreateManagedWidget("displayAv", labelWidgetClass, formAv,
      XtNfont,   avDisplayFont,
      XtNlabel,  avDisplayLabels[muuzmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, avup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  if(depth>8)
    avdown_button =
      XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAv,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
else
    avdown_button =
      XtVaCreateManagedWidget("avdown_button", commandWidgetClass, formAv,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAv,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

XtAddCallback(avdown_button, XtNcallback, avdown_buttonCB, NULL);
  /* END   AV trio     */


  // This is the topform holding the ACTION button-widgets.
  /* start formAction:: action forms code */
  if(depth>8)
    formAction = XtVaCreateManagedWidget("formAction", formWidgetClass,
	 formbox1,
	 XtNfromVert, formAv,
	 XtNfromHoriz, NULL,
	 // ASSEMBLY BACKGROUND COLOR AND SHADOW
	 XtNbackground, whitesmoke_color.pixel,
	 XtNshadowWidth,  2,
	 XtNtop, XawChainTop,
	 XtNbottom, XawChainTop,
	 XtNleft, XawChainLeft,
	 XtNright, XawChainLeft,
	 NULL);
  else
    formAction = XtVaCreateManagedWidget("formAction", formWidgetClass,
     formbox1,
     XtNfromVert, formAv,
     XtNfromHoriz, NULL,
     XtNbackground, whitesmoke,
     XtNshadowWidth,  2,
     XtNtop, XawChainTop,
     XtNbottom, XawChainTop,
     XtNleft, XawChainLeft,
     XtNright, XawChainLeft,
     NULL);

  actionFont = init_font(display, NCS12);
  labelAction =
    XtVaCreateManagedWidget("labelAction", labelWidgetClass, formAction,
    XtNfont, actionFont,
    XtNlabel, L_ACTION,
    //  LABEL_COLORS
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNfromVert, NULL,
    XtNfromHoriz, NULL,
    XtNborderWidth, 0,      /* standalone    */
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  /* begin SSP trio */
  if(depth>8)
    sspup_button =
      XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAction,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    sspup_button =
      XtVaCreateManagedWidget("sspup_button", commandWidgetClass, formAction,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelAction,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(sspup_button, XtNcallback, sspup_buttonCB, NULL);

  /*sspDisplayFont = init_font(display, TBOLD12);*/

  sspDisplayFont = init_font(display, NCS12);
  if(depth>8)
    displayAction =
      XtVaCreateManagedWidget("displayAction", labelWidgetClass, formAction,
      XtNfont, sspDisplayFont,
      XtNlabel, sspDisplayLabels[sspmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90_color.pixel,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, sspup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    displayAction =
      XtVaCreateManagedWidget("displayAction", labelWidgetClass, formAction,
      XtNfont, sspDisplayFont,
      XtNlabel, sspDisplayLabels[sspmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, sspup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  if(depth>8)
    sspdown_button =
      XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAction,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    sspdown_button =
      XtVaCreateManagedWidget("sspdown_button", commandWidgetClass, formAction,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayAction,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(sspdown_button, XtNcallback, sspdown_buttonCB, NULL);
  /* end   SSP trio     */

  /*
   *  These three (assembly) forms on the right are the FIRST-appearing ones.
   */

  /* begin Hertz stuff */
  if(depth>8)
    formFrequency = XtVaCreateManagedWidget("formFrequency", formWidgetClass,
    formbox1,
    XtNfromVert, NULL,
    XtNvertDistance, Do.resizeH(32),   /* lined up with formAv */
    XtNhorizDistance, Do.resizeW(179),    /* right-shift to even appearance */
    // ASSEMBLY BACKGROUND COLOR AND SHADOW
    XtNbackground, whitesmoke_color.pixel,
    XtNshadowWidth,  2,
    XtNfromHoriz, formAv,
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);
  else
    formFrequency = XtVaCreateManagedWidget("formFrequency", formWidgetClass,
    formbox1,
    XtNfromVert, NULL,
    XtNvertDistance, Do.resizeH(32),   /* lined up with formAv */
    XtNhorizDistance, Do.resizeW(179),   /* right-shift to even appearance */
    XtNbackground, whitesmoke,
    XtNshadowWidth,  2,
    XtNfromHoriz, formAv,
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  /*hertzFont = init_font(display, TBOLD12);*/
  hertzFont = init_font(display, NCS12);
  labelHertz =
    XtVaCreateManagedWidget("labelHertz", labelWidgetClass, formFrequency,
	    XtNfont, hertzFont,
	    XtNlabel, L_HERTZ,
	    //  LABEL_COLORS
	    XtNbackground, white_color,
	    XtNforeground, black_color,
	    XtNshadowWidth,  2,
	    XtNfromVert, NULL,
	    XtNfromHoriz, NULL,
	    XtNborderWidth, 0,	/* standalone    */
	    XtNtop, XawChainTop,
	    XtNbottom, XawChainTop,
	    XtNleft, XawChainLeft,
	    XtNright, XawChainLeft,
	    NULL);

  /* begin Hz trio */
  if(depth>8)
    hertzup_button =
      XtVaCreateManagedWidget("hertzup_button", commandWidgetClass,
      formFrequency,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelHertz,
      XtNhorizDistance, Do.resizeW(15),	/* experimental */
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    hertzup_button =
      XtVaCreateManagedWidget("hertzup_button", commandWidgetClass,
      formFrequency,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelHertz,
      XtNhorizDistance, Do.resizeW(15),	/* experimental */
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(hertzup_button, XtNcallback, hertzup_buttonCB, NULL);

  /*hertzDisplayFont = init_font(display, TBOLD12);*/

  hertzDisplayFont = init_font(display, NCS12);
  if(depth>8)
    displayHertz =
      XtVaCreateManagedWidget("displayHertz", labelWidgetClass, formFrequency,
      XtNfont,  hertzDisplayFont,
      XtNlabel, hertzDisplayLabels[frequency],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90_color.pixel,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, hertzup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
else
    displayHertz =
      XtVaCreateManagedWidget("displayHertz", labelWidgetClass, formFrequency,
      XtNfont,  hertzDisplayFont,
      XtNlabel, hertzDisplayLabels[frequency],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, hertzup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  if(depth>8)
    hertzdown_button =
      XtVaCreateManagedWidget("hertzdown_button",commandWidgetClass,
	      formFrequency,
	      XtNbitmap, DownArrow,
	      XtNfromVert, NULL,
	      XtNfromHoriz, displayHertz,
	      // ARROW_COLORS
	      XtNbackground,grey_color.pixel,
	      XtNforeground,darkblue_color.pixel,
	      XtNshadowWidth,  3,
	      XtNtop, XawChainTop,
	      XtNbottom, XawChainTop,
	      XtNleft, XawChainLeft,
	      XtNright, XawChainLeft,
	      NULL);
  else
    hertzdown_button =
      XtVaCreateManagedWidget("hertzdown_button",commandWidgetClass,
      formFrequency,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayHertz,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(hertzdown_button, XtNcallback, hertzdown_buttonCB, NULL);
  /* end   Hz trio     */


  /*
   * Here begins the Pitch assembly, South of Hz and to the right 
   * (horizontalward) of the Action assembly (stop/pause/play).  This
   * need to be shifted N pixels rightward.
   */

  formPitch = XtVaCreateManagedWidget("formPitch", formWidgetClass, formbox1,
      XtNfromVert, formFrequency,
      XtNfromHoriz, formAction,
      XtNhorizDistance, Do.resizeW(179),  /* right-shift to even appearance */
      //  LABEL_COLORS
      XtNbackground, white_color,
      XtNforeground, black_color,
      XtNshadowWidth,  2,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);


  /**pitchFont = init_font(display, TBOLD12);*/

  pitchFont = init_font(display, NCS12);
  labelPitch =
    XtVaCreateManagedWidget("labelHertz", labelWidgetClass, formPitch,
    XtNfont, pitchFont,
    XtNlabel, L_PITCH,   /* Pitch label of 1st control panel */
    //  LABEL_COLORS
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNfromVert, NULL,
    XtNfromHoriz, NULL,
    XtNborderWidth, 0,	/* standalone    */
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  /* begin pitch trio */
  if(depth>8)
    pitchup_button =
      XtVaCreateManagedWidget("pitchup_button", commandWidgetClass, formPitch,
	      XtNbitmap, UpArrow,
	      XtNfromVert, NULL,
	      XtNfromHoriz, labelPitch,
	      // ARROW_COLORS
	      XtNbackground,grey_color.pixel,
	      XtNforeground,darkblue_color.pixel,
	      XtNshadowWidth,  3,
	      XtNtop, XawChainTop,
	      XtNbottom, XawChainTop,
	      XtNleft, XawChainLeft,
	      XtNright, XawChainLeft,
	      NULL);
  else
    pitchup_button =
      XtVaCreateManagedWidget("pitchup_button", commandWidgetClass, formPitch,
	      XtNbitmap, UpArrow,
	      XtNfromVert, NULL,
	      XtNfromHoriz, labelPitch,
	      XtNbackground,grey,
	      XtNforeground,darkblue,
	      XtNshadowWidth,  3,
	      XtNtop, XawChainTop,
	      XtNbottom, XawChainTop,
	      XtNleft, XawChainLeft,
	      XtNright, XawChainLeft,
	      NULL);

  XtAddCallback(pitchup_button, XtNcallback, pitchup_buttonCB, NULL);


  /**pitchDisplayFont = init_font(display, TBOLD12);*/

  pitchDisplayFont = init_font(display, NCS12);
  if(depth>8)
    displayPitch =
      XtVaCreateManagedWidget("displayPitch", labelWidgetClass, formPitch,
      XtNfont,  pitchDisplayFont,
      XtNlabel,  pitchDisplayLabels[octave],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90_color.pixel,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, pitchup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    displayPitch =
      XtVaCreateManagedWidget("displayPitch", labelWidgetClass, formPitch,
      XtNfont,  pitchDisplayFont,
      XtNlabel,  pitchDisplayLabels[octave],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, pitchup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  if(depth>8)
    pitchdown_button =
      XtVaCreateManagedWidget("pitchdown_button", commandWidgetClass, formPitch,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayPitch,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    pitchdown_button =
      XtVaCreateManagedWidget("pitchdown_button", commandWidgetClass, formPitch,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayPitch,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(pitchdown_button, XtNcallback, pitchdown_buttonCB, NULL);

  /* color stuff */
  /* start formColors:: colors stuff */
  if(depth>8)
    formColors = XtVaCreateManagedWidget("formColors", formWidgetClass,
	 formbox1,
	 XtNfromVert, formAction,
	 XtNfromHoriz, NULL,
	 // ASSEMBLY BACKGROUND COLOR AND SHADOW
	 XtNbackground, whitesmoke_color.pixel,
	 XtNshadowWidth,  2,
	 XtNtop, XawChainTop,
	 XtNbottom, XawChainTop,
	 XtNleft, XawChainLeft,
	 XtNright, XawChainLeft,
	 NULL);
  else
    formColors = XtVaCreateManagedWidget("formColors", formWidgetClass,
	 formbox1,
	 XtNfromVert, formAction,
	 XtNfromHoriz, NULL,
	 XtNbackground, whitesmoke,
	 XtNshadowWidth,  2,
	 XtNtop, XawChainTop,
	 XtNbottom, XawChainTop,
	 XtNleft, XawChainLeft,
	 XtNright, XawChainLeft,
	 NULL);

  /**colorsFont = init_font(display, TBOLD12);*/

  colorsFont = init_font(display, NCS12);
  labelColors =
    XtVaCreateManagedWidget("labelColors", labelWidgetClass, formColors,
    XtNfont, colorsFont,
    XtNlabel, L_COLORS,
    //  LABEL_COLORS
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNfromVert, NULL,
    XtNfromHoriz, NULL,
    XtNborderWidth, 0,      /* standalone    */
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft,
    NULL);

  if(depth>8)
    colorsup_button =
      XtVaCreateManagedWidget("colorsup_button", commandWidgetClass, formColors,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelColors,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    colorsup_button =
      XtVaCreateManagedWidget("colorsup_button", commandWidgetClass, formColors,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelColors,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(colorsup_button, XtNcallback, colorsup_buttonCB, NULL);

  colorsDisplayFont = init_font(display, TBOLD12);
  if(depth>8)
    displayColors =
      XtVaCreateManagedWidget("displayColors", labelWidgetClass, formColors,
      XtNfont, colorsDisplayFont,
      XtNlabel, colorsDisplayLabels[colorsmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90_color.pixel,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, colorsup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);
  else
    displayColors =
      XtVaCreateManagedWidget("displayColors", labelWidgetClass, formColors,
      XtNfont, colorsDisplayFont,
      XtNlabel, colorsDisplayLabels[colorsmode],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, colorsup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);

  if(depth>8)
    colorsdown_button =
      XtVaCreateManagedWidget("colorsdown_button", commandWidgetClass,
      formColors,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayColors,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    colorsdown_button =
      XtVaCreateManagedWidget("colorsdown_button", commandWidgetClass,
      formColors,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayColors,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(colorsdown_button, XtNcallback, colorsdown_buttonCB, NULL);

  /* end color stuff */

  if(depth>8)
    formVolume = XtVaCreateManagedWidget("formVolume", formWidgetClass,
      formbox1,
      XtNfromVert, formPitch,
      XtNfromHoriz, formColors,
      XtNhorizDistance, Do.resizeW(211),   /* right-shift to even appearance */
      // ASSEMBLY BACKGROUND COLOR AND SHADOW
      XtNbackground, whitesmoke_color.pixel,
      XtNshadowWidth,  2,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);
  else
    formVolume = XtVaCreateManagedWidget("formVolume", formWidgetClass,
	 formbox1,
	 XtNfromVert, formPitch,
	 XtNfromHoriz, formColors,
	 XtNhorizDistance, Do.resizeW(211), /* right-shift to even appearance */
	 XtNbackground, whitesmoke,
	 XtNshadowWidth,  2,
	 XtNtop, XawChainTop,
	 XtNbottom, XawChainTop,
	 XtNleft, XawChainLeft,
	 XtNright, XawChainLeft,
	 NULL);

  volumeFont = init_font(display, NCS12);
  labelVolume =
    XtVaCreateManagedWidget("labelVolume", labelWidgetClass, formVolume,
    XtNfont, volumeFont,
    XtNlabel, L_VOLUME,
    //  LABEL_COLORS
    XtNbackground, white_color,
    XtNforeground, black_color,
    XtNshadowWidth,  2,
    XtNfromVert, NULL,
    XtNfromHoriz, NULL,
    XtNborderWidth, 0,	/* standalone    */
    XtNtop, XawChainTop,
    XtNbottom, XawChainTop,
    XtNleft, XawChainLeft,
    XtNright, XawChainLeft, NULL);

  /* begin volume trio */
  if(depth>8)
    volumeup_button =
      XtVaCreateManagedWidget("volumeup_button", commandWidgetClass, formVolume,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelVolume,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    volumeup_button =
      XtVaCreateManagedWidget("volumeup_button", commandWidgetClass, formVolume,
      XtNbitmap, UpArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, labelVolume,
      XtNbackground,grey,
      XtNforeground,darkblue,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(volumeup_button, XtNcallback, volumeup_buttonCB, NULL);

  /**volumeDisplayFont = init_font(display, TBOLD12);*/

  volumeDisplayFont = init_font(display, NCS12);
  if(depth>8)
    displayVolume =
      XtVaCreateManagedWidget("displayVolume", labelWidgetClass, formVolume,
        XtNfont,  volumeDisplayFont,
        XtNlabel,  volumeDisplayLabels[volume],
        //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
        XtNbackground, black_color,
        XtNforeground,grey90_color.pixel,
        XtNshadowWidth,  1,
        XtNfromVert, NULL,
        XtNfromHoriz, volumeup_button,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft, NULL);
  else
    displayVolume =
      XtVaCreateManagedWidget("displayVolume", labelWidgetClass, formVolume,
      XtNfont,  volumeDisplayFont,
      XtNlabel,  volumeDisplayLabels[volume],
      //  LABELDISPLAY_COLORS  (shiny black label with light grey type)
      XtNbackground, black_color,
      XtNforeground,grey90,
      XtNshadowWidth,  1,
      XtNfromVert, NULL,
      XtNfromHoriz, volumeup_button,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft, NULL);

  if(depth>8)
    volumedown_button =
      XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
      formVolume,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayVolume,
      // ARROW_COLORS
      XtNbackground,grey_color.pixel,
      XtNforeground,darkblue_color.pixel,
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);
  else
    volumedown_button =
      XtVaCreateManagedWidget("volumedown_button", commandWidgetClass,
      formVolume,
      XtNbitmap, DownArrow,
      XtNfromVert, NULL,
      XtNfromHoriz, displayVolume,
      XtNbackground,grey,\
      XtNforeground,darkblue, \
      XtNshadowWidth,  3,
      XtNtop, XawChainTop,
      XtNbottom, XawChainTop,
      XtNleft, XawChainLeft,
      XtNright, XawChainLeft,
      NULL);

  XtAddCallback(volumedown_button, XtNcallback, volumedown_buttonCB, NULL);

}
