/*
 * $Id: creativity.c,v 1.1 2000/01/29 20:44:49 kline Exp kline $
 */
#include <stdio.h>

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "muuzaudio.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"

extern errMessage program;  // for emsg()


instance_t progCreativity[500];



extern flag_t ccr_flag;   

void
do_creative(int prog)
{
  void XMuuzPrepInformation(char *function, char *version);
  void new_mindset(int prog);
  void visualization (int prog);
  void inspiration (int prog);
  void problem_solving (int prog), imagineering(int prog), 
    alert_creativity(int prog);


  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
  }


  program.emsg(nprint,"\tDO_CREATIVE(): selecting prog = (%d)\n", prog);
  switch(prog)
  {
        case 0:
    new_mindset(prog);
    break;
        case 1:
    visualization(prog);
    break;
        case 2:
    alert_creativity(prog);
    break;
        case 3:
    imagineering(prog);
    break;
        case 4:
    problem_solving(prog);
    break;
        case 5:
    inspiration(prog);
    break;
  }
}

/*
 * trains your mind thru theta and alpha wavestates, flashed to 
 * moderate beta, ending at mid-alpha.
 */
void
new_mindset(int prog)
{
#define NM "NewMindset()"
#define VERNM "0.00"

  void XMuuzErrUnimplemented();
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progCreativity[500];

  instStates ( &progCreativity[++I], 1, 7, WHITE, MID, 4, 0);
  instStates ( &progCreativity[++I], 5, 5, ORANGE, MID, 5, 0);
  instStates ( &progCreativity[++I], 5, 9, YELLOW, MID, 2, 0);
  instStates ( &progCreativity[++I], 17, 11, VRED, LOW, 4, 0);
  instStates ( &progCreativity[++I], 23, 17, SKYBLUE, MID, 5, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
    program.emsg(nprint, "LEAVING new_mindset(): play = (%d), ccr_flag = (%d)\n", play,ccr_flag);
}

/*
 * In 13 minutes move from 3 to 13Hz (delta, theta, to low-alpha)
 * for a rapid and relaxed creativite prog.
 */
void
visualization (int prog)
{
  void XMuuzErrUnimplemented();
#define VZ "Visualization()"
#define VERVZ "0.00"

  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progCreativity[500];

  XMuuzPrepInformation(VZ, VERVZ);
  program.emsg(nprint,"ENTERING f_inspiration(): play =(%d), ccr_flag =(%d)\n",
    play,ccr_flag);
  instStates ( &progCreativity[++I], 4, 2, ORANGE, MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 1, ORANGE, MID, 2, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}

void
alert_creativity(int prog)
{
  void XMuuzErrUnimplemented();
#define AC "AlterCreativity()"
#define VERAC "0.00"

  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int); 
  void startPrep(int);
  extern instance_t progCreativity[500];

  XMuuzPrepInformation(AC, VERAC);
  program.emsg(nprint, "ENTERING test(): play = (%d), ccr_flag = (%d)\n",
    play,ccr_flag);
  instStates ( &progCreativity[++I], 8, 1, WHITE,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}



/*
 * ranges from 4 to 12 Hz, bouncing energetically in the 5 to 10 Hz range
 * primary, with very short state intervals.  encourages, sjarpers imagination
 * and capacity.
 */

void
imagineering(int prog)
{
  void XMuuzErrUnimplemented();
#define IG "Imagineering()"
#define VERIG "0.00"

  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;

   void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int); 
  void startPrep(int);
  extern instance_t progCreativity[500];

  // Re code:: XMuuzErrUnimplemented();      // Until 2001 or '02, perhaps.
  XMuuzPrepInformation(IG, VERIG);
  program.emsg(nprint, "ENTERING test(): play = (%d), ccr_flag = (%d)\n",
    play,ccr_flag);
  instStates ( &progCreativity[++I], 12, 9, WHITE,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 3, 2, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 3, 2, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 4, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 2, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 7, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0); 
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);

  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 5, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);

  // HERE
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 5, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 4, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 2, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 5, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 4, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 4, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 5, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 9, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 7, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 4, 2, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 5, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 6, 4, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 7, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 9, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 5, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 10, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 11, 8, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], 12, 13, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}
void
problem_solving(int prog)
{
  void XMuuzErrUnimplemented();
#define PS "ProblemSolving()"
#define VERPS "0.00"

  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;

   void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int); 
  void startPrep(int);
  extern instance_t progCreativity[500];

  // Re code:: XMuuzErrUnimplemented();      // Until 2001 or '02, perhaps.
  XMuuzPrepInformation(PS, VERPS);
  program.emsg(nprint, "ENTERING test(): play = (%d), ccr_flag = (%d)\n",
    play,ccr_flag);
  instStates ( &progCreativity[++I], 8, 1, WHITE,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}


void
inspiration(int prog)
{
  void XMuuzErrUnimplemented();
#define IS "Inspiration()"
#define VERIS "0.00"

  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int); 
  void startPrep(int);
  extern instance_t progCreativity[500];

  // Re code:: XMuuzErrUnimplemented();      // Until 2001 or '02, perhaps.
  XMuuzPrepInformation(IS, VERIS);
  program.emsg(nprint, "ENTERING test(): play = (%d), ccr_flag = (%d)\n",
    play,ccr_flag);
  instStates ( &progCreativity[++I], 8, 1, WHITE,  MID, 2, 0);
  instStates ( &progCreativity[++I], 8, 3, YELLOW,  MID, 2, 0);
  instStates ( &progCreativity[++I], END, END, YELLOW,  MID, 2, 0);
  (void) startPrep(prog);
}
/*

7; 8; 5; 10; 5; 11; 5; 9; 5; 7; 9; 4; 8; 6; 10; 7; 9; 5; 10
5  11  6; 9; 5; 7; 9; 4; 8; 6; 10; 7; 9; 5; 10; 5 ; 11; 5 ; 9; 5; 7; 9;
4.8. 6. 10; 7; 9; 5; 10; 12 (12secs)

*/

