
/*
 * $Id: do_colors.c,v 1.2 2000/03/07 05:50:18 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"
#include "getDisplayValues.h"
#include "misc.h"
#include "main.h"

extern errMessage program;  // for emsg()


xcolor_t blue, green, grey, grey85, grey90, lightskyblue, orange, pink, brown1,
  lightpink, red, darkblue, slategrey, yellow, black_color, white_color,
  whitesmoke, darkred;


unsigned long global_flash_color;
XColor blue_color, exact_color, pink_color, grey_color, orange_color,
       red_color, hotpink_color, yellow_color, skyblue_color, brown1_color,
       slategrey_color, green_color, darkblue_color, peru_color, grey85_color,
       grey90_color, whitesmoke_color, darkred_color;




int
colorindex(Widget w, int r, int g, int b)
{
  Display        *display;
  int             screen;
  extern Colormap private_cmap;
  XColor          color;

  color.red = r<<8;
  color.green = g<<8;
  color.blue = b<<8;

  if (XAllocColor(display, private_cmap, &color))
    return (color.pixel);
  else
  {
    program.emsg(warning, "Warning: can't allocate requested colour\n",_fl_);
    return (WhitePixel(display, screen));
  }
}



/*
 * initialize color-set for muuz
 */
void
XMuuzInitColors(Display * display, int screen)
{
  extern XColor blue_color, exact_color, pink_color, grey_color, orange_color,
    hotpink_color, yellow_color, skyblue_color, slategrey_color;
  extern unsigned long int white_color;
  Status   status;
  void XMuuzColorAllocError(int, const char *), 
    XMuuzColorLookupError(const char *color);

  /*
   * get some colors from the default colormap.
   */

  /* Lookup the color name in system database */

  status = XLookupColor(display, DefaultColormap(display, screen),  /* blue */
			CBLUE, &exact_color, &blue_color);
  /* begin scope */
  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CBLUE,&blue_color);
    if (status == 0)
	XMuuzColorLookupError(CBLUE);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&blue_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CBLUE);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CBLUE, &blue_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CBLUE);
  }
  /* end scope */

  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CSLATEGREY,&slategrey_color);
    if (status == 0)
	XMuuzColorLookupError(CSLATEGREY);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&blue_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CSLATEGREY);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CSLATEGREY, &slategrey_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CSLATEGREY);
  }

  status = XLookupColor(display, DefaultColormap(display, screen),  /* pink */
			CPINK, &exact_color, &pink_color);

  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CPINK,&pink_color);
    if (status == 0)
	XMuuzColorLookupError(CPINK);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&pink_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CPINK);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CPINK, &pink_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CPINK);
  }


  status = XLookupColor(display, DefaultColormap(display, screen), /* skyblue */
			CLIGHTSKYBLUE, &exact_color, &skyblue_color);

  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CLIGHTSKYBLUE,&skyblue_color);
    if (status == 0)
	XMuuzColorLookupError(CLIGHTSKYBLUE);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&skyblue_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CLIGHTSKYBLUE);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CLIGHTSKYBLUE, &skyblue_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CLIGHTSKYBLUE);
  }

  program.emsg(trace,"DO_DEBUG: XcolorLookup status = (%d)\n", status);

  status = XLookupColor(display, DefaultColormap(display, screen),
			CGREY, &exact_color, &grey_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CGREY,&grey_color);
    if (status == 0)
	XMuuzColorLookupError(CGREY);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&grey_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CGREY);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CGREY, &grey_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CGREY);
  }


  status = XLookupColor(display, DefaultColormap(display, screen), /* orange */
			CORANGE, &exact_color, &orange_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CORANGE,&orange_color);
    if (status == 0)
	XMuuzColorLookupError(CORANGE);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&orange_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CORANGE);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CORANGE, &orange_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CORANGE);
  }

#ifdef WE_NEED_BLACK_LOOKUP
  status = XLookupColor(display, DefaultColormap(display, screen), /* black */
			CBLACK, &exact_color, &black_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CBLACK,&black_color);
    if (status == 0)
	XMuuzColorLookupError(CBLACK);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&black_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CBLACK);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CBLACK, &black_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CBLACK);
  }
#endif // Do black lookup


  status = XLookupColor(display, DefaultColormap(display, screen), /* yellow */
			CYELLOW, &exact_color, &yellow_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CYELLOW,&yellow_color);
    if (status == 0)
	XMuuzColorLookupError(CYELLOW);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&yellow_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CYELLOW);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CYELLOW, &yellow_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CYELLOW);
  }

  /*  DARKRED */
  status = XLookupColor(display, DefaultColormap(display, screen),
			CDARKRED, &exact_color, &darkred_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CDARKRED,&darkred_color);
    if (status == 0)
	XMuuzColorLookupError(CDARKRED);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&darkred_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CDARKRED);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CDARKRED, &darkred_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CDARKRED);
  }
  // End DARKRED

  /*  GREY90 */
  status = XLookupColor(display, DefaultColormap(display, screen),
			CGREY90, &exact_color, &grey90_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CGREY90,&grey90_color);
    if (status == 0)
	XMuuzColorLookupError(CGREY90);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&grey90_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CGREY90);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CGREY90, &grey90_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CGREY90);
  }
  // END GREY90

  /*  WHITESMOKE */
  status = XLookupColor(display, DefaultColormap(display, screen),
			CWHITESMOKE, &exact_color, &whitesmoke_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CWHITESMOKE,&whitesmoke_color);
    if (status == 0)
	XMuuzColorLookupError(CWHITESMOKE);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&whitesmoke_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CWHITESMOKE);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CWHITESMOKE, &whitesmoke_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CWHITESMOKE);
  }
  // END WHITESMOKE


  /*  BROWN1 */
  status = XLookupColor(display, DefaultColormap(display, screen),
			CBROWN1, &exact_color, &brown1_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CBROWN1,&brown1_color);
    if (status == 0)
	XMuuzColorLookupError(CBROWN1);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&brown1_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CBROWN1);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CBROWN1, &brown1_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CBROWN1);
  }
  // END BROWN1

  /*  HOTPINK */
  status = XLookupColor(display, DefaultColormap(display, screen),
			CHOTPINK, &exact_color, &hotpink_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen), 
			CHOTPINK,&hotpink_color);
    if (status == 0)
	XMuuzColorLookupError(CHOTPINK);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&hotpink_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CHOTPINK);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CHOTPINK, &hotpink_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CHOTPINK);
  }

  // END RED

  /* RED */
  status = XLookupColor(display, DefaultColormap(display, screen),
                        CRED, &exact_color, &red_color);
  if (status == 0)
  {
    status = XParseColor(display, DefaultColormap(display,screen),
                        CRED,&red_color);
    if (status == 0)
        XMuuzColorLookupError(CRED);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
                &red_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CRED);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
                            CRED, &red_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CRED);
  }
  /** need this default, too **/
  black_color  = BlackPixel(display, screen);
  white_color  = WhitePixel(display, screen);


  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CGREEN,&green_color);
    if (status == 0)
	XMuuzColorLookupError(CGREEN);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&green_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CGREEN);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CGREEN, &green_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CGREEN);
  }

  /* grey85 */
  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CGREY85,&grey85_color);
    if (status == 0)
	XMuuzColorLookupError(CGREY85);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&grey85_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CGREY85);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CGREY85, &grey85_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CGREY85);
  }
  /* end grey85 */


  /* darkblue */
  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CRBLUE4,&darkblue_color);
    if (status == 0)
	XMuuzColorLookupError(CRBLUE4);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&darkblue_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CRBLUE4);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CRBLUE4, &darkblue_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CRBLUE4);
  }
  /* end darkblue */

  /* begin peru */      /* testing WOOD colors: peru, saddlebrown, sienna,
			 * burlywood, firebrick
			 */
  if (status == 0)
  {
    /* 
     * Maybe the input is not a color name; treat it as a 
     * standard color string 
     */
    status = XParseColor(display, DefaultColormap(display,screen), 
			CPERU,&peru_color);
    if (status == 0)
	XMuuzColorLookupError(CPERU);
    else
    {
      status = XAllocColor(display,DefaultColormap(display,screen),
		&peru_color);
      if ( status == 0)
        XMuuzColorAllocError(0, CPERU);
    }
  }
  else
  {
      status = XAllocNamedColor(display, DefaultColormap(display, screen),
			    CPERU, &peru_color, &exact_color);
      if ( status == 0)
        XMuuzColorAllocError(1, CPERU);
  }
  /* end peru */

  /*
   * not_yet
  XMuuzSetAudioColors();
   */
}




/* 
 *  TEST (24jan99)  create private colormap for muuz.
 */

#if 0
Boolean
XXallocate_private_colormap(Widget _w, Colormap &ret_cmap)
{
#include <stdlib.h>

   int i,  num_reserve_colors;
   Visual *visual;
   Display *display;
   XVisualInfo vinfo;
   Window win;
   Colormap old_cmap, new_cmap;
   Screen *screen;
   XColor *colors;
   unsigned long pix_mask[1], *pixels;
   int scn_num;
   getDisplayValues value;


   display = value.returnDisplay(_w);
   screen = value.returnScreen(_w);
   scn_num = value.returnScreenNumber(_w);
   visual = value.returnVisual(_w); //(display, scn_num);
   win = value.returnWindow(_w);    

   old_cmap = DefaultColormap(display, scn_num);

   program.emsg(nprint,"DEB:  old_cmap = (%d)\n", old_cmap);


   if (!XMatchVisualInfo(display, scn_num, DefaultDepth(display, scn_num),
                         PseudoColor, &vinfo)) {
      return False;
   }
  /* 
   * Check the Visual type of the system to make sure
   * this program can be executed correctly on it 
   *** modified visual->class to visual->c_class for C++ (~~+225 X11/Xlib.h)
   */

  if ((visual->c_class == StaticGray) || (visual->c_class == StaticColor)
     || (visual->c_class == TrueColor)) 
  {
    program.emsg(warning, 5,
      "The underlying system is unsuitable for this application", _fl_);
    return False;
  }



   new_cmap = XCreateColormap(display, win, vinfo.visual, AllocNone);

   colors = (XColor *)malloc (sizeof ( XColor[vinfo.colormap_size]));
   pixels = (unsigned long *)malloc(sizeof(unsigned long[vinfo.colormap_size]));

   program.emsg(debug,"vinfo.colormap_size = (%d)\n", vinfo.colormap_size);

   num_reserve_colors = vinfo.colormap_size/2;

   for (i=0; i < num_reserve_colors; i++) {
      colors[i].pixel = i;
      colors[i].flags = DoRed | DoGreen | DoBlue;
   }

   XQueryColors(display, old_cmap, colors, num_reserve_colors);
   for (i=0; i<num_reserve_colors; i++) {
      XAllocColor(display, new_cmap, &colors[i]);

      if (colors[i].pixel != i) {
         XAllocColorCells(display, old_cmap, False, pix_mask, 0, pixels, 1);
         colors[i].pixel = i;
         colors[i].flags = DoRed | DoGreen | DoBlue;
         XStoreColor(display, new_cmap, &colors[i]);
      }
   }

   old_cmap = new_cmap;
   screen->cmap = new_cmap;
   ret_cmap = new_cmap;
   
   XInstallColormap(display, ret_cmap);
   return True;
}  
#endif

unsigned long
returnNamedColor(Widget w, char *colorname)
{
  Display        *cdisplay;
  int             screen;
  extern Colormap        private_cmap;
  XColor          color, exact;
    
  cdisplay = XtDisplay(w);
  screen = DefaultScreen(cdisplay);
   
   
   
  if (XAllocNamedColor(cdisplay, private_cmap, colorname, &color, &exact))
  {
    program.emsg(debug,"returnNamedColor() returning (%ld) for [%s]",
      color.pixel, colorname, _fl_);
    return (color.pixel);
  }
  else
  {
    program.emsg(debug,"Warning: can't allocate requested xcolor_t [%s]\n", 
      colorname, _fl_);
    return (WhitePixel(cdisplay, screen));
  }
}  

/*
 * initialize various global xcolor_t up front.
 */
void
XMuuzInitNamedColors(Widget w)          /* EXPERIMENTAL :: 07feb99    */
{
  unsigned long returnNamedColor(Widget w, char *colorname);
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
    orange, pink, red, darkblue, slategrey, yellow;

    black_color= BlackPixel(display, DefaultScreen(display)); /* get default */
    blue = returnNamedColor(w, "blue");
    green = returnNamedColor(w, "green");
    grey = returnNamedColor(w, "grey");
    grey85 = returnNamedColor(w, "grey85");
    lightskyblue = returnNamedColor(w, "LightSkyBlue");
    orange = returnNamedColor(w, "orange");
    //pink = returnNamedColor(w, "pink1");
    lightpink = returnNamedColor(w, "lightpink");
    red = returnNamedColor(w, "red");
    darkblue = returnNamedColor(w, "darkblue");
    slategrey = returnNamedColor(w, "slategrey");
    white_color  = WhitePixel(display, DefaultScreen(display));/* get default */
    yellow = returnNamedColor(w, "yellow");
}


/* allocate private colormap */
#if 0
Boolean 
allocate_private_colormap(Widget _w, Colormap &_ret_cmap)
{
   Display *dpy;
   Visual *viz;
   XVisualInfo vinfo;
   Window win;
   Colormap old_cmap, new_cmap;
   Screen *scn;
   XColor *colors, c;
   unsigned long pix_mask[1], *pixels;
   int scn_num;

   dpy = XtDisplay(_w);
   scn = XtScreen(_w);
   scn_num = DefaultScreen(dpy);
   win = RootWindow(dpy, XScreenNumberOfScreen(scn));

   old_cmap = DefaultColormap(dpy, scn_num);

   if (!XMatchVisualInfo(dpy, scn_num, DefaultDepth(dpy, scn_num),
                         PseudoColor, &vinfo))
      if (!XMatchVisualInfo(dpy, scn_num, DefaultDepth(dpy, scn_num),
                         DirectColor, &vinfo))
      {
         return false;
      }

   new_cmap = XCreateColormap(dpy, win, vinfo.visual, AllocNone);

   colors = new XColor[vinfo.colormap_size];
   pixels = new unsigned long[vinfo.colormap_size];

   int i;
   int num_reserve_colors = vinfo.colormap_size/2;

   for (i=0; i < num_reserve_colors; i++) {
      colors[i].pixel = i;
      colors[i].flags = DoRed | DoGreen | DoBlue;
   }

   XQueryColors(dpy, old_cmap, colors, num_reserve_colors);
   for (i=0; i<num_reserve_colors; i++) {
      XAllocColor(dpy, new_cmap, &colors[i]);

      if (colors[i].pixel != i) {
         XAllocColorCells(dpy, old_cmap, false, pix_mask, 0, pixels, 1);
         colors[i].pixel = i;
         colors[i].flags = DoRed | DoGreen | DoBlue;
         XStoreColor(dpy, new_cmap, &colors[i]);
      }
   }

   old_cmap = new_cmap;
   scn->cmap = new_cmap;

   _ret_cmap = new_cmap;
   return true;
}
#endif
