

/* Modified after::
 *  Copyright (c) 1997 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */




#include "muuz.h"
#include "globals.h"
#include "do_private.h"
#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include "copyright.h"


#ifdef INTEGRATING
Widget          top;
Display        *dpy;        /* pointer to the display we're on      */
}
#endif

static char *colors[] = {
  "firebrick", "tan", "mediumspringgreen", "paleturquoise", "peachpuff",
  "lightcyan", "grey90", "purple",
    "lightpink", "darkblue", "slategrey",
    "yellow", "blue", "grey", "red", "green", "grey85",
    "lightskyblue1", "orange", "black", "white", "whitesmoke",
    "darkred"
};
static Pixel color[XtNumber(colors)];
static Colormap _cmap;



Colormap
p_cmap::XMuuzAllocatePrivateColormap(Display *dpy, Widget top)
{
  Visual *visual;
  XVisualInfo vinfo;
  Colormap cmap;
  p_cmap map;
  Window win;
  int visualFound = 0;

  if (XMatchVisualInfo(dpy, DefaultScreen(dpy),
			DefaultDepth(dpy, DefaultScreen(dpy)),
//			8,
                        PseudoColor, &vinfo))
  {
    program.emsg(nprint, "Found PseudoColor visual.\n", _fl_);
    visualFound++;
  }
  else if (!visualFound && XMatchVisualInfo(dpy, DefaultScreen(dpy),
    			 DefaultDepth(dpy, DefaultScreen(dpy)),
                        DirectColor, &vinfo))
  {
    program.emsg(nprint,"Found DirectColor visual.\n", _fl_);
    visualFound++;
  }
  else if (!visualFound && XMatchVisualInfo(dpy, DefaultScreen(dpy),
      			 DefaultDepth(dpy, DefaultScreen(dpy)),
                          TrueColor, &vinfo))
  {
    program.emsg(nprint, 
      "Found TrueColor visual, depth %d.\n",
	DefaultDepth(dpy, DefaultScreen(dpy)));
    visualFound++;
  }
  else if (!visualFound && XMatchVisualInfo(dpy, DefaultScreen(dpy), 
		         DefaultDepth(dpy, DefaultScreen(dpy)),
			 StaticColor, &vinfo))
  {
    program.emsg(nprint, "Found StaticColor visual.\n");
    visualFound++;
  }

  if(!visualFound)
  {
    program.emsg(nprint, "Found no color visual.\n");
    return (Colormap)NULL;
  }

  visual = vinfo.visual;

  if ((visual->c_class == StaticGray) || (visual->c_class == StaticColor)
     || (visual->c_class == TrueColor))
  {
    program.emsg(nprint,
      "The underlying system is unsuitable for this application");
    return (Colormap)NULL; 
  }
  cmap = DefaultColormapOfScreen (XtScreen(top));
  if ((cmap = map.PrivateColormap (dpy, cmap )) == (Colormap)NULL)
    return (Colormap)NULL; 
  cmap = initPrivateColormap ( top, cmap);
  if ( cmap == (Colormap)NULL) {
     program.emsg(nprint, "Error: can't create XColor colormap, exiting.\n");
     return (Colormap)NULL; 
  }
  else
  {
    XtVaSetValues ( top, XtNcolormap, cmap, NULL ); // after setup and init.
    return cmap;
  }
}




Colormap
p_cmap::PrivateColormap( Display *dpy, Colormap cmap)
{
  Colormap private_cmap;

  private_cmap = XCopyColormapAndFree ( dpy, cmap );
  if (private_cmap == (Colormap)BadAlloc||private_cmap == (Colormap)BadColor)
  {
     return (Colormap)NULL;
  }
  _cmap = private_cmap;     
  return private_cmap;
}

/*
** Allocate all colors in color table.  If it fails, create a
** new, private colormap and return it.  Return NULL if any failures.
*/
Colormap initPrivateColormap(Widget top, Colormap cmap)
{ 
  p_cmap map;
  XColor actual, exact;
  Display *dpy = XtDisplay (top);
  short int i;
  Bool oneRetry = False;
  char *caerr = "Warning: private cmap allocation failure, retrying color";

  for (i = 0; i < XtNumber(colors); i++)
  {
    if ( !XAllocNamedColor( dpy, cmap, colors[i], &actual, &exact) ) 
    {
      if (oneRetry == True)
        return (Colormap) NULL;
  
      program.emsg(nprint,"%s \"%s\".\n", caerr, colors[i]);
      if ( (cmap = map.PrivateColormap( dpy, cmap )) == (Colormap)NULL)
        return (Colormap) NULL;
      oneRetry =True;
    } else {
      /* Successful, add to color table */
      color[i] = actual.pixel;
      oneRetry = False;
    }
  }
  _cmap = cmap;
  return cmap; 
}

void quit(Widget w,XtPointer client,XtPointer call)
{ 
    exit(0);
}

/*
 * initialize various global xcolor_t up front.
 */
void
p_cmap::XMuuzInitNamedColors(Screen *screenp)
{
  //unsigned long returnNamedColor(Widget w, char *colorname);
  extern Pixel color[];
  extern xcolor_t blue, green, grey, grey85, lightskyblue, orange, brown1,
    pink, red, darkblue, slategrey, yellow, black_color, white_color,
    whitesmoke, grey90, darkred;



  brown1 = color[BROWN1];
  blue = color[BLUE];
  green = color[GREEN];
  grey = color[GREY];
  grey85 = color[GREY85];
  grey90 = color[GREY90];
  lightskyblue = color[LIGHTSKYBLUE1];
  orange = color[__ORANGE];
  //pink = color[PINK1];
  lightpink = color[LIGHTPINK];
  red = color[RED];
  darkblue = color[DARKBLUE];
  slategrey = color[SLATEGREY];
  yellow = color[LIGHTYELLOW2];
  black_color = color[BLACK];
  white_color = color[__WHITE];
  whitesmoke = color[WHITESMOKE];
  darkred = color[DARKRED];
}   
