/*
 * $Id: energize.c,v 1.1 2000/01/29 20:44:55 kline Exp kline $
 */


#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "muuzaudio.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"

extern errMessage program;  // for emsg()


instance_t progEnergize[100];



extern flag_t cen_flag;   
extern short int reverse;
extern int decrement;

void
do_energize(int prog)
{
  void zoom(int), hi_energy(int);
  void powerboost(int), ramp_up(int), workout(int); 
  void fuel(int), erotic_energy(int);

  program.emsg(nprint,"DO_ENERGIZE(): selecting prog = (%d)\n", prog);

  if (beatsPid)
  {
    kill(beatsPid, SIGINT);
  }


  switch(prog)
  {
  case 0:
    zoom(prog);
    break;
  case 1:
    hi_energy(prog);
    break;
  case 2:
    powerboost(prog);
    break;
  case 3:
    ramp_up(prog);
    break;
  case 4:
    workout(prog);
    break;
  case 5:
    fuel(prog);
    break;
  case 6:
    erotic_energy(prog);
    break;

  }

}

/*
 * from 5 to 30: 
* build rapidly to a zoom of energy.  up from theta to alpha; alpha to mid-beta
* and stepping back for effect, then zooming forward.  more emphasis on the
* steady upbeat:: exiting at 30Hz.
 */
void
zoom(int prog)
{
#define ZM "RelaxInto()"
#define VERZM "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(ZM, VERZM);
  program.emsg(nprint,"ENTERING zoom(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 9, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 10, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 11, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 12, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 13, 17, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 7, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 14, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 15, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 16, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 17, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 18, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 19, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 20, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 22, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 23, 47, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 13, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 14, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 15, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 16, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 17, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 18, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 19, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 23, 13, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 24, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 25, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 26, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 27, 71, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 17, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 19, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 23, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 27, 71, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 19, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 20, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 21, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 23, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 27, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 28, 43, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 29, 71, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 7, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 11, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 13, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 17, 7, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 19, 11, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 23, 13, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 27, 17, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 29, 27, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 30, 67, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 5, 2, WHITE, MID, 2, 0);
  instStates ( &progEnergize[++I], 17, 2, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 29, 71, ORANGE, MID, 2, 0);
  instStates ( &progEnergize[I++], 30, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);
}


/*
 * 7-23hz; 13*60
 */

void
hi_energy(int prog)
{
#define HE "RelaxInto()"
#define VERHE "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(HE, VERHE);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 11, 3, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 9, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 8, 7, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 8, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 9, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 10, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 11, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 12, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 13, 13, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 14, 19, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 15, 29, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 16, 37, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 41, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 11, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 12, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 13, 17, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 19, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 18, 23, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 27, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 29, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 21, 31, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 22, 37, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 41, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 13, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 14, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 15, 17, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 16, 19, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 23, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 27, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 29, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 21, 31, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 37, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 18, 7, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 11, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 13, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 21, 17, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 22, 19, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 43, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 11, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 13, 11, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 13, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 27, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 43, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 8, 17, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 9, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 10, 3, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 11, 13, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 12, 17, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 13, 19, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 14, 23, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 15, 27, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 16, 29, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 31, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 18, 37, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 41, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 43, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 21, 47, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 22, 51, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 53, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 7, 2, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 17, 7, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 19, 11, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], 23, 59, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);

}

void
powerboost(int prog)
{
#define PB "RelaxInto()"
#define VERPB "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(PB, VERPB);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 21, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 5, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 9, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);

}

/*
 * 27 - 1Hz:: 15*60s:: staggered
 */

void
ramp_up(int prog)
{
#define RU "RelaxInto()"
#define VERRU "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(RU, VERRU);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 21, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 5, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 9, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);

}

/*
 * 1-21Hz:: 19*60s
 */

void
workout(int prog)
{
#define WO "RelaxInto()"
#define VERWO "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(WO, VERWO);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 21, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 5, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 9, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);

}
/*
 * 25-4hz:: 17*60s
 */
void
fuel(int prog)
{
#define FL "RelaxInto()"
#define VERFL "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(FL, VERFL);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 21, 5, WHITE, MID, 2, 0);
  instStates ( &progEnergize[I++], 20, 5, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 9, 5, YELLOW, MID, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, MID, 2, 0);

  (void)startPrep(prog);

}


/*
 * schema: 7.0hz 45s; 8: 15s; 9; 15s ;  10-15, 11h-10s, 12-10;13/10s,
 *   14/10s, 15/10s, 16/10, 17/7, 18/7; 19/7; 20/10s; 21hz/90s hold
  21hz/120 (pitch-up from low to med);  //soft vol
  21hz/120 (pitch-up from low to med);  //soft vol
  21hz/120 (pitch-up from med to high);  //soft vol
 */

void
erotic_energy(int prog)
{
#define EO "RelaxInto()"
#define VEREO "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I = UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progEnergize[100];

  XMuuzPrepInformation(EO, VEREO);
  program.emsg(nprint,"ENTERING hi_energy(): play = (%d), cen_flag = (%d)\n",
    play,cen_flag);
  instStates ( &progEnergize[++I], 7, 45, WHITE, LOW, 2, 0);
  instStates ( &progEnergize[I++], 8, 15, SKYBLUE, LOW, 5, 0);
  instStates ( &progEnergize[I++], 9, 15, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 10, 10, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 11, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 12, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 13, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 14, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 15, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 16, 7, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 17, 9, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 18, 9, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 19, 11, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 20, 11, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 5 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 5 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 5 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 5 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 6 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 6 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 6 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 6 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 7 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 7 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 7 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 7 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 8 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 8 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 8 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 8 c_ch
  instStates ( &progEnergize[I++], 21, 45, YELLOW, LOW, 2, 0); // 10 c_ch
  instStates ( &progEnergize[I++], 30, 11, YELLOW, LOW, 2, 0);
  instStates ( &progEnergize[I++], END, END, YELLOW, LOW, 2, 0);

  (void)startPrep(prog);

}
