/* 
 * msg.h - Class header for err|debug output.
 * $Id: errMessage.h,v 1.1 2000/01/29 20:45:01 kline Exp kline $
 */

#if !defined(ERRMSG_H)
#define ERRMSG_H

#define MSG_CATEGORIES 6 
#define MSG_COUNT_LIMIT 512
#define _fl_  __FILE__,(int)__LINE__
#define _FL_  __FILE__,(int)__LINE__
#define EMSG(a,b) emsg(a,b,__FILE_,__LINE__)

typedef enum {trace,debug,warning,error,fatal,doabort,nprint} ecategory_t;
typedef int severity_t;

class errMessage 
{
private:
  bool doAbort;
  unsigned int msg_warnings;
  severity_t severity_level;
  char *___progn;
  int nargs;

public:

  errMessage() 
    {nargs = -1;msg_warnings = MSG_COUNT_LIMIT, ___progn = NULL;doAbort=false;}
  // set program name to argv[0] or to the definition.
  void setNargs(int argc) { nargs = argc;}
  int getNargs(void) { if (!(nargs < 0)) return nargs; }
  void setProgname(char *argv0, char *def)
    { ___progn = (argv0 != NULL && (char *)*argv0 != NULL)?argv0:def;}
  // Return program name set by setProgname, or an empty string if not set.
  char *getProgname(void) { return ___progn != NULL ? ___progn : (char *)""; }

  void msgExit(ecategory_t category);
  void msg_printf(const char *fmt, ...);
  char * parse_preface(const char *);
  void msg_fatal(char *);


  // with severity AND _fl_
  void emsg(ecategory_t category, severity_t severity, const char *args, 
    char *file, int line);
  // with no severity AND with varargs.
  void emsg(ecategory_t category, const char *, ...);
  // WITH severity AND with varargs.
  void emsg(ecategory_t category, severity_t severity, const char *args, ...);
  // Without severity AND _fl_
  void emsg(ecategory_t category, const char *args, char *file, int line);
};
#endif /* ERRMSG_H */

/*
 * Use: setProgname(argv[0], "test); or setProgname("", "test"); or
 *      setProgname(argv[0], "");
 * Use: printf("program name is [%s]\n", program.getProgname);
 *
 * emsg( category[trace,debug,error,warning,fatal, nprint],  MASK [ 1 to 5],
     "message string", [_fl_ | _FL_] );
 *
 * examples of emsg() use:
        emsg(debug, "Testing code", _fl_);
        emsg(error,  3, "Error case code", _fl_);
        emsg(warning,   "Code warning in %s!", file );
        emsg(warning, 2,   "Code warning!" );
        emsg(warning, 5,   "Code warning!", _fl_ );
        emsg(fatal,   "FATAL glitch" _FL_ );
        emsg(trace, 5, "tracing fatal glitch" _FL_ );
        emsg(doabort, 5, "Aborting run:" _FL_ );
        emsg(doabort, "Aborting run:" _fl_ );
 */
