/*
 * $Id: flashForm.c,v 1.1 2000/01/29 20:45:03 kline Exp kline $
 * 
 *  class for changing flashform ((and other??)) background colors
 */

#include "globals.h"
#include "muuz.h"
#include "muuztypes.h"
#include "flashForm.h"
#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include "copyright.h"


#include "errMessage.h"

extern errMessage program;  // for emsg()
/*
       XFillRectangle(display, d, gc, x, y, width, height)
             Display *display;
             Drawable d;
             GC gc;
             int x, y;
             unsigned int width, height;

      window = XtWindow (toplevel);

*/

/*      
 *  set the flashing display window to its  original slategrey color.
 *  also, reset the STOP/PLAY/PAUSE label to stop. 
 */
void flashForm::
setFormColor(unsigned short int color)
{                
  extern action_t sspmode;
  extern xcolor_t  slategrey;
  
  Arg wargs[1];
  extern char *sspDisplayLabels[];
  extern Display  *flashdisplay;
  extern GC flashgc;
  extern Widget displayAction;
  extern XGCValues flashes_gcv;
  unsigned short int n = 0;
  
  if (color == SLATEGREY)
  {
    if(depth>8)
      flashes_gcv.foreground = slategrey_color.pixel; /* was blue_color */
    else
      flashes_gcv.foreground = slategrey; /* was blue_color */
    sspmode = STOP;
    program.emsg(nprint,"WARNING: sspmode is Off--> STOP, we can't play", _fl_);
    program.emsg(nprint,"WARNING: sspmode is (%d)\n", sspmode, _fl_);
  }
  else if (color == GREY)
  {
    if(depth>8)
      flashes_gcv.foreground = grey_color.pixel; 
    else
      flashes_gcv.foreground = grey; 
    sspmode = PAUSE;
  }
  XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
  XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
    Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
  XSync(flashdisplay, False);
  XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] ); n++;
  XtSetValues(displayAction, wargs, n);
  program.emsg(nprint, "DEB:setFormColor hit:: sspmode = (%d)\n", sspmode);
}
/*
 *  set the flashing display window to its  original slategrey color.
 */
void flashForm::
setFormSlategrey()
{
  extern xcolor_t  slategrey;
  extern Display  *flashdisplay;
  extern GC flashgc;
  extern Widget displayAction;
  extern XGCValues flashes_gcv;

    if(depth>8)
      flashes_gcv.foreground = grey_color.pixel; 
    else
      flashes_gcv.foreground = grey; 

  XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
  XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
    Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
  XSync(flashdisplay, False);
  program.emsg(nprint, "DEB:sFS: sspmode = (%d)\n", sspmode);

}
