/*
 * $Id: flashes.c,v 1.1 2000/01/19 17:28:39 kline Exp kline $
 */

#include <signal.h>
#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"

#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include "muuzaudio.h"
#include "setAudioValues.h" 
#include "getDisplayValues.h"
   
extern errMessage program;  // for emsg()
       


toggle playing;
int do_once = 0;
int flashing= 0;
int sounding = 0;

int HzArray[40] =
{
        500000, 250000, 166667, 125000, 100000, /* 1, .5, .33, .25, .20 */
        83333, 71423, 62500, 55556, 50000,
        45455, 41667, 38462, 35714, 33333,
        31250, 29412, 27778, 26316, 25000,
        23809, 22727, 21739, 20833, 20000,
        19231, 18519, 17857, 17241, 16667,
        16129, 15625, 15152, 14706, 14286,
        13889, 13514, 13116, 12820, 12500,
};

unsigned long hertz = 500000;   /* default to one-second flashes */
unsigned long interval;
XtIntervalId timeout;

/*
 * graphic content globals:: initialized in forms.c
 */

GC flashgc;  
Display  *flashdisplay;
Drawable flashwindow;
XGCValues flashes_gcv, audio_gcv;


void
hemiflash_timeout_proc(XtPointer _client_data, XtIntervalId *_id)
{

  extern action_t sspmode;
  void do_beats(char *);
  extern octave_t octave;
  static toggle Switch = off;
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow;
  extern unsigned long hertz;
  extern GC flashgc;
  extern Display  *flashdisplay;
  extern Drawable flashwindow;
  extern XGCValues flashes_gcv;
  extern unsigned long global_flash_color;

  audioValues setAudio;

  /*
   * reset the Switch flag upon state-change from PLAY to STOP || PAUSE
   */
  if (sspmode == STOP || sspmode == PAUSE)
  {
    Switch = off;
  }

  /*
   *  We _ONLY_ hit this code if not in the pre-programmed frame; _only_
   *  if we are in the command/playaround frame!
   */
  if (prepstate == off)
  {
    if (sspmode == PLAY)
    {
      if (Switch != on)
      {
        Switch = on;
	setAudio.Octave();
      }

      flashes_gcv.foreground = global_flash_color;     /* defaults to yellow */
      XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground,
			 &flashes_gcv);
      XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
	Do.resizeW(M_WIDTH/2), Do.resizeH(M_HEIGHT) );
      flashes_gcv.foreground = black_color;
      XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, 
			&flashes_gcv);
      XFillRectangle(flashdisplay, flashwindow, flashgc,400,0,
	Do.resizeW(M_WIDTH/2), Do.resizeH(M_HEIGHT) );
      (void)usleep(hertz);
      XSync(flashdisplay, False); /* True or False::  seems to be a dontcare */
    
      if (interval == 0) 
	program.emsg(fatal, "ZERO in hemiflash_timeout_proc()", _fl_);

      timeout =XtAppAddTimeOut(app,(1/interval)*1000,hemiflash_timeout_proc,
			 NULL);
    
      flashes_gcv.foreground = black_color;
      XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, 
			&flashes_gcv);
      XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
	Do.resizeW(M_WIDTH/2), Do.resizeH(M_HEIGHT) );
      flashes_gcv.foreground = global_flash_color;     /* defaults to yellow */
      XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, 
			&flashes_gcv);
      XFillRectangle(flashdisplay, flashwindow, flashgc,400,0,
	Do.resizeW(M_WIDTH/2), Do.resizeH(M_HEIGHT) );
      (void)usleep(hertz);
      XSync(flashdisplay, False);   /* must be False */
      }
  }
}



/*
 * Set default flash
 */
void
XMuuzSetDefaultFlash()
{
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow;

  extern unsigned long black_color, global_flash_color, white_color;/* flash */
  extern XColor orange_color,  yellow_color;
  extern XGCValues flashes_gcv;

  if(depth>8)
    global_flash_color = yellow_color.pixel;  /* initialize default color */
  else
    global_flash_color = yellow;  /* initialize default color */
  flashes_gcv.background = black_color; 
}


/*
 * init'l Display and Drawable for XCreateGC()
 */
void
XMuuzInitFlashGC(void)
{
  getDisplayValues value;
  extern GC flashgc;
  extern Display  *flashdisplay;
  extern Drawable flashwindow;

  flashdisplay = value.returnDisplay(formflash);
  flashwindow = value.returnDrawable (formflash);
  flashgc = value.returnGC(formflash);
}

// why is the Switch code there????  30mar99 is it messing with flashing, &c
// when audio->video->A+V and stop->play->pause stuff?????  ck.out :)


/* FLASH ROUTINES FOR BASE FRAME */

/* Timeout routine */
void
timeout_proc(XtPointer _client_data, XtIntervalId *_id)
{
  extern int skipTimeOut;
  extern toggle playing;
  extern audiovideo_t muuzmode;
  extern action_t sspmode;
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow;

  extern char *high_o[];
  extern char *low_o[];
  extern char *medium_o[];
  extern char *upper_o[];
  extern unsigned long interval;
  extern octave_t octave;
  extern frequency_t frequency;
  extern unsigned long hertz;
  void do_beats(char *);
  extern toggle playing, prepstate;

  audioValues setAudio;

  program.emsg(nprint,"IN timeout_proc(): sspmode = (%d),volume = (%d)\
   \noctave = (%d), freq = (%d), hertz = (%ld)\n",
    sspmode, volume, octave, frequency, hertz, _fl_);



  /*
   *  We _ONLY_ hit this code if not in the pre-programmed frame; _only_
   *  if we are in the command/playaround frame!
   */
  if (prepstate == off)
  {
    if (sspmode == PLAY)
    {
      program.emsg(nprint,"\t\t ENTERING timeout_proc(): skipTimeOut = (%d)\n",
        skipTimeOut);
      /*
       *  Here, with the do_once (workaround):: 
       *  Obviates kill-restarts.
       */
      if (!do_once)
      {
	if (muuzmode == AUDIOVIDEO)
	{
	  program.emsg(nprint,"\t\tDO_ONCE: timeout_proc(): doing do-beats() stuff");
	  setAudio.Octave(); 
	  setAudio.Volume();
	  sounding = 1;
	}
        if (muuzmode == AUDIO) 
        {
	  flashing = 0;
	  sounding = 1;

	  program.emsg(nprint,"timeout_proc(): doing do-beats() stuff");
          setAudio.Octave(); 
	  setAudio.Volume();
        }
	do_once = 1;
      }
      if (muuzmode == VIDEO || muuzmode == AUDIOVIDEO)
      {
	flashing = 1;
        flashes_gcv.foreground = global_flash_color;    /* defaults to yellow */
        XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, 
	  &flashes_gcv);
        XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
	  Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );

	if (!skipTimeOut)
	{
          (void)usleep(hertz); // YES, needed.
	}
        XSync(flashdisplay, False); 

        if (interval == 0) 
	  program.emsg(fatal,"ZERO in timeout_proc()", _fl_);

        flashes_gcv.foreground = black_color;
        XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, 
	  &flashes_gcv);
        XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
	  Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
        if (!skipTimeOut)
        {
          timeout = XtAppAddTimeOut(app, (1/interval)*1000,timeout_proc, NULL);
          (void)usleep(hertz); 
        }
        else
        {
          program.emsg(nprint, "timeout_proc(): skipTimeOut = (%d)\n", 
	    skipTimeOut, _fl_);
	  skipTimeOut = 0;
        }
        XSync(flashdisplay, False);   /* must be False */
      }
      program.emsg(nprint,
        "\n\n\t\t LEAVING timeout_proc(): skipTimeOut = (%d)\n", skipTimeOut);
    }
  }
}
