/*
 * $Id: forms.c,v 1.2 2000/02/17 20:42:24 kline Exp kline $
 *
 *  All forms here are those seen when the app first starts up.
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "misc.h"
#include "errMessage.h"
#include "main.h"
#include "copyright.h"



/*** 3d includes ***/
#include "/usr/X11R6/include/X11/Xaw3d/ThreeD.h"

XFontStruct *labelPauseFlashFont;
Widget formflash;
Widget labelForm;
/**XFontStruct *labelFont;**/


void
formsCreate()
{
  XFontStruct *init_font(Display *display, const char *fontName);
  extern xcolor_t blue, green, grey, grey85, lightskyblue, 
   orange, pink, red, darkblue, slategrey, yellow, whitesmoke;
  extern XColor   blue_color, exact_color, pink_color, grey_color, orange_color,
    red_color, hotpink_color, yellow_color, skyblue_color,
    whitesmoke_color, peru_color;

  extern Widget form, formbox0, formbox1, formbox2, menuform;
  extern Widget selectpanel_button;
  unsigned long colorname();
  void popDownMenus(Widget form);

/*
 * create the forms for a menu-bar; for the 3 sections beneath the menu-bar,
 * the control-panel, the user-program-panel, and the pre-programmed-pannel
 */
  if (depth > 8)
  {
    menuform = XtVaCreateManagedWidget("menuform", formWidgetClass, form,
	/*
	 *  The _long_ width of this form is now set around line 60, muuzmenu.c
	 */
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
	XtNhorizDistance, 0,  /* flush */
	XtNshadowWidth,  5,
	XtNbackground, whitesmoke_color.pixel, \
	XtNshadowWidth,  2,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }
  else
  {
    menuform = XtVaCreateManagedWidget("menuform", formWidgetClass, form,
	/*
	 *  The _long_ width of this form is now set around line 60, muuzmenu.c
	 *    the form is held wide by:
	 *     XtNhorizDistance, 875, ** set WIDTH of 'menuform' **
	 */
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
	XtNhorizDistance, 0,  /* flush */
	XtNshadowWidth,  5,
	XtNbackground, whitesmoke,
	XtNshadowWidth,  2,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  }
  popDownMenus(menuform); /*  in muuzmenu.c  */

  /*
   * select-which-action form (this form is always displayed)
   */
  formbox0 = XtVaCreateManagedWidget("formbox0", formWidgetClass, form,
        XtNfromVert, menuform,
        XtNfromHoriz, NULL,
	XtNshadowWidth,  3,
        XtNtop, XawChainTop,         /* HERE */
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);

  if (depth > 8) // Here (was orange:: 18feb00)
  {
    XtVaSetValues(formbox0, XtNbackground, red_color.pixel, NULL);
  }
  else
  {
    XtVaSetValues(formbox0, XtNbackground, red, NULL);
  }

  formbox1 = XtVaCreateManagedWidget("formbox1", formWidgetClass, form,
        //XtNheight, Do.resizeH(125), // was 136 ::133 too L
	// height may be set by Assemblies
        XtNwidth,  Do.resizeW(700), // formbox1 is the right-top form :: 725
        XtNresizable, False,
        XtNfromVert, menuform,
        XtNfromHoriz, formbox0,
	XtNshadowWidth,  5,
        XtNtop, XawChainTop,  // wild....
        XtNbottom, XawChainTop,  // BLUEFORM TEST
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  if (depth > 8)
  {
    XtVaSetValues(formbox1, XtNbackground, blue_color.pixel, NULL);
  }
  else
  {
    XtVaSetValues(formbox1, XtNbackground, blue, NULL);
  }


  labelFont = init_font(display, NCS18);
  labelForm = XtVaCreateManagedWidget("labelForm", labelWidgetClass, formbox1,
	XtNfont, labelFont,
	XtNlabel, L_CONTROLPANEL, 
        XtNheight, Do.resizeH(25),
        XtNwidth,  Do.resizeW(625),  /* *This* controls the first labelform ; and this
			  /* width exactly colors the form BLUE edge-to-edge */
        XtNfromVert, NULL,
        XtNfromHoriz, NULL,
        XtNhorizDistance, 0,  /* flush */
        XtNvertDistance, 0,  /* flush */
	XtNborderWidth, 0, 
	/**XtNshadowWidth,  5,  ** Puts a 5pixel shadow around LABEL */
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  if (depth > 8)
  {
  XtVaSetValues(labelForm, XtNbackground, blue_color.pixel, 
    XtNforeground, black_color, NULL);
  }
  else
  {
  XtVaSetValues(labelForm, XtNbackground, blue, 
    XtNforeground, black_color, NULL);
  }





  /*
   *
   *    This creates the slategrey BOX of the Muuz App that flashes or is 
   *    quietly grey.  [[ this sets the first|FIRST grey bg form <--> and
   *    top <--> bottom below the blue "Control Panel" form. ]]
   *
   * Shadowfact: this, ``form'' can be a labelWidget and have the look
   * of a 3D label....  probably overkill..  (07mar98)
   */
  labelPauseFlashFont = init_font(display, NCS18);
  formflash = XtVaCreateManagedWidget("formflash", formWidgetClass, form,
	XtNfont, labelPauseFlashFont,
	XtNlabel, "",
        XtNheight, Do.resizeH(425), // the HEIGTH of the slategrey form.
        XtNwidth, Do.resizeW(900),  // the WIDTH of the flashing|stable form
        XtNfromVert, formbox1,
        XtNfromHoriz, NULL,
	 XtNhorizDistance, 0,   /* flush */
	XtNshadowWidth,  5,
        XtNtop, XawChainTop,
        XtNbottom, XawChainTop,
        XtNleft, XawChainLeft,
        XtNright, XawChainLeft,
        NULL);
  if (depth > 8)
  {
    XtVaSetValues(formflash, XtNbackground, slategrey_color.pixel, NULL);
  }
  else
  {
    XtVaSetValues(formflash, XtNbackground, slategrey, NULL);
  }
}
