/*
 * $Id: getDisplayValues.c,v 1.1 2000/01/29 20:44:34 kline Exp kline $
 * ``objectify'' vars such as screen, width, height, display, screen_number,
 *  visual, window.
 *  Return either default values for several basic X variables.
 */

#include "copyright.h"
#include "globals.h"
#include "getDisplayValues.h"

Display *getDisplayValues::
returnDisplay(Widget w){ return display = XtDisplay(w); }

Screen *getDisplayValues::
returnScreen(Widget w){ return screen = XtScreen(w); }

int getDisplayValues::
returnScreenNumber(Widget w){ return DefaultScreen(XtDisplay(w)); }

Window getDisplayValues::
returnWindow(Widget w)
{ 
  display = XtDisplay(w);
  screen = XtScreen(w);
  return window = RootWindow(display, 
    XScreenNumberOfScreen(screen)); 
}
Visual *getDisplayValues::
returnVisual(Widget w)
{ 
  display = XtDisplay(w);
  return visual = DefaultVisual(display, DefaultScreen(display)); 
}

int getDisplayValues::
returnHeight(Widget w)
{
  display = XtDisplay(w);
  screen_number =  DefaultScreen(display);     
  return height =  DisplayHeight(display, screen_number);
}
int getDisplayValues::
returnWidth(Widget w)
{
  display = XtDisplay(w);
  screen_number =  DefaultScreen(display);     
  return height =  DisplayWidth(display, screen_number);
}
Drawable getDisplayValues::
returnDrawable(Widget w)
{
  return drawable = XtWindow(w);
}

GC getDisplayValues::
returnGC(Widget w)
{
  display = XtDisplay(w);
  drawable = XtWindow (w);
  return gc = XCreateGC(display, drawable, 0, NULL);

}

