/*
 * $Id: main.c,v 1.7 2000/03/07 05:50:18 kline Exp kline $
 */

#ifdef __COMMENT__

/*
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ENTIRELY ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION OR LOSS OF LIFE OR HEALTH) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 */


#endif




/*
 * volume, pitch, Frequency, colors:  all have Displays.
 */


#include <X11/Intrinsic.h>
#include <signal.h>
#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"

#include "callbacks.h"
#include "prepcallbacks.h"
#include "controlpanel.h"
#include "muuzaudio.h"
#include "errMessage.h"
#include "do_colors.h"
#include "do_private.h"
#include "getDisplayValues.h"
#include "misc.h"
#include "mixerControls.h"
#include "select.h"
#include "copyright.h"



/* Xt signal handler ID */
static XtSignalId signalID;

int gdisplaysize, gheight, gwidth;
Colormap private_cmap;
int stop, Pause, play;
int depth;
audiovideo_t audio, video, audiovideo;
XtAppContext  app;
Widget        top;
AppSize Do;          //  for resizeW(), resizeH()
errMessage program;  // for emsg()
Display *display;
static XTextProperty nameprop;
static boolean namestatus = false;
boolean weHaveSound = true;
char *beatsexec = BEATSINSTALLED;



/*
 * main() - this is where things are initialized and do_muuz() invoked.
 */

/* HERE MAIN XXX */
void
main(int argc, char *argv[])
{
  int ch, perr = 0;
  void usage(char *), version();
  extern char *optarg;
  mixerControls audio;
  int devfd, returnval;
  void do_muuz(int argc, char *argv[]);
  void  initState(void);
  void XMuuzFatalErr(char *);


  program.setProgname(argv[0], "");      // stuff the program name
  program.setNargs(argc);                // number of cmdline args
  /*
   * capture the name of the binary ("muuz") for use elsewhere.  apart
   * from the registry status which is used on the title bar.
   */
  argv[0] = PROG_NAME;                   // goes into textproperty fields.
  namestatus = (boolean)XStringListToTextProperty(argv,argc,&nameprop);

  while ((ch = getopt(argc, argv, "vVhH")) != -1)
          switch (ch) {
          case 'V':
          case 'v':
		  version();
                  perr = 0;
                  break;
          case 'H':
          case 'h':
          case '?':
          default:
                  usage( program.getProgname() );
          }
  argc -= optind;
  argv += optind;
  if (perr) 
    usage( program.getProgname() );


  if ((devfd = open ("/dev/dsp", O_WRONLY, 0)) < 0)
  {
    XMuuzFatalErr("Cannot open /dev/dsp: unconfigured or maybe busy?");
    program.emsg(fatal, "Error opening /dev/dsp: maybe busy",_fl_);
  }
  else
  {
    close(devfd);
  }
  if (access (beatsexec, F_OK) != 0)  /* Check for existence */
  {
    printf ("Cannot access file %s!", beatsexec);
    weHaveSound = false;
  }
  else
  {
    if (access (beatsexec, X_OK) != 0) 
    {  
      printf ( "Cannot exec %s!", beatsexec);
      weHaveSound = false;
    }
  }


  if (returnval = access(BEATSPATH, X_OK) < 0)
  {
    program.emsg(nprint, "Don't find %s\n%s\n", BEATSPATH, strerror(errno) );
    exit(1);
  }

#ifdef TEST
  program.emsg(trace, "DEBUG-- PATHS\n: P_ACK = [%s]\n", P_ACK);
  program.emsg(trace, "BEATS BINARY:  %s\n\n", BEATSPATH);
#endif

  initState();				/* initialize many globals */
  audio.XMuuzInitVolume();		/* initialize /dev/mixer */
  (void)do_muuz(argc, argv);
}

void
do_muuz(int argc, char *argv[])
{
  void handler(int);
  void signalCB(XtPointer clientData, XtSignalId *id);
  struct sigaction act, oact;
  extern int gdisplaysize, gheight, gwidth;
  p_cmap map;
  Boolean  XMuuzAllocatePrivateColormap(Display *dpy, Widget w);
  const char *iconName = ICON_NAME;
  Arg wargs[10];
  int n = 0;
  extern Widget top;
  Screen *screen;
  extern Widget	DownArrow, UpArrow;
  extern Widget  form, formbox1, formbox2,
    formtopic, formprogram;
  extern Widget selectionup_button, selectiondown_button, progup_button,
    progdown_button;
  extern XFontStruct 	*selectionFont, *programFont, *init_font();
  int screen_number;
  void setdisplaysize();
  void prepdown_buttonCB(), prepup_buttonCB();
  void selectprep_buttonCB(), selectuser_buttonCB();
  void  progdown_buttonCB(), progup_buttonCB();
  Widget  ReturnDownArrowWidget(Widget w), ReturnUpArrowWidget(Widget w);
  void graphicWarning(Widget _w);
  void formsCreate(), //controlPanel(), select_prep_or_user(),
  XMuuzInitColors(Display *, int), XMuuzInitFlashGC(), XMuuzSetDefaultFlash();
  void timeout_proc();
  void XMuuzSizeHints(Display *display, Window window, int argc, char **argv);
  void XMuuzInitNamedColors(Widget w);    /* EXPERIMENTAL :: 07feb99    */
  getDisplayValues value;



  /*
   * initialize the application - the arguments allows things like
   * application name and class to be specified as well as any command line
   * based or fallback resources that may be relevant
   * 
   */


  top = XtVaAppInitialize(&app, /* Application context */
                          "Xmuuz", /* Application class */
                          NULL, 0, /* command line option list */
                          &argc, argv, /* command line args */
                          NULL, /* for missing app-defaults file */
                          NULL /* terminate varargs list */);



  // Xt signal callback && POSIX signal handler
  signalID = XtAppAddSignal(app, signalCB, 0);
  act.sa_handler = handler;
  signal(SIGCHLD, handler);
  act.sa_flags = SA_NOCLDWAIT;  // create no zombies
  sigaction(SIGINT, &act, &oact);

  display = value.returnDisplay(top);       /* initialize display globally */
  depth = DefaultDepth(display, DefaultScreen(display));
  screen  = value.returnScreen (top);       /* screen pointer              */
  screen_number = value.returnScreenNumber(top);
  gwidth = value.returnWidth(top);
  gheight = value.returnHeight(top);
  (void) Do.setdisplaysize();  // calculate display multiplier for H and W.


  if (depth<=8 && map.XMuuzAllocatePrivateColormap(display, top) == NULL)
  {
    program.emsg(fatal, " XMuuzAllocatePrivateColormap() FAILED!", _fl_);
  }
  if (depth <= 8) // both "map." functions belong to the private cmap code.
  {
    map.XMuuzInitNamedColors(screen);
  }



  program.emsg(nprint, 5,
    "DEBMAIN: gdisplaysize = (%d), gheight = (%d), gwidth = (%d)\n",
     gdisplaysize, gheight, gwidth);
  program.emsg(nprint, 5,
    "DEBMAIN: Do.resizeH(600) = (%d), Do.resizeW(800) = (%d)\n",
     Do.resizeH(575), Do.resizeW(800) );

  if(depth>8)   // default cmap code... .
  {
    (void)XMuuzInitColors(display, screen_number); /* global-init colors  */
  }



  UpArrow = ReturnUpArrowWidget(top);	    /* Get both uparrow and       */
  DownArrow = ReturnDownArrowWidget(top);   /* downarrow, used frequently */

  XtSetArg(wargs[n], XtNwidth, Do.resizeH(800) );
  n++;
  XtSetArg(wargs[n], XtNheight, Do.resizeW(600) );
  n++;
  XtSetArg(wargs[n], XtNbackground,  black_color );
  n++;  // TEST 13sep99
  XtSetValues (top, wargs, n);



  /*
   * create a manager that will take the button children.  This will allow us
   * to control the button placement as desired
   */
  form = XtVaCreateWidget("form", formWidgetClass, top,
                          XtNresizable, FALSE,
                          NULL);

  /*
   * the default flash color is set here (yellow as of 14sep99); and in
   * this file, below, the color_mode index is also set to YELLOW
   */
  (void)XMuuzSetDefaultFlash();
  /*
   * create the forms for a menu-bar; for the 3 sections beneath the menu-bar,
   * the control-panel, the user-program-panel, and the pre-programmed-pannel
   */
  (void)formsCreate();
  /*
   *  control the Light/Sound tool
   */
  (void)controlPanel();
  /*
   * Choose either the pre-programmed window (default), or let the user
   * create his own L/S programs.
   */
  (void)select_prep_or_user();

  /*
   * now that all the formbox1 and sample_dialog children have 
   * been added, we can manage them
   */
  XtManageChild(form);


  /*
   * realize the application - this is when the application really begins to
   * "exist"
   */
  XtRealizeWidget(top);
  /*
   * placing this function _after_ the regular muuz object has been
   * realized   causes the warning-screen to pop-up before|in-front-of
   * the muuz screen.  which is what I want.   08nov98
   */
  (void)graphicWarning (top);

  /*
   * init'l Display, Drawable, and GC  for XCreateGC()
   */
  (void)XMuuzInitFlashGC();

  if (namestatus)  // if all fields set correctly in the XTextProperty struct
  {
    XSetTextProperty(display,XtWindow(top), &nameprop, XA_WM_NAME);
  }
  else
  {
    XStoreName(display, XtWindow(top), PROG_NAME); 
  }
  /*
   * XSetIconName (Display *, Window, "NAME") _must_ be within main setup
   * loop.   Cannot be part of the Xt initialization.
   */
  XSetIconName(display, XtWindow(top), iconName);
  XMuuzSizeHints(display, XtWindow(top), argc, argv);

  //signal(SIGCHLD, sigInterrupt);
  /* enter the X Event loop */
  XtAppMainLoop(app);
}

/*
 * specifically initialize (or re-initialize) critical state variables
 */
void
initState()
{
  extern toggle controlpanelstate, prepstate, userstate;
  extern findex_t  ccr, clr, crx, cmd, csl, cen, cfu;
  extern category_t programCategory;
  extern volume_t volume;

  extern action_t sspmode;
  extern audiovideo_t audio, video, audiovideo;
  extern audiovideo_t muuzmode;
  extern colors_t colorsmode;
  extern frequency_t frequency;
  extern unsigned long interval;
  extern octave_t octave;
  extern int stop, Pause, play;
  /* pre-programmed category flags */
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag,
    csl_flag, cfu_flag;

  interval = 1;  /* timer */
  stop = 1;   /* default and initial state */
  audio = 1;  /* default and initial state */
  muuzmode = AUDIOVIDEO;        /* audio, video, or a+v mode    */
  colorsmode = YELLOW;          /* which colors?                */
  frequency = 0;                /* Frequency: flashes|beats/sec */
  octave    = LOW;		/* start with the lowest        */
  programCategory = 0;                 /* which category of pre-progs? */
  controlpanelstate = on;	/* initially, we have the controlpanel */
  prepstate = off;		/* are we in the pre-programmed window?*/
  userstate = off;		/* are we in the user-programming window?   */
  sspmode =  STOP;                 /* stop, start|play, pause mode */
  volume =   VOFF;            /* set the volume: OFF to 100%  */
  adjustflag = off;		// default is to let the preps play as-written

  /** turn off all the mode flags specifically **/
  ccr_flag = 0, clr_flag = 0, crx_flag = 0, cmd_flag = 0, cen_flag = 0,
                                         csl_flag = 0, cfu_flag = 0;

  /* off prep-mode counters: to one before zero (-1) */
  ccr = clr = crx = cmd = csl = cen = cfu  = -1;

}


/** for checking to see if we are ready to flash or not **/

extern int allmodes, allflags;
void
allmodesState()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
    cfu_flag;
  if (!ccr_flag && !clr_flag && !crx_flag && !cmd_flag && !cen_flag &&
      !csl_flag && !cfu_flag)
  {
    allmodes = 0;
  }
  else
  {
    allmodes = 1;
  }
}


void
allflagsState()
{
  extern findex_t  ccr, clr, crx, cmd, csl, cen, cfu;

  if (ccr== -1 && clr== -1 && crx== -1 && cmd== -1 && csl== -1 &&
      cen== -1 && cfu== -1)
  {
    allflags = 0;
  }
  else
  {
    allflags = 1;
  }
}

#ifdef SIGDEVEL

void 
sigInterrupt(int signo)
{     
  extern toggle playing;
  int status=0;
  int wpid=0;
 
  if((wpid=wait(&status))==beatsPid)
  {
    if(WIFEXITED(status))
    {
	beatsPid=0;
        playing = off;
        program.emsg(debug,"beats exited normally. beatsPid = (%d)\n",beatsPid);
    }
    else if(WIFSIGNALED(status))
    {
      program.emsg(debug,
	"beats exited due to signal. beatsPid = (%d)\n", beatsPid);
      beatsPid=0;
      playing = off;
    }
  }
}
 
 
void
sigChild(int signo)
{
 
    int pid, status; 
 
    puts("IN \7 sigChild()");
  while ((pid=wait3((int *)&status,WNOHANG|WUNTRACED, (struct rusage *)0))> 0)
  {
    puts("wait3");
  }
  if (pid == -1)
  {
        if (errno != ECHILD)
            program.emsg(debug, stderr, "Error waiting for child process: %d");
        return;
  }
  if (pid > 0)
  {
        if (WIFSIGNALED(status))
        {
            program.emsg(debug, "Child process %d terminated with signal %d",
                   pid, WTERMSIG(status));
        }
        if (WIFEXITED(status))
        { 
            program.emsg(debug, "Child process %d terminated normally.",
                   pid);
        }     
        beatsPid =  0;
    }
}
#endif // SIGDEVEL



/*
 * Xt signal callback 
 */
void
signalCB(XtPointer clientData, XtSignalId *id)
{
  void do_beats();
  static short int i = 0;

  if (*id == signalID)
    program.emsg(nprint, "DEB: Xt-signalCB(): received signal\n");
}

/*
 * POSIX signal handler 
 */
void
handler(int sig)
{
  int status, wpid;

  if((wpid=wait(&status))==beatsPid)
  {
    if(WIFEXITED(status))
    {
      beatsPid=0;
      if (sig == SIGCHLD)
      {
        XtNoticeSignal(signalID);
        program.emsg(nprint,"beats exited normally. beatsPid = (%d)\n",beatsPid);
      }
    }
    else if(WIFSIGNALED(status))
    {
      beatsPid=0;
      if (sig == SIGCHLD)
      {
        XtNoticeSignal(signalID);
        program.emsg(nprint,"beats exited on SIGNAL beatsPid = (%d)\n",beatsPid);
      }
    }
  }

}
usage(char *progname)
{
  fprintf(stderr, "Usage: %s: [-hV]\n", progname);
  exit(0);
}

