/*
 * $Id: meditation.c,v 1.1 2000/01/29 20:44:56 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "errMessage.h"

extern errMessage program;  // for emsg()


instance_t progMeditation[200];  // needs to be bumped to ~500 with c_ch's


void
do_meditation(int prog)
{
	void zazen(int), sesshin(int), earth_meditation(int), aum(int), 
	kundalini(int), awake_rest(int);

        program.emsg(nprint,"DO_MEDITATION(): selecting prog = (%d)\n", prog);

        switch(prog)
        {
        case 0:
		zazen(prog);
		break;
        case 1:		
		sesshin(prog);
		break;
        case 2:		
		earth_meditation(prog);
		break;
        case 3:		
		aum(prog);
		break;
        case 4:		
		kundalini(prog);
		break;
        case 5:		
		awake_rest(prog);
		break;

        }

}

/*
 * 2-14hz (medium length)
 */
void 
zazen(int prog)
{
#define ZN "zazen()"
#define VERZN "0.25"  
  unsigned short int I= UINIT;
  void XMuuzPrepInformation(char *function, char *version);
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];

  XMuuzPrepInformation(ZN, VERZN);
  program.emsg(nprint,"ENTERING zazen(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag);
  instStates ( &progMeditation[++I], 17, 13, WHITE, MID, 2, 0);
  instStates ( &progMeditation[I++], 13, 19, WHITE, MID, 2, 0);
  instStates ( &progMeditation[I++], 12, 19, WHITE, MID, 2, 0);
  instStates ( &progMeditation[I++], 11, 19, YELLOW,  MID, 2, 0);
  instStates ( &progMeditation[I++], 10, 17, YELLOW, MID, 2, 0);
  instStates ( &progMeditation[I++], 9,  17, ORANGE, MID, 2, 0);
  instStates ( &progMeditation[I++], 8,  13, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 7, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 79, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 7, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 79, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 10, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 271, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 271, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 11, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 7, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 8, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 9, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 79, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 13, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 11, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 197, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 3, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 127, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 3, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 4, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 6, 4, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 7, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 8, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 9, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 10, 5, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 11, 11, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 12, 19, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 2, 41, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 5, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 7, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 11, 7, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], 13, 47, ORANGE,  MID, 2, 0);
  instStates ( &progMeditation[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);

}

/*
 * 1-23hz:: (long)
 */
void  
sesshin(int prog)
{
#define SH "sesshin()"
#define VERSH "0.23"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I= UINIT;

  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];

  program.emsg(nprint,"ENTERING sesshin(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag);
  instStates ( &progMeditation[++I], 23, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 21, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 19, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 18, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 17, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 16, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 15, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 14, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 13, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 12, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 10, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 9, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 7, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 9, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 23, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 67, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 67, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 247, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 157, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 157, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 957, WHITE, MID, 2, 0); // 20 c_ch
  // first longish sitting: 5 more; now stir.  191linesHERE
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 7, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 9, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 27, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 359, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 9, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 10, 23, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 12, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 13, 19,WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 12, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 10, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 9, 4, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 4, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 29, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 71, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 31, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 359, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 9, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 19, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 27, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 359, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 4, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 4, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 4, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 3, WHITE, MID, 2, 0);
  // 99 lines here.
  instStates ( &progMeditation[++I], 1, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 359, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 12, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 13, 21, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 3, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 359, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 2, 311, WHITE, MID, 2, 0);
  // last period; now slowly rise and exit at 19.
  instStates ( &progMeditation[++I], 3, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 5, 3, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 6, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 8, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 9, 6, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 10, 6, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 6, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 12, 6, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 13, 11, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 14, 11, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 4, 17, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 7, 7, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 11, 7, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 14, 7, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 15, 9, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 16, 9, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 17, 9, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 18, 19, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 19, 47, WHITE, MID, 2, 0);
  // end-end-end
  instStates ( &progMeditation[I++], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);

}

/*
 * 3-24hz
 */
void  
earth_meditation(int prog)
{
#define EM "EarthMeditation()"
#define VEREM "0.00"  
  void XMuuzPrepInformation(char *function, char *version);
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];
  unsigned short int I= UINIT;

  program.emsg(nprint,"ENTERING earth_med(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag,_fl_);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}


/*
 * 2-29hz
 */

void  
aum(int prog)
{
#define AU "Aum()"
#define VERAU "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I= UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];

  XMuuzPrepInformation(AU,  VERAU);
  program.emsg(nprint,"ENTERING aum(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}

/*
 * 7-17hz
 */

void  
kundalini(int prog)
{
#define KD "Kundalini()"
#define VERKD "0.00"
  void XMuuzPrepInformation(char *function, char *version);
  unsigned short int I= UINIT;
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];

  XMuuzPrepInformation(KD, VERKD);
  program.emsg(nprint,"ENTERING kundalini(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}

/*
 * 2-17hz
 */

void 
awake_rest(int prog)
{
#define AR "AwakeRest()"
#define VERAR "0.00"
  unsigned short int I= UINIT;
  void XMuuzPrepInformation(char *function, char *version);
  void instStates(instance_t *instance, frequency_t,
                  seconds_t, colors_t, pitch_t, volume_t, int);
  void startPrep(int);
  extern instance_t progMeditation[200];

  XMuuzPrepInformation(AR, VERAR);
  program.emsg(nprint,"ENTERING awake_rest(): play = (%d), cmd_flag = (%d)\n",
    play,cmd_flag);
  instStates ( &progMeditation[++I], 2, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], 1, 5, WHITE, MID, 2, 0);
  instStates ( &progMeditation[++I], END, END, YELLOW,  MID, 2, 0);
  (void)startPrep(prog);
}
