/*
 * $Id: misc.c,v 1.1 2000/01/29 20:44:59 kline Exp kline $
 */

#include "globals.h"
#include "iconmuuz.h"
#include "muuz.h"
#include "muuztypes.h"
#include "structs.h"
#include "xbm.h"
#include "xfonts.h"
#include "copyright.h"


#include "misc.h"
#include "errMessage.h"
#include "main.h"

Widget
ReturnUpArrowWidget (Widget w)
{

  static unsigned char uparrow_bits[] = {
   0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f,
   0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f};

   return ( (Widget)XCreateBitmapFromData(XtDisplay(w),
                 RootWindowOfScreen(XtScreen(w)),
                 (const char *)uparrow_bits, uparrow_width, uparrow_height));
}

Widget
ReturnDownArrowWidget (Widget w)
{

  static unsigned char downarrow_bits[] = {
   0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
   0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x01};


  return ( (Widget)XCreateBitmapFromData(XtDisplay(w),
                 RootWindowOfScreen(XtScreen(w)),
                 (const char *)downarrow_bits, downarrow_width, downarrow_height) );
}

XFontStruct *
init_font(Display *display, const char *fontName)
{
  XFontStruct *font_struct;
  if ((font_struct = XLoadQueryFont(display, fontName)) == NULL)
  {
    program.emsg(error, "\"%s\" font not found, use \"fixed\" instead\n", 
      fontName);
    font_struct = XLoadQueryFont(display,"fixed");
  }
  return (font_struct);
}


void
XMuuzSizeHints(Display *display, Window window, int argc, char **argv)
{  
  XWMHints        *wm_hints;
  XSizeHints      *main_size_hint;
  Pixmap icon_pixmap = XCreateBitmapFromData(display, window, 
    (const char *)muuzicon_bits, muuzicon_width, muuzicon_height);



  /* Set WM_NORMAL_HINTS */
  main_size_hint = XAllocSizeHints();   /* Allocate */
  main_size_hint->x = 10;
  main_size_hint->y = 10;
  main_size_hint->width = M_WIDTH;
  main_size_hint->height= M_HEIGHT;
  main_size_hint->flags = PPosition | PSize | PMinSize;
  XSetWMNormalHints(display,window,main_size_hint);
  XFree(main_size_hint);                /* de-allocate */

   
  /* Set WM_HINTS, the window starts in Normal (not iconic) state */
  wm_hints = XAllocWMHints();
  /** (wm_hints->initial_state = IconicState;) **/
  wm_hints->initial_state = NormalState;
  wm_hints->input = True;
  wm_hints->icon_pixmap = icon_pixmap;;
  wm_hints->flags = StateHint | IconPixmapHint | InputHint;
  XSetWMHints(display,window,wm_hints);
  XFree(wm_hints);
}

/*
 *  Turn ON one cxx_flag flag_t and turn OFF the rest
 */
void on_ccrflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 1; clr_flag =0; crx_flag =0; cmd_flag =0; cen_flag =0;
  csl_flag = 0; cfu_flag =0; 
}
void on_clrflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =1; crx_flag =0; cmd_flag =0; cen_flag =0;
  csl_flag = 0; cfu_flag =0; 
}
void on_crxflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =1; cmd_flag =0; cen_flag =0;
  csl_flag = 0; cfu_flag =0; 
}
void on_cmdflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =0; cmd_flag =1; cen_flag =0;
  csl_flag = 0; cfu_flag =0; 
}
void on_cenflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =0; cmd_flag =0; cen_flag =1;
  csl_flag = 0; cfu_flag =0; 
}
void on_cslflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =0; cmd_flag =0; cen_flag =0;
  csl_flag = 1; cfu_flag =0; 
}
void on_cfuflag()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =0; cmd_flag =0; cen_flag =0;
  csl_flag = 0; cfu_flag =1; 
}

/* 
 * Turn OFF all pre-programmed flag choices.
 */

void offAllPrepFlags()
{
  extern flag_t ccr_flag, clr_flag, crx_flag, cmd_flag, cen_flag, csl_flag,
	    cfu_flag;

  ccr_flag = 0; clr_flag =0; crx_flag =0; cmd_flag =0; cen_flag =0;
  csl_flag = 0; cfu_flag =0; 
}

int
pdeb()
{

  program.emsg(trace, "\nF_INDICES: ccr = (%d), clx = (%d), crx = (%d), cmd = (%d)\ncen = (%d), csl = (%d), cfu = (%d)\n\n", ccr, clr,crx,cmd,cen,csl,cfu);
  program.emsg(trace, "FLAG_Ts: ccr_flag = %d, crx_flag = %d, clr_flag = %d\ncmd_flag = %d, cen_flag = %d, csl_flag = %d, cfu = (%d)\n", ccr_flag,crx_flag,clr_flag,cmd_flag
		,cen_flag,csl_flag, cfu_flag);

}

#ifdef HAS_MOVED
/*
 *  set the flashing display window to its  original slategrey color.
 *  also, reset the STOP/PLAY/PAUSE label to stop.
 */
void
XMuuzSetSlategrey()
{
  extern action_t sspmode;
  extern xcolor_t  slategrey; 
  
  Arg wargs[1]; 
  extern char *sspDisplayLabels[];
  extern Display  *flashdisplay;
  extern GC flashgc;
  extern Widget displayAction;
  extern XGCValues flashes_gcv;
  int n = 0;
  
  if(depth>8)
    flashes_gcv.foreground = slategrey_color.pixel; /* was blue_color */
  else
    flashes_gcv.foreground = slategrey; /* was blue_color */
  XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
  XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
    Do.resizeW(M_WIDTH), Do.resizeH(M_HEIGHT) );
  XSync(flashdisplay, False);
  sspmode = STOP;  not-used :: 02apr99 ::

  XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] ); n++;
  XtSetValues(displayAction, wargs, n);
} 
  
/*
 *  set the flashing display window to grey.
 */
void
XMuuzSetGrey()
{
  extern action_t sspmode;
  extern xcolor_t grey; 
  Arg wargs[1];  
  extern char *sspDisplayLabels[];
  extern Display  *flashdisplay;
  extern GC flashgc;
  extern Widget displayAction;
  extern XGCValues flashes_gcv;
  int n = 0;

  if(depth>8)
    flashes_gcv.foreground = grey_color.pixel;
  else
    flashes_gcv.foreground = grey;
  XChangeGC(flashdisplay, flashgc, GCForeground | GCBackground, &flashes_gcv);
  XFillRectangle(flashdisplay, flashwindow, flashgc, 0, 0, 
    M_WIDTH, M_HEIGHT);
  XSync(flashdisplay, False);

  if (sspmode != PAUSE)
    sspmode = PAUSE;
  XtSetArg(wargs[n], XtNlabel, sspDisplayLabels[sspmode] ); n++;
  XtSetValues(displayAction, wargs, n);
}
#endif

#define VSMALLW 640
#define VSMALLH 480

#define SMALLW 800   // 0.78125 times larger than STD
#define SMALLH 600   // 0.78125 times larger than STD

#define STDW   1024
#define STDH   768

#define SUNW   1152  // 1.125000 times larger than STD
#define SUNH   900   // 1.171875 times larger than STD

#define BIGW   1280  // 1.250000 times larger than STD
#define BIGH   1024  // 1.333333 times larger than STD

#define VBIGW 1200
#define VBIGH 1600

// non-standards:: smaller, older, ancient; plus oddsized laptop displays, &c.
#define LIBW   800
#define LIBH   480

void
AppSize::setdisplaysize()
{
  extern int gdisplaysize, gheight, gwidth;

  if (gheight == SMALLH && gwidth == SMALLW )
    gdisplaysize = 1;
  else if (gheight == STDH && gwidth == STDW )
    gdisplaysize = 2;
  else if (gheight == SUNH && gwidth == SUNW )
    gdisplaysize = 3;
  else if (gheight == BIGH && gwidth == BIGW )
    gdisplaysize = 4;

#ifdef __NOTYET__
  else if (gheight == VBIGH && gwidth == VBIGW )
    gdisplaysize = 5;
  else if (gheight == HUGEH && gwidth == HUGEW )
    gdisplaysize = 6;
#endif // __NOTYET__

  else
    gdisplaysize = 2;  // default to STD
}


int
AppSize::resizeH(int H)
{
  double h = (double)H;
  extern int gdisplaysize;
  switch(gdisplaysize)
  {
    case 0:  // undef'd smallest, perhaps
    case 1:  // 600, 800  (600x800)   display
      h *= 0.78125;      // reduce dimensions a bit.
      break;
    case 2:  // standard  (768, 1024) do-nothing
       return (H);
    case 3:  // SUN size typically  (900x1152) mult.
      h *= 1.171875; 
      break;
    case 4:  // big 1024, 1280  (1024x1280)    mult.
      h *= 1.33333;      // reduce dimensions a bit.
      break;
    case 5:
    case 6:  // i guess it's conceivable to someday use this... .
      break;
    default: // if UNKNOWN or otherwise non-standard, use the default (768x1024)
      break;
  }
  // round up to the nearest pixel.
  h = ceil(h); 
  // recast into integers.
  return ( (int)h);

}

int
AppSize::resizeW(int W)
{
  double w = (double)W;
  extern int gdisplaysize;

  switch(gdisplaysize)
  {
    case 0:  // undef'd smallest, perhaps
    case 1:  // 600, 800  (600x800)   display
      w *= 0.78125;     // reduce dimensions a bit.
      break;
    case 2:  // standard  (768, 1024) do-nothing
       return(W);
    case 3:  // SUN size typically  (900x1152) mult.
      w *= 1.125;
      break;
    case 4:  // big 1024, 1280  (1024x1280)    mult.
      w *= 1.250;     // reduce dimensions a bit.
      break;
    case 5:
    case 6:  // i guess it's conceivable to someday use this... .
      break;
    default: // if UNKNOWN or otherwise non-standard, use the default (768x1024)
      break;
  }
  // round up to the nearest pixel.
   w = ceil(w);
  // recast into integers.
  return ( (int)w);
}
