/*
 *   $Id: mixerControls.c,v 1.2 2000/01/29 20:45:02 kline Exp kline $
 *      Play with the /dev/mixer in FreeBSD.  
 *
 *      Note that this is one of the few places that will require porting
 *      mods across architectures and flavors of unix.
 */

#include "globals.h"
#include "muuz.h"
#include "mixerControls.h"
#include "muuztypes.h"
#ifdef __FreeBSD__
#include <machine/soundcard.h>
#endif /* __FreeBSD__ */
#include "copyright.h"
#include "errMessage.h"

extern errMessage program;  // for emsg()


void mixerControls::
getSetDevMixer(int command, int left, int right)
{
#ifdef __FreeBSD__
#define MERR "You must have ``/dev/mixer'' configured in your kernel.\n"
#define VMASK 127
#define VNAME "/dev/mixer"
#define VOL 0
   int bar, mixer_fd;
   int vleft, vright;

  if (mdebug)
  {
    program.emsg(nprint, 
      "entering: getSetDevMixer: command = (%d), left = (%d), right = (%d)\n",
      command, left, right);
  }
   if ((mixer_fd = open(VNAME, O_RDWR)) < 0) 
   {
      void XMuuzFatalErr(char *);

      program.emsg(error,  "%s",  MERR );  // MIXER ERROR.
      program.emsg(error,  "Please read the REQUIREMENTS docs and try again\n");
      perror(VNAME);
      XMuuzFatalErr("Cannot open /dev/mixer");
      // should never get here... .
      exit(1);
   }

      if (command == GET_CURRENT)
      {
         if (ioctl(mixer_fd, MIXER_READ(VOL),&bar)== -1)
            perror("MIXER_READ");
	 if (mdebug)
	 {
           program.emsg(nprint, "[[%d %d]]\n",  bar & 0x7f, (bar >> 8) & 0x7f);
	 }

	 vleft = bar & VMASK; vright = (( bar >> 8) & VMASK);
         sprintf(VolDisplay, "%d    %d",  vleft, vright);

	 if (mdebug)
	 {
	   program.emsg(nprint, "DEBUG: getSetDevMixer(): VolDisplay = [%s], vleft = (%d), vright = (%d)\n", VolDisplay, vleft, vright);
	 }

	close (mixer_fd);
      }

      else if (command == SET_VOLUME) 
      {
         if (left < 0) left = 0;
         if (right < 0) right = 0;
         if (left > 100) left = 100;
         if (right > 100) right = 100;

	 if (mdebug)
	 {
           program.emsg(nprint, "mDEB: getSetDevMixer() to %d:%d.\n", left, right);
	 }

	left |= right << 8;
        if (ioctl(mixer_fd, MIXER_WRITE(VOL), &left) == -1)
            perror("WRITE_MIXER");
      } 
   close(mixer_fd);
#endif /* __FreeBSD__ */
}


void mixerControls::
doVolume(int command, int left_vol, int right_vol)
{
  void XMuuzAudioFailure(int n, char *routine);

  if (command == GET_CURRENT && (left_vol == -1 && right_vol == -1))
  {
    getSetDevMixer(GET_CURRENT, -1, -1);
  } 
  else if (command == SET_VOLUME)
  {
    getSetDevMixer(SET_VOLUME, left_vol, right_vol); 
  }
  else 
  {
    XMuuzAudioFailure(-1, "XMuuzDoVolume: neither GET nor SET"); /* unlikely */
  }
}


void mixerControls::
XMuuzInitVolume()
{
  doVolume(GET_CURRENT, -1, -1);
  if (mdebug)
  {
    program.emsg(nprint, "XMuuzInitVolume: VolDisplay is [%s]\n", VolDisplay);
  }
  sscanf(VolDisplay, "%d %d", &volL, &volR);
  if (volL == volR)
    volboth = volL;
  else if (volL >= volR)
    volboth = volL = volR;
  else /* volR > volL */
    volboth = volR = volL;

 /*
  * if initial setting too loud, reset and read new setting for display
  */
 if ( (volL >= LOUD_VOL || volR >= LOUD_VOL) || 
   (volL <= LOW_VOL || volR <= LOW_VOL) )
 {
   doVolume(SET_VOLUME, STARTING_VOL, STARTING_VOL);
   doVolume(GET_CURRENT, -1, -1);
   sscanf(VolDisplay, "%d %d", &volL, &volR);  /* volL and volR initialized */
 }
}

int mixerControls::
ZXMuuzGetChannel()
{
  doVolume(GET_CURRENT, -1, -1);
  //if (mdebug)
  {
    program.emsg(nprint, "ZXMuuzInitVolume: VolDisplay is [%s]\n", VolDisplay);
  }
  //sscanf(VolDisplay, "%d %d", &volL, &volR);
  //if (volL >= volR)
    //return volL;
  //else return volR;
  return 0;
}


void mixerControls::
fadeVolumeToOff()
{
  int 		  vleft, vright;


  doVolume(GET_CURRENT, -1, -1);
  program.emsg(nprint, "DEBUG: decreaseVolumeToVeryLow: VolDisplay is [%s]\n", VolDisplay);
  sscanf(VolDisplay, "%d %d", &vleft, &vright);
  if (vleft >= vright)   /* equalize right and left channels */
    vright = vleft;
  else
    vleft = vright;
  while (vleft > 0 && vright > 0)
  {
    doVolume(SET_VOLUME, vleft-1, vright-1);
    vleft = vright = ZXMuuzGetChannel();
    program.emsg(nprint, "DEBUG: decreaseVolumeToVeryLow(): vleft = (%d), vright = (%d)\n", vleft, vright);
    if (vleft == 0)
      return;
    usleep(750000);
  }

}
/*
 * Set /dev/mixer channel's both to the same volume
 */
void mixerControls::
setBothChannels(int channelvolume)
{
    doVolume(SET_VOLUME, channelvolume, channelvolume);
}

/*
 * set each channel of /dev/mixer to a separate volume level
 */
void mixerControls::
setRightAndLeftChannels(int rightchan, int leftchan)
{
    doVolume(SET_VOLUME, leftchan, rightchan );
}

void mixerControls::
getBothChannels()
{
  doVolume(GET_CURRENT, -1, -1);
  if (mdebug)
  {
    program.emsg(nprint, "XMuuzInitVolume: VolDisplay is [%s]\n", VolDisplay);
  }
  /***  Now we have the information in volL and VolR ***/
  sscanf(VolDisplay, "%d %d", &volL, &volR);
}

void mixerControls::
getBothChannels(int *right, int *left)
{
  doVolume(GET_CURRENT, -1, -1);
  if (mdebug)
  {
    program.emsg(nprint, "XMuuzInitVolume: VolDisplay is [%s]\n", VolDisplay);
  }
  sscanf(VolDisplay, "%d %d", &volL, &volR);
  *right = volR, *left = volL;
}
   
int mixerControls::
returnVolL()
{ 
  getBothChannels();
  return volL;
}

   
int mixerControls::
returnVolR()
{ 
  getBothChannels();
  return volR;
} 

/*
 * Set /dev/mixer channel's both to the same volume
 */
void mixerControls::
XMuuzSetBothVolume(int channelvolume)
{
    doVolume(SET_VOLUME, channelvolume, channelvolume);
}  


