/*
 *   $Id: mixerControls.h,v 1.1 2000/01/29 20:45:04 kline Exp kline $
 */

#ifndef _MIXERCONTROLS_H_
#define _MIXERCONTROLS_H_
#include "globals.h"
#include "muuz.h"
#include "muuztypes.h"
#ifdef __FreeBSD__
#include <machine/soundcard.h>
#endif /* __FreeBSD__ */


class mixerControls {
private:
  char VolDisplay[32];
  int volboth, volL, volR;
  int mdebug;
  void getBothChannels();
  void getSetDevMixer(int command, int left, int right);
public:
  mixerControls::mixerControls() { mdebug = 0, volboth = volL = volR = -1; }
  ~mixerControls(){}
  void doVolume(int command, int left_vol, int right_vol);
  void XMuuzInitVolume();
  int ZXMuuzGetChannel();
  void fadeVolumeToOff();
  void setBothChannels(int channelvolume);
  void setRightAndLeftChannels(int rightchan, int leftchan);
  void getBothChannels(int *right, int *left);
  int returnVolL();
  int returnVolR();
  char *returnVolumeDisplay();
  void XMuuzSetBothVolume(int channelvolume);
};
#endif
