/*
 * $Id: muuz.h,v 1.5 2000/05/01 16:47:15 kline Exp kline $
 */
#ifndef _MUUZ_H_
#define _MUUZ_H_                       


/*
 * miscellaneous defines
 */

#define EKILLBIN "/home/kline/bin/KB"  // external killbeats binary.
#define NUMBER(x)  (x - 1)
#define BLANK4LINES \
"                                                                    \n\
                                                                    \n\
                                                                    \n\
                                                                    "

/*** 
 *** The above 4 lines are actually ASCII '\040'; to be replaced with
 *** an Xlib XClearWindow ( Display *, Window) call.
 ***/


#define  flag_off 0
#define  flag_on  1
#define  UINIT 65535

/*
 * temporary (hopefully...)
 */

#ifdef TEST
#define SHARE_P_ "/tmp/usr/X11R6/share/muuz/"
#else
#define SHARE_P_ "/usr/X11R6/share/muuz/"
#endif


/*
 * paths to the informational files.
 */
#define P_ACK SHARE_P_"acknowledgement.text"
#define P_HELPABOUT SHARE_P_"aboutMuuz.text"
#define P_HELPCONP SHARE_P_"helpConPan.text"
#define P_HELPPREP SHARE_P_"helpPrep.text"
#define P_HELPUSER SHARE_P_"helpUserPrep.text"
#define P_HELPOVER SHARE_P_"helpOverview.text"



/*
 * define the cXX_flag values
 */

#define CCR 1
#define CLR 2
#define CRX 3
#define CMD 4
#define CSL 5
#define CEN 6
#define CFU 7


/*
 * #define Label strings here
 *
 *  Left-side Switch-Control labels first.
 *
 */
#define L_CONTROLPANEL  "Control Panel"
#define L_PREPROGRAMMED "PreProgrammed"
#define L_USERCREATED   "User-Created"
#define L_QUIT          "Quit"

        
#define L_ACTION  " Action  "  /* ssp :: stop|play|pause  */
#define L_COLORS  " Colors  "  /* flash colors:: several  */
#define L_DUMMY   "  "   /* Hold formbox1 way out to end of app screen */
#define L_HERTZ   "Frequency"    /*  freq of flashes control */
#define L_MODE    "  Mode   "     /*  audio|video|audio+video */
#define L_PITCH   "  Pitch  "    /* pitch of audio: 4 octaves */
#define L_PROGRAMS "Programs "
#define L_SELECTIONS "Selections"
#define L_VOLUME  "  Volume "  /* AUDIO volume OFF to 100%  */

#define L_CANCEL   "  Cancel  " /* Cancel Quit selection  */
#define L_CONFIRM  "  Confirm " /* Confirm Quit selection */
/* 
 * colors for flashes
 */ 

#define WHITE   0        /* white  :: or variant thereof */
#define YELLOW  1        /* yellow:: or variant thereof */
#define ORANGE  2        /* orange:: or variant thereof */
#define VRED    3        /* red:: or variant thereof */
#define SKYBLUE 4	 /* skyblue:: or variant thereof */


/*
 * colors for allocation
 */ 

#define CGREEN "green"
#define CBLUE "blue"
#define CRBLUE4 "darkblue"
#define CPINK "pink"
#define CLIGHTSKYBLUE "lightskyblue"
#define CGREY "grey"
#define CGREY85 "grey85"
#define CGREY90 "grey90"
#define CORANGE "orange"
#define CBLACK "black"
#define CYELLOW "yellow"
#define CHOTPINK "hotpink"
#define CRED "red"
#define CPERU "peru"
#define CBROWN1 "brown1"
#define CSLATEGREY "slategrey"
#define CWHITESMOKE "whitesmoke"
#define CDARKRED "darkred"

/*
 *  color macros for controlWidgets
 */

#ifdef D_CMAP
#define ARROW_COLORS XtNbackground,grey_color.pixel,\
                     XtNforeground,darkblue_color.pixel, \
                        XtNshadowWidth,  3

#define ASSEMBLY_COLORS XtNbackground, whitesmoke_color.pixel, \
                        XtNshadowWidth,  2
  
#define LABELDISPLAY_COLORS XtNbackground, black_color,\
                     XtNforeground,grey90_color.pixel, \
                        XtNshadowWidth,  2

#define LABEL_COLORS XtNbackground, white_color, \
                     XtNforeground, black_color, \
                        XtNshadowWidth,  2

#endif


#ifdef P_CMAP
#define ARROW_COLORS XtNbackground,grey,\
                     XtNforeground,darkblue, \
                        XtNshadowWidth,  3

#define ASSEMBLY_COLORS XtNbackground, whitesmoke, \
                        XtNshadowWidth,  2
  
  
#define LABELDISPLAY_COLORS XtNbackground, black_color,\
                     XtNforeground,grey90, \
                        XtNshadowWidth,  2

#define LABEL_COLORS XtNbackground, white_color, \
                     XtNforeground, black_color, \
                        XtNshadowWidth,  2

#endif



/*
 *   for c++ class consolidation
 */
#define FIREBRICK 0
#define BROWN1 1
#define MEDIUMSPRINGGREEN 2
#define PALETURQUOISE 3
#define PEACHPUFF 4
#define LIGHTCYAN 5
#define GREY90 6
#define PURPLE 7
#define LIGHTPINK 8
#define DARKBLUE 9
#define SLATEGREY 10
#define LIGHTYELLOW2 11
#define BLUE 12
#define GREY 13
#define RED  14
#define GREEN 15
#define GREY85 16
#define LIGHTSKYBLUE1 17
#define __ORANGE 18
#define BLACK 19
#define __WHITE    20
#define WHITESMOKE    21
#define DARKRED    22


/*
 * size of flashing window (formsflash)
 *
 *  Note:: this form is  *first* set around line #165ff, forms.c
 */

#define M_HEIGHT 410   
#define M_WIDTH  850 




/*
 *  for audio mixer and audio related.
 */
#define BEATSINSTALLED "/usr/X11R6/bin/muuzbeats"
#define BEATSPATH "/usr/X11R6/bin/muuzbeats"
#define BEATSNAME "muuzbeats"

#define GET_CURRENT 0
#define SET_VOLUME  1
#define CURRENT_RETRIEVED 2
#define VOLUME_SET  3
#define LOUD_VOL   80
#define LOW_VOL    10
#define VOFF	    0        /* volume is off */
#define STARTING_VOL VOFF

/*
 * octaves 
 */
#define LOW     0
#define MID     1
#define UPPER   2
#define HIGH    3

/*
 * muuzmode defines
 */

#define AUDIO  0
#define VIDEO  1
#define AUDIOVIDEO 2

/*
 * ssp mode defines
 */

#define STOP  0
#define PLAY  1
#define PAUSE 2

/*
 * pause timeout 
 */

#define PAUSETIMECOUNT 20 	/* 20 seconds:: test only */
#define PAUSEINTERVAL   1	/*  1 pause == 1 second   */
#define PAUSETIMECOMPLETE 	(PAUSETIMECOUNT*PAUSEINTERVAL)


/*
 * sound files mixer levels....
 */
#define CLICK_VOLUME 25



/*
 * for pre-programmed array recognition
 */
#define R_FASTUNWIND	0
#define R_PAINRELIEF	4

// deleted surplus NUM_XX enttries.

#ifdef REGISTERED
#define ICON_NAME "Muuz"    /*  used only in main.c  */
#define PROG_NAME "Muuz"    /*  used only in main.c  */
#else
#define ICON_NAME "Muuz <Un-Reg>"    /*  used only in main.c  */
#define PROG_NAME "Muuz <Un-registered>"    /*  used only in main.c  */
#endif



#ifdef WWW
		declared old and invalid:: 15feb99 ::gdk::
/*
 * one instance|fragment of a mind program.
 */
struct programInstance
{
        unsigned char freq;     /* ZERO disallowed for Hz    */
        unsigned short seconds; /* 65536 seconds max/Section */
        unsigned char colors;   /* max of 256 colors; 255 if ZERO disallowed */
        char pitch;    /* 8 octaves should be enough forever */
        char volume;   /* ZERO == OFF: 1 to 10; 11 states    */
        char screenflashform;  /* 127 flashforms, ZERO splcase */
        char reserved;           /* Unused yet :: reserved */
};

#define instStates(_var_,    H, S , C , P , V , F) \
{\
        _var_.freq = H; _var_.seconds = S; _var_.colors = C;\
        _var_.pitch= P; _var_.volume = V; _var_.screenflashform=F;\
        _var_.reserved = 0;\
}
#endif

/*
 * error and warning message #defines of various types
 */

#define M_ADJUST \
"Click on the orange ``Ajust Off'' button in the lower righthand\n\
corner of the blue Pre-Programmed form before you raise or lower\n\
the volume of a pre-programmed selection or before choosing the\n\
``Audio'' or ``Video'' mode for playback.  The title of the orange\n\
button will change to ``Adjust On.''\n\
\n\
To restore the pre-programmed defaults, press the ``Adjust On''\n\
button once and it will display ``Adust Off'' again."


#define NAP_ERR "Selection already playing.  Change PLAY to STOP."
#define NP_ERR  "Choose one of the Programs"
#define NS_ERR  "Choose one of Selections before choosing Program"
#define NSP_ERR "Choose one of Selections and one of Programs"


#define W_STRING "WARNING:\n    
\tPersons subject to any form of seizures or epilepsy,  or suffering
\tfrom cardiac arrythmias or other heart disorders, or using a pacemaker,
\tshould not use this program   without strict Medical Supervision.\n\n
\tThis program is made available subject to the following restrictions:\n
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ENTIRELY  ``AS IS''  AND ANY     
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE      
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR     
 * PURPOSE ARE DISCLAIMED.   
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR  ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL  DAMAGES  
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE  GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS,  OR BUSINESS INTERRUPTION 
 * OR LOSS OF LIFE OR HEALTH)   HOWEVER CAUSED AND ON ANY  THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n 
\t\tDo you agree to the above licensing provisions?\n"

#define W_YES "Yes"
#define W_NO  "No"


#endif /* !_MUUZ_H_ */


